/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.connection;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.peermanager.connection.AZPeerConnection;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;

public class PeerConnectionFactory {
    private static final PeerConnectionFactory instance = new PeerConnectionFactory();
    private volatile ArrayList creation_listeners_cow = new ArrayList();
    private AEMonitor creation_listeners_mon = new AEMonitor("PeerConnectionFactory");

    public static PeerConnectionFactory getSingleton() {
        return instance;
    }

    public AZPeerConnection createAZPeerConnection(PeerItem peer_identity, NetworkConnection connection) {
        AZPeerConnection conn = new AZPeerConnection(peer_identity, connection);
        ArrayList listeners = this.creation_listeners_cow;
        for (int i = 0; i < listeners.size(); ++i) {
            CreationListener listener = (CreationListener)listeners.get(i);
            listener.connectionCreated(conn);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCreationListener(CreationListener listener) {
        try {
            this.creation_listeners_mon.enter();
            ArrayList<CreationListener> newlist = new ArrayList<CreationListener>(this.creation_listeners_cow.size() + 1);
            newlist.addAll(this.creation_listeners_cow);
            newlist.add(listener);
            this.creation_listeners_cow = newlist;
        }
        finally {
            this.creation_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterCreationListener(CreationListener listener) {
        try {
            this.creation_listeners_mon.enter();
            ArrayList newlist = new ArrayList(this.creation_listeners_cow);
            newlist.remove(listener);
            this.creation_listeners_cow = newlist;
        }
        finally {
            this.creation_listeners_mon.exit();
        }
    }

    public static interface CreationListener {
        public void connectionCreated(AZPeerConnection var1);
    }
}

