/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.advanced;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZGenericMapPayload;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTChoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUnchoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUninterested;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class ADVMessageFactory {
    private static final byte bss = 11;
    private static final Map legacy_data = new HashMap();
    private static Message[] registered_messages;
    private static final HashMap mapping_table;

    public static void init() {
    }

    private static void registerGenericMapPayloadMessageType(String type_id) throws MessageException {
        MessageManager.getSingleton().registerMessageType(new AZGenericMapPayload(type_id, null));
    }

    private static void refreshMappingTables() {
        Object[] new_msgs = MessageManager.getSingleton().getRegisteredMessages();
        if (!Arrays.equals(registered_messages, new_msgs)) {
            registered_messages = new_msgs;
            mapping_table.clear();
            for (int i = 0; i < registered_messages.length; ++i) {
                String feature_id = registered_messages[i].getFeatureID();
                int sub_id = registered_messages[i].getFeatureSubID();
                byte[] raw_message_id = (byte[])mapping_table.get(feature_id);
                if (raw_message_id == null) {
                    raw_message_id = new byte[3];
                    mapping_table.put(feature_id, raw_message_id);
                }
                if (raw_message_id.length == 3) continue;
                Debug.out("raw_message_id.length[" + raw_message_id.length + "] != 3");
            }
        }
    }

    public static Message createADVMessage(int id, int sub_id, DirectByteBuffer stream_payload) throws MessageException {
        int id_length = stream_payload.getInt((byte)11);
        if (id_length < 1 || id_length > 1024 || id_length > stream_payload.remaining((byte)11) - 1) {
            byte bt_id = stream_payload.get((byte)0, 0);
            throw new MessageException("invalid ADV id length given: " + id_length + ", stream_payload.remaining(): " + stream_payload.remaining((byte)11) + ", BT id?=" + bt_id);
        }
        byte[] id_bytes = new byte[id_length];
        stream_payload.get((byte)11, id_bytes);
        byte version = stream_payload.get((byte)11);
        return MessageManager.getSingleton().createMessage(id_bytes, stream_payload);
    }

    public static RawMessage createADVRawMessage(Message base_message) {
        byte[] id_bytes = base_message.getID().getBytes();
        DirectByteBuffer[] payload = base_message.getData();
        int payload_size = 0;
        for (int i = 0; i < payload.length; ++i) {
            payload_size += payload[i].remaining((byte)11);
        }
        DirectByteBuffer header = DirectByteBufferPool.getBuffer((byte)22, 9 + id_bytes.length);
        header.putInt((byte)11, 5 + id_bytes.length + payload_size);
        header.putInt((byte)11, id_bytes.length);
        header.put((byte)11, id_bytes);
        header.flip((byte)11);
        DirectByteBuffer[] raw_buffs = new DirectByteBuffer[payload.length + 1];
        raw_buffs[0] = header;
        for (int i = 0; i < payload.length; ++i) {
            raw_buffs[i + 1] = payload[i];
        }
        LegacyData ld = (LegacyData)legacy_data.get(base_message.getID());
        if (ld != null) {
            return new RawMessageImpl(base_message, raw_buffs, ld.priority, ld.is_no_delay, ld.to_remove);
        }
        int priority = base_message.getType() == 1 ? 0 : 1;
        return new RawMessageImpl(base_message, raw_buffs, priority, true, null);
    }

    static {
        legacy_data.put("BT_CHOKE", new LegacyData(2, true, new Message[]{new BTUnchoke(), new BTPiece(-1, -1, null)}));
        legacy_data.put("BT_UNCHOKE", new LegacyData(1, true, new Message[]{new BTChoke()}));
        legacy_data.put("BT_INTERESTED", new LegacyData(2, true, new Message[]{new BTUninterested()}));
        legacy_data.put("BT_UNINTERESTED", new LegacyData(1, false, new Message[]{new BTInterested()}));
        legacy_data.put("BT_HAVE", new LegacyData(0, false, null));
        legacy_data.put("BT_BITFIELD", new LegacyData(2, true, null));
        legacy_data.put("BT_REQUEST", new LegacyData(1, true, null));
        legacy_data.put("BT_PIECE", new LegacyData(0, false, null));
        legacy_data.put("BT_CANCEL", new LegacyData(2, true, null));
        legacy_data.put("BT_HANDSHAKE", new LegacyData(2, true, null));
        legacy_data.put("BT_KEEP_ALIVE", new LegacyData(0, false, null));
        mapping_table = new HashMap();
    }

    protected static class LegacyData {
        protected final int priority;
        protected final boolean is_no_delay;
        protected final Message[] to_remove;

        protected LegacyData(int prio, boolean no_delay, Message[] remove) {
            this.priority = prio;
            this.is_no_delay = no_delay;
            this.to_remove = remove;
        }
    }
}

