/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZHandshake
implements AZMessage {
    public static final int HANDSHAKE_TYPE_PLAIN = 0;
    public static final int HANDSHAKE_TYPE_CRYPTO = 1;
    private static final byte bss = 11;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte[] identity;
    private final String client;
    private final String client_version;
    private final String[] avail_ids;
    private final byte[] avail_versions;
    private int tcp_port;
    private int udp_port;
    private int udp_non_data_port;
    private final int handshake_type;

    public AZHandshake(byte[] peer_identity, String _client, String version, int tcp_listen_port, int udp_listen_port, int udp_non_data_listen_port, String[] avail_msg_ids, byte[] avail_msg_versions, int _handshake_type) {
        this.identity = peer_identity;
        this.client = _client;
        this.client_version = version;
        this.avail_ids = avail_msg_ids;
        this.avail_versions = avail_msg_versions;
        this.tcp_port = tcp_listen_port;
        this.udp_port = udp_listen_port;
        this.udp_non_data_port = udp_non_data_listen_port;
        this.handshake_type = _handshake_type;
        if (this.tcp_port < 0 || this.tcp_port > 65535) {
            Debug.out("given TCP listen port is invalid: " + this.tcp_port);
            this.tcp_port = 0;
        }
        if (this.udp_port < 0 || this.udp_port > 65535) {
            Debug.out("given UDP listen port is invalid: " + this.udp_port);
            this.udp_port = 0;
        }
        if (this.udp_non_data_port < 0 || this.udp_non_data_port > 65535) {
            Debug.out("given UDP non-data listen port is invalid: " + this.udp_non_data_port);
            this.udp_non_data_port = 0;
        }
    }

    public byte[] getIdentity() {
        return this.identity;
    }

    public String getClient() {
        return this.client;
    }

    public String getClientVersion() {
        return this.client_version;
    }

    public String[] getMessageIDs() {
        return this.avail_ids;
    }

    public byte[] getMessageVersions() {
        return this.avail_versions;
    }

    public int getTCPListenPort() {
        return this.tcp_port;
    }

    public int getUDPListenPort() {
        return this.udp_port;
    }

    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }

    public int getHandshakeType() {
        return this.handshake_type;
    }

    public String getID() {
        return "AZ_HANDSHAKE";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_HANDSHAKE_BYTES;
    }

    public String getFeatureID() {
        return "AZ1";
    }

    public int getFeatureSubID() {
        return 0;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            String msgs_desc = "";
            for (int i = 0; i < this.avail_ids.length; ++i) {
                String id = this.avail_ids[i];
                byte ver = this.avail_versions[i];
                if (id.equals(this.getID())) continue;
                msgs_desc = msgs_desc + "[" + id + ":" + ver + "]";
            }
            this.description = this.getID() + " from [" + ByteFormatter.nicePrint(this.identity, true) + ", " + this.client + " " + this.client_version + ", TCP/UDP ports " + this.tcp_port + "/" + this.udp_port + "/" + this.udp_non_data_port + ", handshake " + (this.getHandshakeType() == 0 ? "plain" : "crypto") + "] supports " + msgs_desc;
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Object> payload_map = new HashMap<String, Object>();
            payload_map.put("identity", this.identity);
            payload_map.put("client", this.client);
            payload_map.put("version", this.client_version);
            payload_map.put("tcp_port", new Long(this.tcp_port));
            payload_map.put("udp_port", new Long(this.udp_port));
            payload_map.put("udp2_port", new Long(this.udp_non_data_port));
            payload_map.put("handshake_type", new Long(this.handshake_type));
            ArrayList message_list = new ArrayList();
            for (int i = 0; i < this.avail_ids.length; ++i) {
                String id = this.avail_ids[i];
                byte ver = this.avail_versions[i];
                if (id.equals(this.getID())) continue;
                HashMap<String, Object> msg = new HashMap<String, Object>();
                msg.put("id", id);
                msg.put("ver", new byte[]{ver});
                message_list.add(msg);
            }
            payload_map.put("messages", message_list);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(payload_map, (byte)13);
            if (this.buffer.remaining((byte)11) > 1200) {
                System.out.println("Generated AZHandshake size = " + this.buffer.remaining((byte)11) + " bytes");
            }
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        List raw_msgs;
        Long h_type;
        Long udp2_lport;
        Long udp_lport;
        Map root = MessagingUtil.convertBencodedByteStreamToPayload(data, 100, this.getID());
        byte[] id = (byte[])root.get("identity");
        if (id == null) {
            throw new MessageException("id == null");
        }
        if (id.length != 20) {
            throw new MessageException("id.length != 20: " + id.length);
        }
        byte[] raw_name = (byte[])root.get("client");
        if (raw_name == null) {
            throw new MessageException("raw_name == null");
        }
        String name = new String(raw_name);
        byte[] raw_ver = (byte[])root.get("version");
        if (raw_ver == null) {
            throw new MessageException("raw_ver == null");
        }
        String version = new String(raw_ver);
        Long tcp_lport = (Long)root.get("tcp_port");
        if (tcp_lport == null) {
            tcp_lport = new Long(0L);
        }
        if ((udp_lport = (Long)root.get("udp_port")) == null) {
            udp_lport = new Long(0L);
        }
        if ((udp2_lport = (Long)root.get("udp2_port")) == null) {
            udp2_lport = udp_lport;
        }
        if ((h_type = (Long)root.get("handshake_type")) == null) {
            h_type = new Long(0L);
        }
        if ((raw_msgs = (List)root.get("messages")) == null) {
            throw new MessageException("raw_msgs == null");
        }
        String[] ids = new String[raw_msgs.size()];
        byte[] vers = new byte[raw_msgs.size()];
        int pos = 0;
        Iterator i = raw_msgs.iterator();
        while (i.hasNext()) {
            Map msg = (Map)i.next();
            byte[] mid = (byte[])msg.get("id");
            if (mid == null) {
                throw new MessageException("mid == null");
            }
            ids[pos] = new String(mid);
            byte[] ver = (byte[])msg.get("ver");
            if (ver == null) {
                throw new MessageException("ver == null");
            }
            if (ver.length != 1) {
                throw new MessageException("ver.length != 1");
            }
            vers[pos] = ver[0];
            ++pos;
        }
        return new AZHandshake(id, name, version, tcp_lport.intValue(), udp_lport.intValue(), udp2_lport.intValue(), ids, vers, h_type.intValue());
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

