/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;

public class OutgoingBTHaveMessageAggregator {
    private final ArrayList pending_haves = new ArrayList();
    private final AEMonitor pending_haves_mon = new AEMonitor("OutgoingBTHaveMessageAggregator:PH");
    private boolean destroyed = false;
    private final OutgoingMessageQueue outgoing_message_q;
    private final OutgoingMessageQueue.MessageQueueListener added_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        public boolean messageAdded(Message message) {
            return true;
        }

        public void messageQueued(Message message) {
            if (!message.getID().equals("BT_HAVE")) {
                OutgoingBTHaveMessageAggregator.this.sendPendingHaves();
            }
        }

        public void messageRemoved(Message message) {
        }

        public void messageSent(Message message) {
        }

        public void protocolBytesSent(int byte_count) {
        }

        public void dataBytesSent(int byte_count) {
        }
    };

    public OutgoingBTHaveMessageAggregator(OutgoingMessageQueue outgoing_message_q) {
        this.outgoing_message_q = outgoing_message_q;
        outgoing_message_q.registerQueueListener(this.added_message_listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueHaveMessage(int piece_number, boolean force) {
        if (this.destroyed) {
            return;
        }
        try {
            this.pending_haves_mon.enter();
            this.pending_haves.add(new Integer(piece_number));
            if (force) {
                this.sendPendingHaves();
            } else {
                int pending_bytes = this.pending_haves.size() * 9;
                if (pending_bytes >= this.outgoing_message_q.getMssSize()) {
                    this.sendPendingHaves();
                }
            }
        }
        finally {
            this.pending_haves_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.pending_haves_mon.enter();
            this.pending_haves.clear();
            this.destroyed = true;
        }
        finally {
            this.pending_haves_mon.exit();
        }
    }

    public void forceSendOfPending() {
        this.sendPendingHaves();
    }

    public boolean hasPending() {
        return !this.pending_haves.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingHaves() {
        if (this.destroyed) {
            return;
        }
        try {
            this.pending_haves_mon.enter();
            for (int i = 0; i < this.pending_haves.size(); ++i) {
                Integer piece_num = (Integer)this.pending_haves.get(i);
                this.outgoing_message_q.addMessage(new BTHave(piece_num), true);
            }
            this.outgoing_message_q.doListenerNotifications();
            this.pending_haves.clear();
        }
        finally {
            this.pending_haves_mon.exit();
        }
    }
}

