/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageServiceClient;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTFactory;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportFactory;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerAdapter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;

public class Test
implements SpeedManagerAdapter,
DHTNATPuncherAdapter {
    private Average upload_average = Average.getInstance(1000, 10);
    private int upload_limit;
    private int upload_rate;

    protected Test() {
        try {
            AzureusCore core = AzureusCoreFactory.create();
            final LoggerChannel logger = core.getPluginManager().getDefaultPluginInterface().getLogger().getNullChannel("DHTChurner");
            DHTLogger dht_logger = new DHTLogger(){

                public void log(String str) {
                }

                public void log(Throwable e) {
                }

                public void log(int log_type, String str) {
                }

                public boolean isEnabled(int log_type) {
                    return true;
                }

                public PluginInterface getPluginInterface() {
                    return logger.getLogger().getPluginInterface();
                }
            };
            DHTTransportUDP transport = DHTTransportFactory.createUDP((byte)15, 1, null, null, 6881, 4, 2, 30000L, 50, 25, false, true, dht_logger);
            final DHT dht = DHTFactory.create(transport, new Properties(), null, this, dht_logger);
            transport.importContact(new InetSocketAddress("dht.aelitis.com", 6881), (byte)15);
            new AEThread("init", true){

                public void runSupport() {
                    dht.integrate(false);
                }
            }.start();
            SpeedManager sm = core.getSpeedManager();
            sm.setSpeedTester(dht.getSpeedTester());
            sm.setEnabled(true);
            new AEThread("init", true){

                public void runSupport() {
                }
            }.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentProtocolUploadSpeed() {
        Average average = this.upload_average;
        synchronized (average) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentDataUploadSpeed() {
        Average average = this.upload_average;
        synchronized (average) {
            return (int)this.upload_average.getAverage();
        }
    }

    public void setCurrentUploadLimit(int bytes_per_second) {
        this.upload_limit = bytes_per_second;
    }

    public void setCurrentDownloadLimit(int bytes_per_second) {
    }

    public int getCurrentUploadLimit() {
        return this.upload_limit;
    }

    protected void setManualUploadLimit(int bytes_per_second) {
        this.upload_rate = bytes_per_second;
    }

    protected void upload() {
        int THREAD_NUM = 10;
        int SLEEP = 500;
        boolean OUTSTANDING_REPLIES = true;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    Average average = Test.this.upload_average;
                    synchronized (average) {
                        System.out.println("Upload: " + DisplayFormatters.formatByteCountToBase10KBEtcPerSec(Test.this.upload_average.getAverage()));
                    }
                }
            }
        }.start();
        for (int i = 0; i < 10; ++i) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block7: while (true) {
                        ClientMessageService service = ClientMessageServiceClient.getServerService("ae0.aelitis.com", 27021, 30, "DEVNULL");
                        int rep_skip = 1;
                        block8: while (true) {
                            try {
                                while (true) {
                                    int my_upload = Test.this.upload_rate / 20;
                                    HashMap<String, byte[]> request2 = new HashMap<String, byte[]>();
                                    byte[] buffer = new byte[my_upload];
                                    Average average = Test.this.upload_average;
                                    synchronized (average) {
                                        Test.this.upload_average.addValue(my_upload);
                                    }
                                    request2.put("data", buffer);
                                    long start = System.currentTimeMillis();
                                    if (rep_skip > 0) {
                                        --rep_skip;
                                    } else {
                                        service.receiveMessage();
                                    }
                                    service.sendMessage(request2);
                                    long elapsed = System.currentTimeMillis() - start;
                                    long sleep = 500L - elapsed;
                                    if (sleep <= 0L) continue;
                                    try {
                                        Thread.sleep(sleep);
                                        continue block8;
                                    }
                                    catch (Throwable e) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                continue block7;
                            }
                        }
                        break;
                    }
                }
            }.start();
        }
    }

    public Map getClientData(InetSocketAddress originator, Map originator_data) {
        System.out.println("getClientData - " + originator_data + "/" + originator);
        HashMap<String, Long> res = new HashMap<String, Long>();
        res.put("udp_data_port", new Long(1234L));
        res.put("tcp_data_port", new Long(5678L));
        return res;
    }

    public static void main(String[] args) {
        Test test = new Test();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block4: while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = in.readLine()) != null) {
                        line = line.trim().toLowerCase();
                    }
                    if (line == null || line.equals("quit")) break block4;
                    try {
                        test.setManualUploadLimit((int)(Float.parseFloat(line) * 1024.0f));
                        continue block4;
                    }
                    catch (Throwable e) {
                        System.out.println("Usage: quit, <uprate kb/sec>");
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                break;
            }
        }
    }
}

