/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.DHTStorageBlock;
import com.aelitis.azureus.core.dht.DHTStorageKey;
import com.aelitis.azureus.core.dht.DHTStorageKeyStats;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTPluginStorageManager
implements DHTStorageAdapter {
    private static final String pub_exp = "10001";
    private static final String modulus = "b8a440c76405b2175a24c86d70f2c71929673a31045791d8bd84220a48729998900d227b560e88357074fa534ccccc6944729bfdda5413622f068e7926176a8afc8b75d4ba6cde760096624415b544f73677e8093ddba46723cb973b4d55f61c2003b73f52582894c018e141e8d010bb615cdbbfaeb97a7af6ce1a5a20a62994da81bde6487e8a39e66c8df0cfd9d763c2da4729cbf54278ea4912169edb0a33";
    private static final long ADDRESS_EXPIRY = 604800000L;
    private static final int DIV_WIDTH = 10;
    private static final int DIV_FRAG_GET_SIZE = 2;
    private static final long DIV_EXPIRY_MIN = 172800000L;
    private static final long DIV_EXPIRY_RAND = 86400000L;
    private static final long KEY_BLOCK_TIMEOUT_SECS = 604800L;
    public static final int LOCAL_DIVERSIFICATION_SIZE_LIMIT = 4096;
    public static final int LOCAL_DIVERSIFICATION_ENTRIES_LIMIT = 512;
    public static final int LOCAL_DIVERSIFICATION_READS_PER_MIN_SAMPLES = 3;
    public static final int LOCAL_DIVERSIFICATION_READS_PER_MIN = 30;
    public static final int MAX_STORAGE_KEYS = 65536;
    private int network;
    private DHTLogger log;
    private File data_dir;
    private AEMonitor address_mon = new AEMonitor("DHTPluginStorageManager:address");
    private AEMonitor contact_mon = new AEMonitor("DHTPluginStorageManager:contact");
    private AEMonitor storage_mon = new AEMonitor("DHTPluginStorageManager:storage");
    private AEMonitor version_mon = new AEMonitor("DHTPluginStorageManager:version");
    private AEMonitor key_block_mon = new AEMonitor("DHTPluginStorageManager:block");
    private Map version_map = new HashMap();
    private Map recent_addresses = new HashMap();
    private Map remote_diversifications = new HashMap();
    private Map local_storage_keys = new HashMap();
    private volatile ByteArrayHashMap key_block_map_cow = new ByteArrayHashMap();
    private volatile DHTStorageBlock[] key_blocks_direct_cow = new DHTStorageBlock[0];
    private BloomFilter kb_verify_fail_bloom;
    private long kb_verify_fail_bloom_create_time;
    private static RSAPublicKey key_block_public_key;

    public DHTPluginStorageManager(int _network, DHTLogger _log, File _data_dir) {
        this.network = _network;
        this.log = _log;
        this.data_dir = _data_dir;
        this.data_dir.mkdirs();
        this.readRecentAddresses();
        this.readDiversifications();
        this.readVersionData();
        this.readKeyBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importContacts(DHT dht) {
        block9: {
            try {
                this.contact_mon.enter();
                File target = new File(this.data_dir, "contacts.dat");
                if (!target.exists()) {
                    target = new File(this.data_dir, "contacts.saving");
                }
                if (!target.exists()) break block9;
                DataInputStream dis = new DataInputStream(new FileInputStream(target));
                try {
                    dht.importState(dis);
                }
                finally {
                    dis.close();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            finally {
                this.contact_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportContacts(DHT dht) {
        block10: {
            try {
                this.contact_mon.enter();
                File saving = new File(this.data_dir, "contacts.saving");
                File target = new File(this.data_dir, "contacts.dat");
                saving.delete();
                DataOutputStream dos = null;
                boolean ok = false;
                try {
                    dos = new DataOutputStream(new FileOutputStream(saving));
                    dht.exportState(dos, 32);
                    ok = true;
                    Object var7_7 = null;
                    if (dos == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (dos != null) {
                        dos.close();
                        if (ok) {
                            target.delete();
                            saving.renameTo(target);
                        }
                    }
                    throw throwable;
                }
                dos.close();
                if (ok) {
                    target.delete();
                    saving.renameTo(target);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            finally {
                this.contact_mon.exit();
            }
        }
        this.writeDiversifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRecentAddresses() {
        try {
            this.address_mon.enter();
            this.recent_addresses = this.readMapFromFile("addresses");
        }
        finally {
            this.address_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRecentAddresses() {
        try {
            this.address_mon.enter();
            Iterator it = this.recent_addresses.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equals("most_recent")) continue;
                Long time = (Long)this.recent_addresses.get(key);
                if (SystemTime.getCurrentTime() - time <= 604800000L) continue;
                it.remove();
            }
            this.writeMapToFile(this.recent_addresses, "addresses");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            this.address_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordCurrentAddress(String address) {
        try {
            this.address_mon.enter();
            this.recent_addresses.put(address, new Long(SystemTime.getCurrentTime()));
            this.recent_addresses.put("most_recent", address.getBytes());
            this.writeRecentAddresses();
        }
        finally {
            this.address_mon.exit();
        }
    }

    protected String getMostRecentAddress() {
        byte[] addr = (byte[])this.recent_addresses.get("most_recent");
        if (addr == null) {
            return null;
        }
        return new String(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRecentAddress(String address) {
        try {
            this.address_mon.enter();
            if (this.recent_addresses.containsKey(address)) {
                boolean bl = true;
                return bl;
            }
            String most_recent = this.getMostRecentAddress();
            boolean bl = most_recent != null && most_recent.equals(address);
            return bl;
        }
        finally {
            this.address_mon.exit();
        }
    }

    protected void localContactChanged(DHTTransportContact contact) {
        this.purgeDirectKeyBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map readMapFromFile(String file_prefix) {
        block6: {
            Map map;
            File target = new File(this.data_dir, file_prefix + ".dat");
            if (!target.exists()) {
                target = new File(this.data_dir, file_prefix + ".saving");
            }
            if (!target.exists()) break block6;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(target));
            try {
                map = BDecoder.decode(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            is.close();
            return map;
        }
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMapToFile(Map map, String file_prefix) {
        block8: {
            try {
                File saving = new File(this.data_dir, file_prefix + ".saving");
                File target = new File(this.data_dir, file_prefix + ".dat");
                saving.delete();
                if (map.size() == 0) {
                    target.delete();
                    break block8;
                }
                FileOutputStream os = null;
                boolean ok = false;
                try {
                    byte[] data = BEncoder.encode(map);
                    os = new FileOutputStream(saving);
                    os.write(data);
                    os.close();
                    ok = true;
                    Object var9_9 = null;
                    if (os == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (os != null) {
                        os.close();
                        if (ok) {
                            target.delete();
                            saving.renameTo(target);
                        }
                    }
                    throw throwable;
                }
                os.close();
                if (ok) {
                    target.delete();
                    saving.renameTo(target);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readVersionData() {
        try {
            this.version_mon.enter();
            this.version_map = this.readMapFromFile("version");
        }
        finally {
            this.version_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeVersionData() {
        try {
            this.version_mon.enter();
            this.writeMapToFile(this.version_map, "version");
        }
        finally {
            this.version_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextValueVersions(int num) {
        try {
            int next;
            this.version_mon.enter();
            Long l_next = (Long)this.version_map.get("next");
            int now = (int)(SystemTime.getCurrentTime() / 1000L);
            if (l_next == null) {
                next = now;
            } else {
                next = l_next.intValue();
                if (next < now) {
                    next = now;
                }
            }
            this.version_map.put("next", new Long(next + num));
            this.writeVersionData();
            int n = next;
            return n;
        }
        finally {
            this.version_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTStorageKey keyCreated(HashWrapper key, boolean local) {
        try {
            this.storage_mon.enter();
            storageKey storageKey2 = this.getStorageKey(key);
            return storageKey2;
        }
        finally {
            this.storage_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyDeleted(DHTStorageKey key) {
        try {
            this.storage_mon.enter();
            this.deleteStorageKey((storageKey)key);
        }
        finally {
            this.storage_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyRead(DHTStorageKey key, DHTTransportContact contact) {
        try {
            this.storage_mon.enter();
            ((storageKey)key).read(contact);
        }
        finally {
            this.storage_mon.exit();
        }
    }

    public void serialiseStats(storageKey key, DataOutputStream dos) throws IOException {
        dos.writeByte(0);
        dos.writeInt(key.getEntryCount());
        dos.writeInt(key.getSize());
        dos.writeInt(key.getReadsPerMinute());
        dos.writeByte(key.getDiversificationType());
    }

    public DHTStorageKeyStats deserialiseStats(DataInputStream is) throws IOException {
        byte version = is.readByte();
        final int entry_count = is.readInt();
        final int size = is.readInt();
        final int reads = is.readInt();
        final byte div = is.readByte();
        return new DHTStorageKeyStats(){

            public int getEntryCount() {
                return entry_count;
            }

            public int getSize() {
                return size;
            }

            public int getReadsPerMinute() {
                return reads;
            }

            public byte getDiversification() {
                return div;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueAdded(DHTStorageKey key, DHTTransportValue value) {
        try {
            this.storage_mon.enter();
            ((storageKey)key).valueChanged(1, value.getValue().length);
        }
        finally {
            this.storage_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUpdated(DHTStorageKey key, DHTTransportValue old_value, DHTTransportValue new_value) {
        try {
            this.storage_mon.enter();
            ((storageKey)key).valueChanged(0, new_value.getValue().length - old_value.getValue().length);
        }
        finally {
            this.storage_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueDeleted(DHTStorageKey key, DHTTransportValue value) {
        try {
            this.storage_mon.enter();
            ((storageKey)key).valueChanged(-1, -value.getValue().length);
        }
        finally {
            this.storage_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDiversified(byte[] key) {
        HashWrapper wrapper2 = new HashWrapper(key);
        try {
            this.storage_mon.enter();
            boolean bl = this.lookupDiversification(wrapper2) != null;
            return bl;
        }
        finally {
            this.storage_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getExistingDiversification(byte[] key, boolean put_operation, boolean exhaustive) {
        HashWrapper wrapper2 = new HashWrapper(key);
        try {
            this.storage_mon.enter();
            byte[][] res = this.followDivChain(wrapper2, put_operation, exhaustive);
            if (!Arrays.equals(res[0], key)) {
                String trace = "";
                for (int i = 0; i < res.length; ++i) {
                    trace = trace + (i == 0 ? "" : ",") + DHTLog.getString2(res[i]);
                }
                this.log.log("SM: get div: " + DHTLog.getString2(key) + ", put = " + put_operation + ", exh = " + exhaustive + " -> " + trace);
            }
            byte[][] byArray = res;
            return byArray;
        }
        finally {
            this.storage_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] createNewDiversification(DHTTransportContact cause, byte[] key, boolean put_operation, byte diversification_type, boolean exhaustive) {
        HashWrapper wrapper2 = new HashWrapper(key);
        try {
            this.storage_mon.enter();
            diversification div = this.lookupDiversification(wrapper2);
            boolean created = false;
            if (div == null) {
                div = this.createDiversification(wrapper2, diversification_type);
                created = true;
            }
            byte[][] res = this.followDivChain(wrapper2, put_operation, exhaustive);
            String trace = "";
            for (int i = 0; i < res.length; ++i) {
                trace = trace + (i == 0 ? "" : ",") + DHTLog.getString2(res[i]);
            }
            this.log.log("SM: create div: " + DHTLog.getString2(key) + ", new = " + created + ", put = " + put_operation + ", exh = " + exhaustive + ", type = " + DHT.DT_STRINGS[diversification_type] + " -> " + trace + ", cause = " + (cause == null ? "<unknown>" : cause.getString()));
            byte[][] byArray = res;
            return byArray;
        }
        finally {
            this.storage_mon.exit();
        }
    }

    protected byte[][] followDivChain(HashWrapper wrapper2, boolean put_operation, boolean exhaustive) {
        List list = new ArrayList<HashWrapper>();
        list.add(wrapper2);
        list = this.followDivChain(list, put_operation, 0, exhaustive, new ArrayList());
        byte[][] res = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = ((HashWrapper)list.get(i)).getBytes();
        }
        return res;
    }

    protected List followDivChain(List list_in, boolean put_operation, int depth, boolean exhaustive, List keys_done) {
        ArrayList<HashWrapper> list_out = new ArrayList<HashWrapper>();
        for (int i = 0; i < list_in.size(); ++i) {
            HashWrapper wrapper2 = (HashWrapper)list_in.get(i);
            diversification div = this.lookupDiversification(wrapper2);
            if (div == null) {
                if (list_out.contains(wrapper2)) continue;
                list_out.add(wrapper2);
                continue;
            }
            if (keys_done.contains(wrapper2)) {
                if (list_out.contains(wrapper2)) continue;
                list_out.add(wrapper2);
                continue;
            }
            keys_done.add(wrapper2);
            List new_list = this.followDivChain(div.getKeys(put_operation, exhaustive), put_operation, depth + 1, exhaustive, keys_done);
            for (int j = 0; j < new_list.size(); ++j) {
                Object entry = new_list.get(j);
                if (list_out.contains(entry)) continue;
                list_out.add((HashWrapper)entry);
            }
        }
        return list_out;
    }

    protected storageKey getStorageKey(HashWrapper key) {
        storageKey res = (storageKey)this.local_storage_keys.get(key);
        if (res == null) {
            if (this.local_storage_keys.size() >= 65536) {
                res = new storageKey(this, 3, key);
                Debug.out("DHTStorageManager: max key limit exceeded");
                this.log.log("SM: max storage key limit exceeded - " + DHTLog.getString2(key.getBytes()));
            } else {
                res = new storageKey(this, 1, key);
                this.local_storage_keys.put(key, res);
            }
        }
        return res;
    }

    protected void deleteStorageKey(storageKey key) {
        if (this.local_storage_keys.remove(key) != null && key.getDiversificationType() != 1) {
            this.writeDiversifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readDiversifications() {
        try {
            List divs;
            this.storage_mon.enter();
            Map map = this.readMapFromFile("diverse");
            List keys = (List)map.get("local");
            if (keys != null) {
                long now = SystemTime.getCurrentTime();
                for (int i = 0; i < keys.size(); ++i) {
                    storageKey d = storageKey.deserialise(this, (Map)keys.get(i));
                    long time_left = d.getExpiry() - now;
                    if (time_left > 0L) {
                        this.local_storage_keys.put(d.getKey(), d);
                        continue;
                    }
                    this.log.log("SM: serialised sk: " + DHTLog.getString2(d.getKey().getBytes()) + " expired");
                }
            }
            if ((divs = (List)map.get("remote")) != null) {
                long now = SystemTime.getCurrentTime();
                for (int i = 0; i < divs.size(); ++i) {
                    diversification d = diversification.deserialise(this, (Map)divs.get(i));
                    long time_left = d.getExpiry() - now;
                    if (time_left > 0L) {
                        this.remote_diversifications.put(d.getKey(), d);
                        continue;
                    }
                    this.log.log("SM: serialised div: " + DHTLog.getString2(d.getKey().getBytes()) + " expired");
                }
            }
        }
        finally {
            this.storage_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDiversifications() {
        try {
            this.storage_mon.enter();
            HashMap map = new HashMap();
            ArrayList<Map> keys = new ArrayList<Map>();
            map.put("local", keys);
            Iterator it = this.local_storage_keys.values().iterator();
            while (it.hasNext()) {
                storageKey key = (storageKey)it.next();
                if (key.getDiversificationType() == 1) continue;
                keys.add(key.serialise());
            }
            ArrayList<Map> divs = new ArrayList<Map>();
            map.put("remote", divs);
            it = this.remote_diversifications.values().iterator();
            while (it.hasNext()) {
                divs.add(((diversification)it.next()).serialise());
            }
            this.writeMapToFile(map, "diverse");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            this.storage_mon.exit();
        }
    }

    protected diversification lookupDiversification(HashWrapper wrapper2) {
        diversification div = (diversification)this.remote_diversifications.get(wrapper2);
        if (div != null && div.getExpiry() < SystemTime.getCurrentTime()) {
            this.log.log("SM: div: " + DHTLog.getString2(div.getKey().getBytes()) + " expired");
            this.remote_diversifications.remove(wrapper2);
            div = null;
        }
        return div;
    }

    protected diversification createDiversification(HashWrapper wrapper2, byte type) {
        diversification div = new diversification(this, wrapper2, type);
        this.remote_diversifications.put(wrapper2, div);
        this.writeDiversifications();
        return div;
    }

    protected static String formatExpiry(long l) {
        long diff = l - SystemTime.getCurrentTime();
        return (diff < 0L ? "-" : "") + DisplayFormatters.formatTime(Math.abs(diff));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readKeyBlocks() {
        try {
            this.key_block_mon.enter();
            Map map = this.readMapFromFile("block");
            List entries = (List)map.get("entries");
            int now_secs = (int)(SystemTime.getCurrentTime() / 1000L);
            ByteArrayHashMap new_map = new ByteArrayHashMap();
            if (entries != null) {
                for (int i = 0; i < entries.size(); ++i) {
                    try {
                        boolean direct;
                        Map m = (Map)entries.get(i);
                        byte[] request2 = (byte[])m.get("req");
                        byte[] cert = (byte[])m.get("cert");
                        int recv = ((Long)m.get("received")).intValue();
                        boolean bl = direct = (Long)m.get("direct") == 1L;
                        if (recv > now_secs) {
                            recv = now_secs;
                        }
                        keyBlock kb = new keyBlock(request2, cert, recv, direct);
                        if ((!direct || !kb.isAdd()) && (long)(now_secs - recv) >= 604800L || !DHTPluginStorageManager.verifyKeyBlock(request2, cert)) continue;
                        this.log.log("KB: deserialised " + DHTLog.getString2(kb.getKey()) + ",add=" + kb.isAdd() + ",dir=" + kb.isDirect());
                        new_map.put(kb.getKey(), kb);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            this.key_block_map_cow = new_map;
            this.key_blocks_direct_cow = this.buildKeyBlockDetails(new_map);
        }
        finally {
            this.key_block_mon.exit();
        }
    }

    protected DHTStorageBlock[] buildKeyBlockDetails(ByteArrayHashMap map) {
        List kbs = map.values();
        Iterator it = kbs.iterator();
        while (it.hasNext()) {
            keyBlock kb = (keyBlock)it.next();
            if (kb.isDirect()) continue;
            it.remove();
        }
        DHTStorageBlock[] new_blocks = new DHTStorageBlock[kbs.size()];
        kbs.toArray(new_blocks);
        return new_blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeKeyBlocks() {
        try {
            this.key_block_mon.enter();
            HashMap map = new HashMap();
            ArrayList entries = new ArrayList();
            map.put("entries", entries);
            List kbs = this.key_block_map_cow.values();
            for (int i = 0; i < kbs.size(); ++i) {
                keyBlock kb = (keyBlock)kbs.get(i);
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("req", kb.getRequest());
                m.put("cert", kb.getCertificate());
                m.put("received", new Long(kb.getReceived()));
                m.put("direct", new Long(kb.isDirect() ? 1L : 0L));
                entries.add(m);
            }
            this.writeMapToFile(map, "block");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            this.key_block_mon.exit();
        }
    }

    /*
     * Exception decompiling
     */
    public DHTStorageBlock keyBlockRequest(DHTTransportContact originating_contact, byte[] request, byte[] signature) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean verifyKeyBlock(keyBlock kb, DHTTransportContact originator) {
        byte[] id = originator == null ? new byte[20] : originator.getID();
        BloomFilter filter = this.kb_verify_fail_bloom;
        long now = SystemTime.getCurrentTime();
        if (filter == null || this.kb_verify_fail_bloom_create_time > now || now - this.kb_verify_fail_bloom_create_time > 1800000L) {
            this.kb_verify_fail_bloom_create_time = now;
            this.kb_verify_fail_bloom = filter = BloomFilterFactory.createAddOnly(4000);
        }
        if (filter.contains(id)) {
            this.log.log("KB: request verify denied");
            return false;
        }
        try {
            Signature verifier = Signature.getInstance("MD5withRSA");
            verifier.initVerify(key_block_public_key);
            verifier.update(kb.getRequest());
            if (!verifier.verify(kb.getCertificate())) {
                this.log.log("KB: request verify failed for " + DHTLog.getString2(kb.getKey()));
                filter.add(id);
                return false;
            }
            this.log.log("KB: request verify ok " + DHTLog.getString2(kb.getKey()) + ", add = " + kb.isAdd() + ", direct = " + kb.isDirect());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean verifyKeyBlock(byte[] request2, byte[] signature) {
        try {
            Signature verifier = Signature.getInstance("MD5withRSA");
            verifier.initVerify(key_block_public_key);
            verifier.update(request2);
            return verifier.verify(signature);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public DHTStorageBlock getKeyBlockDetails(byte[] key) {
        keyBlock kb = (keyBlock)this.key_block_map_cow.get(key);
        if (kb == null || !kb.isAdd()) {
            return null;
        }
        if (!kb.getLogged()) {
            kb.setLogged();
            this.log.log("KB: Access to key '" + DHTLog.getFullString(kb.getKey()) + "' denied as it is blocked");
        }
        return kb;
    }

    public DHTStorageBlock[] getDirectKeyBlocks() {
        return this.key_blocks_direct_cow;
    }

    public byte[] getKeyForKeyBlock(byte[] request2) {
        if (request2.length <= 8) {
            return new byte[0];
        }
        byte[] key = new byte[request2.length - 8];
        System.arraycopy(request2, 8, key, 0, key.length);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeDirectKeyBlocks() {
        try {
            this.key_block_mon.enter();
            ByteArrayHashMap new_map = new ByteArrayHashMap();
            Iterator it = this.key_block_map_cow.values().iterator();
            boolean changed = false;
            while (it.hasNext()) {
                keyBlock kb = (keyBlock)it.next();
                if (kb.isDirect()) {
                    changed = true;
                    continue;
                }
                new_map.put(kb.getKey(), kb);
            }
            if (changed) {
                this.log.log("KB: Purged direct entries on ID change");
                this.key_block_map_cow = new_map;
                this.key_blocks_direct_cow = this.buildKeyBlockDetails(this.key_block_map_cow);
                this.writeKeyBlocks();
            }
        }
        finally {
            this.key_block_mon.exit();
        }
    }

    static {
        try {
            KeyFactory key_factory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec public_key_spec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(pub_exp, 16));
            key_block_public_key = (RSAPublicKey)key_factory.generatePublic(public_key_spec);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected static class storageKey
    implements DHTStorageKey {
        private DHTPluginStorageManager manager;
        private HashWrapper key;
        private byte type;
        private int size;
        private int entries;
        private long expiry;
        private long read_count_start;
        private short reads_per_min;
        private BloomFilter ip_bloom_filter;

        protected storageKey(DHTPluginStorageManager _manager, byte _type, HashWrapper _key) {
            this.manager = _manager;
            this.type = _type;
            this.key = _key;
            this.expiry = SystemTime.getCurrentTime() + 172800000L + (long)(Math.random() * 8.64E7);
        }

        protected storageKey(DHTPluginStorageManager _manager, byte _type, HashWrapper _key, long _expiry) {
            this.manager = _manager;
            this.type = _type;
            this.key = _key;
            this.expiry = _expiry;
        }

        protected Map serialise() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", this.key.getBytes());
            map.put("type", new Long(this.type));
            map.put("exp", new Long(this.expiry));
            this.manager.log.log("SM: serialised sk: " + DHTLog.getString2(this.key.getBytes()) + ", " + DHT.DT_STRINGS[this.type] + ", " + DHTPluginStorageManager.formatExpiry(this.expiry));
            return map;
        }

        protected static storageKey deserialise(DHTPluginStorageManager _manager, Map map) {
            HashWrapper key = new HashWrapper((byte[])map.get("key"));
            int type = ((Long)map.get("type")).intValue();
            long exp = (Long)map.get("exp");
            _manager.log.log("SM: deserialised sk: " + DHTLog.getString2(key.getBytes()) + ", " + DHT.DT_STRINGS[type] + ", " + DHTPluginStorageManager.formatExpiry(exp));
            return new storageKey(_manager, (byte)type, key, exp);
        }

        public void serialiseStats(DataOutputStream dos) throws IOException {
            this.manager.serialiseStats(this, dos);
        }

        protected HashWrapper getKey() {
            return this.key;
        }

        protected long getExpiry() {
            return this.expiry;
        }

        public byte getDiversificationType() {
            if (this.type != 1 && this.expiry < SystemTime.getCurrentTime()) {
                this.type = 1;
                this.manager.log.log("SM: sk: " + DHTLog.getString2(this.getKey().getBytes()) + " expired");
                this.manager.writeDiversifications();
            }
            return this.type;
        }

        public int getReadsPerMinute() {
            return this.reads_per_min;
        }

        public int getSize() {
            return this.size;
        }

        public int getEntryCount() {
            return this.entries;
        }

        protected void read(DHTTransportContact contact) {
            if (this.type == 1) {
                long now = SystemTime.getCurrentTime();
                long diff = now - this.read_count_start;
                if (diff > 180000L) {
                    if (this.ip_bloom_filter != null) {
                        int ip_entries = this.ip_bloom_filter.getEntryCount();
                        this.reads_per_min = (short)(ip_entries / 3);
                        if (this.reads_per_min == 0 && ip_entries > 0) {
                            this.reads_per_min = 1;
                        }
                        if (ip_entries > 90) {
                            this.type = (byte)2;
                            this.manager.log.log("SM: sk freq created (" + ip_entries + "reads ) - " + DHTLog.getString2(this.key.getBytes()));
                            this.manager.writeDiversifications();
                        }
                    }
                    this.read_count_start = now;
                    this.ip_bloom_filter = null;
                } else {
                    if (this.ip_bloom_filter == null) {
                        this.ip_bloom_filter = BloomFilterFactory.createAddOnly(300);
                    }
                    byte[] address_bytes = contact.getAddress().getAddress().getAddress();
                    this.ip_bloom_filter.add(address_bytes);
                }
            }
        }

        protected void valueChanged(int entries_diff, int size_diff) {
            this.entries += entries_diff;
            this.size += size_diff;
            if (this.entries < 0) {
                Debug.out("entries negative");
                this.entries = 0;
            }
            if (this.size < 0) {
                Debug.out("size negative");
                this.size = 0;
            }
            if (this.type == 1) {
                if (this.size > 4096) {
                    this.type = (byte)3;
                    this.manager.log.log("SM: sk size total created (size " + this.size + ") - " + DHTLog.getString2(this.key.getBytes()));
                    this.manager.writeDiversifications();
                } else if (this.entries > 512) {
                    this.type = (byte)3;
                    this.manager.log.log("SM: sk size entries created (" + this.entries + " entries) - " + DHTLog.getString2(this.key.getBytes()));
                    this.manager.writeDiversifications();
                }
            }
        }
    }

    protected static class diversification {
        private DHTPluginStorageManager manager;
        private HashWrapper key;
        private byte type;
        private long expiry;
        private int[] fixed_put_offsets;

        protected diversification(DHTPluginStorageManager _manager, HashWrapper _key, byte _type) {
            this.manager = _manager;
            this.key = _key;
            this.type = _type;
            this.expiry = SystemTime.getCurrentTime() + 172800000L + (long)(Math.random() * 8.64E7);
            this.fixed_put_offsets = new int[2];
            int pos = 0;
            while (pos < 2) {
                int i = (int)(Math.random() * 10.0);
                boolean found = false;
                for (int j = 0; j < pos; ++j) {
                    if (i != this.fixed_put_offsets[j]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.fixed_put_offsets[pos++] = i;
            }
        }

        protected diversification(DHTPluginStorageManager _manager, HashWrapper _key, byte _type, long _expiry, int[] _fixed_put_offsets) {
            this.manager = _manager;
            this.key = _key;
            this.type = _type;
            this.expiry = _expiry;
            this.fixed_put_offsets = _fixed_put_offsets;
        }

        protected Map serialise() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", this.key.getBytes());
            map.put("type", new Long(this.type));
            map.put("exp", new Long(this.expiry));
            ArrayList<Long> offsets = new ArrayList<Long>();
            for (int i = 0; i < this.fixed_put_offsets.length; ++i) {
                offsets.add(new Long(this.fixed_put_offsets[i]));
            }
            map.put("fpo", offsets);
            this.manager.log.log("SM: serialised div: " + DHTLog.getString2(this.key.getBytes()) + ", " + DHT.DT_STRINGS[this.type] + ", " + DHTPluginStorageManager.formatExpiry(this.expiry));
            return map;
        }

        protected static diversification deserialise(DHTPluginStorageManager _manager, Map _map) {
            HashWrapper key = new HashWrapper((byte[])_map.get("key"));
            int type = ((Long)_map.get("type")).intValue();
            long exp = (Long)_map.get("exp");
            List offsets = (List)_map.get("fpo");
            int[] fops = new int[offsets.size()];
            for (int i = 0; i < fops.length; ++i) {
                fops[i] = ((Long)offsets.get(i)).intValue();
            }
            _manager.log.log("SM: deserialised div: " + DHTLog.getString2(key.getBytes()) + ", " + DHT.DT_STRINGS[type] + ", " + DHTPluginStorageManager.formatExpiry(exp));
            return new diversification(_manager, key, (byte)type, exp, fops);
        }

        protected HashWrapper getKey() {
            return this.key;
        }

        protected long getExpiry() {
            return this.expiry;
        }

        protected List getKeys(boolean put, boolean exhaustive) {
            ArrayList<HashWrapper> keys;
            block11: {
                block9: {
                    block10: {
                        keys = new ArrayList<HashWrapper>();
                        if (!put) break block9;
                        if (this.type != 2) break block10;
                        for (int i = 0; i < 10; ++i) {
                            keys.add(this.diversifyKey(this.key, i));
                        }
                        if (!exhaustive) break block11;
                        keys.add(this.key);
                        break block11;
                    }
                    for (int i = 0; i < this.fixed_put_offsets.length; ++i) {
                        keys.add(this.diversifyKey(this.key, this.fixed_put_offsets[i]));
                    }
                    if (!exhaustive) break block11;
                    keys.add(this.key);
                    break block11;
                }
                if (this.type == 2) {
                    keys.add(this.diversifyKey(this.key, (int)(Math.random() * 10.0)));
                } else if (exhaustive) {
                    for (int i = 0; i < 10; ++i) {
                        keys.add(this.diversifyKey(this.key, i));
                    }
                } else {
                    ArrayList<Integer> randoms = new ArrayList<Integer>();
                    while (randoms.size() < 2) {
                        Integer i = new Integer((int)(Math.random() * 10.0));
                        if (randoms.contains(i)) continue;
                        randoms.add(i);
                    }
                    for (int i = 0; i < 2; ++i) {
                        keys.add(this.diversifyKey(this.key, (Integer)randoms.get(i)));
                    }
                }
            }
            return keys;
        }

        protected HashWrapper diversifyKey(HashWrapper key_in, int offset) {
            byte[] old_bytes = key_in.getBytes();
            byte[] bytes = new byte[old_bytes.length + 1];
            System.arraycopy(old_bytes, 0, bytes, 0, old_bytes.length);
            bytes[old_bytes.length] = (byte)offset;
            return new HashWrapper(new SHA1Simple().calculateHash(bytes));
        }
    }

    protected static class keyBlock
    implements DHTStorageBlock {
        private byte[] request;
        private byte[] cert;
        private int received;
        private boolean direct;
        private BloomFilter sent_to_bloom;
        private boolean logged;

        protected keyBlock(byte[] _request, byte[] _cert, int _received, boolean _direct) {
            this.request = _request;
            this.cert = _cert;
            this.received = _received;
            this.direct = _direct;
        }

        public byte[] getRequest() {
            return this.request;
        }

        public byte[] getCertificate() {
            return this.cert;
        }

        public byte[] getKey() {
            byte[] key = new byte[this.request.length - 8];
            System.arraycopy(this.request, 8, key, 0, key.length);
            return key;
        }

        protected boolean isAdd() {
            return this.request[0] == 1;
        }

        protected boolean getLogged() {
            return this.logged;
        }

        protected void setLogged() {
            this.logged = true;
        }

        protected int getCreated() {
            int created = this.request[4] << 24 & 0xFF000000 | this.request[5] << 16 & 0xFF0000 | this.request[6] << 8 & 0xFF00 | this.request[7] & 0xFF;
            return created;
        }

        protected int getReceived() {
            return this.received;
        }

        protected boolean isDirect() {
            return this.direct;
        }

        public boolean hasBeenSentTo(DHTTransportContact contact) {
            BloomFilter filter = this.sent_to_bloom;
            if (filter == null) {
                return false;
            }
            return filter.contains(contact.getID());
        }

        public void sentTo(DHTTransportContact contact) {
            BloomFilter filter = this.sent_to_bloom;
            if (filter == null || filter.getEntryCount() > 100) {
                this.sent_to_bloom = filter = BloomFilterFactory.createAddOnly(500);
            }
            filter.add(contact.getID());
        }
    }
}

