/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.dht;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyEvent;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTTrackerPlugin
implements Plugin,
DownloadListener,
DownloadPropertyListener,
DownloadTrackerListener {
    private static final String PLUGIN_NAME = "Distributed Tracker";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.dhttracker";
    private static final int ANNOUNCE_TIMEOUT = 120000;
    private static final int SCRAPE_TIMEOUT = 30000;
    private static final int ANNOUNCE_MIN_DEFAULT = 120000;
    private static final int ANNOUNCE_MAX = 3600000;
    private static final int INTERESTING_CHECK_PERIOD = 14400000;
    private static final int INTERESTING_INIT_RAND = 1800000;
    private static final int INTERESTING_INIT_MIN = 300000;
    private static final int INTERESTING_AVAIL_MAX = 8;
    private static final int INTERESTING_PUB_MAX_DEFAULT = 30;
    private static final boolean TRACK_NORMAL_DEFAULT = true;
    private static final int NUM_WANT = 30;
    private static URL DEFAULT_URL;
    private PluginInterface plugin_interface;
    private DHTPlugin dht;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_peer_sources;
    private Map interesting_downloads = new HashMap();
    private int interesting_published = 0;
    private int interesting_pub_max = 30;
    private Set running_downloads = new HashSet();
    private Map registered_downloads = new HashMap();
    private Map query_map = new HashMap();
    private Map in_progress = new HashMap();
    private BooleanParameter track_normal_when_offline;
    private LoggerChannel log;
    private Map scrape_injection_map = new WeakHashMap();
    private AEMonitor this_mon = new AEMonitor("DHTTrackerPlugin");
    static /* synthetic */ Class class$com$aelitis$azureus$plugins$dht$DHTPlugin;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
        this.ta_peer_sources = this.plugin_interface.getTorrentManager().getAttribute("PeerSources");
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(PLUGIN_NAME);
        model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        this.track_normal_when_offline = config.addBooleanParameter2("dhttracker.tracknormalwhenoffline", "dhttracker.tracknormalwhenoffline", true);
        this.track_normal_when_offline.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DHTTrackerPlugin.this.configChanged();
            }
        });
        this.interesting_pub_max = this.plugin_interface.getPluginconfig().getPluginIntParameter("dhttracker.presencepubmax", 30);
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        model.getLogArea().setMaximumSize(80000);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        model.getStatus().setText("Initialising");
        this.log.log("Waiting for Distributed Database initialisation");
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                PluginInterface dht_pi = DHTTrackerPlugin.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(class$com$aelitis$azureus$plugins$dht$DHTPlugin == null ? (class$com$aelitis$azureus$plugins$dht$DHTPlugin = DHTTrackerPlugin.class$("com.aelitis.azureus.plugins.dht.DHTPlugin")) : class$com$aelitis$azureus$plugins$dht$DHTPlugin);
                if (dht_pi != null) {
                    DHTTrackerPlugin.this.dht = (DHTPlugin)dht_pi.getPlugin();
                    AEThread t = new AEThread(this, "DHTTrackerPlugin:init"){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            super(x0);
                        }

                        public void runSupport() {
                            try {
                                if (DHTTrackerPlugin.access$100(3.access$200(this.this$1)).isEnabled()) {
                                    DHTTrackerPlugin.access$300(3.access$200(this.this$1)).log("DDB Available");
                                    3.access$400(this.this$1).getStatus().setText("Running");
                                    3.access$200(this.this$1).initialise();
                                } else {
                                    DHTTrackerPlugin.access$300(3.access$200(this.this$1)).log("DDB Disabled");
                                    3.access$400(this.this$1).getStatus().setText("Disabled, Distributed database not available");
                                    3.access$200(this.this$1).notRunning();
                                }
                            }
                            catch (Throwable e) {
                                DHTTrackerPlugin.access$300(3.access$200(this.this$1)).log("DDB Failed", e);
                                3.access$400(this.this$1).getStatus().setText("Failed");
                                3.access$200(this.this$1).notRunning();
                            }
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                } else {
                    DHTTrackerPlugin.this.log.log("DDB Plugin missing");
                    model.getStatus().setText("Failed");
                    DHTTrackerPlugin.this.notRunning();
                }
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }

            static /* synthetic */ DHTTrackerPlugin access$200(3 x0) {
                return x0.DHTTrackerPlugin.this;
            }

            static /* synthetic */ BasicPluginViewModel access$400(3 x0) {
                return x0.model;
            }
        });
    }

    protected void notRunning() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                Torrent torrent = download.getTorrent();
                if (torrent != null && torrent.isDecentralised()) {
                    download.addListener(new DownloadListener(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void stateChanged(Download download, int old_state, int new_state) {
                            int state = download.getState();
                            if (state == 4 || state == 5) {
                                download.setAnnounceResult(new DownloadAnnounceResult(this, download){
                                    private final /* synthetic */ Download val$download;
                                    private final /* synthetic */ 6 this$2;
                                    {
                                        this.this$2 = this$2;
                                        this.val$download = val$download;
                                    }

                                    public Download getDownload() {
                                        return this.val$download;
                                    }

                                    public int getResponseType() {
                                        return 2;
                                    }

                                    public int getReportedPeerCount() {
                                        return 0;
                                    }

                                    public int getSeedCount() {
                                        return 0;
                                    }

                                    public int getNonSeedCount() {
                                        return 0;
                                    }

                                    public String getError() {
                                        return "Distributed Database Offline";
                                    }

                                    public URL getURL() {
                                        return this.val$download.getTorrent().getAnnounceURL();
                                    }

                                    public DownloadAnnounceResultPeer[] getPeers() {
                                        return new DownloadAnnounceResultPeer[0];
                                    }

                                    public long getTimeToWait() {
                                        return 0L;
                                    }

                                    public Map getExtensions() {
                                        return null;
                                    }
                                });
                            }
                        }

                        public void positionChanged(Download download, int oldPosition, int newPosition) {
                        }
                    });
                    download.setScrapeResult(new DownloadScrapeResult(this, download){
                        private final /* synthetic */ Download val$download;
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$download = val$download;
                        }

                        public Download getDownload() {
                            return this.val$download;
                        }

                        public int getResponseType() {
                            return 2;
                        }

                        public int getSeedCount() {
                            return -1;
                        }

                        public int getNonSeedCount() {
                            return -1;
                        }

                        public long getScrapeStartTime() {
                            return SystemTime.getCurrentTime();
                        }

                        public void setNextScrapeStartTime(long nextScrapeStartTime) {
                        }

                        public long getNextScrapeStartTime() {
                            return -1L;
                        }

                        public String getStatus() {
                            return "Distributed Database Offline";
                        }

                        public URL getURL() {
                            return this.val$download.getTorrent().getAnnounceURL();
                        }
                    });
                }
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    protected void initialise() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){
            Random random = new Random();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void downloadAdded(Download download) {
                String[] networks = download.getListAttribute(DHTTrackerPlugin.this.ta_networks);
                Torrent torrent = download.getTorrent();
                if (torrent != null && networks != null) {
                    boolean public_net = false;
                    for (int i = 0; i < networks.length; ++i) {
                        if (!networks[i].equalsIgnoreCase("Public")) continue;
                        public_net = true;
                        break;
                    }
                    if (public_net && !torrent.isPrivate()) {
                        try {
                            DHTTrackerPlugin.this.this_mon.enter();
                            DHTTrackerPlugin.this.interesting_downloads.put(download, new Long(DHTTrackerPlugin.this.plugin_interface.getUtilities().getCurrentSystemTime() + 300000L + (long)this.random.nextInt(1800000)));
                        }
                        finally {
                            DHTTrackerPlugin.this.this_mon.exit();
                        }
                    }
                }
                download.addPropertyListener(DHTTrackerPlugin.this);
                download.addTrackerListener(DHTTrackerPlugin.this);
                download.addListener(DHTTrackerPlugin.this);
                DHTTrackerPlugin.this.checkDownloadForRegistration(download, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void downloadRemoved(Download download) {
                download.removePropertyListener(DHTTrackerPlugin.this);
                download.removeTrackerListener(DHTTrackerPlugin.this);
                download.removeListener(DHTTrackerPlugin.this);
                try {
                    DHTTrackerPlugin.this.this_mon.enter();
                    DHTTrackerPlugin.this.interesting_downloads.remove(download);
                    DHTTrackerPlugin.this.running_downloads.remove(download);
                }
                finally {
                    DHTTrackerPlugin.this.this_mon.exit();
                }
            }
        });
        this.plugin_interface.getUtilities().createTimer("DHT Tracker", true).addPeriodicEvent(15000L, new UTTimerEventPerformer(){
            private int ticks;

            public void perform(UTTimerEvent event2) {
                ++this.ticks;
                DHTTrackerPlugin.this.processRegistrations();
                if (this.ticks % 4 == 0) {
                    DHTTrackerPlugin.this.processNonRegistrations();
                }
            }
        });
    }

    public void propertyChanged(Download download, DownloadPropertyEvent event2) {
        if (event2.getType() == 1 && (event2.getData() == this.ta_networks || event2.getData() == this.ta_peer_sources)) {
            this.checkDownloadForRegistration(download, false);
        }
    }

    public void scrapeResult(DownloadScrapeResult result) {
        this.checkDownloadForRegistration(result.getDownload(), false);
    }

    public void announceResult(DownloadAnnounceResult result) {
        this.checkDownloadForRegistration(result.getDownload(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDownloadForRegistration(Download download, boolean first_time) {
        String register_reason;
        int state = download.getState();
        boolean register_it = false;
        if (state == 4 || state == 5 || state == 9 || download.isPaused()) {
            String[] networks = download.getListAttribute(this.ta_networks);
            Torrent torrent = download.getTorrent();
            if (torrent != null && networks != null) {
                boolean public_net = false;
                for (int i = 0; i < networks.length; ++i) {
                    if (!networks[i].equalsIgnoreCase("Public")) continue;
                    public_net = true;
                    break;
                }
                if (public_net && !torrent.isPrivate()) {
                    if (torrent.isDecentralised()) {
                        register_it = true;
                        register_reason = "decentralised";
                    } else if (torrent.isDecentralisedBackupEnabled()) {
                        String[] sources = download.getListAttribute(this.ta_peer_sources);
                        boolean ok = false;
                        for (int i = 0; i < sources.length; ++i) {
                            if (!sources[i].equalsIgnoreCase("DHT")) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            register_reason = "decentralised peer source disabled";
                        } else if (torrent.isDecentralisedBackupRequested()) {
                            register_it = true;
                            register_reason = "torrent requests decentralised tracking";
                        } else if (this.track_normal_when_offline.getValue()) {
                            if (state == 4 || state == 5 || download.isPaused()) {
                                DownloadAnnounceResult result = download.getLastAnnounceResult();
                                if (result == null || result.getResponseType() == 2 || TorrentUtils.isDecentralised(result.getURL())) {
                                    register_it = true;
                                    register_reason = "tracker unavailable (announce)";
                                } else {
                                    register_reason = "tracker available (announce: " + result.getURL() + ")";
                                }
                            } else {
                                DownloadScrapeResult result = download.getLastScrapeResult();
                                if (result == null || result.getResponseType() == 2 || TorrentUtils.isDecentralised(result.getURL())) {
                                    register_it = true;
                                    register_reason = "tracker unavailable (scrape)";
                                } else {
                                    register_reason = "tracker available (scrape: " + result.getURL() + ")";
                                }
                            }
                        } else {
                            register_it = true;
                            register_reason = "peer source enabled";
                        }
                    } else {
                        register_reason = "decentralised backup disabled for the torrent";
                    }
                } else {
                    register_reason = "not public";
                }
            } else {
                register_reason = "torrent is broken";
            }
        } else {
            register_reason = state == 7 || state == 8 ? "not running" : "";
        }
        if (register_reason.length() > 0) {
            try {
                this.this_mon.enter();
                if (register_it) {
                    if (!this.running_downloads.contains(download)) {
                        this.log.log((Object)download.getTorrent(), 1, "Monitoring '" + download.getName() + "': " + register_reason);
                        this.running_downloads.add(download);
                    }
                } else if (this.running_downloads.contains(download)) {
                    this.log.log((Object)download.getTorrent(), 1, "Not monitoring '" + download.getName() + "': " + register_reason);
                    this.running_downloads.remove(download);
                    this.interesting_downloads.put(download, new Long(this.plugin_interface.getUtilities().getCurrentSystemTime() + 300000L));
                } else if (first_time) {
                    this.log.log((Object)download.getTorrent(), 1, "Not monitoring '" + download.getName() + "': " + register_reason);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRegistrations() {
        Download dl;
        ArrayList rds;
        try {
            this.this_mon.enter();
            rds = new ArrayList(this.running_downloads);
        }
        finally {
            this.this_mon.exit();
        }
        long now = SystemTime.getCurrentTime();
        Iterator<Object> it = rds.iterator();
        String port_details = TRTrackerUtils.getPortsForURL();
        while (it.hasNext()) {
            int dht_port;
            int udp_port;
            byte new_flags;
            dl = (Download)it.next();
            RegistrationDetails existing_reg = (RegistrationDetails)this.registered_downloads.get(dl);
            byte by = new_flags = dl.isComplete() ? (byte)2 : 1;
            if (existing_reg != null && existing_reg.getFlags() == new_flags && existing_reg.getPortDetails().equals(port_details)) continue;
            this.log.log((existing_reg == null ? "Registering" : "Re-registering") + " download '" + dl.getName() + "' as " + (new_flags == 2 ? "Seeding" : "Downloading"));
            final long start = SystemTime.getCurrentTime();
            RegistrationDetails new_reg = new RegistrationDetails(port_details, new_flags);
            this.registered_downloads.put(dl, new_reg);
            try {
                this.this_mon.enter();
                this.query_map.put(dl, new Long(now));
            }
            finally {
                this.this_mon.exit();
            }
            int tcp_port = this.plugin_interface.getPluginconfig().getIntParameter("TCP.Listen.Port");
            String port_override = COConfigurationManager.getStringParameter("TCP.Announce.Port", "");
            if (!port_override.equals("")) {
                try {
                    tcp_port = Integer.parseInt(port_override);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (tcp_port == 0) {
                this.log.log("    port = 0, registration not performed");
                continue;
            }
            String override_ips = COConfigurationManager.getStringParameter("Override Ip", "");
            String override_ip = null;
            if (override_ips.length() > 0) {
                StringTokenizer tok = new StringTokenizer(override_ips, ";");
                while (tok.hasMoreTokens()) {
                    String cat;
                    String this_address = tok.nextToken().trim();
                    if (this_address.length() <= 0 || (cat = AENetworkClassifier.categoriseAddress(this_address)) != "Public") continue;
                    override_ip = this_address;
                    break;
                }
            }
            if (override_ip != null) {
                try {
                    override_ip = PRHelpers.DNSToIPAddress(override_ip);
                }
                catch (UnknownHostException e) {
                    this.log.log("    Can't resolve IP override '" + override_ip + "'");
                    override_ip = null;
                }
            }
            String value_to_put = override_ip == null ? "" : override_ip + ":";
            value_to_put = value_to_put + tcp_port;
            if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE) {
                value_to_put = value_to_put + ";C";
            }
            if ((udp_port = this.plugin_interface.getPluginconfig().getIntParameter("UDP.Listen.Port")) != (dht_port = this.dht.getLocalAddress().getAddress().getPort())) {
                value_to_put = value_to_put + ";" + udp_port;
            }
            this.dht.put(dl.getTorrent().getHash(), "Tracker registration of '" + dl.getName() + "' -> " + value_to_put, value_to_put.getBytes(), new_flags, new DHTPluginOperationListener(){

                public void diversified() {
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                public void complete(boolean timeout_occurred) {
                    DHTTrackerPlugin.this.log.log((Object)dl.getTorrent(), 1, "Registration of '" + dl.getName() + "' completed (elapsed=" + (SystemTime.getCurrentTime() - start) + ")");
                }
            });
        }
        it = this.registered_downloads.keySet().iterator();
        while (it.hasNext()) {
            boolean unregister;
            dl = (Download)it.next();
            try {
                this.this_mon.enter();
                unregister = !this.running_downloads.contains(dl);
            }
            finally {
                this.this_mon.exit();
            }
            if (!unregister) continue;
            this.log.log((Object)dl.getTorrent(), 1, "Unregistering download '" + dl.getName() + "'");
            final long start = SystemTime.getCurrentTime();
            it.remove();
            try {
                this.this_mon.enter();
                this.query_map.remove(dl);
            }
            finally {
                this.this_mon.exit();
            }
            this.increaseActive(dl);
            this.dht.remove(dl.getTorrent().getHash(), "Tracker deregistration of '" + dl.getName() + "'", new DHTPluginOperationListener(){

                public void diversified() {
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                public void complete(boolean timeout_occurred) {
                    DHTTrackerPlugin.this.log.log((Object)dl.getTorrent(), 1, "Unregistration of '" + dl.getName() + "' completed (elapsed=" + (SystemTime.getCurrentTime() - start) + ")");
                    DHTTrackerPlugin.this.decreaseActive(dl);
                }
            });
        }
        it = rds.iterator();
        while (it.hasNext()) {
            Long next_time;
            dl = (Download)it.next();
            try {
                this.this_mon.enter();
                next_time = (Long)this.query_map.get(dl);
            }
            finally {
                this.this_mon.exit();
            }
            if (next_time == null || now < next_time) continue;
            try {
                this.this_mon.enter();
                this.query_map.remove(dl);
            }
            finally {
                this.this_mon.exit();
            }
            final long start = SystemTime.getCurrentTime();
            PeerManager pm = dl.getPeerManager();
            boolean skip = this.isActive(dl);
            if (skip) {
                this.log.log((Object)dl.getTorrent(), 1, "Deferring announce for '" + dl.getName() + "' as activity outstanding");
            }
            if (pm != null && !skip) {
                int con = pm.getStats().getConnectedLeechers() + pm.getStats().getConnectedSeeds();
                boolean bl = skip = con >= 30;
            }
            if (skip) {
                try {
                    this.this_mon.enter();
                    if (!this.running_downloads.contains(dl)) continue;
                    this.query_map.put(dl, new Long(start + 120000L));
                    continue;
                }
                finally {
                    this.this_mon.exit();
                    continue;
                }
            }
            final Torrent torrent = dl.getTorrent();
            final URL url_to_report = torrent.isDecentralised() ? torrent.getAnnounceURL() : DEFAULT_URL;
            this.increaseActive(dl);
            this.dht.get(dl.getTorrent().getHash(), "Tracker announce for '" + dl.getName() + "'", dl.isComplete() ? (byte)2 : 1, 30, 120000L, false, false, new DHTPluginOperationListener(){
                List addresses = new ArrayList();
                List ports = new ArrayList();
                List udp_ports = new ArrayList();
                List is_seeds = new ArrayList();
                List flags = new ArrayList();
                int seed_count;
                int leecher_count;

                public void diversified() {
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    block10: {
                        try {
                            String tcp_port_str;
                            String[] tokens = new String(value.getValue()).split(";");
                            String tcp_part = tokens[0].trim();
                            int sep = tcp_part.indexOf(58);
                            String ip_str = null;
                            if (sep == -1) {
                                tcp_port_str = tcp_part;
                            } else {
                                ip_str = tcp_part.substring(0, sep);
                                tcp_port_str = tcp_part.substring(sep + 1);
                            }
                            int tcp_port = Integer.parseInt(tcp_port_str);
                            if (tcp_port <= 0 || tcp_port >= 65536) break block10;
                            String flag_str = null;
                            int udp_port = -1;
                            try {
                                for (int i = 1; i < tokens.length; ++i) {
                                    String token = tokens[i].trim();
                                    if (token.length() <= 0) continue;
                                    if (Character.isDigit(token.charAt(0))) {
                                        udp_port = Integer.parseInt(token);
                                        if (udp_port > 0 && udp_port < 65536) continue;
                                        udp_port = -1;
                                        continue;
                                    }
                                    flag_str = token;
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            this.addresses.add(ip_str == null ? originator.getAddress().getAddress().getHostAddress() : ip_str);
                            this.ports.add(new Integer(tcp_port));
                            this.udp_ports.add(new Integer(udp_port == -1 ? originator.getAddress().getPort() : udp_port));
                            this.flags.add(flag_str);
                            if ((value.getFlags() & 1) == 1) {
                                ++this.leecher_count;
                                this.is_seeds.add(new Boolean(false));
                            } else {
                                this.is_seeds.add(new Boolean(true));
                                ++this.seed_count;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(boolean timeout_occurred) {
                    int[] prev;
                    DHTTrackerPlugin.this.log.log((Object)dl.getTorrent(), 1, "Get of '" + dl.getName() + "' completed (elapsed=" + (SystemTime.getCurrentTime() - start) + "), addresses = " + this.addresses.size() + ", seeds = " + this.seed_count + ", leechers = " + this.leecher_count);
                    DHTTrackerPlugin.this.decreaseActive(dl);
                    int peers_found = this.addresses.size();
                    ArrayList<14> peers_for_announce = new ArrayList<14>();
                    int announce_per_min = 4;
                    int num_active = DHTTrackerPlugin.this.query_map.size();
                    int announce_min = Math.max(120000, num_active / announce_per_min * 60 * 1000);
                    announce_min = Math.min(announce_min, 3600000);
                    long retry = announce_min + peers_found * (3600000 - announce_min) / 30;
                    try {
                        DHTTrackerPlugin.this.this_mon.enter();
                        if (DHTTrackerPlugin.this.running_downloads.contains(dl)) {
                            DHTTrackerPlugin.this.query_map.put(dl, new Long(SystemTime.getCurrentTime() + retry));
                        }
                    }
                    finally {
                        DHTTrackerPlugin.this.this_mon.exit();
                    }
                    boolean we_are_seeding = dl.getState() == 5;
                    for (int i = 0; i < this.addresses.size(); ++i) {
                        if (we_are_seeding && ((Boolean)this.is_seeds.get(i)).booleanValue()) continue;
                        int f_i = i;
                        peers_for_announce.add(new DownloadAnnounceResultPeer(this, f_i){
                            private final /* synthetic */ int val$f_i;
                            private final /* synthetic */ 13 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$f_i = val$f_i;
                            }

                            public String getSource() {
                                return "DHT";
                            }

                            public String getAddress() {
                                return (String)this.this$1.addresses.get(this.val$f_i);
                            }

                            public int getPort() {
                                return (Integer)this.this$1.ports.get(this.val$f_i);
                            }

                            public int getUDPPort() {
                                return (Integer)this.this$1.udp_ports.get(this.val$f_i);
                            }

                            public byte[] getPeerID() {
                                return null;
                            }

                            public short getProtocol() {
                                String flag = (String)this.this$1.flags.get(this.val$f_i);
                                int protocol = flag != null && flag.indexOf("C") != -1 ? 2 : 1;
                                return (short)protocol;
                            }
                        });
                    }
                    if (dl.getState() == 4 || dl.getState() == 5) {
                        DownloadAnnounceResultPeer[] peers = new DownloadAnnounceResultPeer[peers_for_announce.size()];
                        peers_for_announce.toArray(peers);
                        dl.setAnnounceResult(new DownloadAnnounceResult(this, peers, retry){
                            private final /* synthetic */ DownloadAnnounceResultPeer[] val$peers;
                            private final /* synthetic */ long val$retry;
                            private final /* synthetic */ 13 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$peers = val$peers;
                                this.val$retry = val$retry;
                            }

                            public Download getDownload() {
                                return 13.access$1000(this.this$1);
                            }

                            public int getResponseType() {
                                return 1;
                            }

                            public int getReportedPeerCount() {
                                return this.val$peers.length;
                            }

                            public int getSeedCount() {
                                return this.this$1.seed_count;
                            }

                            public int getNonSeedCount() {
                                return this.this$1.leecher_count;
                            }

                            public String getError() {
                                return null;
                            }

                            public URL getURL() {
                                return 13.access$1100(this.this$1);
                            }

                            public DownloadAnnounceResultPeer[] getPeers() {
                                return this.val$peers;
                            }

                            public long getTimeToWait() {
                                return this.val$retry / 1000L;
                            }

                            public Map getExtensions() {
                                return null;
                            }
                        });
                    }
                    boolean inject_scrape = this.leecher_count > 0;
                    DownloadScrapeResult result = dl.getLastScrapeResult();
                    if (result != null && result.getResponseType() != 2 && (prev = (int[])DHTTrackerPlugin.this.scrape_injection_map.get(dl)) != null && prev[0] == result.getSeedCount() && prev[1] == result.getNonSeedCount()) {
                        inject_scrape = true;
                    }
                    if (torrent.isDecentralised() || inject_scrape) {
                        PeerManager pm = dl.getPeerManager();
                        int local_seeds = 0;
                        int local_leechers = 0;
                        if (pm != null) {
                            Peer[] dl_peers = pm.getPeers();
                            for (int i = 0; i < dl_peers.length; ++i) {
                                Peer dl_peer = dl_peers[i];
                                if (dl_peer.getPercentDoneInThousandNotation() == 1000) {
                                    ++local_seeds;
                                    continue;
                                }
                                ++local_leechers;
                            }
                        }
                        int f_adj_seeds = Math.max(this.seed_count, local_seeds);
                        int f_adj_leechers = Math.max(this.leecher_count, local_leechers);
                        DHTTrackerPlugin.this.scrape_injection_map.put(dl, new int[]{f_adj_seeds, f_adj_leechers});
                        dl.setScrapeResult(new DownloadScrapeResult(this, f_adj_seeds, f_adj_leechers, retry){
                            private final /* synthetic */ int val$f_adj_seeds;
                            private final /* synthetic */ int val$f_adj_leechers;
                            private final /* synthetic */ long val$retry;
                            private final /* synthetic */ 13 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$f_adj_seeds = val$f_adj_seeds;
                                this.val$f_adj_leechers = val$f_adj_leechers;
                                this.val$retry = val$retry;
                            }

                            public Download getDownload() {
                                return 13.access$1000(this.this$1);
                            }

                            public int getResponseType() {
                                return 1;
                            }

                            public int getSeedCount() {
                                return this.val$f_adj_seeds;
                            }

                            public int getNonSeedCount() {
                                return this.val$f_adj_leechers;
                            }

                            public long getScrapeStartTime() {
                                return 13.access$1300(this.this$1);
                            }

                            public void setNextScrapeStartTime(long nextScrapeStartTime) {
                            }

                            public long getNextScrapeStartTime() {
                                return SystemTime.getCurrentTime() + this.val$retry;
                            }

                            public String getStatus() {
                                return "OK";
                            }

                            public URL getURL() {
                                return 13.access$1100(this.this$1);
                            }
                        });
                    }
                }

                static /* synthetic */ Download access$1000(13 x0) {
                    return x0.dl;
                }

                static /* synthetic */ URL access$1100(13 x0) {
                    return x0.url_to_report;
                }

                static /* synthetic */ long access$1300(13 x0) {
                    return x0.start;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNonRegistrations() {
        if (!this.dht.isReachable()) {
            return;
        }
        if (this.interesting_pub_max > 0 && this.interesting_published > this.interesting_pub_max) {
            return;
        }
        Download ready_download = null;
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        try {
            this.this_mon.enter();
            Iterator it = this.interesting_downloads.keySet().iterator();
            while (it.hasNext() && ready_download == null) {
                DownloadScrapeResult scrape;
                Download download = (Download)it.next();
                if (this.running_downloads.contains(download) || (scrape = download.getLastScrapeResult()).getSeedCount() + scrape.getNonSeedCount() > 30) continue;
                long target = (Long)this.interesting_downloads.get(download);
                if (target <= now) {
                    ready_download = download;
                    this.interesting_downloads.put(download, new Long(now + 14400000L));
                    continue;
                }
                if (target - now <= 14400000L) continue;
                this.interesting_downloads.put(download, new Long(now + target % 14400000L));
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (ready_download != null) {
            final Download f_ready_download = ready_download;
            if (this.dht.isDiversified(ready_download.getTorrent().getHash())) {
                try {
                    this.this_mon.enter();
                    this.interesting_downloads.remove(f_ready_download);
                }
                finally {
                    this.this_mon.exit();
                }
            } else {
                final long start = now;
                this.dht.get(ready_download.getTorrent().getHash(), "Presence query for '" + ready_download.getName() + "'", (byte)0, 8, 120000L, false, false, new DHTPluginOperationListener(){
                    private boolean diversified;
                    private int total = 0;

                    public void diversified() {
                        this.diversified = true;
                    }

                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        ++this.total;
                    }

                    public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void complete(boolean timeout_occurred) {
                        DHTTrackerPlugin.this.log.log((Object)f_ready_download.getTorrent(), 1, "Presence query for '" + f_ready_download.getName() + "': availability=" + (this.total == 8 ? "8+" : this.total + "") + ",div=" + this.diversified + " (elapsed=" + (SystemTime.getCurrentTime() - start) + ")");
                        if (this.diversified) {
                            try {
                                DHTTrackerPlugin.this.this_mon.enter();
                                DHTTrackerPlugin.this.interesting_downloads.remove(f_ready_download);
                            }
                            finally {
                                DHTTrackerPlugin.this.this_mon.exit();
                            }
                        }
                        if (this.total < 8) {
                            try {
                                DHTTrackerPlugin.this.this_mon.enter();
                                DHTTrackerPlugin.this.interesting_downloads.remove(f_ready_download);
                            }
                            finally {
                                DHTTrackerPlugin.this.this_mon.exit();
                            }
                            DHTTrackerPlugin.this.interesting_published++;
                            DHTTrackerPlugin.this.dht.put(f_ready_download.getTorrent().getHash(), "Presence store '" + f_ready_download.getName() + "'", "0".getBytes(), (byte)0, new DHTPluginOperationListener(this){
                                private final /* synthetic */ 17 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void diversified() {
                                }

                                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                                }

                                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                                }

                                public void complete(boolean timeout_occurred) {
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(Download download, int old_state, int new_state) {
        int state = download.getState();
        try {
            this.this_mon.enter();
            if ((state == 4 || state == 5 || state == 9) && this.running_downloads.contains(download)) {
                this.query_map.put(download, new Long(SystemTime.getCurrentTime()));
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.checkDownloadForRegistration(download, false);
    }

    public void positionChanged(Download download, int oldPosition, int newPosition) {
    }

    protected void configChanged() {
        Download[] downloads = this.plugin_interface.getDownloadManager().getDownloads();
        for (int i = 0; i < downloads.length; ++i) {
            this.checkDownloadForRegistration(downloads[i], false);
        }
    }

    public DownloadScrapeResult scrape(byte[] hash) {
        final int[] seeds = new int[]{0};
        final int[] leechers = new int[]{0};
        final AESemaphore sem = new AESemaphore("DHTTrackerPlugin:scrape");
        this.dht.get(hash, "Scrape for '" + ByteFormatter.nicePrint(hash) + "'", (byte)1, 30, 30000L, false, false, new DHTPluginOperationListener(){

            public void diversified() {
            }

            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                if ((value.getFlags() & 1) == 1) {
                    leechers[0] = leechers[0] + 1;
                } else {
                    seeds[0] = seeds[0] + 1;
                }
            }

            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            public void complete(boolean timeout_occurred) {
                sem.release();
            }
        });
        sem.reserve();
        return new DownloadScrapeResult(){

            public Download getDownload() {
                return null;
            }

            public int getResponseType() {
                return 1;
            }

            public int getSeedCount() {
                return seeds[0];
            }

            public int getNonSeedCount() {
                return leechers[0];
            }

            public long getScrapeStartTime() {
                return 0L;
            }

            public void setNextScrapeStartTime(long nextScrapeStartTime) {
            }

            public long getNextScrapeStartTime() {
                return 0L;
            }

            public String getStatus() {
                return "OK";
            }

            public URL getURL() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseActive(Download dl) {
        try {
            this.this_mon.enter();
            Integer active_i = (Integer)this.in_progress.get(dl);
            int active = active_i == null ? 0 : active_i;
            this.in_progress.put(dl, new Integer(active + 1));
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseActive(Download dl) {
        try {
            this.this_mon.enter();
            Integer active_i = (Integer)this.in_progress.get(dl);
            if (active_i == null) {
                Debug.out("active count inconsistent");
            } else {
                int active = active_i - 1;
                if (active == 0) {
                    this.in_progress.remove(dl);
                } else {
                    this.in_progress.put(dl, new Integer(active));
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive(Download dl) {
        try {
            this.this_mon.enter();
            boolean bl = this.in_progress.get(dl) != null;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    static {
        try {
            DEFAULT_URL = new URL("dht:");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected static class RegistrationDetails {
        private String port_details;
        private byte flags;

        protected RegistrationDetails(String _port_details, byte _flags) {
            this.port_details = _port_details;
            this.flags = _flags;
        }

        protected String getPortDetails() {
            return this.port_details;
        }

        protected byte getFlags() {
            return this.flags;
        }
    }
}

