/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2.stats;

import com.aelitis.azureus.vivaldi.ver2.stats.StatsSerializer;
import com.aelitis.azureus.vivaldi.ver2.stats.V1Serializer;
import com.aelitis.azureus.vivaldi.ver2.stats.VivaldiStatistics;
import edu.harvard.syrah.nc.VivaldiClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationController {
    protected final TreeMap<Byte, StatsSerializer> serializers = new TreeMap();
    protected final Set<Byte> versions_ro = Collections.unmodifiableSet(this.serializers.keySet());

    public SerializationController() {
        V1Serializer v1_serializer = V1Serializer.getInstance();
        this.serializers.put(v1_serializer.getSerializedVersion(), v1_serializer);
    }

    public boolean addSerializer(StatsSerializer new_serializer) {
        byte new_version = new_serializer.getSerializedVersion();
        if (this.serializers.containsKey(new_version)) {
            return false;
        }
        this.serializers.put(new_version, new_serializer);
        return true;
    }

    public StatsSerializer removeSerializer(byte version) {
        return this.serializers.remove(version);
    }

    public boolean contains(byte version) {
        return this.serializers.containsKey(version);
    }

    public Set<Byte> getVersions() {
        return this.versions_ro;
    }

    public boolean toSerialized(byte version, DataOutputStream os, VivaldiClient vc) throws IOException {
        StatsSerializer serializer = this.serializers.get(version);
        if (serializer == null) {
            return false;
        }
        os.writeByte(version);
        serializer.toSerialized(os, vc);
        return true;
    }

    public VivaldiStatistics fromSerialized(DataInputStream is) throws IOException {
        byte version = is.readByte();
        StatsSerializer serializer = this.serializers.get(version);
        if (serializer == null) {
            return null;
        }
        return serializer.fromSerialized(is);
    }
}

