/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.natpmp.upnp.impl;

import com.aelitis.net.natpmp.NatPMPDevice;
import com.aelitis.net.natpmp.upnp.impl.NatPMPImpl;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.UPnPStateVariable;
import com.aelitis.net.upnp.services.UPnPSpecificService;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionListener;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ThreadPool;

public class NatPMPUPnPRootDeviceImpl
implements UPnPRootDevice {
    private UPnP upnp;
    private NatPMPDevice nat_device;
    private String USN = "natpmp";
    private URL location;
    private UPnPDevice device;
    private UPnPService[] services;
    private ThreadPool thread_pool;

    public NatPMPUPnPRootDeviceImpl(UPnP _upnp, NatPMPDevice _nat_device) throws Exception {
        this.upnp = _upnp;
        this.nat_device = _nat_device;
        this.location = new URL("http://undefined/");
        this.device = new NatPMPUPnPDevice();
        this.services = new UPnPService[]{new NatPMPUPnPWANConnection()};
        this.thread_pool = new ThreadPool("NatPMPUPnP", 1, true);
    }

    public UPnP getUPnP() {
        return this.upnp;
    }

    public String getUSN() {
        return this.USN;
    }

    public URL getLocation() {
        return this.location;
    }

    public InetAddress getLocalAddress() {
        return this.nat_device.getLocalAddress();
    }

    public NetworkInterface getNetworkInterface() {
        return this.nat_device.getNetworkInterface();
    }

    public String getInfo() {
        return "Nat-PMP";
    }

    public UPnPDevice getDevice() {
        return this.device;
    }

    public boolean isDestroyed() {
        return false;
    }

    public void addListener(UPnPRootDeviceListener l) {
    }

    public void removeListener(UPnPRootDeviceListener l) {
    }

    protected class NatPMPUPnPWANConnection
    implements UPnPWANConnection,
    UPnPService {
        private NatPMPImpl nat_impl;

        protected NatPMPUPnPWANConnection() throws UPnPException {
            this.nat_impl = new NatPMPImpl(NatPMPUPnPRootDeviceImpl.this.nat_device);
        }

        public UPnPDevice getDevice() {
            return NatPMPUPnPRootDeviceImpl.this.device;
        }

        public String getServiceType() {
            return "urn:schemas-upnp-org:service:WANIPConnection:1";
        }

        public URL getControlURL() throws UPnPException {
            return null;
        }

        public UPnPAction[] getActions() throws UPnPException {
            return new UPnPAction[0];
        }

        public UPnPAction getAction(String name) throws UPnPException {
            return null;
        }

        public UPnPStateVariable[] getStateVariables() throws UPnPException {
            return new UPnPStateVariable[0];
        }

        public UPnPStateVariable getStateVariable(String name) throws UPnPException {
            return null;
        }

        public UPnPSpecificService getSpecificService() {
            return this;
        }

        public UPnPService getGenericService() {
            return this;
        }

        public boolean getDirectInvocations() {
            return true;
        }

        public void setDirectInvocations(boolean force) {
        }

        public void addPortMapping(boolean tcp, int port, String description) throws UPnPException {
            NatPMPUPnPRootDeviceImpl.this.thread_pool.run(new AERunnable(this, tcp, port, description){
                private final /* synthetic */ boolean val$tcp;
                private final /* synthetic */ int val$port;
                private final /* synthetic */ String val$description;
                private final /* synthetic */ NatPMPUPnPWANConnection this$1;
                {
                    this.this$1 = this$1;
                    this.val$tcp = val$tcp;
                    this.val$port = val$port;
                    this.val$description = val$description;
                }

                public void runSupport() {
                    try {
                        NatPMPUPnPWANConnection.access$300(this.this$1).addPortMapping(this.val$tcp, this.val$port, this.val$description);
                    }
                    catch (UPnPException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        public UPnPWANConnectionPortMapping[] getPortMappings() throws UPnPException {
            return this.nat_impl.getPortMappings();
        }

        public void deletePortMapping(boolean tcp, int port) throws UPnPException {
            NatPMPUPnPRootDeviceImpl.this.thread_pool.run(new AERunnable(this, tcp, port){
                private final /* synthetic */ boolean val$tcp;
                private final /* synthetic */ int val$port;
                private final /* synthetic */ NatPMPUPnPWANConnection this$1;
                {
                    this.this$1 = this$1;
                    this.val$tcp = val$tcp;
                    this.val$port = val$port;
                }

                public void runSupport() {
                    try {
                        NatPMPUPnPWANConnection.access$300(this.this$1).deletePortMapping(this.val$tcp, this.val$port);
                    }
                    catch (UPnPException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        public String[] getStatusInfo() throws UPnPException {
            return this.nat_impl.getStatusInfo();
        }

        public String getExternalIPAddress() throws UPnPException {
            return this.nat_impl.getExternalIPAddress();
        }

        public void periodicallyRecheckMappings(boolean on) {
        }

        public int getCapabilities() {
            return -1;
        }

        public void addListener(UPnPWANConnectionListener listener) {
        }

        public void removeListener(UPnPWANConnectionListener listener) {
        }

        static /* synthetic */ NatPMPImpl access$300(NatPMPUPnPWANConnection x0) {
            return x0.nat_impl;
        }
    }

    protected class NatPMPUPnPDevice
    implements UPnPDevice {
        protected NatPMPUPnPDevice() {
        }

        public String getDeviceType() {
            return "NatPMP";
        }

        public String getFriendlyName() {
            return "NatPMP";
        }

        public UPnPDevice[] getSubDevices() {
            return new UPnPDevice[0];
        }

        public UPnPService[] getServices() {
            return NatPMPUPnPRootDeviceImpl.this.services;
        }

        public UPnPRootDevice getRootDevice() {
            return NatPMPUPnPRootDeviceImpl.this;
        }
    }
}

