/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.piecemapper.impl;

import java.util.List;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.impl.PieceMapEntryImpl;

public class PieceListImpl
implements DMPieceList {
    private final PieceMapEntryImpl[] pieces;
    private final int[] cumulativeLengths;

    public static PieceListImpl convert(List pieceList) {
        return new PieceListImpl(pieceList.toArray(new PieceMapEntryImpl[pieceList.size()]));
    }

    protected PieceListImpl(PieceMapEntryImpl[] _pieces) {
        this.pieces = _pieces;
        this.cumulativeLengths = new int[this.pieces.length];
        this.initializeCumulativeLengths();
    }

    private void initializeCumulativeLengths() {
        int runningLength = 0;
        for (int i = 0; i < this.pieces.length; ++i) {
            this.cumulativeLengths[i] = runningLength += this.pieces[i].getLength();
        }
    }

    public int size() {
        return this.pieces.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public DMPieceMapEntry get(int index) {
        return this.pieces[index];
    }

    public int getCumulativeLengthToPiece(int index) {
        return this.cumulativeLengths[index];
    }
}

