/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.impl.GlobalManagerImpl;
import org.gudy.azureus2.core3.util.Average;

public class GlobalManagerStatsImpl
implements GlobalManagerStats {
    private GlobalManagerImpl manager;
    private long total_data_bytes_received;
    private long total_protocol_bytes_received;
    private long totalDiscarded;
    private long total_data_bytes_sent;
    private long total_protocol_bytes_sent;
    private Average data_receive_speed = Average.getInstance(1000, 10);
    private Average protocol_receive_speed = Average.getInstance(1000, 10);
    private Average data_send_speed = Average.getInstance(1000, 10);
    private Average protocol_send_speed = Average.getInstance(1000, 10);
    private Average data_send_speed_no_lan = Average.getInstance(1000, 10);
    private Average protocol_send_speed_no_lan = Average.getInstance(1000, 10);

    protected GlobalManagerStatsImpl(GlobalManagerImpl _manager) {
        this.manager = _manager;
    }

    public void discarded(int length) {
        this.totalDiscarded += (long)length;
    }

    public void dataBytesReceived(int length) {
        this.total_data_bytes_received += (long)length;
        this.data_receive_speed.addValue(length);
    }

    public void protocolBytesReceived(int length) {
        this.total_protocol_bytes_received += (long)length;
        this.protocol_receive_speed.addValue(length);
    }

    public void dataBytesSent(int length, boolean LAN) {
        this.total_data_bytes_sent += (long)length;
        if (!LAN) {
            this.data_send_speed_no_lan.addValue(length);
        }
        this.data_send_speed.addValue(length);
    }

    public void protocolBytesSent(int length, boolean LAN) {
        this.total_protocol_bytes_sent += (long)length;
        if (!LAN) {
            this.protocol_send_speed_no_lan.addValue(length);
        }
        this.protocol_send_speed.addValue(length);
    }

    public int getDataReceiveRate() {
        return (int)this.data_receive_speed.getAverage();
    }

    public int getProtocolReceiveRate() {
        return (int)this.protocol_receive_speed.getAverage();
    }

    public int getDataSendRate() {
        return (int)this.data_send_speed.getAverage();
    }

    public int getDataSendRateNoLAN() {
        return (int)this.data_send_speed_no_lan.getAverage();
    }

    public int getProtocolSendRate() {
        return (int)this.protocol_send_speed.getAverage();
    }

    public int getProtocolSendRateNoLAN() {
        return (int)this.protocol_send_speed_no_lan.getAverage();
    }

    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }

    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    public long getTotalDiscardedRaw() {
        return this.totalDiscarded;
    }

    public long getTotalSwarmsPeerRate(boolean downloading, boolean seeding) {
        return this.manager.getTotalSwarmsPeerRate(downloading, seeding);
    }
}

