/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.security.impl;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.gudy.azureus2.core3.security.impl.SESecurityManagerImpl;
import org.gudy.azureus2.core3.util.SystemTime;

public class SESecurityManagerBC {
    protected static void initialise() {
        Security.addProvider(new BouncyCastleProvider());
    }

    public static Certificate createSelfSignedCertificate(SESecurityManagerImpl manager, String alias, String cert_dn, int strength) throws Exception {
        KeyPairGenerator kg = KeyPairGenerator.getInstance("RSA");
        kg.initialize(strength, new SecureRandom());
        KeyPair pair = kg.generateKeyPair();
        X509V3CertificateGenerator certificateGenerator = new X509V3CertificateGenerator();
        certificateGenerator.setSignatureAlgorithm("MD5WithRSAEncryption");
        certificateGenerator.setSerialNumber(new BigInteger("" + SystemTime.getCurrentTime()));
        X509Name issuer_dn = new X509Name(true, cert_dn);
        certificateGenerator.setIssuerDN(issuer_dn);
        X509Name subject_dn = new X509Name(true, cert_dn);
        certificateGenerator.setSubjectDN(subject_dn);
        Calendar not_after = Calendar.getInstance();
        not_after.add(1, 1);
        certificateGenerator.setNotAfter(not_after.getTime());
        certificateGenerator.setNotBefore(Calendar.getInstance().getTime());
        certificateGenerator.setPublicKey(pair.getPublic());
        X509Certificate certificate = certificateGenerator.generateX509Certificate(pair.getPrivate());
        Certificate[] certChain = new Certificate[]{certificate};
        manager.addCertToKeyStore(alias, pair.getPrivate(), certChain);
        return certificate;
    }
}

