/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.security.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.Permission;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SEKeyDetails;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.impl.SESecurityManagerBC;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.Ignore;

public class SESecurityManagerImpl {
    private static final LogIDs LOGID = LogIDs.NET;
    protected static SESecurityManagerImpl singleton = new SESecurityManagerImpl();
    protected static String KEYSTORE_TYPE;
    protected String keystore_name;
    protected String truststore_name;
    protected List certificate_listeners = new ArrayList();
    protected CopyOnWriteList password_listeners = new CopyOnWriteList();
    protected Map password_handlers = new HashMap();
    protected boolean exit_vm_permitted = false;
    protected AEMonitor this_mon = new AEMonitor("SESecurityManager");

    public static SESecurityManagerImpl getSingleton() {
        return singleton;
    }

    public void initialise() {
        this.keystore_name = FileUtil.getUserFile(".keystore").getAbsolutePath();
        this.truststore_name = FileUtil.getUserFile(".certs").getAbsolutePath();
        System.setProperty("javax.net.ssl.trustStore", this.truststore_name);
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        this.installAuthenticator();
        String[] providers = new String[]{"com.sun.net.ssl.internal.ssl.Provider", "org.metastatic.jessie.provider.Jessie"};
        String provider = null;
        for (int i = 0; i < providers.length; ++i) {
            try {
                Class.forName(providers[i]).newInstance();
                provider = providers[i];
                break;
            }
            catch (Throwable e) {
                continue;
            }
        }
        if (provider == null) {
            Debug.out("No SSL provider available");
        }
        try {
            SESecurityManagerBC.initialise();
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, 3, "Bouncy Castle not available"));
        }
        this.installSecurityManager();
        this.ensureStoreExists(this.keystore_name);
        this.ensureStoreExists(this.truststore_name);
    }

    public String getKeystoreName() {
        return this.keystore_name;
    }

    public String getKeystorePassword() {
        return "changeit";
    }

    protected void installSecurityManager() {
        try {
            final SecurityManager old_sec_man = System.getSecurityManager();
            System.setSecurityManager(new SecurityManager(){

                public void checkExit(int status) {
                    if (old_sec_man != null) {
                        old_sec_man.checkExit(status);
                    }
                    if (!SESecurityManagerImpl.this.exit_vm_permitted) {
                        throw new SecurityException("VM exit operation prohibited");
                    }
                }

                public void checkPermission(Permission perm) {
                    if (perm instanceof RuntimePermission && perm.getName().equals("stopThread")) {
                        throw new SecurityException("Thread.stop operation prohibited");
                    }
                    if (old_sec_man != null) {
                        old_sec_man.checkPermission(perm);
                    }
                }

                public void checkPermission(Permission perm, Object context) {
                    if (perm instanceof RuntimePermission && perm.getName().equals("stopThread")) {
                        throw new SecurityException("Thread.stop operation prohibited");
                    }
                    if (old_sec_man != null) {
                        old_sec_man.checkPermission(perm, context);
                    }
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitVM(int status) {
        try {
            this.exit_vm_permitted = true;
            try {
                System.exit(status);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.exit_vm_permitted = false;
        }
    }

    public void installAuthenticator() {
        Authenticator.setDefault(new Authenticator(){
            protected AEMonitor auth_mon = new AEMonitor("SESecurityManager:auth");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected PasswordAuthentication getPasswordAuthentication() {
                try {
                    PasswordAuthentication res;
                    this.auth_mon.enter();
                    PasswordAuthentication passwordAuthentication = res = SESecurityManagerImpl.this.getAuthentication(this.getRequestingPrompt(), this.getRequestingProtocol(), this.getRequestingHost(), this.getRequestingPort());
                    return passwordAuthentication;
                }
                finally {
                    this.auth_mon.exit();
                }
            }
        });
    }

    public PasswordAuthentication getAuthentication(String realm, String protocol, String host, int port) {
        if (protocol.toLowerCase().startsWith("socks") && COConfigurationManager.getStringParameter("Proxy.Username").trim().equalsIgnoreCase("<none>")) {
            return new PasswordAuthentication("", "".toCharArray());
        }
        try {
            URL tracker_url = new URL(protocol + "://" + host + ":" + port + "/");
            return this.getPasswordAuthentication(realm, tracker_url);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected boolean checkKeyStoreHasEntry() {
        File f = new File(this.keystore_name);
        if (!f.exists()) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
            return false;
        }
        try {
            KeyStore key_store = this.loadKeyStore();
            Enumeration<String> enumx = key_store.aliases();
            if (!enumx.hasMoreElements()) {
                Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
                return false;
            }
        }
        catch (Throwable e) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.corrupt"), new String[]{this.keystore_name});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ensureStoreExists(String name) {
        try {
            this.this_mon.enter();
            KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
            if (!new File(name).exists()) {
                keystore.load(null, null);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(name);
                    keystore.store(out, "changeit".toCharArray());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public KeyStore getKeyStore() throws Exception {
        return this.loadKeyStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getTrustStore() throws Exception {
        KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
        if (!new File(this.truststore_name).exists()) {
            keystore.load(null, null);
        } else {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.truststore_name);
                keystore.load(in, "changeit".toCharArray());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return keystore;
    }

    protected KeyStore loadKeyStore() throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        return this.loadKeyStore(keyManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore loadKeyStore(KeyManagerFactory keyManagerFactory) throws Exception {
        KeyStore key_store = KeyStore.getInstance(KEYSTORE_TYPE);
        if (!new File(this.keystore_name).exists()) {
            key_store.load(null, null);
        } else {
            FileInputStream kis = null;
            try {
                kis = new FileInputStream(this.keystore_name);
                key_store.load(kis, "changeit".toCharArray());
            }
            finally {
                if (kis != null) {
                    ((InputStream)kis).close();
                }
            }
        }
        keyManagerFactory.init(key_store, "changeit".toCharArray());
        return key_store;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() throws Exception {
        if (!this.checkKeyStoreHasEntry()) {
            return null;
        }
        SSLContext context = SSLContext.getInstance("SSL");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.loadKeyStore(keyManagerFactory);
        context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        SSLServerSocketFactory factory = context.getServerSocketFactory();
        return factory;
    }

    public SEKeyDetails getKeyDetails(String alias) throws Exception {
        KeyStore key_store = this.loadKeyStore();
        final Key key = key_store.getKey(alias, "changeit".toCharArray());
        if (key == null) {
            return null;
        }
        Certificate[] chain = key_store.getCertificateChain(alias);
        final X509Certificate[] res = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            if (!(chain[i] instanceof X509Certificate)) {
                throw new Exception("Certificate chain must be comprised of X509Certificate entries");
            }
            res[i] = (X509Certificate)chain[i];
        }
        return new SEKeyDetails(){

            public Key getKey() {
                return key;
            }

            public X509Certificate[] getCertificateChain() {
                return res;
            }
        };
    }

    public Certificate createSelfSignedCertificate(String alias, String cert_dn, int strength) throws Exception {
        return SESecurityManagerBC.createSelfSignedCertificate(this, alias, cert_dn, strength);
    }

    /*
     * Exception decompiling
     */
    public SSLSocketFactory installServerCertificates(URL https_url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addCertToKeyStore(String alias, Key public_key, Certificate[] certChain) throws Exception {
        try {
            this.this_mon.enter();
            KeyStore key_store = this.loadKeyStore();
            if (key_store.containsAlias(alias)) {
                key_store.deleteEntry(alias);
            }
            key_store.setKeyEntry(alias, public_key, "changeit".toCharArray(), certChain);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.keystore_name);
                key_store.store(out, "changeit".toCharArray());
                if (out == null) return;
            }
            catch (Throwable e) {
                try {
                    Debug.printStackTrace(e);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            out.close();
            return;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLSocketFactory addCertToTrustStore(String alias, Certificate cert) throws Exception {
        try {
            this.this_mon.enter();
            KeyStore keystore = this.getTrustStore();
            if (cert != null) {
                if (keystore.containsAlias(alias)) {
                    keystore.deleteEntry(alias);
                }
                keystore.setCertificateEntry(alias, cert);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(this.truststore_name);
                    keystore.store(out, "changeit".toCharArray());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory factory = ctx.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(factory);
            SSLSocketFactory sSLSocketFactory = factory;
            return sSLSocketFactory;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public PasswordAuthentication getPasswordAuthentication(String realm, URL tracker) {
        Object[] handler = (Object[])this.password_handlers.get(tracker.toString());
        if (handler != null) {
            try {
                return ((SEPasswordListener)handler[0]).getAuthentication(realm, (URL)handler[1]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        Iterator it = this.password_listeners.iterator();
        while (it.hasNext()) {
            try {
                PasswordAuthentication res = ((SEPasswordListener)it.next()).getAuthentication(realm, tracker);
                if (res == null) continue;
                return res;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public void setPasswordAuthenticationOutcome(String realm, URL tracker, boolean success) {
        Iterator it = this.password_listeners.iterator();
        while (it.hasNext()) {
            ((SEPasswordListener)it.next()).setAuthenticationOutcome(realm, tracker, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPasswordListener(SEPasswordListener l) {
        try {
            this.this_mon.enter();
            this.password_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePasswordListener(SEPasswordListener l) {
        try {
            this.this_mon.enter();
            this.password_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void clearPasswords() {
        Iterator it = this.password_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((SEPasswordListener)it.next()).clearPasswords();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addPasswordHandler(URL url, SEPasswordListener l) {
        String url_s = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + "/";
        this.password_handlers.put(url_s, new Object[]{l, url});
    }

    public void removePasswordHandler(URL url, SEPasswordListener l) {
        Ignore.ignore(l);
        String url_s = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + "/";
        this.password_handlers.remove(url_s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificateListener(SECertificateListener l) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificateListener(SECertificateListener l) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public static void main(String[] args) {
        SESecurityManagerImpl man = SESecurityManagerImpl.getSingleton();
        man.initialise();
        try {
            man.createSelfSignedCertificate("SomeAlias", "CN=fred,OU=wap,O=wip,L=here,ST=there,C=GB", 1000);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    static {
        String[] types = new String[]{"JKS", "GKR"};
        for (int i = 0; i < types.length; ++i) {
            try {
                KeyStore.getInstance(types[i]);
                KEYSTORE_TYPE = types[i];
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        if (KEYSTORE_TYPE == null) {
            KEYSTORE_TYPE = "JKS";
        }
        Logger.log(new LogEvent(LOGID, "Keystore type is " + KEYSTORE_TYPE));
    }
}

