/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentHostImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TRHostConfigImpl {
    public static final String LOG_FILE_NAME = "tracker.log";
    public static final long BACKUP_RETENTION_PERIOD = 604800000L;
    private TRHostImpl host;
    private AEMonitor save_lock_mon = new AEMonitor("TRHostConfig:SL");
    private String log_dir;
    private volatile boolean loading = false;
    private volatile boolean save_outstanding = false;
    private Map saved_stats = new HashMap();
    private AEMonitor this_mon = new AEMonitor("TRHostConfig");

    protected TRHostConfigImpl(TRHostImpl _host) {
        this.host = _host;
        this.log_dir = SystemProperties.getUserPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig(TRHostTorrentFinder finder) {
        try {
            this.this_mon.enter();
            this.loading = true;
            Map map = FileUtil.readResilientConfigFile("tracker.config");
            List torrents = (List)map.get("torrents");
            if (torrents == null) {
                return;
            }
            Iterator iter = torrents.iterator();
            while (iter.hasNext()) {
                Map t_map = (Map)iter.next();
                Long persistent_l = (Long)t_map.get("persistent");
                boolean persistent = persistent_l == null || persistent_l == 1L;
                Long passive_l = (Long)t_map.get("passive");
                boolean passive = passive_l != null && passive_l == 1L;
                Long dateadded_l = (Long)t_map.get("dateadded");
                long date_added = dateadded_l == null ? SystemTime.getCurrentTime() : dateadded_l;
                byte[] hash = (byte[])t_map.get("hash");
                if (persistent) {
                    byte[] file_b;
                    TOTorrent torrent;
                    int state = ((Long)t_map.get("status")).intValue();
                    if (state == 0) {
                        state = 1;
                    }
                    if ((torrent = finder.lookupTorrent(hash)) == null && passive && (file_b = (byte[])t_map.get("torrent_file")) != null) {
                        try {
                            File file = new File(new String(file_b, "ISO-8859-1"));
                            torrent = TorrentUtils.readFromFile(file, true, true);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (torrent != null) {
                        TRHostTorrent ht = this.host.addTorrent(torrent, state, true, passive, date_added);
                        if (!(ht instanceof TRHostTorrentHostImpl)) continue;
                        TRHostTorrentHostImpl hth = (TRHostTorrentHostImpl)ht;
                        this.recoverStats(hth, t_map);
                        continue;
                    }
                    if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable", false)) continue;
                    this.host.addExternalTorrent(hash, state, date_added);
                    continue;
                }
                this.saved_stats.put(new HashWrapper(hash), t_map);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        finally {
            this.loading = false;
            this.this_mon.exit();
        }
    }

    protected void recoverStats(TRHostTorrentHostImpl host_torrent) {
        try {
            HashWrapper hash = host_torrent.getTorrent().getHashWrapper();
            Map t_map = (Map)this.saved_stats.get(hash);
            if (t_map != null) {
                this.saved_stats.remove(hash);
                this.recoverStats(host_torrent, t_map);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void recoverStats(TRHostTorrentHostImpl host_torrent, Map t_map) {
        long completed = 0L;
        long announces = 0L;
        long scrapes = 0L;
        long total_up = 0L;
        long total_down = 0L;
        long bytes_in = 0L;
        long bytes_out = 0L;
        Long dateadded_l = (Long)t_map.get("dateadded");
        long date_added = dateadded_l == null ? SystemTime.getCurrentTime() : dateadded_l;
        Map s_map = (Map)t_map.get("stats");
        if (s_map != null) {
            Long bytes_out_l;
            Long bytes_in_l;
            completed = (Long)s_map.get("completed");
            announces = (Long)s_map.get("announces");
            total_up = (Long)s_map.get("uploaded");
            total_down = (Long)s_map.get("downloaded");
            Long scrapes_l = (Long)s_map.get("scrapes");
            if (scrapes_l != null) {
                scrapes = scrapes_l;
            }
            if ((bytes_in_l = (Long)s_map.get("bytesin")) != null) {
                bytes_in = bytes_in_l;
            }
            if ((bytes_out_l = (Long)s_map.get("bytesout")) != null) {
                bytes_out = bytes_out_l;
            }
        }
        host_torrent.setStartOfDayValues(date_added, completed, announces, scrapes, total_up, total_down, bytes_in, bytes_out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void saveConfig(boolean immediate) {
        if (this.loading) {
            return;
        }
        if (!immediate && !this.save_outstanding) return;
        this.save_outstanding = false;
        try {
            Object hash;
            HashMap map = new HashMap();
            ArrayList<Map> list = new ArrayList<Map>();
            TRHostTorrent[] torrents = this.host.getTorrents();
            ArrayList<StringBuffer> stats_entries = new ArrayList<StringBuffer>();
            HashSet<Object> added = new HashSet<Object>();
            for (int i = 0; i < torrents.length; ++i) {
                try {
                    TRHostTorrent torrent = torrents[i];
                    added.add(torrent.getTorrent().getHashWrapper());
                    StringBuffer stats_entry = new StringBuffer(2048);
                    hash = torrent.getTorrent().getHash();
                    byte[] name = torrent.getTorrent().getName();
                    int status = torrent.getStatus();
                    long completed = torrent.getCompletedCount();
                    long announces = torrent.getAnnounceCount();
                    long scrapes = torrent.getScrapeCount();
                    long uploaded = torrent.getTotalUploaded();
                    long downloaded = torrent.getTotalDownloaded();
                    long bytes_in = torrent.getTotalBytesIn();
                    long bytes_out = torrent.getTotalBytesOut();
                    long date_added = torrent.getDateAdded();
                    int seed_count = torrent.getSeedCount();
                    int non_seed_count = torrent.getLeecherCount();
                    HashMap<String, Object> t_map = new HashMap<String, Object>();
                    t_map.put("persistent", new Long(torrent.isPersistent() ? 1L : 0L));
                    t_map.put("passive", new Long(torrent.isPassive() ? 1L : 0L));
                    if (torrent.isPassive()) {
                        try {
                            String file = TorrentUtils.getTorrentFileName(torrent.getTorrent());
                            t_map.put("torrent_file", file.getBytes("ISO-8859-1"));
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    t_map.put("hash", hash);
                    t_map.put("dateadded", new Long(date_added));
                    t_map.put("status", new Long(status));
                    list.add(t_map);
                    HashMap<String, Long> s_map = new HashMap<String, Long>();
                    t_map.put("stats", s_map);
                    s_map.put("completed", new Long(completed));
                    s_map.put("announces", new Long(announces));
                    s_map.put("scrapes", new Long(scrapes));
                    s_map.put("uploaded", new Long(uploaded));
                    s_map.put("downloaded", new Long(downloaded));
                    s_map.put("bytesin", new Long(bytes_in));
                    s_map.put("bytesout", new Long(bytes_out));
                    stats_entry.append(new String(name, "UTF8"));
                    stats_entry.append(",");
                    stats_entry.append(ByteFormatter.nicePrint((byte[])hash, true));
                    stats_entry.append(",");
                    stats_entry.append(status);
                    stats_entry.append(",");
                    stats_entry.append(seed_count);
                    stats_entry.append(",");
                    stats_entry.append(non_seed_count);
                    stats_entry.append(",");
                    stats_entry.append(completed);
                    stats_entry.append(",");
                    stats_entry.append(announces);
                    stats_entry.append(",");
                    stats_entry.append(scrapes);
                    stats_entry.append(",");
                    stats_entry.append(DisplayFormatters.formatByteCountToKiBEtc(uploaded));
                    stats_entry.append(",");
                    stats_entry.append(DisplayFormatters.formatByteCountToKiBEtc(downloaded));
                    stats_entry.append(",");
                    stats_entry.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(torrent.getAverageUploaded()));
                    stats_entry.append(",");
                    stats_entry.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(torrent.getAverageDownloaded()));
                    stats_entry.append(",");
                    stats_entry.append(DisplayFormatters.formatByteCountToKiBEtc(torrent.getTotalLeft()));
                    stats_entry.append(",");
                    stats_entry.append(DisplayFormatters.formatByteCountToKiBEtc(bytes_in));
                    stats_entry.append(",");
                    stats_entry.append(DisplayFormatters.formatByteCountToKiBEtc(bytes_out));
                    stats_entry.append(",");
                    stats_entry.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(torrent.getAverageBytesIn()));
                    stats_entry.append(",");
                    stats_entry.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(torrent.getAverageBytesOut()));
                    stats_entry.append("\r\n");
                    stats_entries.add(stats_entry);
                    continue;
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
            }
            Iterator it = this.saved_stats.keySet().iterator();
            long now = SystemTime.getCurrentTime();
            while (it.hasNext()) {
                hash = (HashWrapper)it.next();
                if (added.contains(hash)) continue;
                Map t_map = (Map)this.saved_stats.get(hash);
                Long backup = (Long)t_map.get("backup_time");
                if (backup == null) {
                    backup = new Long(now);
                    t_map.put("backup_time", backup);
                }
                if (now - backup >= 604800000L) continue;
                list.add(t_map);
                added.add(hash);
            }
            map.put("torrents", list);
            try {
                this.save_lock_mon.enter();
                FileUtil.writeResilientConfigFile("tracker.config", map);
                if (!COConfigurationManager.getBooleanParameter("Tracker Log Enable", false) || stats_entries.size() <= 0) return;
                try {
                    String timeStamp = "[" + new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date()) + "] ";
                    PrintWriter pw = null;
                    File file_name = new File(this.log_dir.concat(File.separator).concat(LOG_FILE_NAME));
                    pw = new PrintWriter(new FileWriter(file_name, true));
                    for (int i = 0; i < stats_entries.size(); ++i) {
                        StringBuffer stats_entry = (StringBuffer)stats_entries.get(i);
                        String str = timeStamp + stats_entry.toString();
                        pw.print(str);
                    }
                    Object var34_37 = null;
                    if (pw == null) return;
                    try {
                        pw.close();
                        return;
                    }
                    catch (Throwable e2) {}
                    return;
                    {
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            Object var34_38 = null;
                            if (pw == null) return;
                            try {
                                pw.close();
                                return;
                            }
                            catch (Throwable e2) {}
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var34_39 = null;
                        if (pw == null) throw throwable;
                        try {
                            pw.close();
                            throw throwable;
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                return;
            }
            finally {
                this.save_lock_mon.exit();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void saveRequired() {
        this.save_outstanding = true;
    }
}

