/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PRUDPPacketReplyAnnounce2
extends PRUDPPacketReply {
    protected int interval;
    protected int leechers;
    protected int seeders;
    protected static final int BYTES_PER_ENTRY = 6;
    protected int[] addresses;
    protected short[] ports;

    public PRUDPPacketReplyAnnounce2(int trans_id) {
        super(1, trans_id);
    }

    protected PRUDPPacketReplyAnnounce2(DataInputStream is, int trans_id) throws IOException {
        super(1, trans_id);
        this.interval = is.readInt();
        this.leechers = is.readInt();
        this.seeders = is.readInt();
        this.addresses = new int[is.available() / 6];
        this.ports = new short[this.addresses.length];
        for (int i = 0; i < this.addresses.length; ++i) {
            this.addresses[i] = is.readInt();
            this.ports[i] = is.readShort();
        }
    }

    public void setInterval(int value) {
        this.interval = value;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setLeechersSeeders(int _leechers, int _seeders) {
        this.leechers = _leechers;
        this.seeders = _seeders;
    }

    public void setPeers(int[] _addresses, short[] _ports) {
        this.addresses = _addresses;
        this.ports = _ports;
    }

    public int[] getAddresses() {
        return this.addresses;
    }

    public short[] getPorts() {
        return this.ports;
    }

    public int getLeechers() {
        return this.leechers;
    }

    public int getSeeders() {
        return this.seeders;
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeInt(this.interval);
        os.writeInt(this.leechers);
        os.writeInt(this.seeders);
        if (this.addresses != null) {
            for (int i = 0; i < this.addresses.length; ++i) {
                os.writeInt(this.addresses[i]);
                os.writeShort(this.ports[i]);
            }
        }
    }

    public String getString() {
        return super.getString() + "[interval=" + this.interval + ",leechers=" + this.leechers + ",seeders=" + this.seeders + ",addresses=" + this.addresses.length + "]";
    }
}

