/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class BrokenMd5Hasher {
    private ByteBuffer buffer = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
    private int stateA = 1732584193;
    private int stateB = -271733879;
    private int stateC = -1732584194;
    private int stateD = 271733878;
    private long count = 0L;

    public byte[] calculateHash(byte[] data) {
        ByteBuffer input_buffer = ByteBuffer.wrap(data);
        this.reset();
        this.update(input_buffer);
        ByteBuffer result_buffer = ByteBuffer.allocate(16);
        this.finalDigest(result_buffer);
        byte[] result = new byte[16];
        result_buffer.position(0);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result_buffer.get();
        }
        return result;
    }

    public void reset() {
        this.stateA = 1732584193;
        this.stateB = -271733879;
        this.stateC = -1732584194;
        this.stateD = 271733878;
        this.count = 0L;
        this.buffer.rewind();
        for (int i = 0; i < 64; ++i) {
            this.buffer.put((byte)0);
        }
        this.buffer.rewind();
    }

    public void update(ByteBuffer input) {
        int inputLen = input.remaining();
        int index = (int)this.count & 0x3F;
        this.count += (long)inputLen;
        int partLen = 64 - index;
        int i = 0;
        if (inputLen >= partLen) {
            if (index > 0) {
                int t = input.limit();
                input.limit(input.position() + partLen);
                this.buffer.put(input);
                this.buffer.rewind();
                input.limit(t);
                this.transform(this.buffer);
                this.buffer.rewind();
                i = partLen;
                index = partLen;
            }
            while (i + 63 < inputLen) {
                this.transform(input);
                i += 64;
            }
        }
        if (i < inputLen) {
            this.buffer.put(input);
        }
    }

    public void update(byte[] data) {
        this.update(ByteBuffer.wrap(data));
    }

    public byte[] getDigest() {
        ByteBuffer result_buffer = ByteBuffer.allocate(16);
        this.finalDigest(result_buffer);
        byte[] result = new byte[16];
        result_buffer.position(0);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result_buffer.get();
        }
        return result;
    }

    public void finalDigest(ByteBuffer digest) {
        int index = (int)this.count & 0x3F;
        if (index < 56) {
            this.buffer.put((byte)-128);
            for (int i = index; i < 55; ++i) {
                this.buffer.put((byte)0);
            }
            this.buffer.putLong(this.count << 3);
            this.buffer.rewind();
            this.transform(this.buffer);
            this.buffer.rewind();
        } else {
            int i;
            this.buffer.put((byte)-128);
            for (i = index; i < 63; ++i) {
                this.buffer.put((byte)0);
            }
            this.buffer.rewind();
            this.transform(this.buffer);
            this.buffer.rewind();
            for (i = 0; i < 56; ++i) {
                this.buffer.put((byte)0);
            }
            this.buffer.putLong(this.count << 3);
            this.buffer.rewind();
            this.transform(this.buffer);
            this.buffer.rewind();
        }
        digest.putInt(this.stateA);
        digest.putInt(this.stateB);
        digest.putInt(this.stateC);
        digest.putInt(this.stateD);
        this.reset();
    }

    private void transform(ByteBuffer block) {
        int a = this.stateA;
        int b = this.stateB;
        int c = this.stateC;
        int d = this.stateD;
        long e = block.getLong();
        long f = block.getLong();
        long g = block.getLong();
        long h = block.getLong();
        long i = block.getLong();
        long j = block.getLong();
        long k = block.getLong();
        long l = block.getLong();
        a = BrokenMd5Hasher.FF(a, b, c, d, (int)e, 7, -680876936);
        d = BrokenMd5Hasher.FF(d, a, b, c, (int)(e >>> 32), 12, -389564586);
        c = BrokenMd5Hasher.FF(c, d, a, b, (int)f, 17, 606105819);
        b = BrokenMd5Hasher.FF(b, c, d, a, (int)(f >>> 32), 22, -1044525330);
        a = BrokenMd5Hasher.FF(a, b, c, d, (int)g, 7, -176418897);
        d = BrokenMd5Hasher.FF(d, a, b, c, (int)(g >>> 32), 12, 1200080426);
        c = BrokenMd5Hasher.FF(c, d, a, b, (int)h, 17, -1473231341);
        b = BrokenMd5Hasher.FF(b, c, d, a, (int)(h >>> 32), 22, -45705983);
        a = BrokenMd5Hasher.FF(a, b, c, d, (int)i, 7, 1770035416);
        d = BrokenMd5Hasher.FF(d, a, b, c, (int)(i >>> 32), 12, -1958414417);
        c = BrokenMd5Hasher.FF(c, d, a, b, (int)j, 17, -42063);
        b = BrokenMd5Hasher.FF(b, c, d, a, (int)(j >>> 32), 22, -1990404162);
        a = BrokenMd5Hasher.FF(a, b, c, d, (int)k, 7, 1804603682);
        d = BrokenMd5Hasher.FF(d, a, b, c, (int)(k >>> 32), 12, -40341101);
        c = BrokenMd5Hasher.FF(c, d, a, b, (int)l, 17, -1502002290);
        b = BrokenMd5Hasher.FF(b, c, d, a, (int)(l >>> 32), 22, 1236535329);
        a = BrokenMd5Hasher.GG(a, b, c, d, (int)(e >>> 32), 5, -165796510);
        d = BrokenMd5Hasher.GG(d, a, b, c, (int)h, 9, -1069501632);
        c = BrokenMd5Hasher.GG(c, d, a, b, (int)(j >>> 32), 14, 643717713);
        b = BrokenMd5Hasher.GG(b, c, d, a, (int)e, 20, -373897302);
        a = BrokenMd5Hasher.GG(a, b, c, d, (int)(g >>> 32), 5, -701558691);
        d = BrokenMd5Hasher.GG(d, a, b, c, (int)j, 9, 38016083);
        c = BrokenMd5Hasher.GG(c, d, a, b, (int)(l >>> 32), 14, -660478335);
        b = BrokenMd5Hasher.GG(b, c, d, a, (int)g, 20, -405537848);
        a = BrokenMd5Hasher.GG(a, b, c, d, (int)(i >>> 32), 5, 568446438);
        d = BrokenMd5Hasher.GG(d, a, b, c, (int)l, 9, -1019803690);
        c = BrokenMd5Hasher.GG(c, d, a, b, (int)(f >>> 32), 14, -187363961);
        b = BrokenMd5Hasher.GG(b, c, d, a, (int)i, 20, 1163531501);
        a = BrokenMd5Hasher.GG(a, b, c, d, (int)(k >>> 32), 5, -1444681467);
        d = BrokenMd5Hasher.GG(d, a, b, c, (int)f, 9, -51403784);
        c = BrokenMd5Hasher.GG(c, d, a, b, (int)(h >>> 32), 14, 1735328473);
        b = BrokenMd5Hasher.GG(b, c, d, a, (int)k, 20, -1926607734);
        a = BrokenMd5Hasher.HH(a, b, c, d, (int)(g >>> 32), 4, -378558);
        d = BrokenMd5Hasher.HH(d, a, b, c, (int)i, 11, -2022574463);
        c = BrokenMd5Hasher.HH(c, d, a, b, (int)(j >>> 32), 16, 1839030562);
        b = BrokenMd5Hasher.HH(b, c, d, a, (int)l, 23, -35309556);
        a = BrokenMd5Hasher.HH(a, b, c, d, (int)(e >>> 32), 4, -1530992060);
        d = BrokenMd5Hasher.HH(d, a, b, c, (int)g, 11, 1272893353);
        c = BrokenMd5Hasher.HH(c, d, a, b, (int)(h >>> 32), 16, -155497632);
        b = BrokenMd5Hasher.HH(b, c, d, a, (int)j, 23, -1094730640);
        a = BrokenMd5Hasher.HH(a, b, c, d, (int)(k >>> 32), 4, 681279174);
        d = BrokenMd5Hasher.HH(d, a, b, c, (int)e, 11, -358537222);
        c = BrokenMd5Hasher.HH(c, d, a, b, (int)(f >>> 32), 16, -722521979);
        b = BrokenMd5Hasher.HH(b, c, d, a, (int)h, 23, 76029189);
        a = BrokenMd5Hasher.HH(a, b, c, d, (int)(i >>> 32), 4, -640364487);
        d = BrokenMd5Hasher.HH(d, a, b, c, (int)k, 11, -421815835);
        c = BrokenMd5Hasher.HH(c, d, a, b, (int)(l >>> 32), 16, 530742520);
        b = BrokenMd5Hasher.HH(b, c, d, a, (int)f, 23, -995338651);
        a = BrokenMd5Hasher.II(a, b, c, d, (int)e, 6, -198630844);
        d = BrokenMd5Hasher.II(d, a, b, c, (int)(h >>> 32), 10, 1126891415);
        c = BrokenMd5Hasher.II(c, d, a, b, (int)l, 15, -1416354905);
        b = BrokenMd5Hasher.II(b, c, d, a, (int)(g >>> 32), 21, -57434055);
        a = BrokenMd5Hasher.II(a, b, c, d, (int)k, 6, 1700485571);
        d = BrokenMd5Hasher.II(d, a, b, c, (int)(f >>> 32), 10, -1894986606);
        c = BrokenMd5Hasher.II(c, d, a, b, (int)j, 15, -1051523);
        b = BrokenMd5Hasher.II(b, c, d, a, (int)(e >>> 32), 21, -2054922799);
        a = BrokenMd5Hasher.II(a, b, c, d, (int)i, 6, 1873313359);
        d = BrokenMd5Hasher.II(d, a, b, c, (int)(l >>> 32), 10, -30611744);
        c = BrokenMd5Hasher.II(c, d, a, b, (int)h, 15, -1560198380);
        b = BrokenMd5Hasher.II(b, c, d, a, (int)(k >>> 32), 21, 1309151649);
        a = BrokenMd5Hasher.II(a, b, c, d, (int)g, 6, -145523070);
        d = BrokenMd5Hasher.II(d, a, b, c, (int)(j >>> 32), 10, -1120210379);
        c = BrokenMd5Hasher.II(c, d, a, b, (int)f, 15, 718787259);
        b = BrokenMd5Hasher.II(b, c, d, a, (int)(i >>> 32), 21, -343485551);
        this.stateA += a;
        this.stateB += b;
        this.stateC += c;
        this.stateD += d;
    }

    private static int FF(int a, int b, int c, int d, int x, int s, int t) {
        int r = a + x + t + (d ^ b & (c ^ d));
        return (r << s | r >>> 32 - s) + b;
    }

    private static int GG(int a, int b, int c, int d, int x, int s, int t) {
        int r = a + x + t + (c ^ d & (b ^ c));
        return (r << s | r >>> 32 - s) + b;
    }

    private static int HH(int a, int b, int c, int d, int x, int s, int t) {
        int r = a + x + t + (b ^ c ^ d);
        return (r << s | r >>> 32 - s) + b;
    }

    private static int II(int a, int b, int c, int d, int x, int s, int t) {
        int r = a + x + t + (c ^ (b | ~d));
        return (r << s | r >>> 32 - s) + b;
    }
}

