/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.charset.Charset;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.Debug;

public class Constants {
    public static final String SF_WEB_SITE = "http://azureus.sourceforge.net/";
    public static final String AELITIS_WEB_SITE = "http://azureus.aelitis.com/";
    public static final String AELITIS_TORRENTS = "http://torrents.aelitis.com:88/torrents/";
    public static final String AZUREUS_WIKI = "http://azureus.aelitis.com/wiki/index.php/";
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final String BYTE_ENCODING = "ISO-8859-1";
    public static Charset BYTE_CHARSET;
    public static Charset DEFAULT_CHARSET;
    public static final String INFINITY_STRING = "\u221e";
    public static final int INFINITY_AS_INT = 31536000;
    public static final String AZUREUS_NAME = "Azureus";
    public static final String AZUREUS_VERSION = "2.5.0.0";
    public static final byte[] VERSION_ID;
    public static final String OSName;
    public static final boolean isOSX;
    public static final boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isFreeBSD;
    public static final boolean isWindowsXP;
    public static final boolean isWindows95;
    public static final boolean isWindows98;
    public static final boolean isWindowsME;
    public static final boolean isWindows9598ME;
    public static final boolean isWindows;
    public static final boolean isUnix;
    public static final String JAVA_VERSION;
    public static final String FILE_WILDCARD;

    public static String getBaseVersion() {
        return Constants.getBaseVersion(AZUREUS_VERSION);
    }

    public static String getBaseVersion(String version) {
        int p1 = version.indexOf("_");
        if (p1 == -1) {
            return version;
        }
        return version.substring(0, p1);
    }

    public static boolean isCVSVersion() {
        return Constants.isCVSVersion(AZUREUS_VERSION);
    }

    public static boolean isCVSVersion(String version) {
        return version.indexOf("_") != -1;
    }

    public static int getIncrementalBuild() {
        return Constants.getIncrementalBuild(AZUREUS_VERSION);
    }

    public static int getIncrementalBuild(String version) {
        if (!Constants.isCVSVersion(version)) {
            return 0;
        }
        int p1 = version.indexOf("_B");
        if (p1 == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(version.substring(p1 + 2));
        }
        catch (Throwable e) {
            System.out.println("can't parse version");
            return -1;
        }
    }

    public static int compareVersions(String version_1, String version_2) {
        try {
            block7: {
                if (version_1.startsWith(".")) {
                    version_1 = "0" + version_1;
                }
                if (version_2.startsWith(".")) {
                    version_2 = "0" + version_2;
                }
                StringTokenizer tok1 = new StringTokenizer(version_1, ".");
                StringTokenizer tok2 = new StringTokenizer(version_2, ".");
                while (true) {
                    int i1;
                    if (tok1.hasMoreTokens() && tok2.hasMoreTokens()) {
                        int i2;
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == (i2 = Integer.parseInt(tok2.nextToken()))) continue;
                        return i1 - i2;
                    }
                    if (tok1.hasMoreTokens()) {
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == 0) continue;
                        return 1;
                    }
                    if (!tok2.hasMoreTokens()) break block7;
                    int i2 = Integer.parseInt(tok2.nextToken());
                    if (i2 != 0) break;
                }
                return -1;
            }
            return 0;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return 0;
        }
    }

    static {
        try {
            BYTE_CHARSET = Charset.forName(BYTE_ENCODING);
            DEFAULT_CHARSET = Charset.forName(DEFAULT_ENCODING);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        VERSION_ID = "-AZ2500-".getBytes();
        OSName = System.getProperty("os.name");
        isOSX = OSName.toLowerCase().startsWith("mac os");
        isLinux = OSName.equalsIgnoreCase("Linux");
        isSolaris = OSName.equalsIgnoreCase("SunOS");
        isFreeBSD = OSName.equalsIgnoreCase("FreeBSD");
        isWindowsXP = OSName.equalsIgnoreCase("Windows XP");
        isWindows95 = OSName.equalsIgnoreCase("Windows 95");
        isWindows98 = OSName.equalsIgnoreCase("Windows 98");
        isWindowsME = OSName.equalsIgnoreCase("Windows ME");
        isWindows9598ME = isWindows95 || isWindows98 || isWindowsME;
        isWindows = OSName.toLowerCase().startsWith("windows");
        isUnix = !isWindows && !isOSX;
        JAVA_VERSION = System.getProperty("java.version");
        FILE_WILDCARD = isWindows ? "*.*" : "*";
    }
}

