/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.net.magneturi.MagnetURIHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;

public class UrlUtils {
    private static final String[] prefixes = new String[]{"http://", "https://", "ftp://", "magnet:?", "magnet://?"};
    private static int MAGNETURL_STARTS_AT = 3;

    public static boolean isURL(String sURL) {
        return UrlUtils.parseTextForURL(sURL, true) != null;
    }

    public static String parseTextForURL(String text, boolean accept_magnets) {
        String textLower;
        if (text == null || text.length() < 5) {
            return null;
        }
        String href = UrlUtils.parseHTMLforURL(text);
        if (href != null) {
            return href;
        }
        try {
            text = text.trim();
            text = URLDecoder.decode(text);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            textLower = text.toLowerCase();
        }
        catch (Throwable e) {
            textLower = text;
        }
        int max = accept_magnets ? prefixes.length : MAGNETURL_STARTS_AT;
        for (int i = 0; i < max; ++i) {
            int begin = textLower.indexOf(prefixes[i]);
            if (begin < 0) continue;
            int end = text.indexOf("\n", begin + prefixes[i].length());
            String stringURL = end >= 0 ? text.substring(begin, end - 1) : text.substring(begin);
            try {
                URL parsedURL = new URL(stringURL);
                return parsedURL.toExternalForm();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                if (i < MAGNETURL_STARTS_AT) continue;
                return stringURL;
            }
        }
        if (accept_magnets && text.matches("^[a-fA-F0-9]{40}$")) {
            byte[] infohash = ByteFormatter.decodeString(text.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
        }
        return null;
    }

    public static String parseHTMLforURL(String text) {
        Pattern pat = Pattern.compile("<.*a\\s++.*href=\"?([^\\'\"\\s>]++).*", 2);
        Matcher m = pat.matcher(text);
        if (m.find()) {
            String sURL = m.group(1);
            try {
                sURL = URLDecoder.decode(sURL);
            }
            catch (Exception e) {
                // empty catch block
            }
            return sURL;
        }
        return null;
    }

    public static void main(String[] args) {
        MagnetURIHandler.getSingleton();
        byte[] infohash = ByteFormatter.decodeString("1234567890123456789012345678901234567890");
        String[] test = new String[]{"http://moo.com", "http%3A%2F/moo%2Ecom", "magnet:?moo", "magnet%3A%3Fxt=urn:btih:26", "magnet%3A//%3Fmooo", "magnet:?xt=urn:btih:" + Base32.encode(infohash), "aaaaaaaaaabbbbbbbbbbccccccccccdddddddddd"};
        for (int i = 0; i < test.length; ++i) {
            System.out.println(test[i] + " -> " + URLDecoder.decode(test[i]));
            System.out.println(test[i] + " -> " + UrlUtils.isURL(test[i]));
            System.out.println(test[i] + " -> " + UrlUtils.parseTextForURL(test[i], true));
        }
    }

    public static String encode(String s) {
        return URLEncoder.encode(s).replaceAll("\\+", "%20");
    }
}

