/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.nat.NATTraversalObserver;
import com.aelitis.azureus.core.nat.NATTraverser;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnectionListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessage;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionDirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionIndirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class GenericMessageConnectionImpl
implements GenericMessageConnection {
    private static final boolean TRACE = false;
    private static final boolean TEST_TUNNEL = false;
    private MessageManagerImpl message_manager;
    private String msg_id;
    private String msg_desc;
    private GenericMessageEndpointImpl endpoint;
    private int stream_crypto;
    byte[] shared_secret;
    private boolean incoming;
    private volatile GenericMessageConnectionAdapter delegate;
    private volatile boolean closed;
    private volatile boolean connecting;
    private List listeners = new ArrayList();

    protected GenericMessageConnectionImpl(MessageManagerImpl _message_manager, GenericMessageConnectionAdapter _delegate) {
        this.message_manager = _message_manager;
        this.delegate = _delegate;
        this.incoming = true;
        this.delegate.setOwner(this);
    }

    protected GenericMessageConnectionImpl(MessageManagerImpl _message_manager, String _msg_id, String _msg_desc, GenericMessageEndpointImpl _endpoint, int _stream_crypto, byte[] _shared_secret) {
        this.message_manager = _message_manager;
        this.msg_id = _msg_id;
        this.msg_desc = _msg_desc;
        this.endpoint = _endpoint;
        this.stream_crypto = _stream_crypto;
        this.shared_secret = _shared_secret;
        this.incoming = false;
    }

    public GenericMessageEndpoint getEndpoint() {
        return this.endpoint == null ? this.delegate.getEndpoint() : this.endpoint;
    }

    public int getMaximumMessageSize() {
        return this.delegate == null ? 32768 : this.delegate.getMaximumMessageSize();
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public void connect() throws MessageException {
        this.connect(null);
    }

    public void connect(ByteBuffer initial_data) throws MessageException {
        if (this.incoming) {
            throw new MessageException("Already connected");
        }
        if (this.connecting) {
            throw new MessageException("Connect already performed");
        }
        this.connecting = true;
        if (this.closed) {
            throw new MessageException("Connection has been closed");
        }
        InetSocketAddress tcp_ep = this.endpoint.getTCP();
        if (tcp_ep != null) {
            this.connectTCP(initial_data, tcp_ep);
        } else {
            InetSocketAddress udp_ep = this.endpoint.getUDP();
            if (udp_ep != null) {
                this.connectUDP(initial_data, udp_ep, false);
            } else {
                throw new MessageException("No protocols availabld");
            }
        }
    }

    protected void connectTCP(final ByteBuffer initial_data, InetSocketAddress tcp_ep) {
        GenericMessageEndpointImpl gen_tcp = new GenericMessageEndpointImpl(this.endpoint.getNotionalAddress());
        gen_tcp.addTCP(tcp_ep);
        final GenericMessageConnectionDirect tcp_delegate = new GenericMessageConnectionDirect(this.msg_id, this.msg_desc, gen_tcp, this.stream_crypto, this.shared_secret);
        tcp_delegate.setOwner(this);
        tcp_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){

            public void connectSuccess() {
                GenericMessageConnectionImpl.this.delegate = tcp_delegate;
                if (GenericMessageConnectionImpl.this.closed) {
                    try {
                        GenericMessageConnectionImpl.this.delegate.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                } else {
                    GenericMessageConnectionImpl.this.reportConnected();
                }
            }

            public void connectFailure(Throwable failure_msg) {
                InetSocketAddress udp_ep = GenericMessageConnectionImpl.this.endpoint.getUDP();
                if (udp_ep != null) {
                    initial_data.rewind();
                    GenericMessageConnectionImpl.this.connectUDP(initial_data, udp_ep, false);
                } else {
                    GenericMessageConnectionImpl.this.reportFailed(failure_msg);
                }
            }
        });
    }

    protected void connectUDP(final ByteBuffer initial_data, final InetSocketAddress udp_ep, boolean nat_traversal) {
        final GenericMessageEndpointImpl gen_udp = new GenericMessageEndpointImpl(this.endpoint.getNotionalAddress());
        gen_udp.addUDP(udp_ep);
        final GenericMessageConnectionDirect udp_delegate = new GenericMessageConnectionDirect(this.msg_id, this.msg_desc, gen_udp, this.stream_crypto, this.shared_secret);
        udp_delegate.setOwner(this);
        if (nat_traversal) {
            NATTraverser nat_traverser = this.message_manager.getNATTraverser();
            HashMap request2 = new HashMap();
            nat_traverser.attemptTraversal(this.message_manager, udp_ep, request2, false, new NATTraversalObserver(){

                public void succeeded(InetSocketAddress rendezvous, InetSocketAddress target, Map reply) {
                    if (GenericMessageConnectionImpl.this.closed) {
                        GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                    } else {
                        udp_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(this, rendezvous, target){
                            private final /* synthetic */ InetSocketAddress val$rendezvous;
                            private final /* synthetic */ InetSocketAddress val$target;
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$rendezvous = val$rendezvous;
                                this.val$target = val$target;
                            }

                            public void connectSuccess() {
                                GenericMessageConnectionImpl.access$002(2.access$300(this.this$1), 2.access$400(this.this$1));
                                if (GenericMessageConnectionImpl.access$100(2.access$300(this.this$1))) {
                                    try {
                                        GenericMessageConnectionImpl.access$000(2.access$300(this.this$1)).close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    2.access$300(this.this$1).reportFailed(new MessageException("Connection has been closed"));
                                } else {
                                    2.access$300(this.this$1).reportConnected();
                                }
                            }

                            public void connectFailure(Throwable failure_msg) {
                                2.access$500(this.this$1).rewind();
                                2.access$300(this.this$1).connectTunnel(2.access$500(this.this$1), 2.access$600(this.this$1), this.val$rendezvous, this.val$target);
                            }
                        });
                    }
                }

                public void failed(int failure_type) {
                    GenericMessageConnectionImpl.this.reportFailed(new Throwable("UDP connection attempt failed - NAT traversal failed, type=" + failure_type));
                }

                public void failed(Throwable cause) {
                    GenericMessageConnectionImpl.this.reportFailed(cause);
                }

                public void disabled() {
                    GenericMessageConnectionImpl.this.reportFailed(new Throwable("UDP connection attempt failed as DDB is disabled"));
                }

                static /* synthetic */ GenericMessageConnectionImpl access$300(2 x0) {
                    return x0.GenericMessageConnectionImpl.this;
                }

                static /* synthetic */ GenericMessageConnectionAdapter access$400(2 x0) {
                    return x0.udp_delegate;
                }

                static /* synthetic */ ByteBuffer access$500(2 x0) {
                    return x0.initial_data;
                }

                static /* synthetic */ GenericMessageEndpointImpl access$600(2 x0) {
                    return x0.gen_udp;
                }
            });
        } else {
            udp_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){

                public void connectSuccess() {
                    GenericMessageConnectionImpl.this.delegate = udp_delegate;
                    if (GenericMessageConnectionImpl.this.closed) {
                        try {
                            GenericMessageConnectionImpl.this.delegate.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                    } else {
                        GenericMessageConnectionImpl.this.reportConnected();
                    }
                }

                public void connectFailure(Throwable failure_msg) {
                    initial_data.rewind();
                    GenericMessageConnectionImpl.this.connectUDP(initial_data, udp_ep, true);
                }
            });
        }
    }

    protected void connectTunnel(ByteBuffer initial_data, GenericMessageEndpoint ep, InetSocketAddress rendezvous, InetSocketAddress target) {
        final GenericMessageConnectionIndirect tunnel_delegate = new GenericMessageConnectionIndirect(this.message_manager, this.msg_id, this.msg_desc, ep, rendezvous, target);
        tunnel_delegate.setOwner(this);
        tunnel_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){

            public void connectSuccess() {
                GenericMessageConnectionImpl.this.delegate = tunnel_delegate;
                if (GenericMessageConnectionImpl.this.closed) {
                    try {
                        GenericMessageConnectionImpl.this.delegate.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                } else {
                    GenericMessageConnectionImpl.this.reportConnected();
                }
            }

            public void connectFailure(Throwable failure_msg) {
                GenericMessageConnectionImpl.this.reportFailed(failure_msg);
            }
        });
    }

    protected void accepted() {
        this.delegate.accepted();
    }

    public void send(PooledByteBuffer message) throws MessageException {
        int size = ((PooledByteBufferImpl)message).getBuffer().remaining((byte)1);
        if (size > this.getMaximumMessageSize()) {
            throw new MessageException("Message is too large: supplied is " + size + ", maximum is " + this.getMaximumMessageSize());
        }
        this.delegate.send(message);
    }

    protected void receive(GenericMessage message) {
        boolean handled = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            PooledByteBufferImpl buffer = new PooledByteBufferImpl(message.getPayload());
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).receive(this, buffer);
                handled = true;
                continue;
            }
            catch (Throwable f) {
                buffer.returnToPool();
                Debug.printStackTrace(f);
            }
        }
        if (!handled) {
            Debug.out("GenericMessage: incoming message not handled");
        }
    }

    public void close() throws MessageException {
        this.closed = true;
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    protected void reportConnected() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).connected(this);
                continue;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
    }

    protected void reportFailed(Throwable e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).failed(this, e);
                continue;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
    }

    public void addListener(GenericMessageConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GenericMessageConnectionListener listener) {
        this.listeners.remove(listener);
    }
}

