/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.nat.NATTraversalHandler;
import com.aelitis.azureus.core.nat.NATTraverser;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.messaging.MessageManagerListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageHandler;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageRegistration;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionDirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionIndirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageDecoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEncoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;

public class MessageManagerImpl
implements MessageManager,
NATTraversalHandler {
    private static MessageManagerImpl instance;
    private final HashMap compat_checks = new HashMap();
    private final DownloadManagerListener download_manager_listener = new DownloadManagerListener(){

        public void downloadAdded(Download dwnld) {
            dwnld.addPeerListener(new DownloadPeerListener(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void peerManagerAdded(Download download, PeerManager peer_manager) {
                    peer_manager.addListener(new PeerManagerListener(this, download){
                        private final /* synthetic */ Download val$download;
                        private final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = this$2;
                            this.val$download = val$download;
                        }

                        public void peerAdded(PeerManager manager, Peer peer) {
                            peer.addListener(new PeerListener(this, peer){
                                private final /* synthetic */ Peer val$peer;
                                private final /* synthetic */ 3 this$3;
                                {
                                    this.this$3 = this$3;
                                    this.val$peer = val$peer;
                                }

                                public void stateChanged(int new_state) {
                                    if (new_state == 30 && this.val$peer.supportsMessaging()) {
                                        Message[] messages = this.val$peer.getSupportedMessages();
                                        for (int i = 0; i < messages.length; ++i) {
                                            Message msg = messages[i];
                                            Iterator<Map.Entry<K, V>> it = MessageManagerImpl.access$300(1.access$200(2.access$100(3.access$000(this.this$3)))).entrySet().iterator();
                                            while (it.hasNext()) {
                                                Map.Entry<K, V> entry = it.next();
                                                Message message = (Message)entry.getKey();
                                                if (!msg.getID().equals(message.getID())) continue;
                                                MessageManagerListener listener = (MessageManagerListener)entry.getValue();
                                                listener.compatiblePeerFound(3.access$400(this.this$3), this.val$peer, message);
                                            }
                                        }
                                    }
                                }

                                public void sentBadChunk(int piece_num, int total_bad_chunks) {
                                }

                                public void addAvailability(boolean[] peerHavePieces) {
                                }

                                public void removeAvailability(boolean[] peerHavePieces) {
                                }
                            });
                        }

                        public void peerRemoved(PeerManager manager, Peer peer) {
                            Iterator<V> i = MessageManagerImpl.access$300(1.access$200(2.access$100(this.this$2))).values().iterator();
                            while (i.hasNext()) {
                                MessageManagerListener listener = (MessageManagerListener)i.next();
                                listener.peerRemoved(this.val$download, peer);
                            }
                        }

                        static /* synthetic */ 2 access$000(3 x0) {
                            return x0.this$2;
                        }

                        static /* synthetic */ Download access$400(3 x0) {
                            return x0.val$download;
                        }
                    });
                }

                public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                }

                static /* synthetic */ 1 access$100(2 x0) {
                    return x0.this$1;
                }
            });
        }

        public void downloadRemoved(Download download) {
        }

        static /* synthetic */ MessageManagerImpl access$200(1 x0) {
            return x0.MessageManagerImpl.this;
        }
    };
    private AzureusCore core;
    private Map message_handlers = new HashMap();

    public static synchronized MessageManagerImpl getSingleton(AzureusCore core) {
        if (instance == null) {
            instance = new MessageManagerImpl(core);
        }
        return instance;
    }

    private MessageManagerImpl(AzureusCore _core) {
        this.core = _core;
        this.core.getNATTraverser().registerHandler(this);
    }

    public NATTraverser getNATTraverser() {
        return this.core.getNATTraverser();
    }

    public void registerMessageType(Message message) throws MessageException {
        try {
            com.aelitis.azureus.core.peermanager.messaging.MessageManager.getSingleton().registerMessageType(new MessageAdapter(message));
        }
        catch (com.aelitis.azureus.core.peermanager.messaging.MessageException me) {
            throw new MessageException(me.getMessage());
        }
    }

    public void deregisterMessageType(Message message) {
        com.aelitis.azureus.core.peermanager.messaging.MessageManager.getSingleton().deregisterMessageType(new MessageAdapter(message));
    }

    public void locateCompatiblePeers(PluginInterface plug_interface, Message message, MessageManagerListener listener) {
        this.compat_checks.put(message, listener);
        if (this.compat_checks.size() == 1) {
            plug_interface.getDownloadManager().addListener(this.download_manager_listener);
        }
    }

    public void cancelCompatiblePeersLocation(MessageManagerListener orig_listener) {
        Iterator it = this.compat_checks.values().iterator();
        while (it.hasNext()) {
            MessageManagerListener listener = (MessageManagerListener)it.next();
            if (listener != orig_listener) continue;
            it.remove();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericMessageRegistration registerGenericMessageType(String _type, final String description, final int stream_crypto, final GenericMessageHandler handler) throws MessageException {
        final String type = "AEGEN:" + _type;
        final byte[] type_bytes = type.getBytes();
        final byte[] shared_secret = new SHA1Simple().calculateHash(type_bytes);
        Map map = this.message_handlers;
        synchronized (map) {
            this.message_handlers.put(type, handler);
        }
        final NetworkManager.ByteMatcher matcher = new NetworkManager.ByteMatcher(){

            public int size() {
                return type_bytes.length;
            }

            public int minSize() {
                return this.size();
            }

            public Object matches(InetSocketAddress address, ByteBuffer to_compare, int port) {
                int old_limit = to_compare.limit();
                to_compare.limit(to_compare.position() + this.size());
                boolean matches = to_compare.equals(ByteBuffer.wrap(type_bytes));
                to_compare.limit(old_limit);
                return matches ? "" : null;
            }

            public Object minMatches(InetSocketAddress address, ByteBuffer to_compare, int port) {
                return this.matches(address, to_compare, port);
            }

            public byte[] getSharedSecret() {
                return shared_secret;
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(matcher, new NetworkManager.RoutingListener(){

            public void connectionRouted(NetworkConnection connection, Object routing_data) {
                try {
                    ByteBuffer[] skip_buffer = new ByteBuffer[]{ByteBuffer.allocate(type_bytes.length)};
                    connection.getTransport().read(skip_buffer, 0, 1);
                    if (skip_buffer[0].remaining() != 0) {
                        Debug.out("incomplete read");
                    }
                    GenericMessageEndpointImpl endpoint = new GenericMessageEndpointImpl(connection.getEndpoint());
                    GenericMessageConnectionDirect direct_connection = GenericMessageConnectionDirect.receive(endpoint, type, description, stream_crypto, shared_secret);
                    GenericMessageConnectionImpl new_connection = new GenericMessageConnectionImpl(MessageManagerImpl.this, direct_connection);
                    direct_connection.connect(connection);
                    if (handler.accept(new_connection)) {
                        new_connection.accepted();
                    } else {
                        connection.close();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    connection.close();
                }
            }

            public boolean autoCryptoFallback() {
                return stream_crypto != 3;
            }
        }, new MessageStreamFactory(){

            public MessageStreamEncoder createEncoder() {
                return new GenericMessageEncoder();
            }

            public MessageStreamDecoder createDecoder() {
                return new GenericMessageDecoder(type, description);
            }
        });
        return new GenericMessageRegistration(){

            public GenericMessageEndpoint createEndpoint(InetSocketAddress notional_target) {
                return new GenericMessageEndpointImpl(notional_target);
            }

            public GenericMessageConnection createConnection(GenericMessageEndpoint endpoint) throws MessageException {
                return new GenericMessageConnectionImpl(MessageManagerImpl.this, type, description, (GenericMessageEndpointImpl)endpoint, stream_crypto, shared_secret);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel() {
                NetworkManager.getSingleton().cancelIncomingConnectionRouting(matcher);
                Map map = MessageManagerImpl.this.message_handlers;
                synchronized (map) {
                    MessageManagerImpl.this.message_handlers.remove(type);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericMessageHandler getHandler(String type) {
        Map map = this.message_handlers;
        synchronized (map) {
            return (GenericMessageHandler)this.message_handlers.get(type);
        }
    }

    public int getType() {
        return 2;
    }

    public String getName() {
        return "Generic Messaging";
    }

    public Map process(InetSocketAddress originator, Map message) {
        return GenericMessageConnectionIndirect.receive(this, originator, message);
    }

    static /* synthetic */ HashMap access$300(MessageManagerImpl x0) {
        return x0.compat_checks;
    }
}

