/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.update;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderListener;
import org.gudy.azureus2.update.CorePatchChecker;

public class PluginUpdatePlugin
implements Plugin {
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.update";
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    protected PluginInterface plugin_interface;
    protected SFPluginDetailsLoader loader;
    protected LoggerChannel log;
    private String last_id_info = "";

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Plugin Updater");
        this.log = this.plugin_interface.getLogger().getChannel("Plugin Update");
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel("Plugin Update");
        final PluginConfig plugin_config = this.plugin_interface.getPluginconfig();
        boolean enabled = plugin_config.getPluginBooleanParameter("enable.update", true);
        model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        model.getStatus().setText(enabled ? "Running" : "Optional checks disabled");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        this.loader = SFPluginDetailsLoaderFactory.getSingleton();
        this.loader.addListener(new SFPluginDetailsLoaderListener(){

            public void log(String str) {
                PluginUpdatePlugin.this.log.log(1, "[" + str + "]");
            }
        });
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addBooleanParameter2("enable.update", "Plugin.pluginupdate.enablecheck", true);
        UpdateManager update_manager = this.plugin_interface.getUpdateManager();
        update_manager.addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance inst) {
                SFPluginDetailsLoaderFactory.getSingleton().reset();
            }
        });
        final PluginManager plugin_manager = this.plugin_interface.getPluginManager();
        PluginInterface[] plugins = plugin_manager.getPlugins();
        int mandatory_count = 0;
        int non_mandatory_count = 0;
        for (int i = 0; i < plugins.length; ++i) {
            PluginInterface pi = plugins[i];
            boolean pi_mandatory = pi.isMandatory();
            if (pi_mandatory) {
                ++mandatory_count;
                continue;
            }
            ++non_mandatory_count;
        }
        final int f_non_mandatory_count = non_mandatory_count;
        final int f_mandatory_count = mandatory_count;
        update_manager.registerUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return "Non-mandatory plugins";
            }

            public int getMaximumCheckTime() {
                return f_non_mandatory_count * 30;
            }

            public void checkForUpdate(UpdateChecker checker) {
                if (PluginUpdatePlugin.this.checkForUpdateSupport(checker, null, false) == 0) {
                    String[] rps = VersionCheckClient.getSingleton().getRecommendedPlugins();
                    boolean found_one = false;
                    for (int i = 0; i < rps.length; ++i) {
                        String rp_id = rps[i];
                        if (plugin_manager.getPluginInterfaceByID(rp_id) != null) continue;
                        String config_key = "recommended.processed." + rp_id;
                        if (!plugin_config.getPluginBooleanParameter(config_key, false)) {
                            try {
                                PluginInstaller installer = PluginUpdatePlugin.this.plugin_interface.getPluginManager().getPluginInstaller();
                                StandardPlugin[] sps = installer.getStandardPlugins();
                                for (int j = 0; j < sps.length; ++j) {
                                    StandardPlugin sp = sps[j];
                                    if (!sp.getId().equals(rp_id)) continue;
                                    found_one = true;
                                    checker.getCheckInstance().addListener(new UpdateCheckInstanceListener(this, installer, sp, config_key){
                                        private final /* synthetic */ PluginInstaller val$installer;
                                        private final /* synthetic */ StandardPlugin val$sp;
                                        private final /* synthetic */ String val$config_key;
                                        private final /* synthetic */ 4 this$1;
                                        {
                                            this.this$1 = this$1;
                                            this.val$installer = val$installer;
                                            this.val$sp = val$sp;
                                            this.val$config_key = val$config_key;
                                        }

                                        public void cancelled(UpdateCheckInstance instance) {
                                        }

                                        public void complete(UpdateCheckInstance instance) {
                                            if (instance.getUpdates().length == 0) {
                                                4.access$000(this.this$1).installRecommendedPlugin(this.val$installer, this.val$sp);
                                                4.access$100(this.this$1).setPluginParameter(this.val$config_key, true);
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                        if (found_one) break;
                    }
                }
            }

            static /* synthetic */ PluginUpdatePlugin access$000(4 x0) {
                return x0.PluginUpdatePlugin.this;
            }

            static /* synthetic */ PluginConfig access$100(4 x0) {
                return x0.plugin_config;
            }
        }, false);
        update_manager.registerUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return "Mandatory plugins";
            }

            public int getMaximumCheckTime() {
                return f_mandatory_count * 30;
            }

            public void checkForUpdate(UpdateChecker checker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(checker, null, true);
            }
        }, true);
        update_manager.addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance instance) {
                PluginUpdatePlugin.this.log.log(1, "**** Update check starts ****");
            }
        });
    }

    protected void installRecommendedPlugin(PluginInstaller installer, StandardPlugin plugin) {
        try {
            installer.requestInstall(MessageText.getString("plugin.installer.recommended.plugin"), plugin);
        }
        catch (Throwable e) {
            this.log.log(e);
        }
    }

    public UpdatableComponent getCustomUpdateableComponent(final String id, final boolean mandatory) {
        return new UpdatableComponent(){

            public String getName() {
                return "Installation of '" + id + "'";
            }

            public int getMaximumCheckTime() {
                return 30;
            }

            public void checkForUpdate(UpdateChecker checker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(checker, new String[]{id}, mandatory);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int checkForUpdateSupport(UpdateChecker checker, String[] ids_to_check, boolean mandatory) {
        int num_updates_found = 0;
        try {
            int i;
            if (!mandatory && ids_to_check == null && !this.plugin_interface.getPluginconfig().getPluginBooleanParameter("enable.update", true)) {
                int n = num_updates_found;
                return n;
            }
            PluginInterface[] plugins = this.plugin_interface.getPluginManager().getPlugins();
            ArrayList<PluginInterface> plugins_to_check = new ArrayList<PluginInterface>();
            ArrayList<String> plugins_to_check_ids = new ArrayList<String>();
            HashMap<String, Boolean> plugins_to_check_unloadable = new HashMap<String, Boolean>();
            HashMap<String, String> plugins_to_check_names = new HashMap<String, String>();
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                boolean pi_mandatory;
                PluginInterface pi = plugins[i2];
                if (pi.isDisabled()) continue;
                String mand = pi.getPluginProperties().getProperty("plugin.mandatory");
                boolean bl = pi_mandatory = mand != null && mand.trim().toLowerCase().equals("true");
                if (pi_mandatory != mandatory) continue;
                String id = pi.getPluginID();
                String version = pi.getPluginVersion();
                String name = pi.getPluginName();
                if (ids_to_check != null) {
                    boolean id_selected = false;
                    for (int j = 0; j < ids_to_check.length; ++j) {
                        if (!ids_to_check[j].equals(id)) continue;
                        id_selected = true;
                        break;
                    }
                    if (!id_selected) continue;
                }
                if (version != null) {
                    if (plugins_to_check_ids.contains(id)) {
                        String s = (String)plugins_to_check_names.get(id);
                        if (!name.equals(id)) {
                            plugins_to_check_names.put(id, s + "," + name);
                        }
                        Boolean old_unloadable = (Boolean)plugins_to_check_unloadable.get(id);
                        plugins_to_check_unloadable.put(id, new Boolean(pi.isUnloadable() && old_unloadable != false));
                    } else {
                        plugins_to_check_ids.add(id);
                        plugins_to_check.add(pi);
                        plugins_to_check_names.put(id, name.equals(id) ? "" : name);
                        plugins_to_check_unloadable.put(id, new Boolean(pi.isUnloadable()));
                    }
                }
                String location = pi.getPluginDirectoryName();
                this.log.log(1, (mandatory ? "*" : "-") + pi.getPluginName() + ", id = " + id + (version == null ? "" : ", version = " + pi.getPluginVersion()) + (location == null ? "" : ", loc = " + location));
            }
            String[] ids = this.loader.getPluginIDs();
            String id_info = "";
            for (i = 0; i < ids.length; ++i) {
                String id = ids[i];
                SFPluginDetails details = this.loader.getPluginDetails(id);
                id_info = id_info + (i == 0 ? "" : ",") + ids[i] + "=" + details.getVersion() + "/" + details.getCVSVersion();
            }
            if (!id_info.equals(this.last_id_info)) {
                this.last_id_info = id_info;
                this.log.log(1, "Downloaded plugin info = " + id_info);
            }
            for (i = 0; i < plugins_to_check.size(); ++i) {
                if (checker.getCheckInstance().isCancelled()) {
                    throw new Exception("Update check cancelled");
                }
                PluginInterface pi_being_checked = (PluginInterface)plugins_to_check.get(i);
                String plugin_id = pi_being_checked.getPluginID();
                checker.reportProgress("Loading details for " + plugin_id + "/" + pi_being_checked.getPluginName());
                boolean found = false;
                for (int j = 0; j < ids.length; ++j) {
                    if (!ids[j].equalsIgnoreCase(plugin_id)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (pi_being_checked.isBuiltIn()) continue;
                    this.log.log(1, "Skipping " + plugin_id + " as not listed on web site");
                    continue;
                }
                String plugin_names = (String)plugins_to_check_names.get(plugin_id);
                boolean plugin_unloadable = (Boolean)plugins_to_check_unloadable.get(plugin_id);
                this.log.log(1, "Checking " + plugin_id);
                try {
                    String sf_cvs_version;
                    String sf_cvs_version2;
                    String sf_plugin_version;
                    SFPluginDetails details = this.loader.getPluginDetails(plugin_id);
                    if (plugin_names.length() == 0) {
                        plugin_names = details.getName();
                    }
                    boolean az_cvs = this.plugin_interface.getUtilities().isCVSVersion();
                    String pi_version_info = pi_being_checked.getPluginProperties().getProperty("plugin.version.info");
                    String az_plugin_version = pi_being_checked.getPluginVersion();
                    String sf_comp_version = sf_plugin_version = details.getVersion();
                    if (az_cvs && (sf_cvs_version2 = details.getCVSVersion()).length() > 0) {
                        sf_plugin_version = sf_cvs_version2;
                        sf_comp_version = sf_plugin_version.substring(0, sf_plugin_version.length() - 4);
                    }
                    if (sf_comp_version.length() == 0 || !Character.isDigit(sf_comp_version.charAt(0))) {
                        this.log.log(1, "Skipping " + plugin_id + " as no valid version to check");
                        continue;
                    }
                    int comp = PluginUtils.comparePluginVersions(az_plugin_version, sf_comp_version);
                    this.log.log(1, "    Current: " + az_plugin_version + (comp == 0 && sf_plugin_version.endsWith("_CVS") ? "_CVS" : "") + ", Latest: " + sf_plugin_version + (pi_version_info == null ? "" : " [" + pi_version_info + "]"));
                    if (comp >= 0 || pi_being_checked.getPlugin() instanceof UpdatableComponent) continue;
                    String sf_plugin_download = details.getDownloadURL();
                    if (az_cvs && (sf_cvs_version = details.getCVSVersion()).length() > 0) {
                        sf_plugin_download = details.getCVSDownloadURL();
                    }
                    this.log.log(1, "    Description:");
                    ArrayList update_desc = new ArrayList();
                    List desc_lines = HTMLUtils.convertHTMLToText("", details.getDescription());
                    this.logMultiLine("        ", desc_lines);
                    update_desc.addAll(desc_lines);
                    this.log.log(1, "    Comment:");
                    List comment_lines = HTMLUtils.convertHTMLToText("    ", details.getComment());
                    this.logMultiLine("    ", comment_lines);
                    update_desc.addAll(comment_lines);
                    String msg = "A newer version (version " + sf_plugin_version + ") of plugin '" + plugin_id + "' " + (plugin_names.length() == 0 ? "" : "(" + plugin_names + ") ") + "is available. ";
                    this.log.log(1, "");
                    this.log.log(1, "        " + msg + "Download from " + sf_plugin_download);
                    ResourceDownloaderFactory rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                    ResourceDownloader direct_rdl = rdf.create(new URL(sf_plugin_download));
                    String torrent_download = "http://torrents.aelitis.com:88/torrents/";
                    int slash_pos = sf_plugin_download.lastIndexOf("/");
                    torrent_download = slash_pos == -1 ? torrent_download + sf_plugin_download : torrent_download + sf_plugin_download.substring(slash_pos + 1);
                    torrent_download = torrent_download + ".torrent";
                    ResourceDownloader torrent_rdl = rdf.create(new URL(torrent_download));
                    torrent_rdl = rdf.getSuffixBasedDownloader(torrent_rdl);
                    ResourceDownloader alternate_rdl = rdf.getAlternateDownloader(new ResourceDownloader[]{torrent_rdl, direct_rdl});
                    rdf.getTimeoutDownloader(rdf.getRetryDownloader(alternate_rdl, 3), 10000).getSize();
                    String[] update_d = new String[update_desc.size()];
                    update_desc.toArray(update_d);
                    ++num_updates_found;
                    this.addUpdate(pi_being_checked, checker, plugin_id + "/" + plugin_names, update_d, sf_plugin_version, alternate_rdl, sf_plugin_download.toLowerCase().endsWith(".jar"), plugin_unloadable ? 1 : 2, true);
                    continue;
                }
                catch (Throwable e) {
                    this.log.log("    Plugin check failed", e);
                }
            }
        }
        catch (Throwable e) {
            this.log.log("Failed to load plugin details", e);
            checker.failed();
        }
        finally {
            checker.completed();
        }
        return num_updates_found;
    }

    public void addUpdate(final PluginInterface pi_for_update, final UpdateChecker checker, String update_name, String[] update_details, final String version, ResourceDownloader resource_downloader, final boolean is_jar, final int restart_type, final boolean verify) {
        final Update update = checker.addUpdate(update_name, update_details, version, resource_downloader, restart_type);
        update.setUserObject(pi_for_update);
        resource_downloader.addListener(new ResourceDownloaderAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean completed(ResourceDownloader downloader, InputStream data) {
                LoggerChannelListener list = new LoggerChannelListener(this, downloader){
                    private final /* synthetic */ ResourceDownloader val$downloader;
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$downloader = val$downloader;
                    }

                    public void messageLogged(int type, String content) {
                        this.val$downloader.reportActivity(content);
                    }

                    public void messageLogged(String str, Throwable error) {
                        this.val$downloader.reportActivity(str);
                    }
                };
                try {
                    PluginUpdatePlugin.this.log.addListener(list);
                    PluginUpdatePlugin.this.installUpdate(checker, update, pi_for_update, restart_type == 1, is_jar, version, data, verify);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    PluginUpdatePlugin.this.log.removeListener(list);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void installUpdate(UpdateChecker checker, Update update, PluginInterface plugin, boolean unloadable, boolean is_jar, String version, InputStream data, boolean verify) {
        this.log.log(1, "Installing plugin " + plugin.getPluginID() + ", version " + version);
        String target_version = version.endsWith("_CVS") ? version.substring(0, version.length() - 4) : version;
        String plugin_dir = plugin.getPluginDirectoryName();
        UpdateInstaller installer = null;
        try {
            data = update.verifyData(data, verify);
            this.log.log("    Data verification stage complete");
            boolean update_txt_found = false;
            if (plugin_dir == null || plugin_dir.length() == 0) {
                this.log.log(1, "    This is a built-in plugin, updating core");
                CorePatchChecker.patchAzureus2(update.getCheckInstance(), data, plugin.getPluginID() + "_" + version, this.log);
                update.setRestartRequired(2);
            } else {
                String target = plugin_dir + File.separator + plugin.getPluginID() + "_" + target_version + (is_jar ? ".jar" : ".zip");
                FileUtil.copyFile(data, new FileOutputStream(target));
                if (!is_jar) {
                    ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(target)));
                    String common_prefix = null;
                    String selected_platform = null;
                    ArrayList<String> selected_sub_platforms = new ArrayList<String>();
                    try {
                        ZipEntry entry;
                        while ((entry = zis.getNextEntry()) != null) {
                            int len;
                            String name = entry.getName();
                            if (!name.equals("azureus.sig") && !name.endsWith("/")) {
                                int plat_end_pos;
                                if (common_prefix == null) {
                                    common_prefix = name;
                                } else {
                                    int len2 = 0;
                                    for (int i = 0; i < Math.min(common_prefix.length(), name.length()) && common_prefix.charAt(i) == name.charAt(i); ++len2, ++i) {
                                    }
                                    common_prefix = common_prefix.substring(0, len2);
                                }
                                int plat_pos = name.indexOf("platform/");
                                if (plat_pos != -1 && (plat_end_pos = name.indexOf("/", plat_pos += 9)) != -1) {
                                    String platform = name.substring(plat_pos, plat_end_pos);
                                    String sub_platform = null;
                                    int sub_plat_pos = platform.indexOf("_");
                                    if (sub_plat_pos != -1) {
                                        sub_platform = platform.substring(sub_plat_pos + 1);
                                        platform = platform.substring(0, sub_plat_pos);
                                    }
                                    if (Constants.isWindows && platform.equalsIgnoreCase("windows") || Constants.isLinux && platform.equalsIgnoreCase("linux") || Constants.isUnix && platform.equalsIgnoreCase("unix") || Constants.isFreeBSD && platform.equalsIgnoreCase("freebsd") || Constants.isSolaris && platform.equalsIgnoreCase("solaris") || Constants.isOSX && platform.equalsIgnoreCase("osx")) {
                                        selected_platform = platform;
                                        if (sub_platform != null && !selected_sub_platforms.contains(sub_platform)) {
                                            selected_sub_platforms.add(sub_platform);
                                        }
                                    }
                                }
                            }
                            byte[] buffer = new byte[65536];
                            while ((len = zis.read(buffer)) > 0) {
                            }
                        }
                    }
                    finally {
                        zis.close();
                    }
                    if (selected_platform != null) {
                        String[] options = new String[selected_sub_platforms.size()];
                        selected_sub_platforms.toArray(options);
                        if (options.length == 1) {
                            selected_platform = selected_platform + "_" + options[0];
                            this.log.log(1, "platform is '" + selected_platform + "'");
                        } else if (options.length > 1) {
                            String selected_sub_platform = (String)update.getDecision(0, "Select Platform", "Multiple platform options exist for this plugin, please select required one", options);
                            if (selected_sub_platform == null) {
                                throw new Exception("Valid sub-platform selection not selected");
                            }
                            selected_platform = selected_platform + "_" + selected_sub_platform;
                            this.log.log(1, "platform is '" + selected_platform + "'");
                        }
                    }
                    if (common_prefix != null) {
                        int pos = common_prefix.lastIndexOf("/");
                        common_prefix = pos == -1 ? "" : common_prefix.substring(0, pos + 1);
                        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(target)));
                        try {
                            ZipEntry entry;
                            while ((entry = zis.getNextEntry()) != null) {
                                String name = entry.getName();
                                OutputStream entry_os = null;
                                File initial_target = null;
                                File final_target = null;
                                boolean is_plugin_properties = false;
                                try {
                                    int len;
                                    if (name.length() >= common_prefix.length() && !name.equals("azureus.sig") && !name.endsWith("/")) {
                                        boolean skip_file = false;
                                        String file_name = entry.getName().substring(common_prefix.length());
                                        if (selected_platform != null && file_name.indexOf("platform/") != -1) {
                                            String bit_to_remove = "platform/" + selected_platform;
                                            int pp = file_name.indexOf(bit_to_remove);
                                            if (pp != -1) {
                                                file_name = file_name.substring(0, pp) + file_name.substring(pp + bit_to_remove.length() + 1);
                                            } else {
                                                skip_file = true;
                                            }
                                        }
                                        final_target = initial_target = new File(plugin.getPluginDirectoryName() + File.separator + file_name);
                                        if (initial_target.exists()) {
                                            if (file_name.toLowerCase().endsWith(".properties") || file_name.toLowerCase().endsWith(".config")) {
                                                is_plugin_properties = file_name.toLowerCase().equals("plugin.properties");
                                                String old_file_name = file_name;
                                                file_name = file_name + "_" + target_version;
                                                final_target = new File(plugin.getPluginDirectoryName() + File.separator + file_name);
                                                this.log.log(1, "saving new file '" + old_file_name + "'as '" + file_name + "'");
                                            } else if (this.isVersioned(file_name)) {
                                                this.log.log(1, "Version '" + file_name + "' already present, skipping");
                                                skip_file = true;
                                            } else {
                                                this.log.log(1, "overwriting '" + file_name + "'");
                                                File backup = new File(initial_target.getParentFile(), initial_target.getName() + ".bak");
                                                if (backup.exists()) {
                                                    backup.delete();
                                                }
                                                if (!initial_target.renameTo(backup)) {
                                                    this.log.log(1, "    failed to backup '" + file_name + "', deferring until restart");
                                                    if (installer == null) {
                                                        update.setRestartRequired(2);
                                                        installer = update.getCheckInstance().createInstaller();
                                                    }
                                                    File tmp = new File(initial_target.getParentFile(), initial_target.getName() + ".tmp");
                                                    tmp.delete();
                                                    installer.addMoveAction(tmp.getAbsolutePath(), initial_target.getAbsolutePath());
                                                    final_target = tmp;
                                                }
                                            }
                                        }
                                        if (!skip_file) {
                                            final_target.getParentFile().mkdirs();
                                            entry_os = new FileOutputStream(final_target);
                                        }
                                    }
                                    byte[] buffer = new byte[65536];
                                    while ((len = zis.read(buffer)) > 0) {
                                        if (entry_os == null) continue;
                                        entry_os.write(buffer, 0, len);
                                    }
                                }
                                finally {
                                    if (entry_os != null) {
                                        entry_os.close();
                                    }
                                }
                                if (is_plugin_properties) {
                                    Object var41_60;
                                    Properties old_props = new Properties();
                                    Properties new_props = new Properties();
                                    ArrayList<String> props_to_delete = new ArrayList<String>();
                                    HashMap<String, String> props_to_replace = new HashMap<String, String>();
                                    HashMap<String, String> props_to_insert = new HashMap<String, String>();
                                    try {
                                        FileInputStream fis = new FileInputStream(initial_target);
                                        old_props.load(fis);
                                        try {
                                            fis.close();
                                        }
                                        catch (Throwable e) {
                                            // empty catch block
                                        }
                                        fis = new FileInputStream(final_target);
                                        new_props.load(fis);
                                        try {
                                            fis.close();
                                        }
                                        catch (Throwable e) {}
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                    new_props.put("plugin.version", target_version);
                                    String[] prop_names = new String[]{"plugin.name", "plugin.names", "plugin.class", "plugin.classes", "plugin.version", "plugin.langfile"};
                                    for (int z = 0; z < prop_names.length; ++z) {
                                        String prop_name = prop_names[z];
                                        String old_name = old_props.getProperty(prop_name);
                                        String new_name = new_props.getProperty(prop_name);
                                        if (new_name == null) continue;
                                        if (prop_name.equals("plugin.name")) {
                                            props_to_delete.add("plugin.names");
                                        } else if (prop_name.equals("plugin.names")) {
                                            props_to_delete.add("plugin.name");
                                        } else if (prop_name.equals("plugin.class")) {
                                            props_to_delete.add("plugin.classes");
                                        } else if (prop_name.equals("plugin.classes")) {
                                            props_to_delete.add("plugin.class");
                                        }
                                        if (old_name == null) {
                                            props_to_insert.put(prop_name, new_name);
                                            continue;
                                        }
                                        if (new_name.equals(old_name)) continue;
                                        props_to_replace.put(prop_name, new_name);
                                    }
                                    File tmp_file = new File(initial_target.toString() + ".tmp");
                                    File bak_file = new File(initial_target.toString() + ".bak");
                                    BufferedReader lnr = null;
                                    PrintWriter tmp = null;
                                    try {
                                        lnr = new LineNumberReader(new FileReader(initial_target));
                                        tmp = new PrintWriter(new FileWriter(tmp_file));
                                        Iterator it = props_to_insert.keySet().iterator();
                                        while (it.hasNext()) {
                                            String pn = (String)it.next();
                                            String pv = (String)props_to_insert.get(pn);
                                            this.log.log("    Inserting property:" + pn + "=" + pv);
                                            tmp.println(pn + "=" + pv);
                                        }
                                        while (true) {
                                            String line;
                                            if ((line = ((LineNumberReader)lnr).readLine()) == null) {
                                                var41_60 = null;
                                                break;
                                            }
                                            int ep = line.indexOf(61);
                                            if (ep != -1) {
                                                String pn = line.substring(0, ep).trim();
                                                if (props_to_delete.contains(pn)) {
                                                    this.log.log("    Deleting property:" + pn);
                                                    continue;
                                                }
                                                String rv = (String)props_to_replace.get(pn);
                                                if (rv != null) {
                                                    this.log.log("    Replacing property:" + pn + " with " + rv);
                                                    tmp.println(pn + "=" + rv);
                                                    continue;
                                                }
                                                tmp.println(line);
                                                continue;
                                            }
                                            tmp.println(line);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var41_60 = null;
                                        lnr.close();
                                        if (tmp == null) throw throwable;
                                        tmp.close();
                                        throw throwable;
                                    }
                                    lnr.close();
                                    if (tmp != null) {
                                        tmp.close();
                                    }
                                    if (bak_file.exists()) {
                                        bak_file.delete();
                                    }
                                    if (!initial_target.renameTo(bak_file)) {
                                        throw new IOException("Failed to rename '" + initial_target.toString() + "' to '" + bak_file.toString() + "'");
                                    }
                                    if (!tmp_file.renameTo(initial_target)) {
                                        bak_file.renameTo(initial_target);
                                        throw new IOException("Failed to rename '" + tmp_file.toString() + "' to '" + initial_target.toString() + "'");
                                    }
                                    bak_file.delete();
                                    continue;
                                }
                                if (final_target == null || !final_target.getName().equalsIgnoreCase("update.txt")) continue;
                                update_txt_found = true;
                                BufferedReader lnr = null;
                                try {
                                    String line;
                                    lnr = new LineNumberReader(new FileReader(final_target));
                                    while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                                        this.log.log(1, line);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                finally {
                                    if (lnr == null) continue;
                                    lnr.close();
                                }
                            }
                        }
                        finally {
                            zis.close();
                        }
                    }
                }
                if (unloadable) {
                    this.log.log("Plugin initialising, please wait... ");
                    plugin.reload();
                    this.log.log("... initialisation complete.");
                }
            }
            String msg = "Version " + version + " of plugin '" + plugin.getPluginID() + "' " + "installed successfully";
            if (update_txt_found) {
                msg = msg + " - See update log for details";
            }
            this.log.logAlertRepeatable(update_txt_found ? 2 : 1, msg);
            return;
        }
        catch (Throwable e) {
            String msg = "Version " + version + " of plugin '" + plugin.getPluginID() + "' " + "failed to install - " + e.getMessage();
            this.log.logAlertRepeatable(3, msg);
            return;
        }
        finally {
            update.complete();
        }
    }

    protected boolean isVersioned(String name) {
        int pos = name.lastIndexOf(95);
        if (pos == -1 || name.endsWith("_")) {
            return false;
        }
        String rem = name.substring(pos + 1);
        if ((pos = rem.lastIndexOf(46)) != -1) {
            rem = rem.substring(0, pos);
        }
        for (int i = 0; i < rem.length(); ++i) {
            char c = rem.charAt(i);
            if (c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    protected void logMultiLine(String indent, List lines) {
        for (int i = 0; i < lines.size(); ++i) {
            this.log.log(1, indent + (String)lines.get(i));
        }
    }
}

