/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;

public class CommandCollection {
    private final Map subCommands = new HashMap();

    public void execute(String commandName, ConsoleInput ci, List args) {
        IConsoleCommand command = this.get(commandName);
        command.execute(commandName, ci, args);
    }

    public String getCommandDescriptions() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            IConsoleCommand cmd = (IConsoleCommand)iter.next();
            out.println(cmd.getCommandDescriptions());
        }
        return sw.toString();
    }

    public IConsoleCommand get(String commandName) {
        return (IConsoleCommand)this.subCommands.get(commandName);
    }

    public void add(IConsoleCommand command) {
        Iterator iter = command.getCommandNames().iterator();
        while (iter.hasNext()) {
            String cmdName = (String)iter.next();
            this.subCommands.put(cmdName, command);
        }
    }

    public Iterator iterator() {
        return new HashSet(this.subCommands.values()).iterator();
    }
}

