/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.TorrentCommand;

public class TorrentRemove
extends TorrentCommand {
    public TorrentRemove() {
        super(new String[]{"remove", "r"}, "Removing");
    }

    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        try {
            dm.stopIt(70, false, false);
            ci.gm.removeDownloadManager(dm);
        }
        catch (GlobalManagerDownloadRemovalVetoException e) {
            ci.out.println("> Veto when removing torrent (" + e.getMessage() + ")");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace(ci.out);
            return false;
        }
        return true;
    }

    public String getCommandDescriptions() {
        return "remove (<torrentoptions>)\tr\tRemove torrent(s).";
    }
}

