/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.multiuser;

import com.aelitis.azureus.core.AzureusCoreException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.console.UserProfile;

public class UserManager {
    private static final String USER_DB_CONFIG_FILE = "console.users.properties";
    private static UserManager instance;
    private Map usersMap = new HashMap();
    private final String fileName;

    public UserManager(String fileName) {
        this.fileName = fileName;
    }

    public UserProfile authenticate(String username, String password) {
        UserProfile profile = this.getUser(username);
        if (profile != null && profile.authenticate(password)) {
            return profile;
        }
        return null;
    }

    public UserProfile getUser(String username) {
        return (UserProfile)this.usersMap.get(username.toLowerCase());
    }

    public void addUser(UserProfile user) {
        this.usersMap.put(user.getUsername().toLowerCase(), user);
    }

    public Collection getUsers() {
        return Collections.unmodifiableCollection(this.usersMap.values());
    }

    public void load() throws FileNotFoundException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.fileName));
        this.doLoad(bis);
    }

    protected void doLoad(InputStream in) {
        XMLDecoder decoder = new XMLDecoder(in);
        UserManagerConfig managerConfig = (UserManagerConfig)decoder.readObject();
        Iterator iter = managerConfig.getUsers().iterator();
        while (iter.hasNext()) {
            UserProfile user = (UserProfile)iter.next();
            this.usersMap.put(user.getUsername().toLowerCase(), user);
        }
        System.out.println("UserManager: registered " + this.usersMap.size() + " users");
        decoder.close();
    }

    public void save() throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(this.fileName);
        this.doSave(out);
    }

    protected void doSave(OutputStream out) {
        UserManagerConfig config = new UserManagerConfig();
        ArrayList users = new ArrayList(this.usersMap.values());
        config.setUsers(users);
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(out));
        encoder.writeObject(config);
        encoder.close();
    }

    public static UserManager getInstance(PluginInterface pi) {
        if (instance == null) {
            String azureusUserDir = pi.getUtilities().getAzureusUserDir();
            File dbFile = new File(azureusUserDir, USER_DB_CONFIG_FILE);
            try {
                instance = new UserManager(dbFile.getCanonicalPath());
                if (dbFile.exists()) {
                    System.out.println("loading user configuration from: " + dbFile.getCanonicalPath());
                    instance.load();
                } else {
                    System.out.println("file: " + dbFile.getCanonicalPath() + " does not exist. using 'null' user manager");
                }
            }
            catch (IOException e) {
                throw new AzureusCoreException("Unable to instantiate default user manager");
            }
        }
        return instance;
    }

    public void deleteUser(String userName) {
        this.usersMap.remove(userName.toLowerCase());
    }

    public static final class UserManagerConfig {
        private List users = new ArrayList();

        public List getUsers() {
            return this.users;
        }

        public void setUsers(List users) {
            this.users = users;
        }

        public void addUser(UserProfile user) {
            this.users.add(user);
        }

        public void clear() {
            this.users.clear();
        }
    }
}

