/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;

public class SelectableSpeedMenu {
    private static Map parseSpeedPartitionStringCache = new HashMap();

    public static void generateMenuItems(Menu parent, AzureusCore core, GlobalManager globalManager, boolean up_menu) {
        boolean unlim;
        MenuItem[] oldItems = parent.getItems();
        for (int i = 0; i < oldItems.length; ++i) {
            oldItems[i].dispose();
        }
        String configKey = up_menu ? TransferSpeedValidator.getActiveUploadParameter(globalManager) : "Max Download Speed KBs";
        int speedPartitions = 12;
        int maxBandwidth = COConfigurationManager.getIntParameter(configKey);
        boolean bl = unlim = maxBandwidth == 0;
        if (maxBandwidth == 0 && !up_menu) {
            maxBandwidth = 275;
        }
        boolean auto = false;
        if (up_menu) {
            final String configAutoKey = TransferSpeedValidator.getActiveAutoUploadParameter(globalManager);
            auto = COConfigurationManager.getBooleanParameter(configAutoKey);
            final MenuItem auto_item = new MenuItem(parent, 32);
            auto_item.setText(MessageText.getString("ConfigView.auto"));
            auto_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    COConfigurationManager.setParameter(configAutoKey, auto_item.getSelection());
                    COConfigurationManager.save();
                }
            });
            if (auto) {
                auto_item.setSelection(true);
            }
            auto_item.setEnabled(TransferSpeedValidator.isAutoUploadAvailable(core));
            new MenuItem(parent, 2);
        }
        MenuItem item = new MenuItem(parent, 16);
        item.setText(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
        item.setData("maxkb", (Object)new Integer(0));
        item.setSelection(unlim && !auto);
        item.addListener(13, SelectableSpeedMenu.getLimitMenuItemListener(up_menu, parent, globalManager, configKey));
        Integer[] speed_limits = null;
        String config_prefix = "config.ui.speed.partitions.manual." + (up_menu ? "upload" : "download") + ".";
        if (COConfigurationManager.getBooleanParameter(config_prefix + "enabled", false)) {
            speed_limits = SelectableSpeedMenu.parseSpeedPartitionString(COConfigurationManager.getStringParameter(config_prefix + "values", ""));
        }
        if (speed_limits == null) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            int delta = 0;
            for (int i = 0; i < 12; ++i) {
                int[] valuePair = delta == 0 ? new int[]{maxBandwidth} : new int[]{maxBandwidth - delta, maxBandwidth + delta};
                for (int j = 0; j < valuePair.length; ++j) {
                    if (j == 0) {
                        l.add(0, new Integer(valuePair[j]));
                        continue;
                    }
                    l.add(new Integer(valuePair[j]));
                }
                delta += delta >= 50 ? 50 : (delta >= 10 ? 10 : (delta >= 5 ? 5 : (delta >= 2 ? 3 : 1)));
            }
            speed_limits = l.toArray(new Integer[l.size()]);
        }
        for (int i = 0; i < speed_limits.length; ++i) {
            void i_value = speed_limits[i];
            int value = i_value.intValue();
            if (value < 5) continue;
            item = new MenuItem(parent, 16);
            item.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value * 1024, true));
            item.setData("maxkb", (Object)i_value);
            item.addListener(13, SelectableSpeedMenu.getLimitMenuItemListener(up_menu, parent, globalManager, configKey));
            item.setSelection(!unlim && value == maxBandwidth && !auto);
        }
    }

    private static synchronized Integer[] parseSpeedPartitionString(String s) {
        Integer[] result = (Integer[])parseSpeedPartitionStringCache.get(s);
        if (result == null) {
            try {
                result = SelectableSpeedMenu.parseSpeedPartitionString0(s);
            }
            catch (NumberFormatException nfe) {
                result = new Integer[]{};
            }
            parseSpeedPartitionStringCache.put(s, result);
        }
        if (result.length == 0) {
            return null;
        }
        return result;
    }

    private static Integer[] parseSpeedPartitionString0(String s) {
        StringTokenizer tokeniser = new StringTokenizer(s.trim(), ",");
        TreeSet<Integer> values = new TreeSet<Integer>();
        while (tokeniser.hasMoreTokens()) {
            values.add(new Integer(Integer.parseInt(tokeniser.nextToken().trim())));
        }
        return values.toArray(new Integer[values.size()]);
    }

    private static final Listener getLimitMenuItemListener(final boolean up_menu, final Menu parent, final GlobalManager globalManager, final String configKey) {
        return new Listener(){

            public void handleEvent(Event event2) {
                MenuItem[] items = parent.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] == event2.widget) {
                        items[i].setSelection(true);
                        int cValue = (Integer)new TransferSpeedValidator(configKey, items[i].getData("maxkb")).getValue();
                        COConfigurationManager.setParameter(configKey, cValue);
                        if (up_menu) {
                            String configAutoKey = TransferSpeedValidator.getActiveAutoUploadParameter(globalManager);
                            COConfigurationManager.setParameter(configAutoKey, false);
                        }
                        COConfigurationManager.save();
                        continue;
                    }
                    items[i].setSelection(false);
                }
            }
        };
    }
}

