/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.progress;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationListener;
import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.progress.ProgressWindow;

public class ProgressWindow {
    private volatile Shell shell;
    private volatile boolean task_complete;

    public static void register(AzureusCore core) {
        core.addOperationListener(new AzureusCoreOperationListener(){

            public boolean operationCreated(AzureusCoreOperation operation) {
                if (operation.getOperationType() == 2 && Utils.isThisThreadSWT() && operation.getTask() != null) {
                    new ProgressWindow(operation);
                    return true;
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressWindow(final AzureusCoreOperation operation) {
        ProgressWindow progressWindow;
        final RuntimeException[] error = new RuntimeException[]{null};
        new DelayedEvent("ProgWin", 1000L, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (!ProgressWindow.this.task_complete) {
                        Utils.execSWTThread(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                3 var1_1 = this;
                                synchronized (var1_1) {
                                    if (!ProgressWindow.access$000(2.access$100(this.this$1))) {
                                        2.access$100(this.this$1).showDialog();
                                    }
                                }
                            }
                        }, false);
                    }
                }
            }

            static /* synthetic */ ProgressWindow access$100(2 x0) {
                return x0.ProgressWindow.this;
            }
        });
        new AEThread("ProgressWindow", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void runSupport() {
                4 var4_5;
                try {
                    try {
                        operation.getTask().run(operation);
                    }
                    catch (RuntimeException e) {
                        error[0] = e;
                        Object var3_2 = null;
                        4 var4_6 = this;
                        synchronized (var4_6) {
                            ProgressWindow.this.task_complete = true;
                            Utils.execSWTThread(new Runnable(this){
                                private final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                }
                            }, true);
                            return;
                        }
                    }
                    catch (Throwable e) {
                        error[0] = new RuntimeException(e);
                        Object var3_3 = null;
                        4 var4_7 = this;
                        synchronized (var4_7) {
                            ProgressWindow.this.task_complete = true;
                            Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */, true);
                            return;
                        }
                    }
                    Object var3_1 = null;
                    var4_5 = this;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    4 var4_8 = this;
                    synchronized (var4_8) {
                        ProgressWindow.this.task_complete = true;
                        Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */, true);
                        throw throwable;
                    }
                }
                synchronized (var4_5) {
                    ProgressWindow.this.task_complete = true;
                    Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */, true);
                    return;
                }
            }
        }.start();
        try {
            Display display = SWTThread.getInstance().getDisplay();
            while (!this.task_complete && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            Object var5_4 = null;
            progressWindow = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ProgressWindow progressWindow2 = this;
            synchronized (progressWindow2) {
                this.task_complete = true;
            }
            try {
                if (this.shell != null && !this.shell.isDisposed()) {
                    this.shell.dispose();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            throw throwable;
        }
        synchronized (progressWindow) {
            this.task_complete = true;
        }
        try {
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.dispose();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (error[0] != null) {
            throw error[0];
        }
    }

    protected void showDialog() {
        this.shell = ShellFactory.createMainShell(67680);
        this.shell.setText(MessageText.getString("progress.window.title"));
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event2) {
                event2.doit = false;
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        InputStream is = ImageRepository.getImageAsStream("working");
        if (is == null) {
            new Label((Composite)this.shell, 0);
        } else {
            final ImageLoader loader = new ImageLoader();
            final Color background = this.shell.getBackground();
            loader.load(is);
            Canvas canvas = new Canvas((Composite)this.shell, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point(loader.logicalScreenWidth, loader.logicalScreenWidth);
                }
            };
            final GC canvas_gc = new GC((Drawable)canvas);
            new AEThread("GifAnim", true){
                private Image image;
                private boolean useGIFBackground;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void runSupport() {
                    GC offScreenImageGC;
                    block22: {
                        Display display = ProgressWindow.this.shell.getDisplay();
                        ImageData[] image_data = loader.data;
                        Image offScreenImage = new Image((Device)display, loader.logicalScreenWidth, loader.logicalScreenHeight);
                        offScreenImageGC = new GC((Drawable)offScreenImage);
                        offScreenImageGC.setBackground(background);
                        offScreenImageGC.fillRectangle(0, 0, loader.logicalScreenWidth, loader.logicalScreenHeight);
                        try {
                            try {
                                int imageDataIndex = 0;
                                ImageData imageData = image_data[imageDataIndex];
                                if (this.image != null && !this.image.isDisposed()) {
                                    this.image.dispose();
                                }
                                this.image = new Image((Device)display, imageData);
                                offScreenImageGC.drawImage(this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                int repeatCount = loader.repeatCount;
                                while (!ProgressWindow.this.task_complete && loader.repeatCount == 0 || repeatCount > 0) {
                                    switch (imageData.disposalMethod) {
                                        case 2: {
                                            Color bgColor = null;
                                            if (this.useGIFBackground && loader.backgroundPixel != -1) {
                                                bgColor = new Color((Device)display, imageData.palette.getRGB(loader.backgroundPixel));
                                            }
                                            offScreenImageGC.setBackground(bgColor != null ? bgColor : background);
                                            offScreenImageGC.fillRectangle(imageData.x, imageData.y, imageData.width, imageData.height);
                                            if (bgColor == null) break;
                                            bgColor.dispose();
                                            break;
                                        }
                                        case 3: {
                                            offScreenImageGC.drawImage(this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                            break;
                                        }
                                    }
                                    imageDataIndex = (imageDataIndex + 1) % image_data.length;
                                    imageData = image_data[imageDataIndex];
                                    this.image.dispose();
                                    this.image = new Image((Device)display, imageData);
                                    offScreenImageGC.drawImage(this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                    canvas_gc.drawImage(offScreenImage, 0, 0);
                                    try {
                                        int ms = imageData.delayTime * 10;
                                        if (ms < 20) {
                                            ms += 30;
                                        }
                                        if (ms < 30) {
                                            ms += 10;
                                        }
                                        Thread.sleep(ms);
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                    if (imageDataIndex != image_data.length - 1) continue;
                                    --repeatCount;
                                }
                                Object var10_12 = null;
                                if (offScreenImage == null) break block22;
                            }
                            catch (SWTException ex) {
                                ex.printStackTrace();
                                Object var10_13 = null;
                                if (offScreenImage != null && !offScreenImage.isDisposed()) {
                                    offScreenImage.dispose();
                                }
                                if (offScreenImageGC != null && !offScreenImageGC.isDisposed()) {
                                    offScreenImageGC.dispose();
                                }
                                if (this.image == null) return;
                                if (this.image.isDisposed()) return;
                                this.image.dispose();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_14 = null;
                            if (offScreenImage != null && !offScreenImage.isDisposed()) {
                                offScreenImage.dispose();
                            }
                            if (offScreenImageGC != null && !offScreenImageGC.isDisposed()) {
                                offScreenImageGC.dispose();
                            }
                            if (this.image == null) throw throwable;
                            if (this.image.isDisposed()) throw throwable;
                            this.image.dispose();
                            throw throwable;
                        }
                        if (!offScreenImage.isDisposed()) {
                            offScreenImage.dispose();
                        }
                    }
                    if (offScreenImageGC != null && !offScreenImageGC.isDisposed()) {
                        offScreenImageGC.dispose();
                    }
                    if (this.image == null) return;
                    if (this.image.isDisposed()) return;
                    this.image.dispose();
                }
            }.start();
        }
        Label label = new Label((Composite)this.shell, 0);
        label.setText(MessageText.getString("progress.window.msg.filemove"));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }
}

