/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.views.IView;

public abstract class AbstractIView
implements IView {
    protected AEMonitor this_mon = new AEMonitor("AbstractIView");

    public void initialize(Composite composite) {
    }

    public Composite getComposite() {
        return null;
    }

    public void refresh() {
    }

    public void delete() {
        Composite comp = this.getComposite();
        if (comp != null && !comp.isDisposed()) {
            comp.dispose();
        }
    }

    public String getData() {
        return null;
    }

    public String getFullTitle() {
        String key = this.getData();
        if (MessageText.keyExists(key)) {
            return MessageText.getString(this.getData());
        }
        return key.replace('.', ' ');
    }

    public final String getShortTitle() {
        String shortTitle = this.getFullTitle();
        if (shortTitle != null && shortTitle.length() > 30) {
            shortTitle = shortTitle.substring(0, 30) + "...";
        }
        return shortTitle;
    }

    public void updateLanguage() {
        Messages.updateLanguageForControl((Widget)this.getComposite());
    }

    public boolean isEnabled(String itemKey) {
        return false;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public void itemActivated(String itemKey) {
    }

    public void generateDiagnostics(IndentWriter writer) {
        writer.println("Diagnostics for " + this + " (" + this.getFullTitle() + ")");
    }

    public void dataSourceChanged(Object newDataSource) {
    }
}

