/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Table;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;

public class TableRowImpl
extends BufferedTableRow
implements TableRowCore {
    private Map mTableCells;
    private String sTableID;
    private Object coreDataSource;
    private Object pluginDataSource;
    private boolean bDisposed;
    private boolean bSetNotUpToDateLastRefresh = false;
    private static AEMonitor sortedDisposal_mon = new AEMonitor("TableRowImpl");

    public TableRowImpl(Table table, String sTableID, TableColumnCore[] columnsSorted, Object dataSource, boolean bSkipFirstColumn) {
        super(table);
        this.sTableID = sTableID;
        this.coreDataSource = dataSource;
        this.mTableCells = new HashMap();
        this.bDisposed = false;
        for (int i = 0; i < columnsSorted.length; ++i) {
            if (columnsSorted[i] == null) continue;
            TableCellImpl cell = new TableCellImpl(this, columnsSorted[i], bSkipFirstColumn ? i + 1 : i);
            this.mTableCells.put(columnsSorted[i].getName(), cell);
        }
    }

    public boolean isValid() {
        if (this.bDisposed) {
            return true;
        }
        boolean valid = true;
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore cell = (TableCellCore)iter.next();
            if (cell == null) continue;
            valid &= cell.isValid();
        }
        return valid;
    }

    public Object getDataSource() {
        return this.getDataSource(false);
    }

    public String getTableID() {
        return this.sTableID;
    }

    public TableCell getTableCell(String field) {
        if (this.bDisposed) {
            return null;
        }
        return (TableCell)this.mTableCells.get(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean bDeleteSWTObject) {
        sortedDisposal_mon.enter();
        try {
            if (this.bDisposed) {
                return;
            }
            try {
                Iterator iter = this.mTableCells.values().iterator();
                while (iter.hasNext()) {
                    TableCellCore item = (TableCellCore)iter.next();
                    item.dispose();
                }
            }
            finally {
                if (bDeleteSWTObject) {
                    this.dispose();
                }
            }
            this.bDisposed = true;
        }
        finally {
            sortedDisposal_mon.exit();
        }
    }

    public void refresh(boolean bDoGraphics) {
        if (this.bDisposed) {
            return;
        }
        boolean bVisible = this.isVisible();
        this.refresh(bDoGraphics, bVisible);
    }

    public void refresh(boolean bDoGraphics, boolean bVisible) {
        if (!bVisible) {
            if (!this.bSetNotUpToDateLastRefresh) {
                this.setUpToDate(false);
                this.bSetNotUpToDateLastRefresh = true;
            }
            return;
        }
        this.bSetNotUpToDateLastRefresh = false;
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            item.refresh(bDoGraphics, bVisible);
        }
    }

    public void setAlternatingBGColor(boolean bEvenIfNotVisible) {
        super.setAlternatingBGColor(bEvenIfNotVisible);
    }

    public void locationChanged(int iStartColumn) {
        if (this.bDisposed || !this.isVisible()) {
            return;
        }
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            if (item.getTableColumn().getPosition() <= iStartColumn) continue;
            item.locationChanged();
        }
    }

    public void doPaint(GC gc) {
        this.doPaint(gc, this.isVisible());
    }

    public void doPaint(GC gc, boolean bVisible) {
        if (this.bDisposed || !bVisible) {
            return;
        }
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            if (!item.needsPainting()) continue;
            item.doPaint(gc);
        }
    }

    public TableCellCore getTableCellCore(String field) {
        if (this.bDisposed) {
            return null;
        }
        return (TableCellCore)this.mTableCells.get(field);
    }

    public Object getDataSource(boolean bCoreObject) {
        TRHostTorrent item;
        DiskManagerFileInfo fileInfo2;
        PEPiece piece;
        PEPeer peer;
        DownloadManager dm;
        if (this.bDisposed) {
            return null;
        }
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        if ((this.sTableID.equals("MySeeders") || this.sTableID.equals("MyTorrents")) && (dm = (DownloadManager)this.coreDataSource) != null) {
            try {
                this.pluginDataSource = DownloadManagerImpl.getDownloadStatic(dm);
            }
            catch (DownloadException e) {
                // empty catch block
            }
        }
        if (this.sTableID.equals("Peers") && (peer = (PEPeer)this.coreDataSource) != null) {
            this.pluginDataSource = new PeerImpl(peer);
        }
        if (this.sTableID.equals("Pieces") && (piece = (PEPiece)this.coreDataSource) != null) {
            this.pluginDataSource = null;
        }
        if (this.sTableID.equals("Files") && (fileInfo2 = (DiskManagerFileInfo)this.coreDataSource) != null) {
            try {
                this.pluginDataSource = new DiskManagerFileInfoImpl(DownloadManagerImpl.getDownloadStatic(fileInfo2.getDownloadManager()), fileInfo2);
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        if (this.sTableID.equals("MyShares")) {
            this.pluginDataSource = this.coreDataSource;
        }
        if (this.sTableID.equals("MyTracker") && (item = (TRHostTorrent)this.coreDataSource) != null) {
            this.pluginDataSource = new TrackerTorrentImpl(item);
        }
        return this.pluginDataSource;
    }

    public boolean isRowDisposed() {
        return this.bDisposed;
    }

    public int getIndex() {
        if (this.bDisposed) {
            return -1;
        }
        return super.getIndex();
    }

    public boolean setTableItem(int newIndex) {
        if (this.bDisposed) {
            System.out.println("XXX setTI: bDisposed from " + Debug.getCompressedStackTrace());
            return false;
        }
        return this.setTableItem(newIndex, false);
    }

    public void setForeground(Color c) {
        if (!this.isVisible()) {
            return;
        }
        super.setForeground(c);
    }

    public void invalidate() {
        super.invalidate();
        if (this.bDisposed) {
            return;
        }
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore cell = (TableCellCore)iter.next();
            if (cell == null) continue;
            cell.invalidate(true);
        }
    }

    public void repaint() {
        super.invalidate();
    }

    public void setUpToDate(boolean upToDate) {
        if (this.bDisposed) {
            return;
        }
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore cell = (TableCellCore)iter.next();
            if (cell == null) continue;
            cell.setUpToDate(upToDate);
        }
    }

    public String toString() {
        return "TableRowImpl@" + Integer.toHexString(this.hashCode()) + "/#" + this.getIndex();
    }
}

