/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.pieces;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class BlocksItem
extends CoreTableColumn
implements TableCellAddedListener {
    private final int COLOR_REQUESTED = 0;
    private final int COLOR_WRITTEN = 1;
    private final int COLOR_DOWNLOADED = 2;
    private final int COLOR_INCACHE = 3;
    public static Color[] colors = new Color[]{Colors.blues[2], Colors.blues[9], Colors.red, Colors.grey};

    public BlocksItem() {
        super("blocks", "Pieces");
        this.initializeAsGraphic(-2, 200);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener {
        CacheFileManagerStats cacheStats;

        public Cell(TableCell cell) {
            cell.setFillCell(true);
            cell.addListeners(this);
            try {
                this.cacheStats = CacheFileManagerFactory.getSingleton().getStats();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void dispose(TableCell cell) {
            Image img = ((TableCellCore)cell).getGraphicSWT();
            if (img != null && !img.isDisposed()) {
                img.dispose();
            }
        }

        public void refresh(TableCell cell) {
            long addBlocks;
            PEPiece pePiece = (PEPiece)cell.getDataSource();
            if (pePiece == null) {
                cell.setSortValue(0L);
                this.dispose(cell);
                cell.setGraphic(null);
                return;
            }
            cell.setSortValue(pePiece.getNbWritten());
            long lNumBlocks = pePiece.getNbBlocks();
            int newWidth = cell.getWidth();
            if (newWidth <= 0) {
                this.dispose(cell);
                cell.setGraphic(null);
                return;
            }
            int newHeight = cell.getHeight();
            int x1 = newWidth - 2;
            int y1 = newHeight - 3;
            if (x1 < 10 || y1 < 3) {
                this.dispose(cell);
                cell.setGraphic(null);
                return;
            }
            Image image = new Image((Device)SWTThread.getInstance().getDisplay(), newWidth, newHeight);
            GC gcImage = new GC((Drawable)image);
            gcImage.setForeground(Colors.grey);
            gcImage.drawRectangle(0, 0, x1 + 1, y1 + 1);
            int blocksPerPixel = 0;
            int iPixelsPerBlock = 0;
            int pxRes = 0;
            long pxBlockStep = 0L;
            int factor = 4;
            while (iPixelsPerBlock <= 0) {
                iPixelsPerBlock = (int)((long)(x1 + 1) / (lNumBlocks / (long)(++blocksPerPixel)));
            }
            pxRes = (int)((long)x1 - lNumBlocks / (long)blocksPerPixel * (long)iPixelsPerBlock);
            if (pxRes <= 0) {
                pxRes = 1;
            }
            if ((addBlocks = lNumBlocks * (long)factor / (pxBlockStep = lNumBlocks * (long)factor / (long)pxRes)) * (long)iPixelsPerBlock > (long)pxRes) {
                ++pxBlockStep;
            }
            TOTorrent torrent = pePiece.getManager().getDiskManager().getTorrent();
            boolean[] written = pePiece.getDMPiece().getWritten();
            boolean piece_written = pePiece.isWritten();
            int drawnWidth = 0;
            int blockStep = 0;
            int i = 0;
            while ((long)i < lNumBlocks) {
                long bytes;
                int nextWidth = iPixelsPerBlock;
                if ((long)(blockStep += blocksPerPixel * factor) >= pxBlockStep) {
                    nextWidth += (int)((long)blockStep / pxBlockStep);
                    blockStep = (int)((long)blockStep - pxBlockStep);
                }
                if ((long)i >= lNumBlocks - (long)blocksPerPixel) {
                    nextWidth = x1 - drawnWidth;
                }
                Color color = Colors.white;
                if (written == null && piece_written || written != null && written[i]) {
                    color = colors[1];
                } else if (pePiece.isDownloaded(i)) {
                    color = colors[2];
                } else if (pePiece.isRequested(i)) {
                    color = colors[0];
                }
                gcImage.setBackground(color);
                gcImage.fillRectangle(drawnWidth + 1, 1, nextWidth, y1);
                int pieceNumber = pePiece.getPieceNumber();
                int length = pePiece.getBlockSize(i);
                int offset = 16384 * i;
                long l = bytes = this.cacheStats == null ? 0L : this.cacheStats.getBytesInCache(torrent, pieceNumber, offset, length);
                if (bytes == (long)length) {
                    gcImage.setBackground(colors[3]);
                    gcImage.fillRectangle(drawnWidth + 1, 1, nextWidth, 3);
                }
                drawnWidth += nextWidth;
                i += blocksPerPixel;
            }
            gcImage.dispose();
            Image oldImage = ((TableCellCore)cell).getGraphicSWT();
            ((TableCellCore)cell).setGraphic(image);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
            gcImage.dispose();
        }
    }
}

