/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.File;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Utils;

public class ManagerUtils {
    public static void run(DownloadManager dm) {
        if (dm != null) {
            Program.launch((String)dm.getSaveLocation().toString());
        }
    }

    public static void open(DownloadManager dm) {
        if (dm != null) {
            ManagerUtils.open(dm.getSaveLocation());
        }
    }

    public static void open(File f) {
        while (f != null && !f.exists()) {
            f = f.getParentFile();
        }
        if (f == null) {
            return;
        }
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            try {
                PlatformManagerFactory.getPlatformManager().showFile(f.toString());
                return;
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
        if (f.isDirectory()) {
            Program.launch((String)f.toString());
        } else {
            Program.launch((String)f.getParent().toString());
        }
    }

    public static boolean isStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70;
    }

    public static boolean isStopable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65;
    }

    public static boolean isStopped(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 100;
    }

    public static boolean isForceStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 75 || state == 60 || state == 50;
    }

    public static void host(AzureusCore azureus_core, DownloadManager dm, Composite panel) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                azureus_core.getTrackerHost().hostTorrent(torrent, true, false);
            }
            catch (TRHostException e) {
                MessageBox mb = new MessageBox(panel.getShell(), 33);
                mb.setText(MessageText.getString("MyTorrentsView.menu.host.error.title"));
                mb.setMessage(MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
                mb.open();
            }
        }
    }

    public static void publish(AzureusCore azureus_core, DownloadManager dm, Composite panel) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                azureus_core.getTrackerHost().publishTorrent(torrent);
            }
            catch (TRHostException e) {
                MessageBox mb = new MessageBox(panel.getShell(), 33);
                mb.setText(MessageText.getString("MyTorrentsView.menu.host.error.title"));
                mb.setMessage(MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
                mb.open();
            }
        }
    }

    public static void start(DownloadManager dm) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateWaiting();
        }
    }

    public static void queue(DownloadManager dm, Composite panel) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateQueued();
        }
    }

    public static void stop(DownloadManager dm, Composite panel) {
        ManagerUtils.stop(dm, panel, 70);
    }

    public static void stop(DownloadManager dm, Composite panel, int stateAfterStopped) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65 || state == stateAfterStopped) {
            return;
        }
        boolean stopme = true;
        if (state == 60) {
            if (dm.getStats().getShareRatio() >= 0 && dm.getStats().getShareRatio() < 1000 && COConfigurationManager.getBooleanParameter("Alert on close", true)) {
                MessageBox mb = new MessageBox(panel.getShell(), 200);
                mb.setText(MessageText.getString("seedmore.title"));
                mb.setMessage(MessageText.getString("seedmore.shareratio") + dm.getStats().getShareRatio() / 10 + "%.\n" + MessageText.getString("seedmore.uploadmore"));
                int action = mb.open();
                stopme = action == 64;
            } else if (dm.getDownloadState().isOurContent() && dm.getStats().getAvailability() < 2.0f) {
                TRTrackerScraperResponse scrape = dm.getTrackerScrapeResponse();
                int numSeeds = scrape.getSeeds();
                long seedingStartedOn = dm.getStats().getTimeStartedSeeding();
                if (numSeeds > 0 && seedingStartedOn > 0L && scrape.getScrapeStartTime() > seedingStartedOn) {
                    --numSeeds;
                }
                if (numSeeds == 0) {
                    int result = Utils.openMessageBox(panel.getShell(), 192, "Content.alert.notuploaded", new String[]{dm.getDisplayName(), MessageText.getString("Content.alert.notuploaded.stop")});
                    boolean bl = stopme = result == 64;
                }
            }
        }
        if (stopme) {
            ManagerUtils.asyncStop(dm, stateAfterStopped);
        }
    }

    public static void asyncStop(final DownloadManager dm, final int stateAfterStopped) {
        new AEThread("asyncStop", true){

            public void runSupport() {
                dm.stopIt(stateAfterStopped, false, false);
            }
        }.start();
    }

    public static void asyncStopAll() {
        new AEThread("asyncStopAll", true){

            public void runSupport() {
                AzureusCoreFactory.getSingleton().getGlobalManager().stopAllDownloads();
            }
        }.start();
    }

    public static void asyncPause() {
        new AEThread("asyncPause", true){

            public void runSupport() {
                AzureusCoreFactory.getSingleton().getGlobalManager().pauseDownloads();
            }
        }.start();
    }
}

