/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FilenameFilter;
import org.pf.file.ExtendedFileFilter;
import org.pf.file.FileHandler;
import org.pf.text.StringUtil;

public class FileWalker {
    public static final char PATTERN_SEPARATOR_CHAR = ';';
    public static final String PATTERN_SEPARATOR = ";";
    private FileHandler fileHandler = null;
    private boolean goOn = true;
    private Character digitWildcard = null;

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    protected void setFileHandler(FileHandler newValue) {
        this.fileHandler = newValue;
    }

    protected boolean getGoOn() {
        return this.goOn;
    }

    protected void setGoOn(boolean newValue) {
        this.goOn = newValue;
    }

    protected Character getDigitWildcard() {
        return this.digitWildcard;
    }

    protected void setDigitWildcard(Character newValue) {
        this.digitWildcard = newValue;
    }

    public FileWalker(FileHandler handler) {
        this.setFileHandler(handler);
    }

    public FileWalker(FileHandler handler, char digitWildcard) {
        this(handler);
        this.setDigitWildcardChar(digitWildcard);
    }

    public long walkThrough(String dir, String pattern, boolean recursive) {
        ExtendedFileFilter filter = null;
        String[] patterns = null;
        this.setGoOn(true);
        filter = new ExtendedFileFilter();
        patterns = this.extractPatterns(pattern);
        for (int i = 0; i < patterns.length; ++i) {
            String strPattern = patterns[i];
            if (this.hasDigitWildcard()) {
                filter.addPattern(strPattern, true, this.getDigitWildcardChar());
                continue;
            }
            filter.addPattern(strPattern, true);
        }
        if (recursive) {
            filter.alwaysIncludeDirectories();
        } else {
            filter.alwaysExcludeDirectories();
        }
        return this.walkThrough(dir, filter, recursive);
    }

    public void setDigitWildcardChar(char digitWildcard) {
        if (digitWildcard <= '\u0000') {
            this.setDigitWildcard(null);
        } else {
            this.setDigitWildcard(new Character(digitWildcard));
        }
    }

    protected long walkThrough(String dir, FilenameFilter filter, boolean recursive) {
        long counter = 0L;
        File directory = null;
        File file = null;
        File[] files = null;
        int index = 0;
        directory = new File(dir);
        files = directory.listFiles(filter);
        if (files == null) {
            return counter;
        }
        this.setGoOn(this.getFileHandler().directoryStart(directory, files.length));
        if (!this.getGoOn()) {
            return counter;
        }
        for (index = 0; index < files.length; ++index) {
            file = files[index];
            if (file.isDirectory()) {
                if (recursive) {
                    counter += this.walkThrough(file.getPath(), filter, recursive);
                }
            } else {
                this.setGoOn(this.getFileHandler().handleFile(file));
                ++counter;
            }
            if (!this.getGoOn()) break;
        }
        this.setGoOn(this.getFileHandler().directoryEnd(directory));
        return counter;
    }

    protected String[] extractPatterns(String pattern) {
        return StringUtil.current().parts(pattern, PATTERN_SEPARATOR);
    }

    protected char getDigitWildcardChar() {
        if (this.hasDigitWildcard()) {
            return this.getDigitWildcard().charValue();
        }
        return '\u0000';
    }

    protected boolean hasDigitWildcard() {
        return this.getDigitWildcard() != null;
    }
}

