; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#ifndef AppVersion
  #define AppVersion GetFileVersion(SourcePath+'..\..\transgui.exe')
  #define AppVersion Copy(AppVersion, 1, RPos('.', AppVersion) - 1)
  #define tmpvar Copy(AppVersion, RPos('.', AppVersion) + 1, 3)
  #if tmpvar == "0"
    #define AppVersion Copy(AppVersion, 1, RPos('.', AppVersion) - 1)
  #endif
  #undef tmpvar
;  #define AppVersion AppVersion+'-beta'
#endif

#define MyAppName "Transmission Remote GUI"
#define MyAppVerName MyAppName + " " + AppVersion
#define MyAppPublisher "Yury Sidorov"
#define MyAppURL "http://code.google.com/p/transmisson-remote-gui/"
#define MyAppExeName "transgui.exe"

[Setup]
AppId=transgui
AppName={#MyAppName}
AppVerName={#MyAppVerName}
AppCopyright=Copyright (c) 2008-2010 by Yury Sidorov
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}

VersionInfoVersion={#GetFileVersion(SourcePath+'..\units\transgui.exe')}
VersionInfoTextVersion={#GetFileVersion(SourcePath+'..\units\transgui.exe')}

DefaultDirName={pf}\{#MyAppName}
DefaultGroupName={#MyAppName}
AllowNoIcons=yes
LicenseFile=..\..\LICENSE.txt
InfoAfterFile=..\..\history.txt
OutputDir=..\..\Release
OutputBaseFilename=transgui-{#AppVersion}-setup

Compression=lzma/max
InternalCompressLevel=max
SolidCompression=no

PrivilegesRequired=poweruser
ChangesAssociations=yes

WizardImageFile=compiler:\WizModernImage-IS.bmp
WizardSmallImageFile=compiler:\WizModernSmallImage-IS.bmp

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Types]
Name: "full"; Description: "Full installation"
Name: "compact"; Description: "Compact installation"
Name: "custom"; Description: "Custom installation"; Flags: iscustom

[Components]
Name: "app"; Description: "Main application files"; Types: full compact custom; Flags: fixed
Name: "lang"; Description: "Language files"; Types: full custom

[Tasks]
Name: regfileext; Description: "{cm:AssocFileExtension,{#MyAppName},.torrent}"; Flags: unchecked
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "..\..\transgui.exe"; DestDir: "{app}"; Flags: ignoreversion; Components: app
Source: "..\..\LICENSE.txt"; DestDir: "{app}"; Flags: ignoreversion; Components: app
Source: "..\..\readme.txt"; DestDir: "{app}"; Flags: ignoreversion; Components: app
Source: "..\..\history.txt"; DestDir: "{app}"; Flags: ignoreversion; Components: app
Source: "..\..\lang\transgui.*"; DestDir: "{app}\lang"; Flags: ignoreversion; Components: lang

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"
Name: "{group}\History"; Filename: "{app}\history.txt"
Name: "{group}\Read me"; Filename: "{app}\readme.txt"
Name: "{group}\License"; Filename: "{app}\LICENSE.txt"
Name: "{group}\Home page"; Filename: "{#MyAppURL}"
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: quicklaunchicon

[Registry]
Root: HKCU; Subkey: "Software\Classes\.torrent"; ValueType: string; ValueName: ""; ValueData: "{#MyAppName}"; Flags: uninsdeletevalue; Tasks: regfileext
Root: HKCU; Subkey: "Software\Classes\{#MyAppName}\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MyAppExeName}"",0"; Flags: uninsdeletevalue; Tasks: regfileext
Root: HKCU; Subkey: "Software\Classes\{#MyAppName}\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MyAppExeName}"" ""%1"""; Flags: uninsdeletevalue; Tasks: regfileext

[Run]
Filename: "{app}\{#MyAppExeName}"; Description: "{cm:LaunchProgram,{#MyAppName}}"; Flags: nowait postinstall skipifsilent

[UninstallDelete]
Type: filesandordirs ; Name: "{localappdata}\{#MyAppName}"

