#ifndef OPCODE
#error "You must define OPCODE macro before include this file"
#endif

OPCODE(BOR,     "|",                    Assign)
OPCODE(BXOR,    "^",                    Assign)
OPCODE(BAND,    "&",                    Assign)
OPCODE(LSH,     "<<",                   Assign)
OPCODE(RSH,     ">>",                   Assign)
OPCODE(ADD,     "+",                    Assign)
OPCODE(SUB,     "-",                    Assign)
OPCODE(MUL,     "*",                    Assign)
OPCODE(DIV,     "/",                    Assign)
OPCODE(MOD,     "%",                    Assign)
OPCODE(NEG,     "-",                    Assign)
OPCODE(BCOM,    "~",                    Assign)
OPCODE(JZ,      "",                     Branch)
OPCODE(JNZ,     "!",                    Branch)
OPCODE(JE,      "==",                   Branch)
OPCODE(JNE,     "!=",                   Branch)
OPCODE(JG,      ">",                    Branch)
OPCODE(JL,      "<",                    Branch)
OPCODE(JGE,     ">=",                   Branch)
OPCODE(JLE,     "<=",                   Branch)
OPCODE(JMP,     "jmp",                  Jump)
OPCODE(IJMP,    "ijmp",                 IndirectJump)
OPCODE(INC,     "++",                   Inc)
OPCODE(DEC,     "--",                   Dec)
OPCODE(ADDR,    "&",                    Address)
OPCODE(DEREF,   "*",                    Deref)
OPCODE(EXTI1,   "(int)(char)",          Cast)
OPCODE(EXTU1,   "(int)(unsigned char)", Cast)
OPCODE(EXTI2,   "(int)(short)",         Cast)
OPCODE(EXTU2,   "(int)(unsigned short)",Cast)
OPCODE(TRUI1,   "(char)(int)",          Cast)
OPCODE(TRUI2,   "(short)(int)",         Cast)
OPCODE(CVTI4F4, "(float)(int)",         Cast)
OPCODE(CVTI4F8, "(double)(int)",        Cast)
OPCODE(CVTU4F4, "(float)(unsigned)",    Cast)
OPCODE(CVTU4F8, "(double)(unsigned)",   Cast)
OPCODE(CVTF4,   "(double)(float)",      Cast)
OPCODE(CVTF4I4, "(int)(float)",         Cast)
OPCODE(CVTF4U4, "(unsigned)(float)",    Cast)
OPCODE(CVTF8,   "(float)(double)",      Cast)
OPCODE(CVTF8I4, "(int)(double)",        Cast)
OPCODE(CVTF8U4, "(unsigned)(double)",   Cast)
OPCODE(MOV,     "=",                    Move)
OPCODE(IMOV,    "*=",                   IndirectMove)
OPCODE(CALL,    "call",                 Call)
OPCODE(RET,     "ret",                  Return)
OPCODE(CLR,     "",                     Clear)
OPCODE(NOP,     "NOP",                  NOP)

