#ifndef _VSTRIP_H_INCLUDED

/*************************************************************************
vStrip: Parses VOB- and IFO-Files and extracts data from them.
Copyright (C) 1999-2002 [maven] (maven@maven.de)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*************************************************************************/

#define _VSTRIP_H_INCLUDED

//#define vs_DECRYPT

#define vs_STDERR stdout
#define vs_STDOUT stdout

#include <stdio.h>
#include "s_types.h"
#include "file_io.h"
#include "in_buffer.h"
#include "aspi.h"

#ifdef __UNIX__
#define stricmp(a, b) strcasecmp(a, b)
#endif

#define SEQUENCE_HEADER_CODE 0x000001b3
#define PICTURE_START_CODE 0x00000100
#define PICTURE_EXTENSION_START_CODE 0x000001b5
#define PICTURE_CODING_EXTENSION_ID 8
#define PICTURE_I_TYPE 1
#define PICTURE_P_TYPE 2
#define PICTURE_B_TYPE 3
#define PICTURE_TOP_FIELD 1
#define PICTURE_BOTTOM_FIELD 2
#define PICTURE_FRAME_PICTURE 3
#define MPEG_PROGRAM_END_CODE 0x000001b9
#define PACK_START_CODE 0x000001ba
#define SYSTEM_HEADER_START_CODE 0x000001bb
#define PACKET_START_CODE_PREFIX 0x000001

#define SUBSTREAM_AC3 0x80
#define MAX_SUBSTREAM_AC3 0x87

#define SUBSTREAM_PCM 0xa0
#define MAX_SUBSTREAM_PCM 0xa7

#define AUDIO_STREAM 0xc0
#define MAX_AUDIO_STREAM 0xc7

#define VIDEO_STREAM 0xe0
#define MAX_VIDEO_STREAM 0xe7

#define PROGRAM_STREAM_MAP 0xbc
#define PRIVATE_STREAM_1 0xbd
#define PADDING_STREAM 0xbe
#define PRIVATE_STREAM_2 0xbf
#define ECM_STREAM 0xf0
#define EMM_STREAM 0xf1
#define PROGRAM_STREAM_DIRECTORY 0xff
#define DSMCC_STREAM 0xf2
#define ITUTRECH222TYPEE_STREAM 0xf8

#define MAX_FRAMERATE 8
#define MAX_ASPECTRATIO 4
#define MAX_VOBIDS 256
#define MAX_CELLIDS 256

#define vs_MACROVISION_BITS 0x80

#define CSS_OFFSET 0x80

#ifdef vs_DECRYPT
#define	CSS_BYTES_NEEDED 10
#define CSS_MAX_ASSUME_PADDING (fio_SECTOR_SIZE - CSS_OFFSET)
#define CSS_MIN_GUESS_REPEAT 2
#define CSS_MIN_GUESS_LENGTH 16
#define CSS_MIN_GUESS_PERIOD 2
#define CSS_MAX_GUESS_PERIOD 64

typedef union
{
	dword d;
	byte b[4];
} t_vs_key_union;

typedef struct
{
	t_vs_key_union	key;
	dword	found;
	void	*next;
} t_vs_4key, *tp_vs_4key;

typedef struct
{
	// input
	dword	same_guess;	// number of guesses of the same key to consider the percentage
	dword	pad_guess;	// how much correct guesses we give for a padding-stream guess
	dword	pc_guess;	// percentage our candidate key has to be of all the keys that we found
	// output
	dword	total_keys;	// total number of keys found
	tp_vs_4key	*keys;	// if != NULL, pointer to 256 tp_vs_4keys linked list (index represents 1st byte)
	tp_vs_4key	key;	// != if found (to key that first fullfilled above conditions)
	byte	k0;	// idx into keys of result key
} t_vs_keysearch, *tp_vs_keysearch;

#endif

typedef enum
{
	vs_PRINT_SUMMARY = 1, vs_PRINT_INFO = 2, vs_PRINT_ERROR = 4,
	vs_IGNORE_UNKNOWN_CELLS = 8, vs_NO_VOB = 16, vs_DEMACRO = 32,
#ifdef aspi_USE_ASPI
	vs_USE_ASPI = 64, vs_PREFER_ASPI = 128, vs_SUPPORT_1GB = 256,
#endif
#ifdef vs_DECRYPT
	vs_DONT_CRACK = 512, vs_CRACK_EACH_VOB_ID = 1024, vs_CRACK_EACH_CELL_ID = 2048,
#endif
	vs_FORCE_DWORD = -1
} t_vs_flags;

typedef enum
{
	vso_APPEND = 1, vso_SPLIT_VOBID = 2, vso_SPLIT_CELLID = 4, vso_DEMUX = 8,
	vso_KEEP_AC3_IDENT_BYTES = 16, vso_KEEP_PCM_IDENT_BYTES = 32, vso_ONLY_KEEP_GOPS = 64,
	vso_DVD2AVI = 128,
	vso_FORCE_DWORD = -1
} t_vs_outputflags;

typedef enum
{
	vse_OK = 0, vse_DONE = 1, vse_USER_FUNC_EXIT = 2, vse_INIT_FAILED = 3, vse_CANT_OPEN_INPUT = 4,
	vse_CANT_CREATE_OUTPUT = 5, vse_CANT_WRITE_OUTPUT = 6, vse_CANT_CRACK = 7, vse_LOST_SYNC = 8,
	vse_FORCE_DWORD = -1
} t_vs_errorcode;

typedef enum
{
	vsv_NONE = 0, vsv_DECRYPT = 1,
	vsv_FORCE_DWORD = -1
} t_vs_versionflags;

// -----------------------------------------------------------------------------

typedef struct
{
	bool	opened;
#ifdef vs_DECRYPT
	bool	valid_key;
	byte	key[5];
#endif
} t_vs_vobcellinfo, *tp_vobcellinfo;

typedef struct
{
	dword	start_lba, end_lba;
	word	vob_id;
	byte	cell_id;
	byte	angle;
	byte	chapter;
	byte	time[4];	// hour, minute, second, frame (not BCD!)
} t_vs_vobcellid, *tp_vs_vobcellid;

// -----------------------------------------------------------------------------

typedef struct
{
	char	outfile[256];	// can be ""
	dword	split_output;	// autosplits output after x sectors (0 ^= no splitting)
	t_vs_outputflags	flags;
} t_vs_output_data;

typedef struct
{
	dword	stream_id;	// valid if > 0
	dword	substream_id;	// valid if stream_id == PRIVATE_STREAM_1
	dword	vob_id;	// valid if != -1
	dword	cell_id;	// valid if != -1
	dword	lba;	// logical block address (relative to 1st file (or offset from there))
	dword	out_lba; // for the current output-file
	dword	out_file_num; // index of the current file
	t_vs_output_data* out_flags;
	dword	idx;	// offset from the beginning of the sector
	dword	length;	// length of this chunk
	bool	encrypted;	// are we encrypted?
} t_vs_streaminfo, *tp_vs_streaminfo;

typedef bool (*tp_vstrip_stream_func) (byte *data, tp_vs_streaminfo const si, void *user_data);

typedef struct
{
	tp_vstrip_stream_func	user_func;	// set before calling vs_vstrip
	void	*user_data;	// set before calling vs_vstrip
	dword	packets, bytes;
	double	pts;	// PTS of first occurence (ms)
	byte	remap_to;	// set before calling vs_vstrip
	byte	save;	// represents outputs0-7 (lowest bit ^= output 0)
	bool	found;
} t_vs_streamflags, *tp_vs_streamflags;

typedef struct
{
	char	outfileprep[inb_MAX_OUTPUT][256];
	char	outfileext[inb_MAX_OUTPUT][256];
	tp_inb_buffer	buffer;
	t_vs_streaminfo	sti;
	tp_vs_streamflags	cur_stream;
	dword	framerate, aspectratio;
	dword	pack_packets, system_packets;
	tp_vobcellinfo	opened;
	void	*dvd2avi;
	dword	dvd2avi_idx;
	byte	only_gop_mask;
	bool	did_video_info;	// already printed video-stream info
	bool	save_cell;
	bool	init_ok;
#ifdef vs_DECRYPT
	bool	valid_key, vob_key, cell_key;
#endif
} t_vs_internal_data, *tp_vs_internal_data;

typedef struct
{
	char	*infile;	// better exist (list of strings (\0\0 terminates) if it starts with ':')
	dword	num_outputs;	// 0 -> no output
	t_vs_output_data	outputs[inb_MAX_OUTPUT];
	dword	framerate;	// -1 == don't change
	dword	aspectratio;	// -1 == don't change
	dword	max_sync_bytes;	// max. number of bytes to search for resync
	dword	start_lba;	// start at that lba
	dword	end_lba;	// end at his lba, 0 ^= whole file
	t_vs_flags	flags;	// user_func is only called if vs_DEMUX is set
#ifdef vs_DECRYPT
	dword	same_guess;	// number of guesses of the same key to consider the percentage
	dword	pad_guess;	// how much correct guesses we give for a padding-stream guess
	dword	pc_guess;	// percentage our candidate key has to be of all the keys that we found
	byte	key[5];	// all 0 or key for css
#endif
	t_vs_internal_data	_in;	// data that vstrip needs between calls
} t_vs_data, *tp_vs_data;

// -----------------------------------------------------------------------------

// bits 24-31: major version, bits 16-23: minor version, bits 8-15: revision (ascii), bits 0-7: build
VSTRIP_DLL_API dword VSTRIP_DLL_CC vs_get_version(t_vs_versionflags* flags);
VSTRIP_DLL_API const char* VSTRIP_DLL_CC vs_get_author(void);
VSTRIP_DLL_API const char* VSTRIP_DLL_CC vs_get_stream_name(const dword id);
VSTRIP_DLL_API const char* VSTRIP_DLL_CC vs_get_framerate(const dword id);
VSTRIP_DLL_API const char* VSTRIP_DLL_CC vs_get_aspectratio(const dword id);
VSTRIP_DLL_API const char* VSTRIP_DLL_CC vs_get_time(const double time);
VSTRIP_DLL_API t_vs_errorcode VSTRIP_DLL_CC vs_init(tp_vs_data vsd, t_vs_streamflags streams[256], t_vs_streamflags substreams[256]);
VSTRIP_DLL_API t_vs_errorcode VSTRIP_DLL_CC vs_strip_one_block(tp_vs_data vsd, t_vs_streamflags streams[256], t_vs_streamflags substreams[256], dword num_idl, tp_vs_vobcellid idl);
VSTRIP_DLL_API t_vs_errorcode VSTRIP_DLL_CC vs_strip(tp_vs_data vsd, t_vs_streamflags streams[256], t_vs_streamflags substreams[256], dword num_idl, tp_vs_vobcellid idl);
VSTRIP_DLL_API t_vs_errorcode VSTRIP_DLL_CC vs_done(tp_vs_data vsd, t_vs_streamflags streams[256], t_vs_streamflags substreams[256]);

#endif
