/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher.solaris;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.providers.Notifier;

public final class FAMNotifier
extends Notifier<Integer> {
    private final FAMLibrary.FAMConnection conn;
    private final FAMLibrary lib;
    private final Map<Integer, String> map = Collections.synchronizedMap(new HashMap());
    private final BlockingQueue<String> events = new LinkedBlockingQueue<String>();
    private final Thread eventReader;
    private volatile boolean stopped = false;
    private static int ACTIVE_REQUESTS_LIMIT = 100;
    private final Set<Integer> activeRequests = Collections.synchronizedSet(new HashSet());
    private static final Logger LOG = Logger.getLogger(FAMNotifier.class.getName());

    public FAMNotifier() {
        FAMLibrary library;
        if (!Boolean.getBoolean("org.netbeans.modules.masterfs.watcher.FAM")) {
            this.conn = null;
            this.lib = null;
            this.eventReader = null;
            return;
        }
        try {
            library = (FAMLibrary)Native.loadLibrary((String)"gamin-1", FAMLibrary.class);
        }
        catch (LinkageError x) {
            library = (FAMLibrary)Native.loadLibrary((String)"fam", FAMLibrary.class);
        }
        this.lib = library;
        this.conn = new FAMLibrary.FAMConnection();
        this.eventReader = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!FAMNotifier.this.stopped) {
                    while (FAMNotifier.this.lib.FAMPending(FAMNotifier.this.conn) > 0) {
                        String path;
                        FAMLibrary.FAMEvent evt = new FAMLibrary.FAMEvent();
                        if (FAMNotifier.this.lib.FAMNextEvent(FAMNotifier.this.conn, evt) == -1) continue;
                        if (evt.code == 9 || evt.code == 7) {
                            Set set = FAMNotifier.this.activeRequests;
                            synchronized (set) {
                                FAMNotifier.this.activeRequests.remove(evt.fr.reqnum);
                                FAMNotifier.this.activeRequests.notifyAll();
                            }
                        }
                        if ((path = (String)FAMNotifier.this.map.get(evt.fr.reqnum)) == null) continue;
                        FAMNotifier.this.events.add(path);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "FAM events reader");
    }

    public Integer addWatch(String path) throws IOException {
        this.startRequest();
        FAMLibrary.FAMRequest request = new FAMLibrary.FAMRequest();
        this.lib.FAMMonitorDirectory(this.conn, path, request, null);
        LOG.log(Level.FINEST, "addWatch {0}({1}), queue length: {2}", new Object[]{path, request.reqnum, this.activeRequests.size()});
        this.activeRequests.add(request.reqnum);
        this.map.put(request.reqnum, path);
        return request.reqnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRequest() {
        Set<Integer> set = this.activeRequests;
        synchronized (set) {
            while (this.activeRequests.size() > ACTIVE_REQUESTS_LIMIT) {
                long start = System.currentTimeMillis();
                try {
                    this.activeRequests.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                LOG.warning("Blocking FAM requests for " + (System.currentTimeMillis() - start) + "ms, requests queue is full");
            }
        }
    }

    public String nextEvent() throws IOException, InterruptedException {
        return this.events.take();
    }

    public void removeWatch(Integer key) throws IOException {
        LOG.log(Level.FINEST, "removeWatch {0}({1}), queue length: {2}", new Object[]{this.map.get(key), key, this.activeRequests.size()});
        this.startRequest();
        this.activeRequests.add(key);
        this.lib.FAMCancelMonitor(this.conn, new FAMLibrary.FAMRequest(key));
        this.map.remove(key);
    }

    protected void start() throws IOException {
        if (this.lib == null || this.lib.FAMOpen(this.conn) != 0) {
            throw new IOException();
        }
        this.eventReader.start();
    }

    protected void stop() throws IOException {
        this.stopped = true;
        try {
            this.eventReader.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.lib.FAMClose(this.conn);
    }

    static interface FAMLibrary
    extends Library {
        public static final int PATH_MAX = 1024;
        public static final int FAMChanged = 1;
        public static final int FAMDeleted = 2;
        public static final int FAMStartExecuting = 3;
        public static final int FAMStopExecuting = 4;
        public static final int FAMCreated = 5;
        public static final int FAMMoved = 6;
        public static final int FAMAcknowledge = 7;
        public static final int FAMExists = 8;
        public static final int FAMEndExist = 9;

        public int FAMOpen(FAMConnection var1);

        public int FAMClose(FAMConnection var1);

        public int FAMMonitorDirectory(FAMConnection var1, String var2, FAMRequest var3, Pointer var4);

        public int FAMCancelMonitor(FAMConnection var1, FAMRequest var2);

        public int FAMPending(FAMConnection var1);

        public int FAMNextEvent(FAMConnection var1, FAMEvent var2);

        public static class FAMEvent
        extends Structure {
            public FAMConnection.Reference fc;
            public FAMRequest fr;
            public String hostname;
            public byte[] filename = new byte[1024];
            public Pointer userdata;
            public int code;
        }

        public static class FAMRequest
        extends Structure {
            public int reqnum;

            public FAMRequest() {
            }

            public FAMRequest(int reqnum) {
                this.reqnum = reqnum;
            }
        }

        public static class FAMConnection
        extends Structure {
            public int fd;
            public Pointer client;

            public static class Reference
            extends FAMConnection
            implements Structure.ByReference {
            }
        }
    }
}

