/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.ClassLoaderFieldValue;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofFieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LoadClass;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.PrimitiveArrayDump;
import org.netbeans.lib.profiler.heap.TagBounds;

class ClassDump
extends HprofObject
implements JavaClass {
    private static final boolean DEBUG = false;
    final ClassDumpSegment classDumpSegment;
    private int instances;
    private long loadClassOffset;

    ClassDump(ClassDumpSegment segment, long offset) {
        super(offset);
        this.classDumpSegment = segment;
        assert (this.getHprofBuffer().get(offset) == 32);
    }

    @Override
    public long getAllInstancesSize() {
        if (this.isArray()) {
            return (Long)this.classDumpSegment.arrayMap.get(this);
        }
        return (long)this.getInstancesCount() * (long)this.getInstanceSize();
    }

    @Override
    public boolean isArray() {
        return this.classDumpSegment.arrayMap.get(this) != null;
    }

    @Override
    public Instance getClassLoader() {
        return this.getHprof().getInstanceByID(this.getClassLoaderId());
    }

    public Field getField(String name) {
        for (Field field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public List getFields() {
        List filedsList = (List)this.classDumpSegment.fieldsCache.get(this);
        if (filedsList == null) {
            filedsList = this.computeFields();
            this.classDumpSegment.fieldsCache.put(this, filedsList);
        }
        return filedsList;
    }

    @Override
    public int getInstanceSize() {
        if (this.isArray()) {
            return -1;
        }
        return this.classDumpSegment.getMinimumInstanceSize() + this.getHprofBuffer().getInt(this.fileOffset + (long)this.classDumpSegment.instanceSizeOffset);
    }

    @Override
    public List getInstances() {
        int instancesCount = this.getInstancesCount();
        if (instancesCount == 0) {
            return Collections.EMPTY_LIST;
        }
        long classId = this.getJavaClassId();
        HprofHeap heap = this.getHprof();
        HprofByteBuffer dumpBuffer = this.getHprofBuffer();
        int idSize = dumpBuffer.getIDSize();
        ArrayList<InstanceDump> instances = new ArrayList<InstanceDump>(instancesCount);
        TagBounds allInstanceDumpBounds = heap.getAllInstanceDumpBounds();
        long[] offset = new long[]{allInstanceDumpBounds.startOffset};
        while (offset[0] < allInstanceDumpBounds.endOffset) {
            InstanceDump instance;
            long start = offset[0];
            int classIdOffset = 0;
            long instanceClassId = 0L;
            int tag = heap.readDumpTag(offset);
            if (tag == 33) {
                classIdOffset = idSize + 4;
            } else if (tag == 34) {
                classIdOffset = idSize + 4 + 4;
            } else if (tag == 35) {
                byte type = dumpBuffer.get(start + 1L + (long)idSize + 4L + 4L);
                instanceClassId = this.classDumpSegment.getPrimitiveArrayClass(type).getJavaClassId();
            }
            if (classIdOffset != 0) {
                instanceClassId = dumpBuffer.getID(start + 1L + (long)classIdOffset);
            }
            if (instanceClassId != classId) continue;
            if (tag == 33) {
                instance = new InstanceDump(this, start);
            } else if (tag == 34) {
                instance = new ObjectArrayDump(this, start);
            } else if (tag == 35) {
                instance = new PrimitiveArrayDump(this, start);
            } else {
                throw new IllegalArgumentException("Illegal tag " + tag);
            }
            instances.add(instance);
            if (--instancesCount != 0) continue;
            return instances;
        }
        return instances;
    }

    @Override
    public int getInstancesCount() {
        if (this.instances == 0) {
            this.getHprof().computeInstances();
        }
        return this.instances;
    }

    @Override
    public long getJavaClassId() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classIDOffset);
    }

    @Override
    public String getName() {
        return this.getLoadClass().getName();
    }

    @Override
    public List getStaticFieldValues() {
        return this.getStaticFieldValues(true);
    }

    @Override
    public Collection getSubClasses() {
        List classes = this.classDumpSegment.hprofHeap.getAllClasses();
        ArrayList<JavaClass> subclasses = new ArrayList<JavaClass>(classes.size() / 10);
        HashMap<ClassDump, Boolean> subclassesMap = new HashMap<ClassDump, Boolean>(classes.size() * 4 / 3);
        subclassesMap.put(this, Boolean.TRUE);
        for (int i = 0; i < classes.size(); ++i) {
            JavaClass jcls = (JavaClass)classes.get(i);
            Boolean b = (Boolean)subclassesMap.get(jcls);
            if (b == null) {
                b = ClassDump.isSubClass(jcls, subclassesMap);
            }
            if (!b.booleanValue() || jcls == this) continue;
            subclasses.add(jcls);
        }
        return subclasses;
    }

    @Override
    public JavaClass getSuperClass() {
        long superClassId = this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.superClassIDOffset);
        return this.classDumpSegment.getClassDumpByID(superClassId);
    }

    @Override
    public Object getValueOfStaticField(String name) {
        for (FieldValue fieldValue : this.getStaticFieldValues()) {
            if (!fieldValue.getField().getName().equals(name)) continue;
            if (fieldValue instanceof HprofFieldObjectValue) {
                return ((HprofFieldObjectValue)fieldValue).getInstance();
            }
            return ((HprofFieldValue)fieldValue).getTypeValue();
        }
        return null;
    }

    private List computeFields() {
        HprofByteBuffer buffer = this.getHprofBuffer();
        long offset = this.fileOffset + (long)this.getInstanceFieldOffset();
        int fields = buffer.getShort(offset);
        ArrayList<HprofField> filedsList = new ArrayList<HprofField>(fields);
        for (int i = 0; i < fields; ++i) {
            filedsList.add(new HprofField(this, offset + 2L + (long)(i * this.classDumpSegment.fieldSize)));
        }
        return filedsList;
    }

    List getStaticFieldValues(boolean addClassLoader) {
        HprofByteBuffer buffer = this.getHprofBuffer();
        long offset = this.fileOffset + (long)this.getStaticFieldOffset();
        HprofHeap heap = this.getHprof();
        int fields = buffer.getShort(offset);
        offset += 2L;
        ArrayList<HprofFieldObjectValue> filedsList = new ArrayList<HprofFieldObjectValue>(fields + (addClassLoader ? (short)0 : 1));
        for (int i = 0; i < fields; ++i) {
            byte type = buffer.get(offset + (long)this.classDumpSegment.fieldTypeOffset);
            int fieldSize = this.classDumpSegment.fieldSize + heap.getValueSize(type);
            HprofFieldValue value = type == 2 ? new HprofFieldObjectValue(this, offset) : new HprofFieldValue(this, offset);
            filedsList.add((HprofFieldObjectValue)value);
            offset += (long)fieldSize;
        }
        if (addClassLoader) {
            long classLoaderOffset = this.fileOffset + (long)this.classDumpSegment.classLoaderIDOffset;
            filedsList.add(new ClassLoaderFieldValue(this, classLoaderOffset));
        }
        return filedsList;
    }

    List getAllInstanceFields() {
        ArrayList fields = new ArrayList(50);
        for (JavaClass jcls = this; jcls != null; jcls = jcls.getSuperClass()) {
            fields.addAll(jcls.getFields());
        }
        return fields;
    }

    void setClassLoadOffset(long offset) {
        this.loadClassOffset = offset;
    }

    int getConstantPoolSize() {
        long cpOffset = this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset;
        HprofByteBuffer buffer = this.getHprofBuffer();
        int cpRecords = buffer.getShort(cpOffset);
        HprofHeap heap = this.getHprof();
        cpOffset += 2L;
        for (int i = 0; i < cpRecords; ++i) {
            byte type = buffer.get(cpOffset + 2L);
            int size = heap.getValueSize(type);
            cpOffset += (long)(3 + size);
        }
        return (int)(cpOffset - (this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset));
    }

    HprofHeap getHprof() {
        return this.classDumpSegment.hprofHeap;
    }

    HprofByteBuffer getHprofBuffer() {
        return this.classDumpSegment.hprofHeap.dumpBuffer;
    }

    int getInstanceFieldOffset() {
        int staticFieldOffset = this.getStaticFieldOffset();
        return staticFieldOffset + this.getStaticFiledSize(staticFieldOffset);
    }

    LoadClass getLoadClass() {
        return new LoadClass(this.getHprof().getLoadClassSegment(), this.loadClassOffset);
    }

    long getClassLoaderId() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classLoaderIDOffset);
    }

    List getReferences() {
        return this.getHprof().findReferencesFor(this.getJavaClassId());
    }

    int getStaticFieldOffset() {
        return this.classDumpSegment.constantPoolSizeOffset + this.getConstantPoolSize();
    }

    int getStaticFiledSize(int staticFieldOffset) {
        HprofByteBuffer buffer = this.getHprofBuffer();
        int idSize = buffer.getIDSize();
        long fieldOffset = this.fileOffset + (long)staticFieldOffset;
        int fields = this.getHprofBuffer().getShort(fieldOffset);
        HprofHeap heap = this.getHprof();
        fieldOffset += 2L;
        for (int i = 0; i < fields; ++i) {
            byte type = buffer.get(fieldOffset + (long)idSize);
            int size = heap.getValueSize(type);
            fieldOffset += (long)(idSize + 1 + size);
        }
        return (int)(fieldOffset - (long)staticFieldOffset - this.fileOffset);
    }

    void findStaticReferencesFor(long instanceId, List refs) {
        HprofByteBuffer buffer = this.getHprofBuffer();
        int idSize = buffer.getIDSize();
        long fieldOffset = this.fileOffset + (long)this.getStaticFieldOffset();
        int fields = this.getHprofBuffer().getShort(fieldOffset);
        List staticFileds = null;
        HprofHeap heap = this.getHprof();
        fieldOffset += 2L;
        for (int i = 0; i < fields; ++i) {
            byte type = buffer.get(fieldOffset + (long)idSize);
            int size = heap.getValueSize(type);
            if (type == 2 && instanceId == buffer.getID(fieldOffset + (long)idSize + 1L)) {
                if (staticFileds == null) {
                    staticFileds = this.getStaticFieldValues();
                }
                refs.add(staticFileds.get(i));
            }
            fieldOffset += (long)(idSize + 1 + size);
        }
        if (instanceId == this.getClassLoaderId()) {
            if (staticFileds == null) {
                staticFileds = this.getStaticFieldValues();
            }
            refs.add(staticFileds.get(fields));
        }
    }

    void incrementInstance() {
        ++this.instances;
    }

    private static Boolean isSubClass(JavaClass jcls, Map subclassesMap) {
        Boolean b;
        JavaClass superClass = jcls.getSuperClass();
        if (superClass == null) {
            b = Boolean.FALSE;
        } else {
            b = (Boolean)subclassesMap.get(superClass);
            if (b == null) {
                b = ClassDump.isSubClass(superClass, subclassesMap);
            }
        }
        subclassesMap.put(jcls, b);
        return b;
    }
}

