/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

import org.netbeans.lib.profiler.utils.Wildcards;

public class MethodNameFormatter {
    private static final String BOOLEAN_TEXT = "boolean";
    private static final String CHAR_TEXT = "char";
    private static final String BYTE_TEXT = "byte";
    private static final String SHORT_TEXT = "short";
    private static final String INT_TEXT = "int";
    private static final String LONG_TEXT = "long";
    private static final String FLOAT_TEXT = "float";
    private static final String DOUBLE_TEXT = "double";
    private static final String VOID_TEXT = "void";
    private static final char BOOLEAN_CODE = 'Z';
    private static final char CHAR_CODE = 'C';
    private static final char BYTE_CODE = 'B';
    private static final char SHORT_CODE = 'S';
    private static final char INT_CODE = 'I';
    private static final char LONG_CODE = 'J';
    private static final char FLOAT_CODE = 'F';
    private static final char DOUBLE_CODE = 'D';
    private static final char VOID_CODE = 'V';
    private String className;
    private String methodName;
    private String params;
    private String returnType;

    public MethodNameFormatter(String cname, String mname, String sig) {
        StringBuilder arrayIndicator = new StringBuilder();
        this.className = cname != null ? cname.replace('/', '.') : "<unknown class>";
        if (mname == null) {
            this.params = "";
            this.returnType = "";
        } else {
            this.methodName = "".equals(mname) ? "<init>" : mname;
            if ("<clinit>".equals(this.methodName) || Wildcards.isMethodWildcard(this.methodName)) {
                this.params = "";
                this.returnType = "";
            } else {
                char nextChar;
                int curPos;
                int idx1 = sig.lastIndexOf(41) + 1;
                if (idx1 > 0 && !"<init>".equals(this.methodName)) {
                    this.returnType = sig.substring(idx1);
                    curPos = 0;
                    while (this.returnType.charAt(curPos) == '[') {
                        arrayIndicator.append("[]");
                        ++curPos;
                    }
                    if ((nextChar = this.returnType.charAt(curPos++)) == 'Z') {
                        this.returnType = BOOLEAN_TEXT + arrayIndicator.toString();
                    } else if (nextChar == 'C') {
                        this.returnType = CHAR_TEXT + arrayIndicator.toString();
                    } else if (nextChar == 'B') {
                        this.returnType = BYTE_TEXT + arrayIndicator.toString();
                    } else if (nextChar == 'S') {
                        this.returnType = SHORT_TEXT + arrayIndicator.toString();
                    } else if (nextChar == 'I') {
                        this.returnType = INT_TEXT + arrayIndicator.toString();
                    } else if (nextChar == 'J') {
                        this.returnType = LONG_TEXT + arrayIndicator.toString();
                    } else if (nextChar == 'F') {
                        this.returnType = FLOAT_TEXT + arrayIndicator.toString();
                    } else if (nextChar == 'D') {
                        this.returnType = DOUBLE_TEXT + arrayIndicator.toString();
                    } else if (nextChar == 'V') {
                        this.returnType = VOID_TEXT + arrayIndicator.toString();
                    } else {
                        this.returnType = this.returnType.substring(curPos, this.returnType.length() - 1);
                        if (this.returnType.startsWith("java/lang/") && this.returnType.indexOf(47, 10) == -1) {
                            this.returnType = this.returnType.substring(10);
                        }
                        this.returnType = this.returnType.replace('$', '.');
                        this.returnType = this.returnType.replace('/', '.') + arrayIndicator.toString();
                    }
                } else {
                    this.returnType = "";
                }
                idx1 = sig.indexOf(40) + 1;
                int idx2 = sig.lastIndexOf(41);
                if (idx2 > 0) {
                    String paramsString = sig.substring(idx1, idx2);
                    StringBuilder paramsBuf = new StringBuilder();
                    arrayIndicator.setLength(0);
                    curPos = 0;
                    while (curPos < paramsString.length()) {
                        while (paramsString.charAt(curPos) == '[') {
                            arrayIndicator.append("[]");
                            ++curPos;
                        }
                        if ((nextChar = paramsString.charAt(curPos++)) == 'Z') {
                            paramsBuf.append(BOOLEAN_TEXT);
                        } else if (nextChar == 'C') {
                            paramsBuf.append(CHAR_TEXT);
                        } else if (nextChar == 'B') {
                            paramsBuf.append(BYTE_TEXT);
                        } else if (nextChar == 'S') {
                            paramsBuf.append(SHORT_TEXT);
                        } else if (nextChar == 'I') {
                            paramsBuf.append(INT_TEXT);
                        } else if (nextChar == 'J') {
                            paramsBuf.append(LONG_TEXT);
                        } else if (nextChar == 'F') {
                            paramsBuf.append(FLOAT_TEXT);
                        } else if (nextChar == 'D') {
                            paramsBuf.append(DOUBLE_TEXT);
                        } else {
                            int startPos = curPos;
                            while (paramsString.charAt(curPos) != ';') {
                                ++curPos;
                            }
                            String typeName = paramsString.substring(startPos, curPos);
                            if (typeName.startsWith("java/lang/") && typeName.indexOf(47, 10) == -1) {
                                typeName = typeName.substring(10);
                            }
                            typeName = typeName.replace('$', '.');
                            typeName = typeName.replace('/', '.');
                            paramsBuf.append(typeName);
                            ++curPos;
                        }
                        if (arrayIndicator.length() > 0) {
                            paramsBuf.append(arrayIndicator.toString());
                        }
                        arrayIndicator.setLength(0);
                        if (curPos >= paramsString.length()) continue;
                        paramsBuf.append(", ");
                    }
                    this.params = paramsBuf.toString();
                } else {
                    this.params = "";
                }
            }
        }
    }

    public String getFormattedClass() {
        return this.className;
    }

    public String getFormattedClassAndMethod() {
        if (this.methodName == null) {
            return this.getFormattedClass();
        }
        return this.className + "." + this.getFormattedMethod();
    }

    public String getFormattedMethod() {
        if (this.methodName == null) {
            return "";
        }
        if ("<clinit>".equals(this.methodName)) {
            return this.methodName;
        }
        return this.methodName + "(" + this.getParamsString() + ")";
    }

    public String getFullFormattedClassAndMethod() {
        if (this.methodName == null) {
            return this.getFormattedClass();
        }
        return this.className + "." + this.getFullFormattedMethod();
    }

    public String getFullFormattedMethod() {
        if (this.methodName == null) {
            return "";
        }
        if ("<clinit>".equals(this.methodName)) {
            return this.methodName;
        }
        if ("<init>".equals(this.methodName)) {
            return this.methodName + "(" + this.getParamsString() + ")";
        }
        return this.methodName + "(" + this.getParamsString() + ") : " + this.getReturnType();
    }

    public String getParamsString() {
        return this.params;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String toString() {
        return this.getFullFormattedClassAndMethod();
    }

    private boolean isAllWildCard(String methodName) {
        return methodName.equals("<all>") || methodName.equals("*");
    }
}

