/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ui.BasicAbstractResultsPanel;
import org.netbeans.modules.search.ui.BasicReplaceResultsPanel;
import org.netbeans.modules.search.ui.BasicSearchResultsPanel;
import org.netbeans.spi.search.provider.SearchResultsDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class ResultDisplayer
extends SearchResultsDisplayer<MatchingObject.Def> {
    private ResultModel resultModel;
    private BasicSearchCriteria criteria;
    private BasicComposition composition;
    private BasicAbstractResultsPanel resultPanel;
    private Node infoNode;

    public ResultDisplayer(BasicSearchCriteria criteria, BasicComposition composition) {
        this.criteria = criteria;
        this.resultModel = new ResultModel(criteria, criteria.getReplaceString());
        this.composition = composition;
        this.resultModel.setCommonSearchFolder(CommonSearchRoot.find(composition.getRootFiles()));
    }

    @Override
    public synchronized JComponent getVisualComponent() {
        if (this.resultPanel != null) {
            return this.resultPanel;
        }
        this.resultPanel = this.criteria.isSearchAndReplace() ? new BasicReplaceResultsPanel(this.resultModel, this.composition, this.composition.getRootFiles(), this.infoNode) : new BasicSearchResultsPanel(this.resultModel, this.composition, this.criteria.isFullText(), this.composition.getRootFiles(), this.infoNode);
        this.resultPanel.setToolTipText(this.composition.getScopeDisplayName() + ": " + this.getTitle());
        return this.resultPanel;
    }

    @Override
    public void addMatchingObject(MatchingObject.Def object) {
        if (this.resultModel.objectFound(object.getFileObject(), object.getCharset(), object.getTextDetails())) {
            this.resultPanel.update();
            this.resultPanel.addMatchingObject(this.resultModel.getMatchingObjects().get(this.resultModel.size() - 1));
        }
        if (this.resultModel.wasLimitReached()) {
            this.composition.terminate();
        }
    }

    ResultModel getResultModel() {
        return this.resultModel;
    }

    @Override
    public String getTitle() {
        if (this.criteria.getTextPattern() == null) {
            if (this.criteria.getFileNamePattern() == null) {
                return NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_RESULTS_FOR_FILE_PATTERN");
            }
            return this.criteria.getFileNamePatternExpr();
        }
        return this.criteria.getTextPatternExpr();
    }

    @Override
    public void searchStarted() {
        this.resultModel.setStartTime();
        this.resultPanel.searchStarted();
    }

    @Override
    public void searchFinished() {
        this.resultPanel.searchFinished();
    }

    @Override
    public void setInfoNode(Node infoNode) {
        this.infoNode = infoNode;
    }

    static class CommonSearchRoot {
        private static final int MIN_REL_PATH_LEN = 4;
        private boolean exists = true;
        private List<FileObject> path;
        private FileObject file = null;

        CommonSearchRoot() {
        }

        synchronized void update(FileObject fo) {
            if (this.exists) {
                if (this.exists && this.file == null) {
                    this.initCommonPath(fo);
                } else if (!FileUtil.isParentOf((FileObject)this.file, (FileObject)fo)) {
                    List<FileObject> p = CommonSearchRoot.filePathAsList(fo.getParent());
                    this.path = CommonSearchRoot.findCommonPath(this.path, p);
                    if (this.path.isEmpty()) {
                        this.path = null;
                        this.file = null;
                        this.exists = false;
                    } else {
                        this.file = this.path.get(this.path.size() - 1);
                    }
                }
            }
        }

        static List<FileObject> findCommonPath(List<FileObject> p1, List<FileObject> p2) {
            Iterator<FileObject> i1 = p1.iterator();
            Iterator<FileObject> i2 = p2.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                FileObject fo2;
                FileObject fo1 = i1.next();
                if (fo1.equals(fo2 = i2.next())) continue;
                return p1.subList(0, p1.indexOf(fo1));
            }
            return p1;
        }

        static List<FileObject> filePathAsList(FileObject fo) {
            LinkedList<FileObject> path = new LinkedList<FileObject>();
            for (FileObject p = fo; p != null; p = p.getParent()) {
                path.add(0, p);
            }
            return path;
        }

        private void initCommonPath(FileObject fo) {
            Object p;
            for (p = fo; p != null; p = p.getParent()) {
                FileObject projectParent;
                if (!this.isLikeProjectFolder((FileObject)p) || (projectParent = p.getParent()) == null) continue;
                this.file = projectParent;
                this.path = CommonSearchRoot.filePathAsList(projectParent);
                return;
            }
            p = CommonSearchRoot.filePathAsList(fo);
            if (p.size() > 4) {
                this.path = p.subList(0, p.size() - 4);
                this.file = this.path.get(this.path.size() - 1);
            } else {
                this.exists = false;
            }
        }

        private boolean isLikeProjectFolder(FileObject folder) {
            if (folder.getFileObject("src") != null) {
                return true;
            }
            return folder.getFileObject("nbproject") != null;
        }

        synchronized FileObject getFileObject() {
            if (this.exists) {
                return this.file;
            }
            return null;
        }

        private static FileObject find(List<FileObject> roots) {
            CommonSearchRoot csr = new CommonSearchRoot();
            for (FileObject f : roots) {
                csr.update(f);
            }
            return csr.getFileObject();
        }
    }
}

