/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.CharConversionException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.modules.search.Selectable;
import org.netbeans.modules.search.ui.ReplaceCheckableNode;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;

public final class TextDetail
implements Selectable {
    public static final int DH_SHOW = 1;
    public static final int DH_GOTO = 2;
    public static final int DH_HIDE = 3;
    private DataObject dobj;
    private int line;
    private String lineText;
    private int column;
    private int markLength;
    private Line lineObj;
    private SearchPattern searchPattern;
    private int startOffset;
    private int endOffset;
    private String matchedText;
    private boolean selected = true;
    private String lineNumberIndent = "";
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public TextDetail(DataObject dobj, SearchPattern pattern) {
        this.dobj = dobj;
        this.searchPattern = pattern;
    }

    public void showDetail(int how) {
        JEditorPane[] panes;
        this.prepareLine();
        if (this.lineObj == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (how == 3) {
            return;
        }
        EditorCookie edCookie = (EditorCookie)this.dobj.getLookup().lookup(EditorCookie.class);
        if (edCookie != null) {
            edCookie.open();
        }
        if (how == 1) {
            this.lineObj.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE, this.column - 1);
        } else if (how == 2) {
            this.lineObj.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column - 1);
        }
        if (this.markLength > 0 && edCookie != null && (panes = edCookie.getOpenedPanes()) != null && panes.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Caret caret = panes[0].getCaret();
                    caret.moveDot(caret.getDot() + TextDetail.this.markLength);
                }
            });
        }
        SearchHistory.getDefault().setLastSelected(SearchPattern.create(this.searchPattern.getSearchExpression(), this.searchPattern.isWholeWords(), this.searchPattern.isMatchCase(), this.searchPattern.isRegExp()));
    }

    public String getLineText() {
        return this.lineText;
    }

    public void setLineText(String text) {
        this.lineText = text;
    }

    String getLineTextPart(int beginIndex, int endIndex) {
        return this.lineText.substring(beginIndex, endIndex);
    }

    String getLineTextPart(int beginIndex) {
        return this.lineText.substring(beginIndex);
    }

    public int getLineTextLength() {
        return this.lineText == null ? 0 : this.lineText.length();
    }

    public DataObject getDataObject() {
        return this.dobj;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int col) {
        this.column = col;
    }

    int getColumn0() {
        return this.column - 1;
    }

    public void setMarkLength(int len) {
        this.markLength = len;
    }

    public int getMarkLength() {
        return this.markLength;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public String getMatchedText() {
        return this.matchedText;
    }

    public void setMatchedText(String matchedText) {
        this.matchedText = matchedText;
    }

    public void associate(int lineNumber, int column, String lineText) {
        this.setLine(lineNumber);
        this.setColumn(column);
        this.setLineText(lineText);
    }

    private void prepareLine() {
        LineCookie lineCookie;
        if (this.dobj == null || !this.dobj.isValid()) {
            this.lineObj = null;
        } else if (this.lineObj == null && (lineCookie = (LineCookie)this.dobj.getLookup().lookup(LineCookie.class)) != null) {
            Line.Set lineSet = lineCookie.getLineSet();
            try {
                this.lineObj = lineSet.getOriginal(this.line - 1);
            }
            catch (IndexOutOfBoundsException ioobex) {
                this.lineObj = lineSet.getOriginal(TextDetail.findMaxLine(lineSet));
                this.markLength = 0;
                this.column = 0;
            }
        }
    }

    private static int findMaxLine(Line.Set set) {
        int from = 0;
        int to = 32000;
        try {
            while (true) {
                set.getOriginal(to);
                from = to;
                to *= 2;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            while (from < to) {
                int middle = (from + to + 1) / 2;
                try {
                    set.getOriginal(middle);
                    from = middle;
                }
                catch (IndexOutOfBoundsException ex2) {
                    to = middle - 1;
                }
            }
            return from;
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
            this.fireChange();
        }
    }

    @Override
    public void setSelectedRecursively(boolean selected) {
        this.setSelected(selected);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void fireChange() {
        this.changeSupport.fireChange();
    }

    void setLineNumberIndent(String lineNumberIndent) {
        this.lineNumberIndent = lineNumberIndent;
    }

    private static class GotoDetailAction
    extends AbstractAction {
        private DetailNode detailNode;

        public GotoDetailAction(DetailNode detailNode) {
            super(UiUtils.getText("LBL_GotoDetailAction"));
            this.detailNode = detailNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.detailNode.gotoDetail();
        }
    }

    static final class DetailNode
    extends AbstractNode
    implements OutputListener {
        private static final String ICON = "org/netbeans/modules/search/res/textDetail.png";
        private TextDetail txtDetail;

        public DetailNode(TextDetail txtDetail, boolean replacing) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{txtDetail, new ReplaceCheckableNode(txtDetail, replacing)}));
            this.txtDetail = txtDetail;
            this.setShortDescription(DetailNode.getShortDesc(txtDetail));
            this.setValue("output line", DetailNode.getFullDesc(txtDetail));
            txtDetail.prepareLine();
            txtDetail.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DetailNode.this.fireIconChange();
                    ResultsOutlineSupport.toggleParentSelected((Node)DetailNode.this);
                }
            });
            this.setIconBaseWithExtension(ICON);
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                return new Action[]{this.getPreferredAction()};
            }
            return new Action[0];
        }

        public Action getPreferredAction() {
            return new GotoDetailAction(this);
        }

        public boolean equals(Object anotherObj) {
            return anotherObj != null && anotherObj.getClass() == DetailNode.class && ((DetailNode)((Object)anotherObj)).txtDetail.equals(this.txtDetail);
        }

        public int hashCode() {
            return this.txtDetail.hashCode() + 1;
        }

        public String getName() {
            return this.txtDetail.getLineText() + "      [" + DetailNode.getName(this.txtDetail) + "]";
        }

        public String getHtmlDisplayName() {
            try {
                StringBuffer text = new StringBuffer();
                text.append("<font color='!controlShadow'>");
                text.append(this.txtDetail.lineNumberIndent);
                text.append(this.txtDetail.getLine());
                text.append(": ");
                text.append("</font>");
                if (this.canBeMarked()) {
                    this.appendMarkedText(text);
                } else {
                    text.append(DetailNode.escape(this.txtDetail.getLineText()));
                }
                text.append("      ");
                text.append("<font color='!controlShadow'>[");
                text.append(DetailNode.escape(DetailNode.getLinePos(this.txtDetail)));
                text.append("]");
                return text.toString();
            }
            catch (CharConversionException e) {
                return null;
            }
        }

        private boolean canBeMarked() {
            int col0 = this.txtDetail.getColumn0();
            return this.txtDetail.getMarkLength() > 0 && col0 > -1 && col0 < this.txtDetail.getLineTextLength();
        }

        private void appendMarkedText(StringBuffer text) throws CharConversionException {
            int col0 = this.txtDetail.getColumn0();
            int end = col0 + Math.min(this.txtDetail.getMarkLength(), this.txtDetail.getLineTextLength() - col0);
            int markEnd = col0 + this.txtDetail.getMarkLength();
            int detailLen = this.txtDetail.getLineTextLength();
            text.append(DetailNode.escape(this.txtDetail.getLineTextPart(0, col0)));
            text.append("<b>");
            if (markEnd > detailLen) {
                text.append(DetailNode.escape(this.txtDetail.getLineTextPart(col0, end)));
                text.append(" ...");
            } else {
                text.append(DetailNode.escape(this.txtDetail.getLineTextPart(col0, end)));
            }
            text.append("</b>");
            if (detailLen > end) {
                text.append(DetailNode.escape(this.txtDetail.getLineTextPart(end)));
            }
        }

        private static String escape(String s) throws CharConversionException {
            return XMLUtil.toElementContent((String)s);
        }

        void gotoDetail() {
            this.txtDetail.showDetail(2);
        }

        private void showDetail() {
            this.txtDetail.showDetail(1);
        }

        public void outputLineSelected(OutputEvent evt) {
            this.txtDetail.showDetail(1);
        }

        public void outputLineAction(OutputEvent evt) {
            this.txtDetail.showDetail(2);
        }

        public void outputLineCleared(OutputEvent evt) {
            this.txtDetail.showDetail(3);
        }

        private static String getName(TextDetail det) {
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME1", (Object)Integer.toString(line), (Object)Integer.toString(col));
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME2", (Object)Integer.toString(line));
        }

        private static String getLinePos(TextDetail det) {
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME3", (Object)col);
            }
            return "";
        }

        private static String getShortDesc(TextDetail det) {
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT1", (Object[])new Object[]{Integer.toString(line), Integer.toString(col)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT2", (Object)Integer.toString(line));
        }

        private static String getFullDesc(TextDetail det) {
            String filename = det.getDataObject().getPrimaryFile().getNameExt();
            String lineText = det.getLineText();
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL1", (Object[])new Object[]{lineText, filename, Integer.toString(line), Integer.toString(col)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL2", (Object[])new Object[]{lineText, filename, Integer.toString(line)});
        }

        protected void createPasteTypes(Transferable t, List<PasteType> s) {
        }
    }
}

