/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.api.search.provider.impl.CompoundSearchIterator;
import org.netbeans.api.search.provider.impl.DelegatingSearchInfo;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.filesystems.FileObject;

public class CompoundSearchInfoDefinition
extends SearchInfoDefinition {
    private final SearchInfoDefinition[] elements;

    public CompoundSearchInfoDefinition(SearchInfoDefinition ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        this.elements = elements.length != 0 ? elements : null;
    }

    @Override
    public boolean canSearch() {
        if (this.elements != null) {
            for (SearchInfoDefinition element : this.elements) {
                if (!element.canSearch()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<FileObject> filesToSearch(SearchScopeOptions options, SearchListener listener, AtomicBoolean terminated) {
        if (this.elements == null) {
            return Collections.emptyList().iterator();
        }
        ArrayList<DelegatingSearchInfo> searchableElements = new ArrayList<DelegatingSearchInfo>(this.elements.length);
        for (SearchInfoDefinition element : this.elements) {
            if (!element.canSearch()) continue;
            searchableElements.add(new DelegatingSearchInfo(element));
        }
        return new CompoundSearchIterator(searchableElements.toArray(new SearchInfo[searchableElements.size()]), options, listener, terminated);
    }

    @Override
    public List<SearchRoot> getSearchRoots() {
        LinkedList<SearchRoot> allRoots = new LinkedList<SearchRoot>();
        for (SearchInfoDefinition si : this.elements) {
            allRoots.addAll(si.getSearchRoots());
        }
        return allRoots;
    }
}

