/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import javax.swing.JPanel;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.panels.Bundle;
import org.netbeans.modules.profiler.attach.panels.ReviewSettingsPanelUI;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.openide.util.HelpCtx;

public class ReviewSettingsPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "ReviewSettingsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ReviewSettingsPanel.HelpCtx");
    private Model model = new Model();
    private ReviewSettingsPanelUI panel;

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return true;
    }

    @Override
    public boolean canBack(AttachWizardContext context) {
        return true;
    }

    @Override
    public boolean canFinish(AttachWizardContext context) {
        return true;
    }

    @Override
    public boolean canNext(AttachWizardContext context) {
        return true;
    }

    @Override
    public boolean onCancel(AttachWizardContext context) {
        return true;
    }

    @Override
    public void onEnter(AttachWizardContext context) {
        if (this.getContext().getAttachSettings().isRemote()) {
            this.getContext().setManual(true);
            this.getContext().setAutomatic(false);
        } else {
            if (this.getContext().getIntegrationProvider() != null && this.getContext().getIntegrationProvider().supportsManual()) {
                this.getContext().setAutomatic(false);
            }
            if (this.getContext().getIntegrationProvider() != null && this.getContext().getIntegrationProvider().supportsAutomation()) {
                this.getContext().setManual(false);
            }
        }
        this.getContext().setHideIntegration(true);
    }

    @Override
    public void onExit(AttachWizardContext context) {
        boolean isModified = this.getContext().getAttachSettings().commit();
        if (isModified) {
            this.getContext().setConfigChanged();
        }
        this.getContext().setHideIntegration(false);
    }

    @Override
    public void onFinish(AttachWizardContext context) {
    }

    @Override
    public void onPanelShow() {
        this.model.setSummary(this.buildSummary(this.getContext().getAttachSettings()));
        this.panel.refresh();
    }

    @Override
    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new ReviewSettingsPanelUI(this.model);
        }
        return this.panel;
    }

    private String buildSummary(AttachSettings attachSettings) {
        StringBuilder attachSettingsSummaryBuffer = new StringBuilder();
        attachSettingsSummaryBuffer.append("<b>");
        attachSettingsSummaryBuffer.append(Bundle.AttachWizard_TargetTypeString());
        attachSettingsSummaryBuffer.append("</b> ");
        attachSettingsSummaryBuffer.append(attachSettings.getTargetType());
        attachSettingsSummaryBuffer.append("<br>");
        if (!this.getContext().isProviderSingular()) {
            attachSettingsSummaryBuffer.append("<b>");
            attachSettingsSummaryBuffer.append(Bundle.AttachWizard_TargetNameTypeString());
            attachSettingsSummaryBuffer.append("</b> ");
            attachSettingsSummaryBuffer.append(attachSettings.getServerType());
            attachSettingsSummaryBuffer.append("<br>");
        }
        attachSettingsSummaryBuffer.append("<br>");
        attachSettingsSummaryBuffer.append("<b>");
        attachSettingsSummaryBuffer.append(Bundle.AttachWizard_TargetNameLocationString());
        attachSettingsSummaryBuffer.append("</b> ");
        if (attachSettings.isRemote()) {
            attachSettingsSummaryBuffer.append(Bundle.AttachWizard_RemoteSystemString());
            attachSettingsSummaryBuffer.append("<br>");
            attachSettingsSummaryBuffer.append("<b>");
            attachSettingsSummaryBuffer.append(Bundle.AttachWizard_RemoteSystemHostNameString());
            attachSettingsSummaryBuffer.append("</b> ");
            attachSettingsSummaryBuffer.append(attachSettings.getHost());
            attachSettingsSummaryBuffer.append("<br>");
            attachSettingsSummaryBuffer.append("<b>");
            attachSettingsSummaryBuffer.append(Bundle.AttachWizard_RemoteSystemOsString());
            attachSettingsSummaryBuffer.append("</b> ");
            attachSettingsSummaryBuffer.append(attachSettings.getHostOS());
            attachSettingsSummaryBuffer.append("<br>");
        } else {
            attachSettingsSummaryBuffer.append(Bundle.AttachWizard_LocalMachineString());
            attachSettingsSummaryBuffer.append("<br>");
            attachSettingsSummaryBuffer.append("<b>");
            attachSettingsSummaryBuffer.append(Bundle.AttachWizard_AttachMethodString());
            attachSettingsSummaryBuffer.append("</b> ");
            attachSettingsSummaryBuffer.append(attachSettings.isDirect() ? Bundle.AttachWizard_DirectAttachString() : Bundle.AttachWizard_DynamicAttachString());
            attachSettingsSummaryBuffer.append("<br>");
        }
        return attachSettingsSummaryBuffer.toString();
    }

    public class Model {
        private String summary;

        public String getProviderName() {
            return ReviewSettingsPanel.this.getContext().getIntegrationProvider().getTitle();
        }

        public void setSummary(String htmlText) {
            this.summary = htmlText;
        }

        public String getSummary() {
            if (this.summary == null) {
                return "";
            }
            return this.summary;
        }
    }
}

