/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.SamplingThread;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Stacks;
import org.netbeans.lib.profiler.server.system.Timers;

class ProfilerRuntimeSampler
extends ProfilerRuntime {
    private static Sampling sampling;
    private static int samplingFrequency;

    ProfilerRuntimeSampler() {
    }

    static void setSamplngFrequency(int v) {
        samplingFrequency = v;
    }

    static void initialize() {
        sampling = new Sampling(samplingFrequency);
        sampling.start();
    }

    public static void shutdown() {
        sampling.terminate();
        sampling = null;
        ProfilerRuntime.clearDataStructures();
    }

    static void resetProfilerCollectors() {
        if (sampling != null) {
            sampling.resetData = true;
        }
    }

    static {
        samplingFrequency = 10;
    }

    static class Sampling
    extends SamplingThread {
        private int[] states = new int[0];
        private int[][] methodIds = new int[0][];
        private Map arrayOffsetMap = new HashMap();
        private Map threadIdMap = new HashMap();
        private int threadCount = 0;
        private volatile boolean resetData = false;
        private boolean sendDataAvailable = true;

        Sampling(int samplingInterval) {
            super(samplingInterval);
            this.setName("*** Profiler Agent Special Execution Thread 10");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void sample() {
            Thread[][] newThreads = new Thread[1][];
            int[][] newStates = new int[1][];
            int[][][] newMethodIds = new int[1][][];
            HashMap<Long, Integer> newArrayOffsetMap = new HashMap<Long, Integer>();
            HashMap<Long, Integer> newThreadIdMap = new HashMap<Long, Integer>();
            if (this.resetData) {
                this.resetProfilerCollectors();
                this.resetData = false;
                this.sendDataAvailable = true;
            }
            Stacks.getAllStackTraces(newThreads, newStates, newMethodIds);
            long timestamp = Timers.getCurrentTimeInCounts();
            if (newThreads[0] == null || ProfilerRuntime.eventBuffer == null) return;
            byte[] byArray = ProfilerRuntime.eventBuffer;
            synchronized (ProfilerRuntime.eventBuffer) {
                if (this.resetData) {
                    // ** MonitorExit[var8_7] (shouldn't be in output)
                    return;
                }
                this.writeThreadDumpStart(timestamp);
                for (int i = 0; i < newThreads[0].length; ++i) {
                    Thread t = newThreads[0][i];
                    int[] mids = newMethodIds[0][i];
                    if (ThreadInfo.isProfilerServerThread(t)) continue;
                    int status = newStates[0][i];
                    Long ltid = t.getId();
                    Integer index = (Integer)this.arrayOffsetMap.get(ltid);
                    Integer tid = (Integer)this.threadIdMap.get(ltid);
                    if (index != null) {
                        if (status == this.states[index] && Arrays.equals(mids, this.methodIds[index])) {
                            this.writeThreadInfoNoChange(tid);
                        } else {
                            this.writeThreadInfo(tid, status, mids);
                        }
                    } else {
                        if (status == 0 || mids.length <= 0) continue;
                        tid = new Integer(++this.threadCount);
                        ProfilerRuntime.writeThreadCreationEvent(t, tid);
                        this.writeThreadInfo(tid, status, mids);
                    }
                    newArrayOffsetMap.put(ltid, new Integer(i));
                    newThreadIdMap.put(ltid, tid);
                }
                this.writeThreadDumpEnd();
                // ** MonitorExit[var8_7] (shouldn't be in output)
                this.arrayOffsetMap = newArrayOffsetMap;
                this.threadIdMap = newThreadIdMap;
                this.states = newStates[0];
                this.methodIds = newMethodIds[0];
                return;
            }
        }

        private void resetProfilerCollectors() {
            this.arrayOffsetMap = new HashMap();
            this.threadIdMap = new HashMap();
            this.states = new int[0];
            this.methodIds = new int[0][];
            this.threadCount = 0;
        }

        private void writeThreadDumpStart(long absTimeStamp) {
            int curPos;
            if (ProfilerRuntime.eventBuffer == null) {
                return;
            }
            if (this.sendDataAvailable) {
                ProfilerServer.notifyClientOnResultsAvailability();
                this.sendDataAvailable = false;
            }
            if ((curPos = ProfilerRuntime.globalEvBufPos) + 8 > ProfilerRuntime.globalEvBufPosThreshold) {
                ProfilerRuntime.externalActionsHandler.handleEventBufferDump(ProfilerRuntime.eventBuffer, 0, curPos);
                curPos = 0;
            }
            ProfilerRuntime.eventBuffer[curPos++] = 28;
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(absTimeStamp >> 48 & 0xFFL);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(absTimeStamp >> 40 & 0xFFL);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(absTimeStamp >> 32 & 0xFFL);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(absTimeStamp >> 24 & 0xFFL);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(absTimeStamp >> 16 & 0xFFL);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(absTimeStamp >> 8 & 0xFFL);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(absTimeStamp & 0xFFL);
            ProfilerRuntime.globalEvBufPos = curPos;
        }

        private void writeThreadDumpEnd() {
            if (ProfilerRuntime.eventBuffer == null) {
                return;
            }
            int curPos = ProfilerRuntime.globalEvBufPos;
            if (curPos + 1 > ProfilerRuntime.globalEvBufPosThreshold) {
                ProfilerRuntime.externalActionsHandler.handleEventBufferDump(ProfilerRuntime.eventBuffer, 0, curPos);
                curPos = 0;
            }
            ProfilerRuntime.eventBuffer[curPos++] = 29;
            ProfilerRuntime.globalEvBufPos = curPos;
        }

        private void writeThreadInfoNoChange(Integer tid) {
            if (ProfilerRuntime.eventBuffer == null) {
                return;
            }
            int curPos = ProfilerRuntime.globalEvBufPos;
            if (curPos + 3 > ProfilerRuntime.globalEvBufPosThreshold) {
                ProfilerRuntime.externalActionsHandler.handleEventBufferDump(ProfilerRuntime.eventBuffer, 0, curPos);
                curPos = 0;
            }
            int threadId = tid;
            ProfilerRuntime.eventBuffer[curPos++] = 30;
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(threadId >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(threadId & 0xFF);
            ProfilerRuntime.globalEvBufPos = curPos;
        }

        private void writeThreadInfo(Integer tid, int status, int[] mids) {
            if (ProfilerRuntime.eventBuffer == null) {
                return;
            }
            int curPos = ProfilerRuntime.globalEvBufPos;
            if (curPos + 6 + mids.length * 4 > ProfilerRuntime.globalEvBufPosThreshold) {
                ProfilerRuntime.externalActionsHandler.handleEventBufferDump(ProfilerRuntime.eventBuffer, 0, curPos);
                curPos = 0;
            }
            int threadId = tid;
            int stackLen = mids.length;
            ProfilerRuntime.eventBuffer[curPos++] = 31;
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(threadId >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(threadId & 0xFF);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(status & 0xFF);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(stackLen >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[curPos++] = (byte)(stackLen & 0xFF);
            for (int i = 0; i < mids.length; ++i) {
                ProfilerRuntime.eventBuffer[curPos++] = (byte)(mids[i] >> 24 & 0xFF);
                ProfilerRuntime.eventBuffer[curPos++] = (byte)(mids[i] >> 16 & 0xFF);
                ProfilerRuntime.eventBuffer[curPos++] = (byte)(mids[i] >> 8 & 0xFF);
                ProfilerRuntime.eventBuffer[curPos++] = (byte)(mids[i] & 0xFF);
            }
            ProfilerRuntime.globalEvBufPos = curPos;
        }
    }
}

