/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.layers.SessionManager;
import org.openide.LifecycleManager;
import org.openide.modules.Places;
import org.openide.util.Exceptions;

public class ModuleLifecycleManager
extends LifecycleManager {
    private final AtomicBoolean exiting = new AtomicBoolean(false);

    public void saveAll() {
    }

    public void exit() {
        this.exit(0);
    }

    public void exit(int status) {
        if (this.exiting.getAndSet(true)) {
            return;
        }
        if (Main.getModuleSystem().shutDown(new Runnable(){

            @Override
            public void run() {
                try {
                    CLIHandler.stopServer();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    Exceptions.printStackTrace((Throwable)t);
                }
            }
        })) {
            try {
                SessionManager.getDefault().close();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
            if (System.getProperty("netbeans.close.no.exit") == null) {
                TopSecurityManager.exit((int)status);
            }
        }
    }

    public void markForRestart() throws UnsupportedOperationException {
        if (!TopSecurityManager.class.getClassLoader().getClass().getName().endsWith(".Launcher$AppClassLoader")) {
            throw new UnsupportedOperationException("not running in regular module system, cannot restart");
        }
        File userdir = Places.getUserDirectory();
        if (userdir == null) {
            throw new UnsupportedOperationException("no userdir");
        }
        File restartFile = new File(userdir, "var/restart");
        if (!restartFile.exists()) {
            try {
                restartFile.createNewFile();
            }
            catch (IOException x) {
                throw new UnsupportedOperationException(x);
            }
        }
    }
}

