/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

abstract class ParsingLayerCacheManager
extends LayerCacheManager
implements ContentHandler,
ErrorHandler,
EntityResolver {
    private static final String[] ATTR_TYPES = new String[]{"boolvalue", "bundlevalue", "bytevalue", "charvalue", "doublevalue", "floatvalue", "intvalue", "longvalue", "methodvalue", "newvalue", "serialvalue", "shortvalue", "stringvalue", "urlvalue"};
    private static final String DTD_1_0 = "-//NetBeans//DTD Filesystem 1.0//EN";
    private static final String DTD_1_1 = "-//NetBeans//DTD Filesystem 1.1//EN";
    private static final String DTD_1_2 = "-//NetBeans//DTD Filesystem 1.2//EN";
    private Locator locator;
    private MemFolder root;
    private Stack<Object> curr;
    private URL base;
    private final StringBuilder buf = new StringBuilder();
    private URL ref;
    private int weight;
    private int fileCount;
    private int folderCount;
    private int attrCount;
    private Set<String> oneLayerFiles;
    private String currPath;
    private boolean atLeastOneFileOrFolderInLayer;

    protected ParsingLayerCacheManager() {
    }

    @Override
    public final void store(FileSystem fs, List<URL> urls, OutputStream os) throws IOException {
        this.store(fs, this.createRoot(urls), os);
    }

    private MemFolder createRoot(List<URL> urls) throws IOException {
        this.root = new MemFolder(null);
        this.curr = new Stack();
        this.curr.push(this.root);
        try {
            XMLReader r = XMLUtil.createXMLReader();
            r.setFeature("http://xml.org/sax/features/validation", false);
            r.setFeature("http://xml.org/sax/features/namespaces", false);
            try {
                r.setFeature("http://xml.org/sax/features/string-interning", true);
            }
            catch (SAXException x) {
                Logger.getLogger(ParsingLayerCacheManager.class.getName()).log(Level.INFO, "#127537: could not set string-interning feature on parser; are you using a nonstandard XML parser?", x);
            }
            r.setContentHandler(this);
            r.setErrorHandler(this);
            r.setEntityResolver(this);
            Exception carrier = null;
            urls = new ArrayList<URL>(urls);
            Collections.reverse(urls);
            for (URL this.base : urls) {
                this.oneLayerFiles = new HashSet<String>(100);
                this.currPath = null;
                LayerCacheManager.err.log(Level.FINE, "Parsing: {0}", this.base);
                this.atLeastOneFileOrFolderInLayer = false;
                try {
                    r.parse(this.base.toExternalForm());
                    if (this.atLeastOneFileOrFolderInLayer || this.root.attrs != null) continue;
                    LayerCacheManager.err.log(Level.WARNING, "Inefficient to include an empty layer in a module: {0}", this.base);
                }
                catch (Exception e) {
                    this.curr.clear();
                    this.curr.push(this.root);
                    Exceptions.attachMessage((Throwable)e, (String)("While parsing " + this.base));
                    if (carrier == null) {
                        carrier = e;
                        continue;
                    }
                    Throwable t = carrier;
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    t.initCause(e);
                }
            }
            if (carrier != null) {
                throw carrier;
            }
            LayerCacheManager.err.fine("Finished layer parsing; " + this.fileCount + " files, " + this.folderCount + " folders, " + this.attrCount + " attributes");
            MemFolder memFolder = this.root;
            return memFolder;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
        finally {
            this.attrCount = 0;
            this.folderCount = 0;
            this.fileCount = 0;
            this.base = null;
            this.locator = null;
            this.curr = null;
            this.root = null;
            this.oneLayerFiles = null;
            this.currPath = null;
        }
    }

    protected abstract void store(FileSystem var1, MemFolder var2, OutputStream var3) throws IOException;

    protected abstract boolean openURLs();

    @Override
    public void startElement(String ns, String lname, String qname, Attributes attrs) throws SAXException {
        if (qname.equals("filesystem")) {
            return;
        }
        if (qname.equals("folder")) {
            this.fileOrFolder(qname, attrs);
        } else if (qname.equals("file")) {
            MemFileOrFolder mfof = this.fileOrFolder(qname, attrs);
            if (!(mfof instanceof MemFile)) {
                throw new ClassCastException("mfof: " + mfof + " stack: " + this.curr);
            }
            this.buf.setLength(0);
            this.ref = null;
            String u = attrs.getValue("url");
            if (u != null) {
                try {
                    this.ref = new URL(this.base, u);
                }
                catch (MalformedURLException mfue) {
                    throw (SAXException)new SAXException(mfue.toString()).initCause(mfue);
                }
            }
            this.weight = 0;
        } else if (qname.equals("attr")) {
            ++this.attrCount;
            MemAttr attr = new MemAttr();
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                String attrName = attrs.getQName(i);
                if ("name".equals(attrName)) {
                    attr.name = attrs.getValue(i);
                } else {
                    int idx = Arrays.binarySearch(ATTR_TYPES, attrName);
                    if (idx >= 0) {
                        attr.type = ATTR_TYPES[idx];
                        attr.data = attrs.getValue(i);
                    }
                }
                if (attr.name != null && attr.data != null) break;
            }
            if ("weight".equals(attr.name)) {
                if ("intvalue".equals(attr.type)) {
                    try {
                        this.weight = Integer.parseInt(attr.data);
                    }
                    catch (NumberFormatException x) {}
                } else {
                    LayerCacheManager.err.log(Level.WARNING, "currently unsupported value type for weight attribute in {0}: {1}", new Object[]{this.base, attr.type});
                }
            }
            if (attr.type == null) {
                throw new SAXParseException("unknown <attr> value type for " + attr.name, this.locator);
            }
            MemFileOrFolder parent = (MemFileOrFolder)this.curr.peek();
            if (parent.attrs == null) {
                parent.attrs = new LinkedList<MemAttr>();
            }
            Iterator<MemAttr> it = parent.attrs.iterator();
            while (it.hasNext()) {
                if (!it.next().name.equals(attr.name)) continue;
                --this.attrCount;
                it.remove();
            }
            parent.attrs.add(attr);
            if (!this.oneLayerFiles.add(this.currPath + "//" + attr.name)) {
                LayerCacheManager.err.warning("layer " + this.base + " contains duplicate attributes " + attr.name + " for " + this.currPath);
            }
        } else {
            throw new SAXException(qname);
        }
    }

    private MemFileOrFolder fileOrFolder(String qname, Attributes attrs) {
        this.atLeastOneFileOrFolderInLayer = true;
        String name = attrs.getValue("name");
        if (name == null) {
            throw new NullPointerException("No name");
        }
        if (!(this.curr.peek() instanceof MemFolder)) {
            throw new ClassCastException("Stack: " + this.curr);
        }
        MemFolder parent = (MemFolder)this.curr.peek();
        MemFileOrFolder f = null;
        if (parent.children == null) {
            parent.children = new LinkedList<MemFileOrFolder>();
        } else {
            for (MemFileOrFolder f2 : parent.children) {
                if (!f2.name.equals(name)) continue;
                f = f2;
                f.registerURL(this.base);
                break;
            }
        }
        if (f == null) {
            if (qname.equals("folder")) {
                f = new MemFolder(this.base);
                ++this.folderCount;
            } else {
                f = new MemFile(this.base);
                ++this.fileCount;
            }
            f.name = name;
            parent.children.add(f);
        }
        this.curr.push(f);
        this.currPath = this.currPath == null ? name : this.currPath + "/" + name;
        if (!this.oneLayerFiles.add(this.currPath)) {
            LayerCacheManager.err.warning("layer " + this.base + " contains duplicate " + qname + "s named " + this.currPath);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String ns, String lname, String qname) throws SAXException {
        MemFile file;
        if (qname.equals("file") && this.weight >= (file = (MemFile)this.curr.peek()).weight) {
            String text;
            file.weight = this.weight;
            file.contents = null;
            if (this.buf.length() > 0 && (text = this.buf.toString().trim()).length() > 0) {
                if (this.ref != null) {
                    throw new SAXParseException("CDATA plus url= in <file>", this.locator);
                }
                file.contents = text.getBytes();
            }
            file.ref = this.ref;
            if (this.openURLs() && file.ref != null && file.contents == null && file.ref.toExternalForm().startsWith("jar:file:")) {
                try {
                    URLConnection conn = file.ref.openConnection();
                    conn.connect();
                    byte[] readBuf = new byte[conn.getContentLength()];
                    InputStream is = conn.getInputStream();
                    try {
                        int read;
                        for (int pos = 0; pos < readBuf.length; pos += read) {
                            read = is.read(readBuf, pos, readBuf.length - pos);
                            if (read >= 1) continue;
                            throw new IOException("Premature EOF on " + file.ref.toExternalForm());
                        }
                        if (is.read() != -1) {
                            throw new IOException("Delayed EOF on " + file.ref.toExternalForm());
                        }
                    }
                    finally {
                        is.close();
                    }
                    file.contents = readBuf;
                    file.ref = null;
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
            }
        }
        if (qname.equals("file") || qname.equals("folder")) {
            this.curr.pop();
            int i = this.currPath.lastIndexOf(47);
            this.currPath = i == -1 ? null : this.currPath.substring(0, i);
        }
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        Object currF = this.curr.peek();
        if (!(currF instanceof MemFile)) {
            return;
        }
        this.buf.append(ch, start, len);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        LayerCacheManager.err.log(Level.WARNING, null, e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public InputSource resolveEntity(String pubid, String sysid) throws SAXException, IOException {
        if (pubid != null && (pubid.equals(DTD_1_0) || pubid.equals(DTD_1_1) || pubid.equals(DTD_1_2))) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.curr.size() != 1) {
            throw new SAXException("Wrong stack: " + this.curr);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String str, String str1) throws SAXException {
    }

    @Override
    public void skippedEntity(String str) throws SAXException {
    }

    @Override
    public void processingInstruction(String str, String str1) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] values, int param, int param2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String str) throws SAXException {
    }

    protected static final class MemAttr {
        public String name;
        public String type;
        public String data;

        protected MemAttr() {
        }

        public String toString() {
            return "MemAttr[" + this.name + "," + this.type + "," + this.data + "]";
        }
    }

    protected static final class MemFile
    extends MemFileOrFolder {
        public byte[] contents = null;
        public URL ref = null;
        private int weight = Integer.MIN_VALUE;

        public MemFile(URL base) {
            super(base);
        }

        public String toString() {
            return "MemFile[" + this.name + "]";
        }
    }

    protected static final class MemFolder
    extends MemFileOrFolder {
        public List<MemFileOrFolder> children = null;

        public MemFolder(URL base) {
            super(base);
        }

        public String toString() {
            return "MemFolder[" + this.name + "]";
        }
    }

    protected static abstract class MemFileOrFolder {
        public String name;
        public List<MemAttr> attrs = null;
        private Object base;

        public MemFileOrFolder(URL base) {
            this.base = base;
        }

        final URL getBase() {
            Object o = this.base;
            if (o instanceof URL) {
                return (URL)o;
            }
            return (URL)((Iterable)o).iterator().next();
        }

        final List<URL> getURLs() {
            Object o = this.base;
            if (o instanceof URL) {
                return Collections.singletonList((URL)o);
            }
            return o != null ? (List)o : Collections.emptyList();
        }

        final void registerURL(URL url) {
            ArrayList<URL> urls;
            if (this.base instanceof URL) {
                URL u = (URL)this.base;
                this.base = urls = new ArrayList<URL>();
                urls.add(u);
            } else {
                urls = (ArrayList<URL>)this.base;
            }
            urls.add(url);
        }
    }
}

