/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.DefaultCaret;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.DynamicPieChartModel;
import org.netbeans.lib.profiler.ui.charts.PieChart;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;
import org.netbeans.lib.profiler.ui.threads.ThreadsDetailsPanel;
import org.netbeans.lib.profiler.ui.threads.TimeLineUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public class ThreadDetailsComponent
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    private static final String THREAD_ALIVE_STRING = messages.getString("ThreadDetailsComponent_ThreadAliveString");
    private static final String THREAD_FINISHED_STRING = messages.getString("ThreadDetailsComponent_ThreadFinishedString");
    private static final String NO_DATA_COLLECTED_STRING = messages.getString("ThreadDetailsComponent_NoDataCollectedString");
    private static final String THREAD_STATE_UNKNOWN_STRING = messages.getString("ThreadDetailsComponent_ThreadStateUnknownString");
    private static final String THREAD_STARTED_STRING = messages.getString("ThreadDetailsComponent_ThreadStartedString");
    private static final String HIDE_BUTTON_NAME = messages.getString("ThreadDetailsComponent_HideButtonName");
    private static final String TOTAL_LABEL_STRING = messages.getString("ThreadDetailsComponent_TotalLabelString");
    private static final String GENERAL_TAB_NAME = messages.getString("ThreadDetailsComponent_GeneralTabName");
    private static final String DETAILS_TAB_NAME = messages.getString("ThreadDetailsComponent_DetailsTabName");
    private static final String TIMELINE_ACCESS_NAME = messages.getString("ThreadDetailsComponent_TimeLineAccessName");
    private static final String THREAD_NAME_LABEL_ACCESS_NAME = messages.getString("ThreadDetailsComponent_ThreadNameLabelAccessName");
    private static final String THREAD_STATE_LABEL_ACCESS_NAME = messages.getString("ThreadDetailsComponent_ThreadStateLabelAccessName");
    private static final String HIDE_BUTTON_ACCESS_DESCR = messages.getString("ThreadDetailsComponent_HideButtonAccessDescr");
    private static final String PIECHART_ACCESS_NAME = messages.getString("ThreadDetailsComponent_PieChartAccessName");
    private static final String TAB_ACCESS_NAME = messages.getString("ThreadDetailsComponent_TabAccessName");
    private static final int THREAD_ICON_SIZE = 9;
    private static ThreadStateIcon runningIcon = new ThreadStateIcon(1, 9, 9);
    private static ThreadStateIcon sleepingIcon = new ThreadStateIcon(2, 9, 9);
    private static ThreadStateIcon monitorIcon = new ThreadStateIcon(3, 9, 9);
    private static ThreadStateIcon waitIcon = new ThreadStateIcon(4, 9, 9);
    private static ThreadStateIcon unknownIcon = new ThreadStateIcon(-1, 9, 9);
    private static ThreadStateIcon zombieIcon = new ThreadStateIcon(0, 9, 9);
    private static ThreadStateIcon noneIcon = new ThreadStateIcon(-100, 9, 9);
    private static final Color TIMELINE_ALIVE_BACKGROUND = Color.WHITE;
    private static final Color TIMELINE_FINISHED_BACKGROUND = new Color(240, 240, 240);
    long monitorTime;
    long runningTime;
    long sleepingTime;
    long unknownTime;
    long waitTime;
    private DynamicPieChartModel pieChartModel;
    private JButton hideButton;
    private JLabel monitorTitleLabel;
    private JLabel monitorValueLabel;
    private JLabel monitorValueRelLabel;
    private JLabel runningTitleLabel;
    private JLabel runningValueLabel;
    private JLabel runningValueRelLabel;
    private JLabel sleepingTitleLabel;
    private JLabel sleepingValueLabel;
    private JLabel sleepingValueRelLabel;
    private JLabel threadClassNameLabel;
    private JLabel threadNameLabel;
    private JLabel threadStateLabel;
    private JLabel totalTitleLabel;
    private JLabel totalValueLabel;
    private JLabel waitTitleLabel;
    private JLabel waitValueLabel;
    private JLabel waitValueRelLabel;
    private JPanel descriptionPanel;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JPanel tabsPanel;
    private JPanel timeLinePanel;
    private JPanel titlePanel;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTabbedPane jTabbedPane1;
    private JTextArea detailsArea;
    private JTextArea threadDescriptionArea;
    private PieChart pieChart;
    private SingleThreadState timeLine;
    private ThreadsDetailsPanel viewManager;
    private boolean internalAdjustmentEvent;
    private boolean supportsSleepingState;
    private byte lastThreadState;
    private int lastStatesCount;
    private int lastThreadIndex;
    private int threadIndex;
    private long lastThreadDataEnd;

    public ThreadDetailsComponent(ThreadsDetailsPanel viewManager, boolean supportsSleepingState) {
        this(viewManager, -1, supportsSleepingState);
    }

    private ThreadDetailsComponent(ThreadsDetailsPanel viewManager, int index, boolean supportsSleepingState) {
        this.viewManager = viewManager;
        this.supportsSleepingState = supportsSleepingState;
        this.initPieChartComponents();
        this.initComponents();
        this.hookDetailsAreaScrollBar();
        this.resetData();
        this.setIndex(index);
    }

    public void setIndex(int index) {
        this.threadIndex = index;
        this.updateThreadState();
    }

    public int getIndex() {
        return this.threadIndex;
    }

    public void dataReset() {
        this.resetData();
        this.setIndex(-1);
    }

    private String getPercentValue(float value, float basevalue) {
        int basis = (int)(value / basevalue * 1000.0f);
        int percent = basis / 10;
        int permille = basis % 10;
        return "" + percent + "." + permille;
    }

    private String getThreadDetail(long timestamp, String description) {
        long relTimeStamp = timestamp - this.viewManager.getDataStartTime();
        return " " + TimeLineUtils.getMillisValue(relTimeStamp) + ": " + description + "\n";
    }

    private long getThreadStateDuration(ThreadData threadData, int index) {
        long startTime = threadData.getTimeStampAt(index);
        long endTime = this.viewManager.getDataEndTime();
        if (index < threadData.size() - 1) {
            endTime = threadData.getTimeStampAt(index + 1);
        }
        return endTime - startTime;
    }

    private void hookDetailsAreaScrollBar() {
        this.jScrollPane1.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar scrollbar = ThreadDetailsComponent.this.jScrollPane1.getVerticalScrollBar();
                int value = e.getValue();
                int increment = scrollbar.getUnitIncrement(-1);
                if (!ThreadDetailsComponent.this.internalAdjustmentEvent) {
                    if (ThreadDetailsComponent.this.detailsArea.getCaretPosition() == ThreadDetailsComponent.this.detailsArea.getText().length()) {
                        if (scrollbar.getValue() + scrollbar.getVisibleAmount() < scrollbar.getMaximum()) {
                            try {
                                ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getLineStartOffset(value / increment));
                            }
                            catch (Exception ex) {}
                        }
                    } else if (scrollbar.getValue() + scrollbar.getVisibleAmount() >= scrollbar.getMaximum()) {
                        ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getText().length());
                    }
                }
                ThreadDetailsComponent.this.internalAdjustmentEvent = false;
            }
        });
    }

    private void initComponents() {
        this.timeLine = new SingleThreadState();
        this.timeLine.getAccessibleContext().setAccessibleName(TIMELINE_ACCESS_NAME);
        this.titlePanel = new JPanel();
        this.threadNameLabel = new JLabel();
        this.threadClassNameLabel = new JLabel();
        this.threadStateLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jPanel9 = new JPanel();
        this.hideButton = new JButton();
        this.descriptionPanel = new JPanel();
        this.threadDescriptionArea = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this.tabsPanel = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jPanel11 = new JPanel();
        this.jPanel10 = new JPanel();
        this.runningTitleLabel = new JLabel();
        this.sleepingTitleLabel = new JLabel();
        this.waitTitleLabel = new JLabel();
        this.monitorTitleLabel = new JLabel();
        this.runningValueLabel = new JLabel();
        this.runningValueRelLabel = new JLabel();
        this.sleepingValueLabel = new JLabel();
        this.sleepingValueRelLabel = new JLabel();
        this.waitValueLabel = new JLabel();
        this.waitValueRelLabel = new JLabel();
        this.monitorValueLabel = new JLabel();
        this.monitorValueRelLabel = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.totalTitleLabel = new JLabel();
        this.totalValueLabel = new JLabel();
        this.jPanel12 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.detailsArea = new JTextArea();
        this.jSeparator3 = new JSeparator();
        this.timeLinePanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, UIUtils.getDisabledLineColor()), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.titlePanel.setLayout(new BorderLayout(5, 5));
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new FlowLayout(1, 0, 0));
        this.threadNameLabel.setFont(this.getFont().deriveFont(1, this.getFont().getSize() + 1));
        this.threadNameLabel.setVerticalAlignment(0);
        this.threadNameLabel.setIcon(noneIcon);
        this.threadNameLabel.setIconTextGap(7);
        this.threadNameLabel.setBorder(new EmptyBorder(new Insets(5, 7, 0, 0)));
        this.threadNameLabel.getAccessibleContext().setAccessibleName(THREAD_NAME_LABEL_ACCESS_NAME);
        this.threadClassNameLabel.setFont(this.getFont().deriveFont((float)(this.getFont().getSize() + 1)));
        this.threadClassNameLabel.setVerticalAlignment(0);
        this.threadClassNameLabel.setBorder(new EmptyBorder(new Insets(5, 5, 0, 0)));
        namePanel.add(this.threadNameLabel);
        namePanel.add(this.threadClassNameLabel);
        this.titlePanel.add((Component)namePanel, "West");
        this.threadStateLabel.setVerticalAlignment(0);
        this.threadStateLabel.setBorder(new EmptyBorder(new Insets(5, 0, 0, 5)));
        this.threadStateLabel.getAccessibleContext().setAccessibleName(THREAD_STATE_LABEL_ACCESS_NAME);
        this.titlePanel.add((Component)this.threadStateLabel, "Center");
        this.titlePanel.add((Component)this.jSeparator2, "South");
        this.jPanel9.setLayout(new BorderLayout(5, 0));
        this.hideButton.setText(HIDE_BUTTON_NAME);
        this.hideButton.setPreferredSize(new Dimension(this.hideButton.getPreferredSize().width, this.hideButton.getPreferredSize().height - 4));
        this.hideButton.setMaximumSize(new Dimension(this.hideButton.getMaximumSize().width, this.hideButton.getMaximumSize().height - 4));
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadDetailsComponent.this.viewManager.hideThreadDetails(ThreadDetailsComponent.this.threadIndex);
            }
        });
        this.hideButton.getAccessibleContext().setAccessibleDescription(HIDE_BUTTON_ACCESS_DESCR);
        this.jPanel9.add((Component)this.hideButton, "West");
        this.titlePanel.add((Component)this.jPanel9, "East");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.titlePanel, gridBagConstraints);
        this.descriptionPanel.setLayout(new BorderLayout());
        JPanel threadDescriptionIconPanel = new JPanel();
        threadDescriptionIconPanel.setLayout(new BorderLayout());
        threadDescriptionIconPanel.setBorder(new EmptyBorder(new Insets(0, 5, 5, 0)));
        JLabel threadDescriptionIcon = new JLabel(Icons.getIcon((String)"GeneralIcons.Info"));
        threadDescriptionIconPanel.add((Component)threadDescriptionIcon, "North");
        this.descriptionPanel.add((Component)threadDescriptionIconPanel, "West");
        this.threadDescriptionArea.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        this.threadDescriptionArea.setBackground(this.getBackground());
        this.threadDescriptionArea.setOpaque(false);
        this.threadDescriptionArea.setWrapStyleWord(true);
        this.threadDescriptionArea.setLineWrap(true);
        this.threadDescriptionArea.setEnabled(false);
        this.threadDescriptionArea.setFont(UIManager.getFont("Label.font"));
        this.threadDescriptionArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.threadDescriptionArea.setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle nloc) {
            }
        });
        this.descriptionPanel.add((Component)this.threadDescriptionArea, "Center");
        this.descriptionPanel.add((Component)this.jSeparator1, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.descriptionPanel, gridBagConstraints);
        this.tabsPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(TAB_ACCESS_NAME);
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel11.setLayout(new BorderLayout());
        this.jPanel10.setLayout(new GridBagLayout());
        this.runningTitleLabel.setText(CommonConstants.THREAD_STATUS_RUNNING_STRING);
        this.runningTitleLabel.setIcon(runningIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel10.add((Component)this.runningTitleLabel, gridBagConstraints);
        if (this.supportsSleepingState) {
            this.sleepingTitleLabel.setText(CommonConstants.THREAD_STATUS_SLEEPING_STRING);
            this.sleepingTitleLabel.setBorder(new EmptyBorder(new Insets(5, 5, 0, 5)));
            this.sleepingTitleLabel.setIcon(sleepingIcon);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jPanel10.add((Component)this.sleepingTitleLabel, gridBagConstraints);
        }
        this.waitTitleLabel.setText(CommonConstants.THREAD_STATUS_WAIT_STRING);
        this.waitTitleLabel.setIcon(waitIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel10.add((Component)this.waitTitleLabel, gridBagConstraints);
        this.monitorTitleLabel.setText(CommonConstants.THREAD_STATUS_MONITOR_STRING);
        this.monitorTitleLabel.setIcon(monitorIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel10.add((Component)this.monitorTitleLabel, gridBagConstraints);
        this.runningValueLabel.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel10.add((Component)this.runningValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.jPanel10.add((Component)this.runningValueRelLabel, gridBagConstraints);
        if (this.supportsSleepingState) {
            this.sleepingValueLabel.setHorizontalAlignment(11);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            this.jPanel10.add((Component)this.sleepingValueLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 0, 0, 10);
            this.jPanel10.add((Component)this.sleepingValueRelLabel, gridBagConstraints);
        }
        this.waitValueLabel.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel10.add((Component)this.waitValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.jPanel10.add((Component)this.waitValueRelLabel, gridBagConstraints);
        this.monitorValueLabel.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel10.add((Component)this.monitorValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        this.jPanel10.add((Component)this.monitorValueRelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel10.add((Component)this.jSeparator4, gridBagConstraints);
        this.totalTitleLabel.setText(TOTAL_LABEL_STRING);
        this.totalTitleLabel.setIcon(noneIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel10.add((Component)this.totalTitleLabel, gridBagConstraints);
        this.totalValueLabel.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel10.add((Component)this.totalValueLabel, gridBagConstraints);
        this.jPanel11.add((Component)this.jPanel10, "West");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(new Insets(10, 0, 0, 0)));
        northPanel.add((Component)this.jPanel11, "North");
        this.jPanel6.add((Component)northPanel, "Center");
        this.jPanel12.setLayout(new BorderLayout());
        this.pieChart.setPreferredSize(new Dimension(230, 100));
        this.pieChart.setBorder(BorderFactory.createEmptyBorder(15, 30, 15, 30));
        this.jPanel12.add((Component)this.pieChart, "North");
        this.jPanel12.getAccessibleContext().setAccessibleName(PIECHART_ACCESS_NAME);
        this.pieChart.setAccessibleContext(this.jPanel12.getAccessibleContext());
        this.jPanel6.add((Component)this.jPanel12, "West");
        this.jTabbedPane1.addTab(GENERAL_TAB_NAME, this.jPanel6);
        this.jPanel7.setLayout(new BorderLayout());
        this.detailsArea.setEditable(false);
        this.detailsArea.setRows(1);
        this.jScrollPane1.setViewportView(this.detailsArea);
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder());
        this.jScrollPane1.setViewportBorder(BorderFactory.createEmptyBorder());
        this.jPanel7.add((Component)this.jScrollPane1, "Center");
        this.jTabbedPane1.addTab(DETAILS_TAB_NAME, this.jPanel7);
        this.tabsPanel.add((Component)this.jTabbedPane1, "Center");
        this.tabsPanel.add((Component)this.jSeparator3, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.tabsPanel, gridBagConstraints);
        this.timeLinePanel.setLayout(new BorderLayout());
        JPanel timeLineContainer = new JPanel();
        timeLineContainer.setLayout(new BorderLayout());
        timeLineContainer.setBorder(new BevelBorder(1));
        timeLineContainer.add((Component)this.timeLine, "Center");
        this.timeLinePanel.add((Component)timeLineContainer, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.timeLinePanel, gridBagConstraints);
    }

    private void initPieChartComponents() {
        this.pieChart = new PieChart();
        this.pieChart.setFocusable(false);
        this.pieChartModel = new DynamicPieChartModel();
        if (this.supportsSleepingState) {
            this.pieChartModel.setupModel(new String[]{CommonConstants.THREAD_STATUS_RUNNING_STRING, CommonConstants.THREAD_STATUS_SLEEPING_STRING, CommonConstants.THREAD_STATUS_WAIT_STRING, CommonConstants.THREAD_STATUS_MONITOR_STRING}, new Color[]{CommonConstants.THREAD_STATUS_RUNNING_COLOR, CommonConstants.THREAD_STATUS_SLEEPING_COLOR, CommonConstants.THREAD_STATUS_WAIT_COLOR, CommonConstants.THREAD_STATUS_MONITOR_COLOR});
        } else {
            this.pieChartModel.setupModel(new String[]{CommonConstants.THREAD_STATUS_RUNNING_STRING, CommonConstants.THREAD_STATUS_WAIT_STRING, CommonConstants.THREAD_STATUS_MONITOR_STRING}, new Color[]{CommonConstants.THREAD_STATUS_RUNNING_COLOR, CommonConstants.THREAD_STATUS_WAIT_COLOR, CommonConstants.THREAD_STATUS_MONITOR_COLOR});
        }
        this.pieChart.setModel(this.pieChartModel);
    }

    private void resetData() {
        this.lastThreadIndex = -1;
        this.lastStatesCount = 0;
        this.lastThreadDataEnd = 0L;
        this.lastThreadState = (byte)-10;
        this.runningTime = 0L;
        this.sleepingTime = 0L;
        this.waitTime = 0L;
        this.monitorTime = 0L;
        this.unknownTime = 0L;
        this.detailsArea.setText("");
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void updateThreadState() {
        if (this.threadIndex == -1) {
            return;
        }
        ThreadData threadData = this.viewManager.getThreadData(this.threadIndex);
        this.threadNameLabel.setText(this.viewManager.getThreadName(this.threadIndex));
        if (this.threadIndex != this.lastThreadIndex) {
            this.threadClassNameLabel.setText("[" + this.viewManager.getThreadClassName(this.threadIndex) + "]");
        }
        if (threadData == null || threadData.size() == 0) {
            this.threadNameLabel.setIcon(zombieIcon);
            this.timeLine.setBackground(TIMELINE_FINISHED_BACKGROUND);
            this.threadStateLabel.setText("(" + THREAD_FINISHED_STRING + ")");
        } else if (this.lastThreadState != threadData.getLastState()) {
            switch (threadData.getLastState()) {
                case -1: {
                    this.threadNameLabel.setIcon(unknownIcon);
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_STATE_UNKNOWN_STRING + ")");
                    break;
                }
                case 0: {
                    this.threadNameLabel.setIcon(zombieIcon);
                    this.timeLine.setBackground(TIMELINE_FINISHED_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_FINISHED_STRING + ")");
                    break;
                }
                case 2: {
                    if (this.supportsSleepingState) {
                        this.threadNameLabel.setIcon(sleepingIcon);
                    } else {
                        this.threadNameLabel.setIcon(runningIcon);
                    }
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_ALIVE_STRING + ")");
                    break;
                }
                case 1: {
                    this.threadNameLabel.setIcon(runningIcon);
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_ALIVE_STRING + ")");
                    break;
                }
                case 4: {
                    this.threadNameLabel.setIcon(waitIcon);
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_ALIVE_STRING + ")");
                    break;
                }
                case 3: {
                    this.threadNameLabel.setIcon(monitorIcon);
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_ALIVE_STRING + ")");
                }
            }
        }
        this.threadDescriptionArea.setText(this.viewManager.getThreadDescription(this.threadIndex));
        if (threadData == null || threadData.size() == 0) {
            if (this.threadIndex != this.lastThreadIndex) {
                this.resetData();
                this.runningValueLabel.setText("-");
                this.runningValueRelLabel.setText("(-%)");
                if (this.supportsSleepingState) {
                    this.sleepingValueLabel.setText("-");
                    this.sleepingValueRelLabel.setText("(-%)");
                }
                this.waitValueLabel.setText("-");
                this.waitValueRelLabel.setText("(-%)");
                this.monitorValueLabel.setText("-");
                this.monitorValueRelLabel.setText("(-%)");
                this.totalValueLabel.setText(NO_DATA_COLLECTED_STRING);
                if (this.supportsSleepingState) {
                    this.pieChartModel.setItemValues(new double[]{0.0, 0.0, 0.0, 0.0});
                } else {
                    this.pieChartModel.setItemValues(new double[]{0.0, 0.0, 0.0});
                }
            }
        } else {
            if (this.threadIndex != this.lastThreadIndex) {
                this.resetData();
            }
            StringBuilder detailsToAppend = new StringBuilder();
            block21: for (int i = this.lastStatesCount; i < threadData.size(); ++i) {
                long timeStamp = threadData.getTimeStampAt(i);
                byte state = threadData.getStateAt(i);
                if (i == 0) {
                    detailsToAppend.append(this.getThreadDetail(timeStamp, THREAD_STARTED_STRING));
                }
                switch (state) {
                    case 1: {
                        detailsToAppend.append(this.getThreadDetail(timeStamp, CommonConstants.THREAD_STATUS_RUNNING_STRING));
                        this.runningTime += this.getThreadStateDuration(threadData, i);
                        continue block21;
                    }
                    case 2: {
                        if (this.supportsSleepingState) {
                            detailsToAppend.append(this.getThreadDetail(timeStamp, CommonConstants.THREAD_STATUS_SLEEPING_STRING));
                            this.sleepingTime += this.getThreadStateDuration(threadData, i);
                            continue block21;
                        }
                        detailsToAppend.append(this.getThreadDetail(timeStamp, CommonConstants.THREAD_STATUS_RUNNING_STRING));
                        this.runningTime += this.getThreadStateDuration(threadData, i);
                        continue block21;
                    }
                    case 4: {
                        detailsToAppend.append(this.getThreadDetail(timeStamp, CommonConstants.THREAD_STATUS_WAIT_STRING));
                        this.waitTime += this.getThreadStateDuration(threadData, i);
                        continue block21;
                    }
                    case 3: {
                        detailsToAppend.append(this.getThreadDetail(timeStamp, CommonConstants.THREAD_STATUS_MONITOR_STRING));
                        this.monitorTime += this.getThreadStateDuration(threadData, i);
                        continue block21;
                    }
                    case 0: {
                        if (i == 0) continue block21;
                        detailsToAppend.append(this.getThreadDetail(timeStamp, CommonConstants.THREAD_STATUS_ZOMBIE_STRING));
                    }
                }
            }
            if (this.lastStatesCount == threadData.size() && threadData.size() != 0) {
                long timeDiff = this.viewManager.getDataEndTime() - this.lastThreadDataEnd;
                byte state = threadData.getLastState();
                switch (state) {
                    case 1: {
                        this.runningTime += timeDiff;
                        break;
                    }
                    case 2: {
                        if (this.supportsSleepingState) {
                            this.sleepingTime += timeDiff;
                            break;
                        }
                        this.runningTime += timeDiff;
                        break;
                    }
                    case 4: {
                        this.waitTime += timeDiff;
                        break;
                    }
                    case 3: {
                        this.monitorTime += timeDiff;
                    }
                }
            }
            long totalTime = 0L;
            totalTime = this.supportsSleepingState ? this.runningTime + this.sleepingTime + this.waitTime + this.monitorTime : this.runningTime + this.waitTime + this.monitorTime;
            if (this.supportsSleepingState) {
                this.pieChartModel.setItemValues(new double[]{this.runningTime, this.sleepingTime, this.waitTime, this.monitorTime});
            } else {
                this.pieChartModel.setItemValues(new double[]{this.runningTime, this.waitTime, this.monitorTime});
            }
            this.runningValueLabel.setText(TimeLineUtils.getMillisValue(this.runningTime));
            this.runningValueRelLabel.setText("(" + (this.runningTime == 0L ? "0.0" : this.getPercentValue(this.runningTime, totalTime)) + "%)");
            if (this.supportsSleepingState) {
                this.sleepingValueLabel.setText(TimeLineUtils.getMillisValue(this.sleepingTime));
                this.sleepingValueRelLabel.setText("(" + (this.sleepingTime == 0L ? "0.0" : this.getPercentValue(this.sleepingTime, totalTime)) + "%)");
            }
            this.waitValueLabel.setText(TimeLineUtils.getMillisValue(this.waitTime));
            this.waitValueRelLabel.setText("(" + (this.waitTime == 0L ? "0.0" : this.getPercentValue(this.waitTime, totalTime)) + "%)");
            this.monitorValueLabel.setText(TimeLineUtils.getMillisValue(this.monitorTime));
            this.monitorValueRelLabel.setText("(" + (this.monitorTime == 0L ? "0.0" : this.getPercentValue(this.monitorTime, totalTime)) + "%)");
            this.totalValueLabel.setText(TimeLineUtils.getMillisValue(totalTime));
            if (detailsToAppend.length() > 0) {
                if (this.detailsArea.getCaretPosition() == this.detailsArea.getText().length()) {
                    this.internalAdjustmentEvent = true;
                }
                this.detailsArea.append(detailsToAppend.toString());
                if (this.lastStatesCount == 0) {
                    this.detailsArea.setCaretPosition(1);
                }
            }
            this.lastThreadIndex = this.threadIndex;
            this.lastStatesCount = threadData.size();
            this.lastThreadDataEnd = this.viewManager.getDataEndTime();
            this.lastThreadState = threadData.getLastState();
            this.timeLine.updateData(threadData, this.viewManager.getDataStartTime(), this.viewManager.getDataEndTime());
        }
    }

    private class SingleThreadState
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final int DISPLAY_MARGIN = 20;
        private final Color SELECTION_BRIGHT = new Color(150, 150, 255);
        private final Color SELECTION_DARK = new Color(80, 80, 255);
        private ThreadData threadData;
        private boolean dragging = false;
        private float factor;
        private int focusedThreadDataIndex;
        private int mouseDraggedX = -1;
        private int mousePressedX = -1;
        private int width;
        private long dataEnd;
        private long dataStart;
        private long viewEnd;
        private long viewStart;

        public SingleThreadState() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setBackground(TIMELINE_ALIVE_BACKGROUND);
            this.threadData = new ThreadData(null, null);
            this.dataStart = 0L;
            this.dataEnd = 0L;
            this.focusedThreadDataIndex = -1;
        }

        public int getFocusedThreadDataIndex(Point point) {
            if (!this.isFocusedX(point.x)) {
                return -1;
            }
            if (!this.isFocusedY(point.y)) {
                return -1;
            }
            int focused = this.getFocusedThreadDataIndex(point.x);
            if (focused == this.threadData.size()) {
                return -1;
            }
            return focused;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, this.getFont().getSize() + 20);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int focusedIndex = this.getFocusedThreadDataIndex(e.getPoint());
            if (focusedIndex == -1) {
                ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getCaretPosition());
                return;
            }
            this.selectDescriptionAreaLines(focusedIndex, focusedIndex);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.mousePressedX != -1) {
                this.dragging = true;
                this.mouseDraggedX = e.getX();
                if (this.mousePressedX == this.mouseDraggedX) {
                    return;
                }
                int startX = this.mousePressedX;
                int endX = this.mouseDraggedX;
                if (startX > endX) {
                    int tmp = endX;
                    endX = startX;
                    startX = tmp;
                }
                int startIndex = this.getFocusedThreadDataIndex(startX);
                int endIndex = this.getFocusedThreadDataIndex(endX);
                if (startIndex == -1 && endIndex == -1) {
                    ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getCaretPosition());
                    this.repaint();
                    return;
                }
                if (startIndex >= this.threadData.size() && endIndex >= this.threadData.size()) {
                    ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getCaretPosition());
                    this.repaint();
                    return;
                }
                int offsetStart = this.threadData.getFirstState() == 0 ? 1 : 0;
                int offsetEnd = this.threadData.getLastState() == 0 ? 1 : 0;
                startIndex = Math.max(startIndex, offsetStart);
                endIndex = Math.min(endIndex, this.threadData.size() - 1 - offsetEnd);
                this.selectDescriptionAreaLines(startIndex, endIndex);
                this.repaint();
            } else {
                ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getCaretPosition());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.focusedThreadDataIndex = -1;
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int currentlyFocused = this.getFocusedThreadDataIndex(e.getPoint());
            if (currentlyFocused != this.focusedThreadDataIndex) {
                this.focusedThreadDataIndex = currentlyFocused;
                this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mousePressedX = this.isFocusedY(e.getY()) ? e.getX() : -1;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dragging = false;
            this.focusedThreadDataIndex = this.getFocusedThreadDataIndex(e.getPoint());
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.viewStart = this.dataStart;
            this.viewEnd = this.dataEnd;
            this.width = this.getWidth() - 40;
            this.factor = (float)this.width / (float)(this.viewEnd - this.viewStart);
            if (this.viewEnd - this.viewStart > 0L) {
                this.paintTimeMarks(g);
                this.paintThreadData(g);
            }
        }

        private int getFirstVisibleDataUnit() {
            if (this.threadData.size() > 0) {
                return 0;
            }
            return -1;
        }

        private int getFocusedThreadDataIndex(int xpos) {
            if (this.threadData == null) {
                return -1;
            }
            if (this.viewEnd - this.viewStart <= 0L) {
                return -1;
            }
            int index = this.getFirstVisibleDataUnit();
            if (index != -1) {
                while (index < this.threadData.size() && this.threadData.getTimeStampAt(index) <= this.viewEnd) {
                    if (this.threadData.getStateAt(index) != 0) {
                        int x = Math.max((int)((float)(this.threadData.getTimeStampAt(index) - this.viewStart) * this.factor), 0) + 20;
                        if (xpos < x) {
                            return -1;
                        }
                        int xx = index < this.threadData.size() - 1 ? Math.min((int)((float)(this.threadData.getTimeStampAt(index + 1) - this.viewStart) * this.factor), this.width) + 20 : Math.min((int)((float)(this.dataEnd - this.viewStart) * this.factor), this.width + 1) + 20;
                        if (xpos >= x && xpos <= xx) {
                            return index;
                        }
                    }
                    ++index;
                }
            }
            return index;
        }

        private boolean isFocusedX(int x) {
            return x > 20 && x < this.getWidth() - 20;
        }

        private boolean isFocusedY(int y) {
            return y > 7 + this.getFont().getSize() && y <= this.getHeight();
        }

        private void paintThreadData(Graphics g) {
            int index;
            if (this.threadData != null && (index = this.getFirstVisibleDataUnit()) != -1 && this.viewEnd - this.viewStart > 0L) {
                while (index < this.threadData.size() && this.threadData.getTimeStampAt(index) <= this.viewEnd) {
                    if (this.threadData.getStateAt(index) != 0) {
                        this.paintThreadState(g, index, this.threadData.getThreadStateColorAt(index));
                    }
                    ++index;
                }
            }
        }

        private void paintThreadState(Graphics g, int index, Color threadStateColor) {
            int graphicsFontSize = g.getFont().getSize();
            int x = Math.max((int)((float)(this.threadData.getTimeStampAt(index) - this.viewStart) * this.factor), 0) + 20;
            int xx = index < this.threadData.size() - 1 ? Math.min((int)((float)(this.threadData.getTimeStampAt(index + 1) - this.viewStart) * this.factor), this.width) + 20 : Math.min((int)((float)(this.dataEnd - this.viewStart) * this.factor), this.width + 1) + 20;
            g.setColor(threadStateColor);
            g.fillRect(x, 11 + graphicsFontSize, xx - x, this.getHeight() - graphicsFontSize - 14);
            if (this.dragging) {
                g.setColor(this.SELECTION_BRIGHT);
                g.drawLine(this.mousePressedX, 10 + graphicsFontSize - 2, this.mouseDraggedX, 10 + graphicsFontSize - 2);
                g.drawLine(this.mousePressedX, this.getHeight() - 1, this.mouseDraggedX, this.getHeight() - 1);
                g.setColor(this.SELECTION_DARK);
                g.drawLine(this.mousePressedX, 11 + graphicsFontSize - 2, this.mouseDraggedX, 11 + graphicsFontSize - 2);
                g.drawLine(this.mousePressedX, this.getHeight() - 2, this.mouseDraggedX, this.getHeight() - 2);
            } else if (index == this.focusedThreadDataIndex) {
                g.setColor(this.SELECTION_BRIGHT);
                g.drawLine(x, 10 + graphicsFontSize - 2, xx - 1, 10 + graphicsFontSize - 2);
                g.drawLine(x, this.getHeight() - 1, xx - 1, this.getHeight() - 1);
                g.setColor(this.SELECTION_DARK);
                g.drawLine(x, 11 + graphicsFontSize - 2, xx - 1, 11 + graphicsFontSize - 2);
                g.drawLine(x, this.getHeight() - 2, xx - 1, this.getHeight() - 2);
            }
        }

        private void paintTimeMarkString(Graphics g, int currentMark, int optimalUnits, int x, int y) {
            int markStringMillisMargin = 0;
            int markStringMillisReduce = 2;
            Font markStringNoMillisFont = g.getFont();
            Font markStringMillisFont = markStringNoMillisFont.deriveFont((float)(markStringNoMillisFont.getSize() - 2));
            String markStringNoMillis = TimeLineUtils.getTimeMarkNoMillisString(currentMark, optimalUnits);
            int wMarkStringNoMillis = g.getFontMetrics().stringWidth(markStringNoMillis);
            String markStringMillis = TimeLineUtils.getTimeMarkMillisString(currentMark, optimalUnits);
            if (!markStringMillis.isEmpty()) {
                markStringMillis = "." + markStringMillis;
            }
            int xMarkStringNoMillis = x - wMarkStringNoMillis / 2 + 1;
            int xMarkStringMillis = xMarkStringNoMillis + wMarkStringNoMillis + markStringMillisMargin;
            g.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
            g.drawString(markStringNoMillis, xMarkStringNoMillis, y);
            g.setFont(markStringMillisFont);
            g.drawString(markStringMillis, xMarkStringMillis, y - markStringMillisReduce + 1);
            g.setFont(markStringNoMillisFont);
        }

        private void paintTimeMarks(Graphics g) {
            g.setFont(g.getFont().deriveFont(1));
            int firstValue = (int)(this.viewStart - this.dataStart);
            int lastValue = (int)(this.viewEnd - this.dataStart);
            int optimalUnits = TimeLineUtils.getOptimalUnits(this.factor);
            int firstMark = Math.max((int)(Math.ceil((double)firstValue / (double)optimalUnits) * (double)optimalUnits), 0);
            int componentFontSize = this.getFont().getSize();
            for (int currentMark = firstMark - optimalUnits; currentMark <= lastValue + optimalUnits; currentMark += optimalUnits) {
                if (currentMark < 0) continue;
                float currentMarkRel = currentMark - firstValue;
                int markPosition = (int)(currentMarkRel * this.factor) + 20;
                this.paintTimeTicks(g, (int)(currentMarkRel * this.factor) + 20, (int)((currentMarkRel + (float)optimalUnits) * this.factor) + 20, TimeLineUtils.getTicksCount(optimalUnits));
                g.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
                g.drawLine(markPosition, 0, markPosition, 4);
                this.paintTimeMarkString(g, currentMark, optimalUnits, markPosition, 5 + componentFontSize);
                g.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                g.drawLine(markPosition, 8 + componentFontSize, markPosition, this.getHeight() - 1);
            }
            Font origFont = g.getFont();
            Font plainFont = origFont.deriveFont(0);
            String sLegend = TimeLineUtils.getUnitsLegend(lastValue, optimalUnits);
            int wLegend = g.getFontMetrics(plainFont).stringWidth(sLegend);
            if (wLegend + 7 <= this.width) {
                g.setFont(plainFont);
                g.setColor(this.getBackground());
                g.fillRect(this.width - wLegend - 6 + 40, 5, wLegend + 7, 4 + plainFont.getSize());
                g.setColor(Color.BLACK);
                g.drawString(sLegend, this.width - wLegend - 2 + 40, 5 + plainFont.getSize());
                g.setFont(origFont);
            }
        }

        private void paintTimeTicks(Graphics g, int startPos, int endPos, int count) {
            float timeTicksFactor = (float)(endPos - startPos) / (float)count;
            for (int i = 1; i < count; ++i) {
                int x = startPos + (int)((float)i * timeTicksFactor);
                g.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
                g.drawLine(x, 0, x, 2);
                g.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
                g.drawLine(x, 3, x, this.getHeight() - 1);
            }
        }

        private void selectDescriptionAreaLines(int firstLine, int lastLine) {
            int offsetStart;
            if (firstLine < 0 || lastLine < 0) {
                return;
            }
            if (firstLine >= this.threadData.size() || lastLine >= this.threadData.size()) {
                return;
            }
            int n = offsetStart = this.threadData.getFirstState() == 0 ? 0 : 1;
            if (ThreadDetailsComponent.this.jTabbedPane1.getSelectedIndex() != 1) {
                ThreadDetailsComponent.this.jTabbedPane1.setSelectedIndex(1);
            }
            try {
                ThreadDetailsComponent.this.detailsArea.scrollRectToVisible(ThreadDetailsComponent.this.detailsArea.modelToView(ThreadDetailsComponent.this.detailsArea.getLineStartOffset(firstLine + offsetStart)));
                ThreadDetailsComponent.this.internalAdjustmentEvent = true;
                ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getLineStartOffset(firstLine + offsetStart));
                ThreadDetailsComponent.this.detailsArea.moveCaretPosition(ThreadDetailsComponent.this.detailsArea.getLineEndOffset(lastLine + offsetStart));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThreadDetailsComponent.this.detailsArea.requestFocus();
                    }
                });
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        private void updateData(ThreadData threadData, long dataStart, long dataEnd) {
            this.threadData = threadData != null ? threadData : new ThreadData(null, null);
            this.dataStart = dataStart;
            this.dataEnd = this.threadData.size() > 0 && this.threadData.getLastState() != 0 ? dataEnd : this.threadData.getLastTimeStamp();
            this.repaint();
        }
    }
}

