/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.EqualFlowLayout;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.SnippetPanel;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.ThreadsWindow;
import org.netbeans.modules.profiler.actions.HeapDumpAction;
import org.netbeans.modules.profiler.actions.ModifyProfilingAction;
import org.netbeans.modules.profiler.actions.RerunAction;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.RunGCAction;
import org.netbeans.modules.profiler.actions.ShowTelemetryViewAction;
import org.netbeans.modules.profiler.actions.StopAction;
import org.netbeans.modules.profiler.actions.TelemetryOverviewAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.Delegate;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ProfilerControlPanel2
extends ProfilerTopComponent
implements ProfilingStateListener {
    private static final Logger LOGGER = Logger.getLogger(ProfilerControlPanel2.class.getName());
    private static final String HELP_CTX_KEY = "ProfilerControlPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProfilerControlPanel.HelpCtx");
    private static final String RENAME_SNAPSHOT_HELP_CTX_KEY = "ProfilerControlPanel.RenameSnapshot.HelpCtx";
    private static final HelpCtx RENAME_SNAPSHOT_HELP_CTX = new HelpCtx("ProfilerControlPanel.RenameSnapshot.HelpCtx");
    private static ProfilerControlPanel2 defaultInstance;
    private static final Image windowIcon;
    private static final Icon cpuIcon;
    private static final Icon fragmentIcon;
    private static final Icon memoryIcon;
    private static final Icon heapDumpIcon;
    private static final Icon emptyIcon;
    private static final String ID = "profiler_cp";
    private static final Integer EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS;
    private static final Color CP_BACKGROUND_COLOR;
    private final BasicTelemetryPanel basicTelemetrySnippet;
    private final JScrollPane scrollPane;
    private final ResultsSnippetPanel resultsSnippet;
    private final SnapshotsPanel snapshotsSnippet;
    private final SnippetPanel spBasicTelemetry;
    private final SnippetPanel spControls;
    private final SnippetPanel spResults;
    private final SnippetPanel spSnapshots;
    private final SnippetPanel spStatus;
    private final SnippetPanel spView;
    private final StatusPanel statusSnippet;
    private boolean initialized = false;
    private Listener listener;

    public ProfilerControlPanel2() {
        this.setName(Bundle.LAB_ControlPanelName());
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_ControlPanelAcessDescr());
        this.setLayout(new BorderLayout());
        ControlsPanel controlsSnippet = new ControlsPanel();
        this.statusSnippet = new StatusPanel();
        ViewPanel viewSnippet = new ViewPanel();
        this.snapshotsSnippet = new SnapshotsPanel();
        this.resultsSnippet = new ResultsSnippetPanel();
        this.basicTelemetrySnippet = new BasicTelemetryPanel();
        SnippetPanel.Padding padding = new SnippetPanel.Padding();
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new VerticalLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.spControls = new SnippetPanel(Bundle.ProfilerControlPanel2_ControlsSnippetName(), (JComponent)controlsSnippet);
        scrollPanel.add((Component)this.spControls, gbc);
        this.spStatus = new SnippetPanel(Bundle.ProfilerControlPanel2_StatusSnippetName(), (JComponent)this.statusSnippet);
        scrollPanel.add((Component)this.spStatus, gbc);
        this.spResults = new SnippetPanel(Bundle.ProfilerControlPanel2_ResultsSnippetName(), (JComponent)this.resultsSnippet);
        scrollPanel.add((Component)this.spResults, gbc);
        this.spSnapshots = new SnippetPanel(Bundle.ProfilerControlPanel2_SnapshotsSnippetName(), (JComponent)this.snapshotsSnippet);
        scrollPanel.add((Component)this.spSnapshots, gbc);
        this.spView = new SnippetPanel(Bundle.ProfilerControlPanel2_ViewSnippetName(), (JComponent)viewSnippet);
        scrollPanel.add((Component)this.spView, gbc);
        this.spBasicTelemetry = new SnippetPanel(Bundle.ProfilerControlPanel2_TelemetrySnippetName(), (JComponent)this.basicTelemetrySnippet);
        scrollPanel.add((Component)this.spBasicTelemetry, gbc);
        gbc.weighty = 1.0;
        scrollPanel.add((Component)padding, gbc);
        this.scrollPane = new JScrollPane(scrollPanel, 20, 30);
        this.spControls.setBorder((Border)BorderFactory.createMatteBorder(2, 0, 0, 0, CP_BACKGROUND_COLOR));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setBackground(CP_BACKGROUND_COLOR);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        this.add(this.scrollPane, "Center");
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ProfilerControlPanel2.this.scrollPane.getVerticalScrollBar().setBlockIncrement((int)((float)ProfilerControlPanel2.this.scrollPane.getVerticalScrollBar().getModel().getExtent() * 0.95f));
                ProfilerControlPanel2.this.scrollPane.getHorizontalScrollBar().setBlockIncrement((int)((float)ProfilerControlPanel2.this.scrollPane.getHorizontalScrollBar().getModel().getExtent() * 0.95f));
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.listener = (Listener)Lookup.getDefault().lookup(Listener.class);
        this.listener.setDelegate((Object)this);
    }

    public static synchronized ProfilerControlPanel2 getDefault() {
        while (defaultInstance == null) {
            Runnable resolver = new Runnable(){

                @Override
                public void run() {
                    defaultInstance = (ProfilerControlPanel2)WindowManager.getDefault().findTopComponent(ProfilerControlPanel2.ID);
                    if (defaultInstance == null) {
                        defaultInstance = new ProfilerControlPanel2();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                resolver.run();
                break;
            }
            try {
                SwingUtilities.invokeAndWait(resolver);
            }
            catch (InterruptedException e) {
                ProfilerLogger.info((String)("InterruptedException in ProfilerControlPanel2.getDefault() [will retry]: " + e.getMessage()));
            }
            catch (Throwable t) {
                ProfilerLogger.severe((String)("Throwable in ProfilerControlPanel2.getDefault(): " + t.getMessage()));
                break;
            }
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setProfiledProject(Lookup.Provider project) {
        this.snapshotsSnippet.setDisplayedProject(project);
    }

    public String getToolTipText() {
        return Bundle.ProfilerControlPanel2_ControlPanelToolTip();
    }

    public static synchronized void closeIfOpened() {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (defaultInstance != null && defaultInstance.isOpened()) {
                    defaultInstance.close();
                }
            }
        });
    }

    public int getPersistenceType() {
        return 0;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.spControls;
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
        this.updateStatus();
    }

    public boolean needsDocking() {
        return WindowManager.getDefault().findMode((TopComponent)this) == null;
    }

    public void open() {
        Mode mode;
        if (this.needsDocking() && (mode = WindowManager.getDefault().findMode("explorer")) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (!this.initialized) {
            this.initialized = true;
            this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        }
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        this.updateStatus();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Integer version;
        super.readExternal(in);
        try {
            version = (Integer)in.readObject();
        }
        catch (Exception e) {
            ProfilerLogger.severe((String)("Error while deserializing Profiler CP2: " + e.getMessage()));
            LOGGER.log(Level.WARNING, null, e);
            return;
        }
        if (version.compareTo(EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS) > 0) {
            return;
        }
        this.spControls.setCollapsed(((Boolean)in.readObject()).booleanValue());
        this.spStatus.setCollapsed(((Boolean)in.readObject()).booleanValue());
        this.spResults.setCollapsed(((Boolean)in.readObject()).booleanValue());
        this.spView.setCollapsed(((Boolean)in.readObject()).booleanValue());
        this.spBasicTelemetry.setCollapsed(((Boolean)in.readObject()).booleanValue());
        if (version.equals(EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS)) {
            this.spSnapshots.setCollapsed(((Boolean)in.readObject()).booleanValue());
        }
    }

    public void refreshSnapshotsList() {
        if (this.snapshotsSnippet != null) {
            this.snapshotsSnippet.refreshList();
        }
    }

    public void threadsMonitoringChanged() {
        this.updateStatus();
    }

    public void updateStatus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilerControlPanel2.this.statusSnippet.refreshStatus();
                ProfilerControlPanel2.this.resultsSnippet.refreshStatus();
                ProfilerControlPanel2.this.basicTelemetrySnippet.refreshStatus();
            }
        });
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS);
        out.writeObject(this.spControls.isCollapsed());
        out.writeObject(this.spStatus.isCollapsed());
        out.writeObject(this.spResults.isCollapsed());
        out.writeObject(this.spView.isCollapsed());
        out.writeObject(this.spBasicTelemetry.isCollapsed());
        out.writeObject(this.spSnapshots.isCollapsed());
    }

    protected String preferredID() {
        return ID;
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowControlPanel");
        cpuIcon = Icons.getIcon((String)"ProfilerIcons.Cpu");
        fragmentIcon = Icons.getIcon((String)"ProfilerIcons.Fragment");
        memoryIcon = Icons.getIcon((String)"ProfilerIcons.Memory");
        heapDumpIcon = Icons.getIcon((String)"ProfilerIcons.HeapDump");
        emptyIcon = Icons.getIcon((String)"GeneralIcons.Empty");
        EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS = 3;
        CP_BACKGROUND_COLOR = UIUtils.getProfilerResultsBackground();
    }

    private static final class RenameSnapshotPanel
    extends JPanel {
        private JTextField textField;

        RenameSnapshotPanel() {
            this.initComponents();
        }

        String getSnapshotName() {
            return this.textField.getText().trim();
        }

        void setSnapshotName(String text) {
            this.textField.setText(text);
            this.textField.selectAll();
        }

        private void initComponents() {
            JLabel textLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)textLabel, (String)Bundle.ProfilerControlPanel2_NewFileNameLbl());
            textLabel.setAlignmentX(0.0f);
            this.textField = new JTextField();
            textLabel.setLabelFor(this.textField);
            this.textField.setPreferredSize(new Dimension(350, this.textField.getPreferredSize().height));
            this.textField.requestFocus();
            this.textField.setAlignmentX(0.0f);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(15, 10, 5, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)textLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 10, 15, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)this.textField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
        }
    }

    private static final class ViewPanel
    extends CPPanel
    implements ActionListener {
        private final JButton threadsButton;
        private final JButton vmTelemetryButton;

        ViewPanel() {
            this.setLayout((LayoutManager)new EqualFlowLayout(0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(7, 6, 8, 6));
            CompoundBorder myRolloverBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            this.vmTelemetryButton = new JButton(Bundle.ProfilerControlPanel2_TelemetryButtonName(), Icons.getIcon((String)"ProfilerIcons.ViewTelemetry32"));
            UIUtils.fixButtonUI((AbstractButton)this.vmTelemetryButton);
            this.vmTelemetryButton.addActionListener(this);
            this.vmTelemetryButton.setContentAreaFilled(false);
            this.vmTelemetryButton.setMargin(new Insets(1, 1, 1, 1));
            this.vmTelemetryButton.setVerticalTextPosition(3);
            this.vmTelemetryButton.setHorizontalTextPosition(0);
            this.vmTelemetryButton.setRolloverEnabled(true);
            this.vmTelemetryButton.setBorder(myRolloverBorder);
            this.vmTelemetryButton.setToolTipText(Bundle.ProfilerControlPanel2_TelemetryButtonToolTip());
            this.threadsButton = new JButton(Bundle.ProfilerControlPanel2_ThreadsButtonName(), Icons.getIcon((String)"ProfilerIcons.ViewThreads32"));
            UIUtils.fixButtonUI((AbstractButton)this.threadsButton);
            this.threadsButton.addActionListener(this);
            this.threadsButton.setContentAreaFilled(false);
            this.threadsButton.setMargin(new Insets(1, 1, 1, 1));
            this.threadsButton.setVerticalTextPosition(3);
            this.threadsButton.setHorizontalTextPosition(0);
            this.threadsButton.setRolloverEnabled(true);
            this.threadsButton.setBorder(myRolloverBorder);
            this.threadsButton.setToolTipText(Bundle.ProfilerControlPanel2_ThreadsButtonToolTip());
            this.add(this.vmTelemetryButton);
            this.add(this.threadsButton);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.vmTelemetryButton) {
                new ShowTelemetryViewAction().actionPerformed(null);
            } else if (e.getSource() == this.threadsButton) {
                ThreadsWindow.getDefault().showThreads();
            }
        }
    }

    private static final class StatusPanel
    extends CPPanel {
        private final JLabel modeValueLabel;
        private final JLabel onLabel;
        private final JLabel onValueLabel;
        private final JLabel profileValueLabel;
        private final JLabel statusValueLabel;
        private final JLabel typeValueLabel;
        private String configuration = null;
        private String host = null;
        private int count = 0;
        private int mode = -1;
        private int state = -1;

        StatusPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(8, 3, 9, 3));
            this.setLayout(new GridBagLayout());
            JLabel modeLabel = new JLabel(Bundle.ProfilerControlPanel2_ModeLabelString());
            modeLabel.setFont(modeLabel.getFont().deriveFont(1));
            JLabel typeLabel = new JLabel(Bundle.ProfilerControlPanel2_TypeLabelString());
            typeLabel.setFont(typeLabel.getFont().deriveFont(1));
            JLabel profileLabel = new JLabel(Bundle.ProfilerControlPanel2_ConfigLabelString());
            profileLabel.setFont(profileLabel.getFont().deriveFont(1));
            this.onLabel = new JLabel(Bundle.ProfilerControlPanel2_OnLabelString());
            this.onLabel.setFont(this.onLabel.getFont().deriveFont(1));
            JLabel statusLabel = new JLabel(Bundle.ProfilerControlPanel2_StatusLabelString());
            statusLabel.setFont(statusLabel.getFont().deriveFont(1));
            this.modeValueLabel = new JLabel(Bundle.ProfilerControlPanel2_NoConfigurationString());
            this.typeValueLabel = new JLabel(Bundle.ProfilerControlPanel2_NoConfigurationString());
            this.profileValueLabel = new JLabel(Bundle.ProfilerControlPanel2_NoConfigurationString());
            this.onValueLabel = new JLabel(Bundle.ProfilerControlPanel2_NoConfigurationString());
            this.statusValueLabel = new JLabel(Bundle.ProfilerControlPanel2_InactiveLabelString());
            GridBagConstraints labelGbc = new GridBagConstraints();
            labelGbc.anchor = 17;
            labelGbc.insets = new Insets(0, 10, 0, 10);
            GridBagConstraints valueGbc = new GridBagConstraints();
            valueGbc.anchor = 17;
            valueGbc.gridwidth = 0;
            valueGbc.insets = new Insets(0, 0, 0, 0);
            valueGbc.fill = 2;
            valueGbc.weightx = 1.0;
            this.add((Component)typeLabel, labelGbc);
            this.add((Component)this.typeValueLabel, valueGbc);
            this.add((Component)profileLabel, labelGbc);
            this.add((Component)this.profileValueLabel, valueGbc);
            this.add((Component)this.onLabel, labelGbc);
            this.add((Component)this.onValueLabel, valueGbc);
            this.add((Component)statusLabel, labelGbc);
            this.add((Component)this.statusValueLabel, valueGbc);
            this.onLabel.setVisible(false);
            this.onValueLabel.setVisible(false);
        }

        void refreshStatus() {
            int newState;
            String newHost;
            ProfilingSettings ps;
            if (this.mode != Profiler.getDefault().getProfilingMode()) {
                this.mode = Profiler.getDefault().getProfilingMode();
                if (this.mode == 0) {
                    this.modeValueLabel.setText(Bundle.ProfilerControlPanel2_AttachLabelString());
                } else {
                    this.modeValueLabel.setText(Bundle.ProfilerControlPanel2_ProfileLabelString());
                }
            }
            if (!((ps = Profiler.getDefault().getLastProfilingSettings()) == null || this.configuration != null && this.configuration.equals(ps.getSettingsName()))) {
                switch (ps.getProfilingType()) {
                    case 32: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_CodeFragmentLabelString());
                        break;
                    }
                    case 8: 
                    case 16: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_CpuLabelString());
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_MemoryLabelString());
                        break;
                    }
                    case 1: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_MonitorLabelString());
                    }
                }
                this.configuration = ps.getSettingsName();
                this.profileValueLabel.setText(this.configuration);
            }
            if ((newHost = Profiler.getDefault().getTargetAppRunner().getProfilerEngineSettings().getRemoteHost()) == null) {
                newHost = "";
            }
            if (this.host == null || !this.host.equals(newHost)) {
                this.host = newHost;
                if ("".equals(this.host)) {
                    this.onValueLabel.setText("");
                    this.onLabel.setVisible(false);
                    this.onValueLabel.setVisible(false);
                } else {
                    this.onValueLabel.setText(this.host);
                    this.onLabel.setVisible(true);
                    this.onValueLabel.setVisible(true);
                }
            }
            if (this.state != (newState = Profiler.getDefault().getProfilingState())) {
                this.state = newState;
                switch (this.state) {
                    case 1: {
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_InactiveLabelString());
                        break;
                    }
                    case 2: {
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_StartedLabelString());
                        this.count = 1;
                        break;
                    }
                    case 8: {
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_PausedLabelString());
                        break;
                    }
                    case 4: {
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_RunningLabelString());
                        break;
                    }
                    case 16: {
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_StoppedLabelString());
                    }
                }
            } else if (this.state == 2) {
                StringBuilder text = new StringBuilder(Bundle.ProfilerControlPanel2_StartingLabelString());
                for (int i = 0; i < this.count; ++i) {
                    text.append('.');
                }
                this.statusValueLabel.setText(text.toString());
                ++this.count;
                if (this.count == 5) {
                    this.count = 0;
                }
            }
        }
    }

    private static final class SnapshotsPanel
    extends CPPanel
    implements ListSelectionListener,
    ActionListener,
    ChangeListener {
        private DefaultListModel listModel;
        private JButton deleteButton;
        private JButton exportButton;
        private JButton renameButton;
        private JButton openButton;
        private JComboBox combo;
        private JList list;
        private Lookup.Provider displayedProject;
        private boolean internalChange = false;
        private static final RequestProcessor updater = new RequestProcessor("Snapshots Updater");
        private static final Object updaterSync = new Object();
        private boolean updating = false;
        private boolean dirty = false;

        SnapshotsPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.setLayout(new BorderLayout(6, 6));
            CompoundBorder buttonsBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY, Color.GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            LineBorder comboBorder = new LineBorder(Color.LIGHT_GRAY){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Color oldColor = g.getColor();
                    g.setColor(this.lineColor);
                    g.drawLine(x, y, x, height - 1);
                    g.setColor(oldColor);
                }
            };
            this.combo = new JComboBox(new DefaultComboBoxModel());
            this.combo.setRenderer(new ProjectNameRenderer());
            this.combo.getAccessibleContext().setAccessibleName(Bundle.ProfilerControlPanel2_ComboAccessName());
            this.combo.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_ComboAccessDescr());
            ComboBoxUI ui = this.combo.getUI();
            if (ui instanceof BasicComboBoxUI) {
                BasicComboBoxUI bui = (BasicComboBoxUI)ui;
                JComponent b = null;
                try {
                    Field f = BasicComboBoxUI.class.getDeclaredField("arrowButton");
                    f.setAccessible(true);
                    b = (JButton)f.get(bui);
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                if (b != null) {
                    b.setBackground(CP_BACKGROUND_COLOR);
                    b.setBorder(BorderFactory.createCompoundBorder(comboBorder, BorderFactory.createEmptyBorder(0, ((AbstractButton)b).getIconTextGap(), 0, ((AbstractButton)b).getIconTextGap())));
                }
            }
            this.combo.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            this.combo.setBackground(CP_BACKGROUND_COLOR);
            this.combo.addActionListener(this);
            ProjectUtilities.addOpenProjectsListener((ChangeListener)this);
            this.listModel = new DefaultListModel();
            this.list = new JList(this.listModel);
            this.list.getAccessibleContext().setAccessibleName(Bundle.ProfilerControlPanel2_ListAccessName());
            this.list.setVisibleRowCount(8);
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (isSelected && list.isEnabled()) {
                        this.setForeground(list.isFocusOwner() ? list.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
                        this.setBackground(list.isFocusOwner() ? list.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
                    } else if (!list.isEnabled()) {
                        this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                        this.setBackground(UIManager.getColor("TextField.inactiveBackground"));
                    } else {
                        this.setForeground(list.getForeground());
                        this.setBackground(list.getBackground());
                    }
                    if (value instanceof Snapshot) {
                        Snapshot s = (Snapshot)value;
                        FileObject fo = s.getFile();
                        if (s.isHeapDump()) {
                            Set tcs = WindowManager.getDefault().getRegistry().getOpened();
                            for (TopComponent tc : tcs) {
                                Object o = tc.getClientProperty((Object)"HeapDumpFileName");
                                if (o == null || !FileUtil.toFile((FileObject)fo).equals(new File(o.toString()))) continue;
                                c.setFont(c.getFont().deriveFont(1));
                                break;
                            }
                        } else {
                            LoadedSnapshot ls = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fo));
                            if (ls != null) {
                                c.setFont(c.getFont().deriveFont(1));
                            }
                        }
                        c.setText(s.getDisplayName());
                        c.setIcon(s.getIcon());
                    } else {
                        c.setText(value.toString());
                    }
                    return c;
                }
            });
            this.list.addListSelectionListener(this);
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        SnapshotsPanel.this.openSelectedSnapshots();
                    } else if (e.getKeyCode() == 127) {
                        final FileObject[] selectedSnapshotFiles = SnapshotsPanel.this.getSelectedSnapshotFiles();
                        if (selectedSnapshotFiles.length == 0) {
                            return;
                        }
                        if (ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerControlPanel2_ConfirmDeleteSnapshotMsg(), (String)Bundle.ProfilerControlPanel2_ConfirmDeleteSnapshotCaption())) {
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    SnapshotsPanel.this.deleteSnapshots(selectedSnapshotFiles);
                                    SnapshotsPanel.this.refreshList();
                                }
                            });
                        }
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        SnapshotsPanel.this.openSelectedSnapshots();
                    }
                }
            });
            this.add((Component)this.combo, "North");
            JScrollPane listScroll = new JScrollPane(this.list, 20, 31);
            listScroll.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            listScroll.setPreferredSize(new Dimension(1, listScroll.getPreferredSize().height));
            this.add((Component)listScroll, "Center");
            this.openButton = new JButton(Bundle.ProfilerControlPanel2_OpenButtonName());
            UIUtils.fixButtonUI((AbstractButton)this.openButton);
            this.openButton.setContentAreaFilled(false);
            this.openButton.setMargin(new Insets(3, 3, 3, 3));
            this.openButton.setRolloverEnabled(true);
            this.openButton.setBorder(buttonsBorder);
            this.openButton.addActionListener(this);
            this.openButton.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_OpenButtonAccessDescr());
            this.renameButton = new JButton(Bundle.ProfilerControlPanel2_RenameButtonName());
            UIUtils.fixButtonUI((AbstractButton)this.renameButton);
            this.renameButton.setContentAreaFilled(false);
            this.renameButton.setMargin(new Insets(3, 3, 3, 3));
            this.renameButton.setRolloverEnabled(true);
            this.renameButton.setBorder(buttonsBorder);
            this.renameButton.addActionListener(this);
            this.renameButton.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_RenameButtonAccessDescr());
            this.deleteButton = new JButton(Bundle.ProfilerControlPanel2_DeleteButtonName());
            UIUtils.fixButtonUI((AbstractButton)this.deleteButton);
            this.deleteButton.setContentAreaFilled(false);
            this.deleteButton.setMargin(new Insets(3, 3, 3, 3));
            this.deleteButton.setRolloverEnabled(true);
            this.deleteButton.setBorder(buttonsBorder);
            this.deleteButton.addActionListener(this);
            this.deleteButton.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_DeleteButtonAccessDescr());
            this.exportButton = new JButton(Bundle.ProfilerControlPanel2_ExportButtonName());
            UIUtils.fixButtonUI((AbstractButton)this.exportButton);
            this.exportButton.setContentAreaFilled(false);
            this.exportButton.setMargin(new Insets(3, 3, 3, 3));
            this.exportButton.setRolloverEnabled(true);
            this.exportButton.setBorder(buttonsBorder);
            this.exportButton.addActionListener(this);
            this.exportButton.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_ExportButtonAccessDescr());
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setOpaque(false);
            buttonsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 0, 4, 0);
            gbc.gridwidth = 0;
            buttonsPanel.add((Component)this.openButton, gbc);
            buttonsPanel.add((Component)this.renameButton, gbc);
            buttonsPanel.add((Component)this.deleteButton, gbc);
            buttonsPanel.add((Component)this.exportButton, gbc);
            gbc.weighty = 1.0;
            gbc.fill = 1;
            JPanel padding = new JPanel();
            padding.setOpaque(false);
            buttonsPanel.add((Component)padding, gbc);
            this.add((Component)buttonsPanel, "East");
            this.updateButtons();
            this.updateCombo();
            this.setDisplayedProject(ProjectUtilities.getMainProject());
        }

        public void setDisplayedProject(Lookup.Provider project) {
            this.displayedProject = project;
            this.list.clearSelection();
            this.refreshList();
            this.internalChange = true;
            if (project == null) {
                this.combo.setSelectedItem(Bundle.ProfilerControlPanel2_GlobalComboItemString());
            } else {
                this.combo.setSelectedItem(project);
            }
            this.internalChange = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.openButton) {
                this.openSelectedSnapshots();
            } else if (e.getSource() == this.renameButton) {
                this.renameSelectedSnapshot();
            } else if (e.getSource() == this.deleteButton) {
                final FileObject[] selectedSnapshotFiles = this.getSelectedSnapshotFiles();
                if (ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerControlPanel2_ConfirmDeleteSnapshotMsg(), (String)Bundle.ProfilerControlPanel2_ConfirmDeleteSnapshotCaption())) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotsPanel.this.deleteSnapshots(selectedSnapshotFiles);
                            SnapshotsPanel.this.refreshList();
                        }
                    });
                }
            } else if (e.getSource() == this.exportButton) {
                ResultsManager.getDefault().exportSnapshots(this.getSelectedSnapshotFiles());
            } else if (e.getSource() == this.combo && !this.internalChange) {
                Object o = this.combo.getSelectedItem();
                if (o instanceof Lookup.Provider) {
                    this.setDisplayedProject((Lookup.Provider)o);
                } else {
                    this.setDisplayedProject(null);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateCombo();
        }

        public void snapshotLoaded(LoadedSnapshot snapshot) {
            this.refreshList();
        }

        public void snapshotRemoved(LoadedSnapshot snapshot) {
            SnapshotResultsWindow.closeWindow(snapshot);
            this.refreshList();
        }

        public void snapshotSaved(LoadedSnapshot ls) {
            int idx;
            if (SnapshotResultsWindow.hasSnapshotWindow(ls)) {
                SnapshotResultsWindow.get(ls).updateTitle();
            }
            this.refreshList();
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)ls.getFile()));
            if (fo != null && (idx = this.listModel.indexOf(fo)) != -1) {
                this.list.ensureIndexIsVisible(idx);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateButtons();
        }

        private FileObject[] getSelectedSnapshotFiles() {
            Object[] sel = this.list.getSelectedValues();
            FileObject[] ret = new FileObject[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                ret[i] = ((Snapshot)sel[i]).getFile();
            }
            return ret;
        }

        private void deleteSnapshots(FileObject[] selectedSnapshots) {
            boolean success = true;
            for (int i = 0; i < selectedSnapshots.length; ++i) {
                FileObject selectedSnapshotFile = selectedSnapshots[i];
                try {
                    DataObject.find((FileObject)selectedSnapshotFile).delete();
                    continue;
                }
                catch (Throwable t) {
                    success = false;
                    t.printStackTrace();
                }
            }
            if (!success) {
                ProfilerDialogs.displayError((String)Bundle.ProfilerControlPanel2_SnapshotsNotDeletedMsg());
            }
        }

        private LoadedSnapshot[] loadSelectedSnapshots() {
            FileObject[] sel = this.getSelectedSnapshotFiles();
            return ResultsManager.getDefault().loadSnapshots(sel);
        }

        private void openSelectedSnapshots() {
            FileObject[] selectedSnapshotFiles = this.getSelectedSnapshotFiles();
            for (int i = 0; i < selectedSnapshotFiles.length; ++i) {
                final FileObject selectedSnapshotFile = selectedSnapshotFiles[i];
                String selectedSnapshotFileExt = selectedSnapshotFile.getExt();
                SnapshotResultsWindow srw = null;
                if (selectedSnapshotFileExt.equalsIgnoreCase("nps")) {
                    LoadedSnapshot ls = ResultsManager.getDefault().loadSnapshot(selectedSnapshotFile);
                    if (ls != null) {
                        srw = SnapshotResultsWindow.get(ls);
                        srw.open();
                    }
                } else if (selectedSnapshotFileExt.equalsIgnoreCase("hprof")) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ResultsManager.getDefault().openSnapshot(selectedSnapshotFile);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                }
                if (srw == null) continue;
                srw.requestActive();
            }
        }

        private void renameSelectedSnapshot() {
            FileObject[] selectedSnapshotFiles = this.getSelectedSnapshotFiles();
            if (selectedSnapshotFiles.length == 1) {
                final FileObject fileObject = selectedSnapshotFiles[0];
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String newName;
                        String origName = fileObject.getName();
                        RenameSnapshotPanel panel = new RenameSnapshotPanel();
                        panel.setSnapshotName(origName);
                        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.ProfilerControlPanel2_RenameSnapshotCaption(), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, RENAME_SNAPSHOT_HELP_CTX, null);
                        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                        d.setVisible(true);
                        if (dd.getValue() == DialogDescriptor.OK_OPTION && !origName.equals(newName = panel.getSnapshotName())) {
                            if (newName.length() == 0) {
                                ProfilerDialogs.displayError((String)Bundle.ProfilerControlPanel2_EmptyNameMsg());
                                SnapshotsPanel.this.renameSelectedSnapshot();
                            } else {
                                FileLock lock = null;
                                try {
                                    lock = fileObject.lock();
                                    LoadedSnapshot ls = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
                                    fileObject.rename(lock, newName, fileObject.getExt());
                                    if (ls != null) {
                                        ls.setFile(FileUtil.toFile((FileObject)fileObject));
                                    }
                                    ProfilerControlPanel2.getDefault().refreshSnapshotsList();
                                }
                                catch (IOException e) {
                                    ProfilerLogger.warning((String)("Failed to rename snapshot " + fileObject + " to " + newName + ": " + e.getMessage()));
                                    ProfilerDialogs.displayError((String)Bundle.ProfilerControlPanel2_RenameSnapshotFailedMsg(newName));
                                    SnapshotsPanel.this.renameSelectedSnapshot();
                                }
                                finally {
                                    if (lock != null) {
                                        lock.releaseLock();
                                    }
                                }
                            }
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshList() {
            Object object = updaterSync;
            synchronized (object) {
                if (this.updating) {
                    this.dirty = true;
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final List<Object> selection = Arrays.asList(SnapshotsPanel.this.list.getSelectedValues());
                    updater.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = updaterSync;
                            synchronized (object) {
                                SnapshotsPanel.this.dirty = false;
                                SnapshotsPanel.this.updating = true;
                            }
                            final ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
                            try {
                                for (FileObject fo : ResultsManager.getDefault().listSavedSnapshots(SnapshotsPanel.this.displayedProject, null)) {
                                    snapshots.add(new Snapshot(fo));
                                }
                                for (FileObject fo : ResultsManager.getDefault().listSavedHeapdumps(SnapshotsPanel.this.displayedProject, null)) {
                                    snapshots.add(new Snapshot(fo));
                                }
                            }
                            catch (Throwable t) {
                                LOGGER.log(Level.WARNING, null, t);
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    SnapshotsPanel.this.listModel.clear();
                                    for (int i = 0; i < snapshots.size(); ++i) {
                                        Snapshot s = (Snapshot)snapshots.get(i);
                                        SnapshotsPanel.this.listModel.addElement(s);
                                        if (!selection.contains(s)) continue;
                                        SnapshotsPanel.this.list.addSelectionInterval(i, i);
                                    }
                                    boolean refreshAgain = false;
                                    Object object = updaterSync;
                                    synchronized (object) {
                                        SnapshotsPanel.this.updating = false;
                                        if (SnapshotsPanel.this.dirty) {
                                            refreshAgain = true;
                                        }
                                    }
                                    if (refreshAgain) {
                                        SnapshotsPanel.this.refreshList();
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }

        private void updateButtons() {
            int[] selected = this.list.getSelectedIndices();
            this.openButton.setEnabled(selected.length > 0);
            this.renameButton.setEnabled(selected.length == 1);
            this.deleteButton.setEnabled(selected.length > 0);
            this.exportButton.setEnabled(selected.length > 0);
        }

        private void updateCombo() {
            Lookup.Provider[] projects = ProjectUtilities.getSortedProjects((Lookup.Provider[])ProjectUtilities.getOpenedProjects());
            ArrayList<Object> items = new ArrayList<Object>(projects.length + 1);
            items.addAll(Arrays.asList(projects));
            items.add(0, Bundle.ProfilerControlPanel2_GlobalComboItemString());
            DefaultComboBoxModel comboModel = (DefaultComboBoxModel)this.combo.getModel();
            comboModel.removeAllElements();
            for (Object e : items) {
                comboModel.addElement(e);
            }
            if (this.displayedProject != null && comboModel.getIndexOf(this.displayedProject) != -1) {
                this.internalChange = true;
                this.combo.setSelectedItem(this.displayedProject);
                this.internalChange = false;
            } else {
                Lookup.Provider mainProject = ProjectUtilities.getMainProject();
                this.setDisplayedProject(mainProject);
            }
        }

        private static class Snapshot {
            private FileObject fo;
            private String displayName;
            private Icon icon;
            private boolean isHeapDump;

            Snapshot(FileObject fo) {
                this.fo = fo;
                this.loadDetails();
            }

            public String getDisplayName() {
                return this.displayName;
            }

            public Icon getIcon() {
                return this.icon;
            }

            public FileObject getFile() {
                return this.fo;
            }

            public boolean isHeapDump() {
                return this.isHeapDump;
            }

            private void loadDetails() {
                if (this.fo.getExt().equalsIgnoreCase("hprof")) {
                    this.icon = heapDumpIcon;
                    this.displayName = ResultsManager.getDefault().getHeapDumpDisplayName(this.fo.getName());
                    this.isHeapDump = true;
                } else {
                    int snapshotType = ResultsManager.getDefault().getSnapshotType(this.fo);
                    this.displayName = ResultsManager.getDefault().getSnapshotDisplayName(this.fo.getName(), snapshotType);
                    this.icon = Snapshot.getIcon(snapshotType);
                    this.isHeapDump = false;
                }
            }

            private static Icon getIcon(int snapshotType) {
                switch (snapshotType) {
                    case 1: {
                        return cpuIcon;
                    }
                    case 2: {
                        return fragmentIcon;
                    }
                    case 4: 
                    case 8: {
                        return memoryIcon;
                    }
                }
                return null;
            }

            public boolean equals(Object o) {
                return this.fo.equals(((Snapshot)o).fo);
            }

            public int hashCode() {
                return this.fo.hashCode();
            }
        }
    }

    private static final class ResultsSnippetPanel
    extends CPPanel
    implements ActionListener {
        private static final int CPU = 1;
        private static final int MEMORY = 2;
        private static final int FRAGMENT = 3;
        private static final Icon TAKE_SNAPSHOT_CPU_ICON = Icons.getIcon((String)"ProfilerIcons.TakeSnapshotCpu32");
        private static final Icon TAKE_SNAPSHOT_MEMORY_ICON = Icons.getIcon((String)"ProfilerIcons.TakeSnapshotMemory32");
        private static final Icon TAKE_SNAPSHOT_FRAGMENT_ICON = Icons.getIcon((String)"ProfilerIcons.TakeSnapshotFragment32");
        private static final Icon TAKE_HEAP_DUMP_ICON = Icons.getIcon((String)"ProfilerIcons.TakeHeapDump32");
        private static final Icon LIVE_RESULTS_CPU_ICON = Icons.getIcon((String)"ProfilerIcons.ViewLiveResultsCpu32");
        private static final Icon LIVE_RESULTS_MEMORY_ICON = Icons.getIcon((String)"ProfilerIcons.ViewLiveResultsMemory32");
        private static final Icon LIVE_RESULTS_FRAGMENT_ICON = Icons.getIcon((String)"ProfilerIcons.ViewLiveResultsFragment32");
        private final JButton takeCPUSnapshotButton;
        private final JButton takeFragmentSnapshotButton;
        private final JButton takeMemorySnapshotButton;
        private final JButton takeHeapDumpButton;
        private final JPanel centerPanel;
        private JButton liveResultsButton;
        private LoadedSnapshot lastSnapshot;
        private int displayedIcon = 1;

        ResultsSnippetPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(7, 5, 8, 0));
            CompoundBorder myRolloverBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            this.takeCPUSnapshotButton = new JButton(Bundle.ProfilerControlPanel2_TakeSnapshotButtonName(), TAKE_SNAPSHOT_CPU_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeCPUSnapshotButton);
            this.takeCPUSnapshotButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeCPUSnapshotButton.getIcon()).getImage()))));
            this.takeCPUSnapshotButton.addActionListener(this);
            this.takeCPUSnapshotButton.setContentAreaFilled(false);
            this.takeCPUSnapshotButton.setMargin(new Insets(1, 2, 1, 2));
            this.takeCPUSnapshotButton.setVerticalTextPosition(3);
            this.takeCPUSnapshotButton.setHorizontalTextPosition(0);
            this.takeCPUSnapshotButton.setRolloverEnabled(true);
            this.takeCPUSnapshotButton.setBorder(myRolloverBorder);
            this.takeCPUSnapshotButton.setToolTipText(Bundle.ProfilerControlPanel2_TakeSnapshotButtonToolTip());
            this.takeMemorySnapshotButton = new JButton(Bundle.ProfilerControlPanel2_TakeSnapshotButtonName(), TAKE_SNAPSHOT_MEMORY_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeMemorySnapshotButton);
            this.takeMemorySnapshotButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeMemorySnapshotButton.getIcon()).getImage()))));
            this.takeMemorySnapshotButton.addActionListener(this);
            this.takeMemorySnapshotButton.setContentAreaFilled(false);
            this.takeMemorySnapshotButton.setMargin(new Insets(1, 2, 1, 2));
            this.takeMemorySnapshotButton.setVerticalTextPosition(3);
            this.takeMemorySnapshotButton.setHorizontalTextPosition(0);
            this.takeMemorySnapshotButton.setRolloverEnabled(true);
            this.takeMemorySnapshotButton.setBorder(myRolloverBorder);
            this.takeMemorySnapshotButton.setToolTipText(Bundle.ProfilerControlPanel2_TakeSnapshotButtonToolTip());
            this.takeHeapDumpButton = new JButton((Action)((Object)HeapDumpAction.getInstance()));
            this.takeHeapDumpButton.setText(Bundle.ProfilerControlPanel2_DumpHeapButtonName());
            this.takeHeapDumpButton.setIcon(TAKE_HEAP_DUMP_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeHeapDumpButton);
            this.takeHeapDumpButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeHeapDumpButton.getIcon()).getImage()))));
            this.takeHeapDumpButton.addActionListener(this);
            this.takeHeapDumpButton.setContentAreaFilled(false);
            this.takeHeapDumpButton.setMargin(new Insets(1, 2, 1, 2));
            this.takeHeapDumpButton.setVerticalTextPosition(3);
            this.takeHeapDumpButton.setHorizontalTextPosition(0);
            this.takeHeapDumpButton.setRolloverEnabled(true);
            this.takeHeapDumpButton.setBorder(myRolloverBorder);
            this.takeHeapDumpButton.setToolTipText(Bundle.ProfilerControlPanel2_TakeHeapDumpButtonToolTip());
            this.takeFragmentSnapshotButton = new JButton(Bundle.ProfilerControlPanel2_TakeSnapshotButtonName(), TAKE_SNAPSHOT_FRAGMENT_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeFragmentSnapshotButton);
            this.takeFragmentSnapshotButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeFragmentSnapshotButton.getIcon()).getImage()))));
            this.takeFragmentSnapshotButton.addActionListener(this);
            this.takeFragmentSnapshotButton.setContentAreaFilled(false);
            this.takeFragmentSnapshotButton.setMargin(new Insets(1, 2, 1, 2));
            this.takeFragmentSnapshotButton.setVerticalTextPosition(3);
            this.takeFragmentSnapshotButton.setHorizontalTextPosition(0);
            this.takeFragmentSnapshotButton.setRolloverEnabled(true);
            this.takeFragmentSnapshotButton.setBorder(myRolloverBorder);
            this.takeFragmentSnapshotButton.setToolTipText(Bundle.ProfilerControlPanel2_TakeSnapshotButtonToolTip());
            this.liveResultsButton = new JButton(Bundle.ProfilerControlPanel2_LiveResultsButtonName(), LIVE_RESULTS_CPU_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.liveResultsButton);
            this.liveResultsButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.liveResultsButton.getIcon()).getImage()))));
            this.liveResultsButton.addActionListener(this);
            this.liveResultsButton.setContentAreaFilled(false);
            this.liveResultsButton.setMargin(new Insets(1, 2, 1, 2));
            this.liveResultsButton.setVerticalTextPosition(3);
            this.liveResultsButton.setHorizontalTextPosition(0);
            this.liveResultsButton.setRolloverEnabled(true);
            this.liveResultsButton.setBorder(myRolloverBorder);
            this.liveResultsButton.setToolTipText(Bundle.ProfilerControlPanel2_LiveResultsButtonToolTip());
            this.displayedIcon = 1;
            this.centerPanel = new JPanel();
            this.centerPanel.setOpaque(false);
            this.centerPanel.setLayout(new FlowLayout(0, 0, 0));
            this.centerPanel.add(this.takeCPUSnapshotButton);
            this.centerPanel.add(this.takeHeapDumpButton);
            this.centerPanel.add(this.liveResultsButton);
            this.add((Component)this.centerPanel, "Center");
            this.refreshStatus();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.takeCPUSnapshotButton || e.getSource() == this.takeFragmentSnapshotButton) {
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ResultsManager.getDefault().takeSnapshot();
                    }
                });
            } else if (e.getSource() == this.takeMemorySnapshotButton) {
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ResultsManager.getDefault().takeSnapshot();
                    }
                });
            } else if (e.getSource() == this.liveResultsButton) {
                LiveResultsWindow.getDefault().open();
                LiveResultsWindow.getDefault().requestActive();
                LiveResultsWindow.getDefault().refreshLiveResults();
            }
        }

        public void refreshStatus() {
            int newMode;
            this.updateResultsButtons();
            int state = Profiler.getDefault().getProfilingState();
            int instr = state != 1 ? Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType() : 0;
            switch (instr) {
                case 1: {
                    newMode = 3;
                    break;
                }
                case 5: 
                case 6: {
                    newMode = 2;
                    break;
                }
                default: {
                    newMode = 1;
                }
            }
            if (this.displayedIcon != newMode) {
                this.displayedIcon = newMode;
                this.centerPanel.remove(this.centerPanel.getComponent(0));
                if (newMode == 1) {
                    this.centerPanel.add((Component)this.takeCPUSnapshotButton, 0);
                    this.liveResultsButton.setIcon(LIVE_RESULTS_CPU_ICON);
                } else if (newMode == 2) {
                    this.centerPanel.add((Component)this.takeMemorySnapshotButton, 0);
                    this.liveResultsButton.setIcon(LIVE_RESULTS_MEMORY_ICON);
                } else {
                    this.centerPanel.add((Component)this.takeFragmentSnapshotButton, 0);
                    this.liveResultsButton.setIcon(LIVE_RESULTS_FRAGMENT_ICON);
                }
                this.liveResultsButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.liveResultsButton.getIcon()).getImage()))));
            }
        }

        public void resultsAvailable() {
            this.updateResultsButtons();
        }

        public void resultsReset() {
            this.updateResultsButtons();
        }

        private void updateResultsButtons() {
            int state = Profiler.getDefault().getProfilingState();
            int instr = state != 1 ? Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType() : 0;
            boolean enabled = state == 8 || state == 4;
            enabled = enabled && instr != 0;
            this.liveResultsButton.setEnabled(enabled);
            boolean dataAvailable = ResultsManager.getDefault().resultsAvailable();
            this.takeCPUSnapshotButton.setEnabled(enabled && dataAvailable);
            this.takeMemorySnapshotButton.setEnabled(enabled && dataAvailable);
            this.takeFragmentSnapshotButton.setEnabled(enabled && dataAvailable);
        }

        public void snapshotRemoved(LoadedSnapshot snapshot) {
            if (this.lastSnapshot == snapshot) {
                this.lastSnapshot = null;
            }
        }

        public void snapshotTaken(LoadedSnapshot ls) {
            this.lastSnapshot = ls;
            if (ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                int sortingColumn = LiveResultsWindow.hasDefault() ? LiveResultsWindow.getDefault().getSortingColumn() : -1;
                boolean sortingOrder = LiveResultsWindow.hasDefault() ? LiveResultsWindow.getDefault().getSortingOrder() : false;
                ResultsManager.getDefault().openSnapshot(ls, sortingColumn, sortingOrder);
            }
            if (ProfilerIDESettings.getInstance().getAutoSaveSnapshot()) {
                ResultsManager.getDefault().saveSnapshot(ls);
            }
        }
    }

    private static final class ProjectNameRenderer
    extends DefaultListCellRenderer {
        private Renderer renderer = new Renderer();
        private boolean firstFontSet = false;

        private ProjectNameRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel rendererOrig = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.renderer.setComponentOrientation(rendererOrig.getComponentOrientation());
            this.renderer.setFontEx(rendererOrig.getFont());
            this.renderer.setOpaque(rendererOrig.isOpaque());
            this.renderer.setForeground(rendererOrig.getForeground());
            this.renderer.setBackground(rendererOrig.getBackground());
            this.renderer.setEnabled(rendererOrig.isEnabled());
            this.renderer.setBorder(rendererOrig.getBorder());
            if (value != null && value instanceof Lookup.Provider) {
                Lookup.Provider p = (Lookup.Provider)value;
                this.renderer.setText(ProjectUtilities.getDisplayName((Lookup.Provider)p));
                this.renderer.setIcon(ProjectUtilities.getIcon((Lookup.Provider)p));
                if (ProjectUtilities.getMainProject() == value) {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(1));
                } else {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(0));
                }
            } else {
                this.renderer.setText(rendererOrig.getText());
                this.renderer.setIcon(emptyIcon);
            }
            return this.renderer;
        }

        private static class Renderer
        extends DefaultListCellRenderer {
            private Renderer() {
            }

            @Override
            public void setFont(Font font) {
            }

            public void setFontEx(Font font) {
                super.setFont(font);
            }
        }
    }

    private static final class ControlsPanel
    extends CPPanel {
        ControlsPanel() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            CompoundBorder myRolloverBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            JButton rerunButton = new JButton((Action)SystemAction.get(RerunAction.class));
            rerunButton.setText(null);
            UIUtils.fixButtonUI((AbstractButton)rerunButton);
            rerunButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)rerunButton.getIcon()).getImage()))));
            rerunButton.setContentAreaFilled(false);
            rerunButton.setMargin(new Insets(3, 3, 3, 3));
            rerunButton.setRolloverEnabled(true);
            rerunButton.setBorder(myRolloverBorder);
            this.add(rerunButton);
            JButton stopButton = new JButton((Action)((Object)StopAction.getInstance())){

                @Override
                public void setText(String text) {
                }

                @Override
                public void setIcon(Icon icon) {
                    super.setIcon(icon);
                    this.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.getIcon()).getImage()))));
                }
            };
            UIUtils.fixButtonUI((AbstractButton)stopButton);
            stopButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)stopButton.getIcon()).getImage()))));
            stopButton.setContentAreaFilled(false);
            stopButton.setMargin(new Insets(3, 3, 3, 3));
            stopButton.setRolloverEnabled(true);
            stopButton.setBorder(myRolloverBorder);
            this.add(stopButton);
            JButton resetButton = new JButton((Action)((Object)ResetResultsAction.getInstance()));
            resetButton.setText(null);
            UIUtils.fixButtonUI((AbstractButton)resetButton);
            resetButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)resetButton.getIcon()).getImage()))));
            resetButton.setContentAreaFilled(false);
            resetButton.setMargin(new Insets(3, 3, 3, 3));
            resetButton.setRolloverEnabled(true);
            resetButton.setBorder(myRolloverBorder);
            this.add(resetButton);
            JButton rungcButton = new JButton((Action)((Object)RunGCAction.getInstance()));
            rungcButton.setText(null);
            UIUtils.fixButtonUI((AbstractButton)rungcButton);
            rungcButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)rungcButton.getIcon()).getImage()))));
            rungcButton.setContentAreaFilled(false);
            rungcButton.setMargin(new Insets(3, 3, 3, 3));
            rungcButton.setRolloverEnabled(true);
            rungcButton.setBorder(myRolloverBorder);
            this.add(rungcButton);
            JButton modifyButton = new JButton((Action)((Object)ModifyProfilingAction.getInstance()));
            modifyButton.setText(null);
            UIUtils.fixButtonUI((AbstractButton)modifyButton);
            modifyButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)modifyButton.getIcon()).getImage()))));
            modifyButton.setContentAreaFilled(false);
            modifyButton.setMargin(new Insets(3, 3, 3, 3));
            modifyButton.setRolloverEnabled(true);
            modifyButton.setBorder(myRolloverBorder);
            this.add(modifyButton);
            JButton telemetryButton = new JButton(TelemetryOverviewAction.getInstance());
            telemetryButton.setText(null);
            UIUtils.fixButtonUI((AbstractButton)telemetryButton);
            telemetryButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)telemetryButton.getIcon()).getImage()))));
            telemetryButton.setContentAreaFilled(false);
            telemetryButton.setMargin(new Insets(3, 3, 3, 3));
            telemetryButton.setRolloverEnabled(true);
            telemetryButton.setBorder(myRolloverBorder);
            this.add(telemetryButton);
        }
    }

    private static class CPPanel
    extends JPanel {
        CPPanel() {
            this.setOpaque(true);
            this.setBackground(CP_BACKGROUND_COLOR);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
    }

    private static final class BasicTelemetryPanel
    extends CPPanel {
        private final JLabel instrFilterValueLabel;
        private final JLabel instrValueLabel;
        private final JLabel relTimeValueLabel;
        private final JLabel threadsValueLabel;
        private final JLabel totalMemValueLabel;
        private final JLabel typeValueLabel;
        private final JLabel usedMemValueLabel;
        private final NumberFormat intFormat;
        private final NumberFormat percentFormat = NumberFormat.getPercentInstance();
        private String savedInstrFilterText = "";
        private String savedInstrText = "";
        private boolean inactive = true;

        BasicTelemetryPanel() {
            this.percentFormat.setMinimumFractionDigits(1);
            this.percentFormat.setMaximumIntegerDigits(2);
            this.intFormat = NumberFormat.getIntegerInstance();
            this.intFormat.setGroupingUsed(true);
            this.setBorder(BorderFactory.createEmptyBorder(8, 3, 9, 3));
            this.setLayout(new GridBagLayout());
            JLabel instrLabel = new JLabel(Bundle.ProfilerControlPanel2_InstrumentedLabelString());
            instrLabel.setFont(instrLabel.getFont().deriveFont(1));
            JLabel instrFilterLabel = new JLabel(Bundle.ProfilerControlPanel2_FilterLabelString());
            instrFilterLabel.setFont(instrFilterLabel.getFont().deriveFont(1));
            JLabel threadsLabel = new JLabel(Bundle.ProfilerControlPanel2_ThreadsLabelString());
            threadsLabel.setFont(threadsLabel.getFont().deriveFont(1));
            JLabel typeLabel = new JLabel(Bundle.ProfilerControlPanel2_TypeLabelString());
            typeLabel.setFont(typeLabel.getFont().deriveFont(1));
            JLabel totalMemLabel = new JLabel(Bundle.ProfilerControlPanel2_TotalMemoryLabelString());
            totalMemLabel.setFont(totalMemLabel.getFont().deriveFont(1));
            JLabel usedMemLabel = new JLabel(Bundle.ProfilerControlPanel2_UsedMemoryLabelString());
            usedMemLabel.setFont(usedMemLabel.getFont().deriveFont(1));
            JLabel relTimeLabel = new JLabel(Bundle.ProfilerControlPanel2_GcTimeLabelString());
            relTimeLabel.setFont(relTimeLabel.getFont().deriveFont(1));
            this.instrValueLabel = new JLabel(this.savedInstrText);
            this.instrFilterValueLabel = new JLabel("");
            this.threadsValueLabel = new JLabel("");
            this.typeValueLabel = new JLabel("");
            this.totalMemValueLabel = new JLabel("");
            this.usedMemValueLabel = new JLabel("");
            this.relTimeValueLabel = new JLabel("");
            GridBagConstraints labelGbc = new GridBagConstraints();
            labelGbc.anchor = 17;
            labelGbc.insets = new Insets(0, 10, 0, 10);
            GridBagConstraints valueGbc = new GridBagConstraints();
            valueGbc.anchor = 17;
            valueGbc.gridwidth = 0;
            valueGbc.insets = new Insets(0, 0, 0, 0);
            valueGbc.fill = 2;
            valueGbc.weightx = 1.0;
            this.add((Component)instrLabel, labelGbc);
            this.add((Component)this.instrValueLabel, valueGbc);
            this.add((Component)instrFilterLabel, labelGbc);
            this.add((Component)this.instrFilterValueLabel, valueGbc);
            this.add((Component)threadsLabel, labelGbc);
            this.add((Component)this.threadsValueLabel, valueGbc);
            this.add((Component)totalMemLabel, labelGbc);
            this.add((Component)this.totalMemValueLabel, valueGbc);
            this.add((Component)usedMemLabel, labelGbc);
            this.add((Component)this.usedMemValueLabel, valueGbc);
            this.add((Component)relTimeLabel, labelGbc);
            this.add((Component)this.relTimeValueLabel, valueGbc);
        }

        void refreshStatus() {
            int state = Profiler.getDefault().getProfilingState();
            TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
            String instrStatusText = "";
            if (state != 1) {
                int currentInstrType = targetAppRunner.getProfilingSessionStatus().currentInstrType;
                switch (currentInstrType) {
                    case 1: {
                        instrStatusText = Bundle.ProfilerControlPanel2_NoLinesCodeRegionMsg(targetAppRunner.getProfilingSessionStatus().instrEndLine - targetAppRunner.getProfilingSessionStatus().instrStartLine);
                        break;
                    }
                    case 3: 
                    case 4: {
                        int nMethods = targetAppRunner.getProfilingSessionStatus().getNInstrMethods();
                        if (nMethods > 0) {
                            --nMethods;
                        }
                        instrStatusText = Bundle.ProfilerControlPanel2_NoMethodsMsg(nMethods);
                        break;
                    }
                    case 5: 
                    case 6: {
                        int nClasses = targetAppRunner.getProfilingSessionStatus().getNInstrClasses();
                        instrStatusText = Bundle.ProfilerControlPanel2_NoClassesMsg(nClasses);
                        break;
                    }
                    case 0: 
                    case 2: {
                        instrStatusText = Bundle.ProfilerControlPanel2_NothingInstrumentedMsg();
                    }
                }
            }
            if (this.savedInstrText == null || !this.savedInstrText.equals(instrStatusText)) {
                this.savedInstrText = instrStatusText;
                this.instrValueLabel.setText(this.savedInstrText);
            }
            String filterText = "";
            switch (state) {
                case 1: {
                    if (this.inactive) {
                        return;
                    }
                    this.inactive = true;
                    this.threadsValueLabel.setText("");
                    this.totalMemValueLabel.setText("");
                    this.usedMemValueLabel.setText("");
                    this.relTimeValueLabel.setText("");
                    this.typeValueLabel.setText("");
                    break;
                }
                default: {
                    this.inactive = false;
                    MonitoredData data = Profiler.getDefault().getVMTelemetryManager().getLastData();
                    if (data != null) {
                        this.threadsValueLabel.setText("" + this.intFormat.format(data.getNUserThreads() + data.getNSystemThreads()));
                        this.totalMemValueLabel.setText("" + this.intFormat.format(data.getTotalMemory()) + " B");
                        this.usedMemValueLabel.setText("" + this.intFormat.format(data.getTotalMemory() - data.getFreeMemory()) + " B");
                        this.relTimeValueLabel.setText("" + this.percentFormat.format((float)data.getRelativeGCTimeInPerMil() / 1000.0f));
                        this.typeValueLabel.setText("");
                        filterText = Profiler.getDefault().getLastProfilingSettings().getSelectedInstrumentationFilter().toString();
                        break;
                    }
                    this.threadsValueLabel.setText("");
                    this.totalMemValueLabel.setText("");
                    this.usedMemValueLabel.setText("");
                    this.relTimeValueLabel.setText("");
                    this.typeValueLabel.setText("");
                }
            }
            if (this.savedInstrFilterText == null || !this.savedInstrFilterText.equals(filterText)) {
                this.savedInstrFilterText = filterText;
                this.instrFilterValueLabel.setText(this.savedInstrFilterText);
            }
        }
    }

    public static final class WhiteFilter
    extends RGBImageFilter {
        private final float[] hsv = new float[3];

        public WhiteFilter() {
            this.canFilterIndexColorModel = true;
        }

        public static Image createDisabledImage(Image i) {
            WhiteFilter filter = new WhiteFilter();
            FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
            return Toolkit.getDefaultToolkit().createImage(prod);
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int transparency = rgb >> 24 & 0xFF;
            if (transparency <= 1) {
                return rgb;
            }
            Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb >> 0 & 0xFF, this.hsv);
            this.hsv[1] = 0.0f;
            return Color.HSBtoRGB(this.hsv[0], this.hsv[1], this.hsv[2]) + ((transparency /= 2) << 24);
        }
    }

    public static final class VerticalLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int posX = insets.left;
            int posY = insets.top;
            int width = parent.getWidth() - insets.left - insets.right;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!comp.isVisible()) continue;
                int height = comp.getPreferredSize().height;
                if (i == comps.length - 1 && posY + height < parent.getHeight() - insets.bottom) {
                    height = parent.getHeight() - insets.bottom - posY;
                }
                comp.setBounds(posX, posY, width, height);
                posY += height;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension d = new Dimension(parent.getInsets().left + parent.getInsets().right, parent.getInsets().top + parent.getInsets().bottom);
            int maxWidth = 0;
            int height = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!comp.isVisible()) continue;
                Dimension size = comp.getMinimumSize();
                maxWidth = Math.max(maxWidth, size.width);
                height += size.height;
            }
            d.width += maxWidth;
            d.height += height;
            return d;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension(parent.getInsets().left + parent.getInsets().right, parent.getInsets().top + parent.getInsets().bottom);
            int maxWidth = 0;
            int height = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!comp.isVisible()) continue;
                Dimension size = comp.getPreferredSize();
                maxWidth = Math.max(maxWidth, size.width);
                height += size.height;
            }
            d.width += maxWidth;
            d.height += height;
            return d;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    public static final class Listener
    extends Delegate<ProfilerControlPanel2>
    implements SnapshotsListener,
    ResultsListener {
        @Override
        public void resultsAvailable() {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.resultsAvailable();
            }
        }

        @Override
        public void resultsReset() {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.resultsReset();
            }
        }

        @Override
        public void snapshotLoaded(LoadedSnapshot snapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).snapshotsSnippet.snapshotLoaded(snapshot);
            }
        }

        @Override
        public void snapshotRemoved(LoadedSnapshot snapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.snapshotRemoved(snapshot);
            }
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).snapshotsSnippet.snapshotRemoved(snapshot);
            }
        }

        @Override
        public void snapshotSaved(LoadedSnapshot snapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).snapshotsSnippet.snapshotSaved(snapshot);
            }
        }

        @Override
        public void snapshotTaken(LoadedSnapshot snapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.snapshotTaken(snapshot);
            }
        }
    }
}

