/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.ui.ResultsView;
import org.netbeans.lib.profiler.ui.threads.ThreadsDetailsPanel;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;
import org.netbeans.lib.profiler.ui.threads.ThreadsTablePanel;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;

public final class ThreadsWindow
extends ProfilerTopComponent
implements ProfilingStateListener,
ActionListener,
ChangeListener,
SaveViewAction.ViewProvider {
    private static final String HELP_CTX_KEY = "ThreadsWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ThreadsWindow.HelpCtx");
    private static ThreadsWindow defaultInstance;
    private static final Image windowIcon;
    private final JPanel threadsTimelinePanelContainer;
    private final ResultsView threadsView;
    private final ThreadsPanel threadsPanel;
    private final ThreadsTablePanel threadsTablePanel;
    private JPanel threadsDetailsPanelContainer;
    private ThreadsDetailsPanel threadsDetailsPanel;

    public ThreadsWindow() {
        this.setName(Bundle.ThreadsWindow_ThreadsWindowName());
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(Bundle.ThreadsWindow_ThreadsAccessDescr());
        this.setLayout(new BorderLayout());
        this.threadsView = new ResultsView();
        this.add((Component)this.threadsView, "Center");
        boolean tvmSupportsSleepingState = Platform.supportsThreadSleepingStateMonitoring((String)Profiler.getDefault().getTargetAppRunner().getProfilerEngineSettings().getTargetJDKVersionString());
        this.threadsPanel = new ThreadsPanel(Profiler.getDefault().getThreadsManager(), new ThreadsPanel.ThreadsDetailsCallback(){

            public void showDetails(int[] indexes) {
                ThreadsWindow.this.threadsDetailsPanel.showDetails(indexes);
                ThreadsWindow.this.threadsView.selectView((Component)ThreadsWindow.this.threadsDetailsPanelContainer);
            }
        }, tvmSupportsSleepingState);
        this.threadsTimelinePanelContainer = new JPanel(){

            @Override
            public void requestFocus() {
                ThreadsWindow.this.threadsPanel.requestFocus();
            }
        };
        this.threadsTimelinePanelContainer.setLayout(new BorderLayout());
        this.threadsTimelinePanelContainer.add((Component)this.threadsPanel, "Center");
        this.threadsPanel.addThreadsMonitoringActionListener((ActionListener)this);
        this.threadsPanel.addSaveViewAction((AbstractAction)new SaveViewAction(this));
        this.threadsTablePanel = new ThreadsTablePanel(Profiler.getDefault().getThreadsManager(), new ThreadsTablePanel.ThreadsDetailsCallback(){

            public void showDetails(int[] indexes) {
                ThreadsWindow.this.threadsDetailsPanel.showDetails(indexes);
                ThreadsWindow.this.threadsView.selectView((Component)ThreadsWindow.this.threadsDetailsPanelContainer);
            }
        }, tvmSupportsSleepingState);
        this.threadsTablePanel.addSaveViewAction((AbstractAction)new SaveViewAction(this));
        this.threadsDetailsPanel = new ThreadsDetailsPanel(Profiler.getDefault().getThreadsManager(), tvmSupportsSleepingState);
        this.threadsDetailsPanelContainer = new JPanel(){

            @Override
            public void requestFocus() {
                ThreadsWindow.this.threadsDetailsPanel.requestFocus();
            }
        };
        this.threadsDetailsPanelContainer.setLayout(new BorderLayout());
        this.threadsDetailsPanelContainer.add((Component)this.threadsDetailsPanel, "Center");
        this.threadsDetailsPanel.addSaveViewAction((AbstractAction)new SaveViewAction(this));
        this.threadsView.addView(Bundle.ThreadsWindow_ThreadsTimelineTabName(), null, Bundle.ThreadsWindow_ThreadsTimelineTabDescr(), (Component)this.threadsTimelinePanelContainer, this.threadsPanel.getToolbar());
        this.threadsView.addView(Bundle.ThreadsWindow_ThreadsTableTabName(), null, Bundle.ThreadsWindow_ThreadsTableTabDescr(), (Component)this.threadsTablePanel, this.threadsTablePanel.getToolbar());
        this.threadsView.addView(Bundle.ThreadsWindow_ThreadsDetailsTabName(), null, Bundle.ThreadsWindow_ThreadsDetailsTabDescr(), (Component)this.threadsDetailsPanelContainer, this.threadsDetailsPanel.getToolbar());
        this.profilingStateChanged(Profiler.getDefault().getProfilingState());
        this.threadsMonitoringChanged();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.threadsView.addChangeListener((ChangeListener)this);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public static ThreadsWindow getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ThreadsWindow();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Profiler.getDefault().setThreadsMonitoringEnabled(true);
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        Component selectedView = this.threadsView.getSelectedView();
        if (selectedView == this.threadsTimelinePanelContainer) {
            return this.threadsPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (selectedView == this.threadsTablePanel) {
            return this.threadsTablePanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (selectedView == this.threadsDetailsPanelContainer) {
            return this.threadsDetailsPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        return null;
    }

    @Override
    public String getViewName() {
        Component selectedView = this.threadsView.getSelectedView();
        if (selectedView == this.threadsTimelinePanelContainer) {
            return "threads-timeline";
        }
        if (selectedView == this.threadsTablePanel) {
            return "threads-table";
        }
        if (selectedView == this.threadsDetailsPanelContainer) {
            return "threads-details";
        }
        return null;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.threadsPanel;
    }

    @Override
    public boolean fitsVisibleArea() {
        Component selectedView = this.threadsView.getSelectedView();
        if (selectedView == this.threadsTimelinePanelContainer) {
            return this.threadsPanel.fitsVisibleArea();
        }
        if (selectedView == this.threadsTablePanel) {
            return this.threadsTablePanel.fitsVisibleArea();
        }
        if (selectedView == this.threadsDetailsPanelContainer) {
            return this.threadsDetailsPanel.fitsVisibleArea();
        }
        return true;
    }

    @Override
    public boolean hasView() {
        Component selectedView = this.threadsView.getSelectedView();
        if (selectedView == this.threadsTimelinePanelContainer) {
            return this.threadsPanel.hasView();
        }
        if (selectedView == this.threadsTablePanel) {
            return this.threadsTablePanel.hasView();
        }
        if (selectedView == this.threadsDetailsPanelContainer) {
            return this.threadsDetailsPanel.hasView();
        }
        return false;
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        this.profilingStateChanged(e.getNewState());
    }

    public void showThreads() {
        this.threadsView.selectView((Component)this.threadsTimelinePanelContainer);
        this.open();
        this.requestActive();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component selectedView = ThreadsWindow.this.threadsView.getSelectedView();
                if (selectedView != null) {
                    selectedView.requestFocus();
                }
            }
        });
    }

    public void threadsMonitoringChanged() {
        if (Profiler.getDefault().getThreadsMonitoringEnabled()) {
            this.threadsPanel.threadsMonitoringEnabled();
            this.threadsView.setViewEnabled((Component)this.threadsTablePanel, true);
            this.threadsView.setViewEnabled((Component)this.threadsDetailsPanelContainer, true);
        } else {
            this.threadsPanel.threadsMonitoringDisabled();
            this.threadsView.selectView((Component)this.threadsTimelinePanelContainer);
            this.threadsView.setViewEnabled((Component)this.threadsTablePanel, false);
            this.threadsView.setViewEnabled((Component)this.threadsDetailsPanelContainer, false);
        }
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    private void profilingStateChanged(boolean enable) {
        if (enable) {
            this.threadsPanel.profilingSessionStarted();
        } else {
            this.threadsPanel.profilingSessionFinished();
        }
    }

    private void profilingStateChanged(int profilingState) {
        if (profilingState == 4) {
            this.profilingStateChanged(true);
        } else {
            this.profilingStateChanged(false);
        }
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowThreads");
    }
}

