/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public final class ManualMethodSelect
extends JPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "ManualMethodSelect.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ManualMethodSelect.HelpCtx");
    private static ManualMethodSelect mms;
    private static JButton okButton;
    private HTMLTextArea hintArea;
    private JTextField className;
    private JTextField methodName;
    private JTextField methodSignature;
    private MethodSelectDocumentListener documentListener = new MethodSelectDocumentListener();

    private ManualMethodSelect() {
        JLabel classNameLabel = new JLabel();
        this.className = new JTextField();
        JLabel methodNameLabel = new JLabel();
        this.methodName = new JTextField();
        JLabel methodSignatureLabel = new JLabel();
        this.methodSignature = new JTextField();
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.setLayout(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 0, 0);
        labelConstraints.anchor = 17;
        fieldConstraints.insets = new Insets(5, 5, 0, 0);
        fieldConstraints.weightx = 1.0;
        fieldConstraints.fill = 2;
        classNameLabel.setLabelFor(this.className);
        Mnemonics.setLocalizedText((JLabel)classNameLabel, (String)Bundle.ManualMethodSelect_ClassNameLabelText());
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        this.add((Component)classNameLabel, labelConstraints);
        this.className.getAccessibleContext().setAccessibleName(Bundle.ManualMethodSelect_ClassNameAccessName());
        this.className.setPreferredSize(new Dimension(290, this.className.getPreferredSize().height));
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 0;
        this.add((Component)this.className, fieldConstraints);
        methodNameLabel.setLabelFor(this.methodName);
        Mnemonics.setLocalizedText((JLabel)methodNameLabel, (String)Bundle.ManualMethodSelect_MethodNameLabelText());
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 1;
        this.add((Component)methodNameLabel, labelConstraints);
        this.methodName.getAccessibleContext().setAccessibleName(Bundle.ManualMethodSelect_MethodNameAccessName());
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 1;
        this.add((Component)this.methodName, fieldConstraints);
        methodSignatureLabel.setLabelFor(this.methodSignature);
        Mnemonics.setLocalizedText((JLabel)methodSignatureLabel, (String)Bundle.ManualMethodSelect_MethodSignatureLabelText());
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 2;
        this.add((Component)methodSignatureLabel, labelConstraints);
        this.methodSignature.getAccessibleContext().setAccessibleName(Bundle.ManualMethodSelect_MethodSignatureAccessName());
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 2;
        this.add((Component)this.methodSignature, fieldConstraints);
        Color panelBackground = UIManager.getColor("Panel.background");
        Color hintBackground = UIUtils.getSafeColor((int)(panelBackground.getRed() - 10), (int)(panelBackground.getGreen() - 10), (int)(panelBackground.getBlue() - 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        this.add((Component)new JPanel(), constraints);
        this.hintArea.setText(Bundle.ManualMethodSelect_HintMsg());
        this.hintArea.setEnabled(false);
        this.hintArea.setDisabledTextColor(Color.darkGray);
        this.hintArea.setBackground(hintBackground);
        this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, hintBackground));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(18, 0, 0, 0);
        constraints.anchor = 18;
        constraints.fill = 1;
        this.add((Component)this.hintArea, constraints);
        this.setBorder(new EmptyBorder(12, 12, 0, 12));
        this.className.getDocument().addDocumentListener(this.documentListener);
        this.methodName.getDocument().addDocumentListener(this.documentListener);
        this.methodSignature.getDocument().addDocumentListener(this.documentListener);
        this.updateEnabledState();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static ClientUtils.SourceCodeSelection selectMethod() {
        return ManualMethodSelect.selectMethod(null);
    }

    public static ClientUtils.SourceCodeSelection selectMethod(ClientUtils.SourceCodeSelection method) {
        if (mms == null) {
            mms = new ManualMethodSelect();
        }
        if (method != null) {
            mms.setClassName(method.getClassName());
            mms.setMethodName(method.getMethodName());
            mms.setMethodSignature(method.getMethodSignature());
        } else {
            mms.setClassName("");
            mms.setMethodName("");
            mms.setMethodSignature("");
        }
        DialogDescriptor dd = new DialogDescriptor((Object)mms, method == null ? Bundle.ManualMethodSelect_SelectMethodsDialogCaption() : Bundle.ManualMethodSelect_EditMethodDialogCaption(), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == okButton) {
            return mms.getSelectedMethod();
        }
        return null;
    }

    private void setClassName(String cName) {
        this.className.setText(ClientUtils.formatClassName((String)cName.trim()));
    }

    private String getClassName() {
        return ClientUtils.parseClassName((String)this.className.getText().trim(), (boolean)true);
    }

    private void setMethodName(String mName) {
        this.methodName.setText(mName.trim());
    }

    private String getMethodName() {
        String ret = this.methodName.getText().trim();
        if ("".equals(ret)) {
            return null;
        }
        return ret;
    }

    private void setMethodSignature(String mSignature) {
        this.methodSignature.setText(mSignature.trim());
    }

    private String getMethodSignature() {
        String ret = this.methodSignature.getText().trim();
        if ("".equals(ret)) {
            return null;
        }
        return ret;
    }

    private ClientUtils.SourceCodeSelection getSelectedMethod() {
        return new ClientUtils.SourceCodeSelection(this.getClassName(), this.getMethodName(), this.getMethodSignature());
    }

    private void updateEnabledState() {
        String cm;
        boolean enabled = true;
        String fClassName = this.className.getText().trim();
        String fMethodName = this.methodName.getText().trim();
        String fMethodSignature = this.methodName.getText().trim();
        if (fClassName.isEmpty()) {
            enabled = false;
        }
        if (fMethodName.isEmpty() != fMethodSignature.isEmpty()) {
            enabled = false;
        }
        if ((cm = ClientUtils.parseClassName((String)fClassName, (fMethodName.isEmpty() && fMethodSignature.isEmpty() ? 1 : 0) != 0)) == null) {
            enabled = false;
            this.className.setForeground(Color.red);
        } else {
            this.className.setForeground(UIManager.getColor("Label.foreground"));
        }
        okButton.setEnabled(enabled);
    }

    static {
        okButton = new JButton(Bundle.ManualMethodSelect_OKButtonText());
    }

    private final class MethodSelectDocumentListener
    implements DocumentListener {
        private MethodSelectDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ManualMethodSelect.this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ManualMethodSelect.this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ManualMethodSelect.this.updateEnabledState();
        }
    }
}

