/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.utils.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;

public final class IDEUtils {
    private static HelpCtx HELP_CTX = new HelpCtx("SelectSettingsConfiguration.HelpCtx");

    public static String getAntProfilerStartArgument15(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk15");
    }

    public static String getAntProfilerStartArgument16(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk16");
    }

    public static String getAntProfilerStartArgument17(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk17");
    }

    public static String getAntProfilerStartArgument18(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk18");
    }

    public static ProfilingSettings selectSettings(int type, ProfilingSettings[] availableSettings, ProfilingSettings settingsToSelect) {
        int selectedIndex;
        Object[] settings = new Object[availableSettings.length + 1];
        for (int i = 0; i < availableSettings.length; ++i) {
            settings[i] = availableSettings[i];
        }
        settings[availableSettings.length] = Bundle.IDEUtils_CreateNewConfigurationHint();
        JLabel label = new JLabel(Bundle.IDEUtils_SelectSettingsConfigurationLabelText());
        final JButton okButton = new JButton(Bundle.IDEUtils_OkButtonText());
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(450, 250));
        panel.setBorder(new EmptyBorder(12, 12, 12, 12));
        panel.setLayout(new BorderLayout(0, 5));
        panel.add((Component)label, "North");
        final JList<Object> list = new JList<Object>(settings);
        label.setLabelFor(list);
        list.getAccessibleContext().setAccessibleName(Bundle.IDEUtils_ListAccessName());
        list.setSelectionMode(0);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                okButton.setEnabled(list.getSelectedIndex() != -1);
            }
        });
        if (settingsToSelect != null) {
            list.setSelectedValue(settingsToSelect, true);
        } else {
            list.setSelectedIndex(0);
        }
        panel.add((Component)new JScrollPane(list), "Center");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.IDEUtils_SelectSettingsConfigurationDialogCaption(), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, HELP_CTX, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() == okButton && (selectedIndex = list.getSelectedIndex()) != -1) {
            if (selectedIndex < settings.length - 1) {
                ProfilingSettings selectedSettings = (ProfilingSettings)settings[selectedIndex];
                selectedSettings.setProfilingType(type);
                return selectedSettings;
            }
            ProfilingSettings newSettings = ProfilingSettingsManager.createNewSettings((int)type, (ProfilingSettings[])availableSettings);
            if (newSettings == null) {
                return null;
            }
            newSettings.setProfilingType(type);
            return newSettings;
        }
        return null;
    }

    private static String getAntProfilerStartArgument(int port, int architecture, String jdkVersion) {
        String ld = Profiler.getDefault().getLibsDir();
        String nativeLib = Platform.getAgentNativeLibFullName((String)ld, (boolean)false, (String)jdkVersion, (int)architecture);
        if (ld.contains(" ")) {
            ld = "\"" + ld + "\"";
        }
        if (nativeLib.contains(" ")) {
            nativeLib = "\"" + nativeLib + "\"";
        }
        return "-agentpath:" + nativeLib + "=" + ld + "," + port + "," + System.getProperty("profiler.agent.connect.timeout", "10");
    }
}

