/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.util.concurrent.atomic.AtomicBoolean;

abstract class WrappingSearchCursor<R> {
    private String searchTerm;
    private int majorCounter = 0;
    private int minorCounter = -1;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    WrappingSearchCursor(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    final R forward() {
        this.cancelled.set(false);
        R item = null;
        int majorTmp = this.majorCounter;
        int minorTmp = this.minorCounter;
        do {
            if (this.majorCounter >= this.getSlotsNumber()) {
                this.majorCounter = 0;
                this.minorCounter = -1;
                continue;
            }
            if (++this.minorCounter >= this.getSlotSize(this.majorCounter)) {
                this.minorCounter = -1;
                ++this.majorCounter;
                continue;
            }
            item = this.getItem(this.majorCounter, this.minorCounter);
            if (!this.cancelled.get()) continue;
            return null;
        } while (item == null && (majorTmp != this.majorCounter || minorTmp != this.minorCounter));
        return item;
    }

    final R back() {
        this.cancelled.set(false);
        R item = null;
        int majorTmp = this.majorCounter;
        int minorTmp = this.minorCounter;
        while (true) {
            if (--this.minorCounter < 0) {
                if (--this.majorCounter < 0) {
                    this.majorCounter = this.getSlotsNumber() - 1;
                }
                if (this.minorCounter < 0 && this.majorCounter < 0) {
                    return null;
                }
                this.minorCounter = this.getSlotSize(this.majorCounter);
                if (!this.cancelled.get()) continue;
                return null;
            }
            item = this.getItem(this.majorCounter, this.minorCounter);
            if (this.cancelled.get()) {
                return null;
            }
            if (item != null || majorTmp == this.majorCounter && minorTmp == this.minorCounter) break;
        }
        return item;
    }

    final void cancel() {
        this.cancelled.set(true);
    }

    protected final boolean isCancelled() {
        return this.cancelled.get();
    }

    final String getSearchTerm() {
        return this.searchTerm;
    }

    protected abstract int getSlotsNumber();

    protected abstract int getSlotSize(int var1);

    protected abstract R getItem(int var1, int var2);
}

